(SETQ SETFNS
   '(SETFNS MEM1 SUBSET SYMM-DIFF 
    UNION INTERSECTION MAKESET SETEQ 
    SETP SUBSETP ENTER ATTACH INSERT 
    DREMOVE))

(DE MEM1
  (L1 L2)
  (COND((ATOM L1)
       NIL)
    ((MEMBER(CAR L1) L2))
    (T(MEM1(CDR L1) L2))))

(DE SUBSET
  (FUN L)
  (COND((ATOM L)
       NIL)
    ((APPLY* FUN
      (CAR L))
      (CONS(CAR L)
        (SUBSET FUN
          (CDR L))))
    (T(SUBSET FUN
        (CDR L)))))

(DE SYMM-DIFF
  (L1 L2)
  (COND((ATOM L1)
       NIL)
    ((MEMBER(CAR L1) L2)
      (SYMM-DIFF(CDR L1) L2))
    (T(CONS(CAR L1)
        (SYMM-DIFF(CDR L1) L2)))))

(DE UNION
  (L1 L2)
  (COND((ATOM L1)
       L2)
    ((MEMBER(CAR L1) L2)
      (UNION(CDR L1) L2))
    (T(CONS(CAR L1)
        (UNION(CDR L1) L2)))))

(DE INTERSECTION
  (L1 L2)
  (COND((ATOM L1)
       NIL)
    ((MEMBER(CAR L1) L2)
      (CONS(CAR L1)
        (INTERSECTION(CDR L1) L2)))
    (T(INTERSECTION(CDR L1) L2))))

(DE MAKESET
  (L1)
  (COND((ATOM L1)
       NIL)
    ((NOT(MEMBER(CAR L1)
        (CDR L1)))
      (CONS(CAR L1)
        (MAKESET(CDR L1))))
    (T(MAKESET(CDR L1)))))

(DE SETEQ
  (L1 L2)
  (COND((EQUAL L1 L2))
    ((ATOM L1)
      (ATOM L2))
    ((MEMBER(CAR L1) L2)
      (SETEQ(CDR L1)
        (REMOVE(CAR L1) L2)))))

(DE SETP
  (L1)
  (COND((NULL L1)
       T)
    ((MEMBER(CAR L1)
      (CDR L1))
       NIL)
    (T(SETP(CDR L1)))))

(DE SUBSETP
  (L1 L2)
  (COND((EQUAL L1 L2))
    ((ATOM L1))
    ((MEMBER(CAR L1) L2)
      (SUBSETP(CDR L1) L2))))

(DE ENTER
  (X L)
  (COND((MEMBER X L)
       L)
    (T(ATTACH X L))))

(DE ATTACH
  (X L)
  (COND((ATOM L)
      (CONS X NIL))
    (T(RPLACD L
        (CONS(CAR L)
          (CDR L)))
      (RPLACA L X))))

(DE INSERT
  (X Y L)
  (ATTACH X
    (NTH L Y)) L)

(DE DREMOVE
  (L1 L2)
  (PROG(L3 L4)
    (SETQ L4 L2) LOOP
    (COND((ATOM L4)
        (RETURN L2))
      ((SETQ L3
        (MEMBER L1 L4))
        (COND((ATOM(CDR L3))
            (RETURN L2))
          (T(RPLACA L3
              (CADR L3))
            (RPLACD L3
              (CDDR L3)))))
      (T(SETQ L4
          (CDR L4))))
    (GO LOOP)))

