/*
  Insert page numbers into help text,
  and save in separate pages.

  Wotan mit uns.
*/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>


#define PAGENUMBERCODE  0x80
#define ENDOFPAGECODE   0x81


int Ascii2PetsciiChar(int c)
{
  if ((c>=0x20)&&(c<0x41)) return c;
  if ((c>=0x41)&&(c<0x5b)) return c+0x80;
  if ((c>=0x5b)&&(c<0x60)) return c;
  if ((c>=0x61)&&(c<0x7b)) return c-0x20;
  fprintf(stderr, "Conversion not defined for ASCII 0x%02x.\n", c);
  return c;
}


int paginate(FILE *in, FILE *out, const char *filenameTemplate)
{
  static char buf[256];
  static char filename[80];
  char pageNumBuf[4];
  FILE *outC64=NULL;
  int pageNum;

  pageNum=0;
  sprintf(filename, filenameTemplate, pageNum);
  outC64=fopen(filename, "wb");
  int c=fgetc(in);
  while (!feof(in)) {
    switch (c) {
      case ENDOFPAGECODE:
        if (outC64) {
          fputc(0x00, outC64);
          fclose(outC64);
        }
        sprintf(filename, filenameTemplate, pageNum);
        outC64=fopen(filename, "wb");
        fgets(buf, sizeof(buf), in);
        fputc('\n', out);
        fputc('\n', out);
        fputc('\n', out);
        break;
      case PAGENUMBERCODE:
        sprintf(pageNumBuf, "%02d", pageNum);
        fputc(Ascii2PetsciiChar(pageNumBuf[0]), outC64);
        fputc(Ascii2PetsciiChar(pageNumBuf[1]), outC64);
        fputc(pageNumBuf[0], out);
        fputc(pageNumBuf[1], out);
        pageNum++;
        break;
      default:
        if (c==0x0a) fputc(0x0d, outC64);
        else if (c!=0x0d) fputc(Ascii2PetsciiChar(c), outC64);
        if ((c==0x0a) || (c==0x0d) || ((c>=0x20)&&(c<0x80))) fputc(c, out);
        if (c==164) fputc('_', out);
    }
    c=fgetc(in);
  }
  if (outC64) {
    fputc(0x00, outC64);
    fclose(outC64);
  }
  return 0;
}


int main(int argc, char *argv[])
{
  if (argc==4) {
    FILE *in=fopen(argv[1], "rt");
    if (!in) {
      fprintf(stderr, "Error opening input file.");
      return EXIT_FAILURE;
    }
    FILE *out=fopen(argv[2], "wt");
    if (!out) {
      fprintf(stderr, "Error opening input file.");
      return EXIT_FAILURE;
    }
    paginate(in, out, argv[3]);
    return EXIT_SUCCESS;
  }
  else {
    return EXIT_FAILURE;
  }
}
