; ======================================
; Kernal routines and data.
; ======================================

; Kernal data.
status          = $90
shiftflags      = $028d
caseswitch      = $0291

;Kernal routines.
acptr   = $ffa5 ; Input byte from serial port
chkin   = $ffc6 ; Open channel for input (C is set if error)
chkout  = $ffc9 ; Open channel for output
chrin   = $ffcf ; Input character from channel
chrout  = $ffd2 ; Output character to channel
ciout   = $ffa8 ; Output byte to serial port
cint    = $ff81 ; Initialize screen editor
clall   = $ffe7 ; Close all channels and files
close   = $ffc3 ; Close a specified logical file
clrchn  = $ffcc ; Close input and output channels
getin   = $ffe4 ; Get character from keyboard queue (keyboard buffer)
iobase  = $fff3 ; Returns base address of I/O devices
ioinit  = $ff84 ; Initialize input/output
listen  = $ffb1 ; Command devices on the serial bus to LISTEN
load    = $ffd5 ; Load RAM from a device
membot  = $ff9c ; Read/set the bottom of memory
memtop  = $ff99 ; Read/set the top of memory
open    = $ffc0 ; Open a logical file (C is set if error)
plot    = $fff0 ; Read/set X,Y cursor position
ramtas  = $ff87 ; Initialize RAM, allocate tape buffer, set screen $0400
rdtim   = $ffde ; Read real time clock
readst  = $ffb7 ; Read I/O status word
restor  = $ff8a ; Restore default I/O vectors
save    = $ffd8 ; Save RAM to device
scnkey  = $ff9f ; Scan keyboard
screen  = $ffed ; Return X,Y organization of screen
second  = $ff93 ; Send secondary address after LISTEN
setlfs  = $ffba ; Set logical, first, and second addresses
setmsg  = $ff90 ; Control KERNAL messages
setnam  = $ffbd ; Set file name
settim  = $ffdb ; Set real time clock
settmo  = $ffa2 ; Set timeout on serial bus
stop    = $ffe1 ; Scan stop key
talk    = $ffb4 ; Command serial bus device to TALK
tksa    = $ff96 ; Send secondary address after TALK
udtim   = $ffea ; Increment real time clock
unlsn   = $ffae ; Command serial bus to UNLISTEN
untlk   = $ffab ; Command serial bus to UNTALK
vector  = $ff8d ; Read/set vectored I/O

; Keycodes returned by getin.
;KEY_                   = $00
;KEY_                   = $01
;KEY_                   = $02
KEY_RUNSTOP             = $03
;KEY_                   = $04
KEY_CTRL_2              = $05
KEY_CTRL_LEFTARROW      = $06
;KEY_                   = $07
;KEY_                   = $08
;KEY_                   = $09
;KEY_                   = $0A
;KEY_                   = $0B
;KEY_                   = $0C
KEY_RETURN              = $0D
;KEY_                   = $0E
;KEY_                   = $0F
;KEY_                   = $10
KEY_DOWN                = $11
KEY_CTRL_9              = $12
KEY_HOME                = $13
KEY_DELETE              = $14
;KEY_                   = $15
;KEY_                   = $16
;KEY_                   = $17
;KEY_                   = $18
;KEY_                   = $19
;KEY_                   = $1A
;KEY_                   = $1B
KEY_CTRL_3              = $1C
KEY_RIGHT               = $1D
KEY_CTRL_6              = $1E
KEY_CTRL_7              = $1F
KEY_SPACE               = $20
KEY_EXCL                = $21
KEY_DOUBLEQUOT          = $22
KEY_HASHMARK            = $23
KEY_DOLLAR              = $24
KEY_PERCENT             = $25
KEY_AMP                 = $26
KEY_QUOT                = $27
KEY_LBRACKET            = $28
KEY_RBRACKET            = $29
KEY_ASTERISK            = $2A
KEY_PLUS                = $2B
KEY_COMMA               = $2C
KEY_MINUS               = $2D
KEY_PERIOD              = $2E
KEY_SLASH               = $2F
KEY_0                   = $30
KEY_1                   = $31
KEY_2                   = $32
KEY_3                   = $33
KEY_4                   = $34
KEY_5                   = $35
KEY_6                   = $36
KEY_7                   = $37
KEY_8                   = $38
KEY_9                   = $39
KEY_COLON               = $3A
KEY_SEMICOLON           = $3B
KEY_LESS                = $3C
KEY_EQUALS              = $3D
KEY_GREATER             = $3E
KEY_QUEST               = $3F
KEY_AT                  = $40                   ; @
KEY_A                   = $41
KEY_B                   = $42
KEY_C                   = $43
KEY_D                   = $44
KEY_E                   = $45
KEY_F                   = $46
KEY_G                   = $47
KEY_H                   = $48
KEY_I                   = $49
KEY_J                   = $4A
KEY_K                   = $4B
KEY_L                   = $4C
KEY_M                   = $4D
KEY_N                   = $4E
KEY_O                   = $4F
KEY_P                   = $50
KEY_Q                   = $51
KEY_R                   = $52
KEY_S                   = $53
KEY_T                   = $54
KEY_U                   = $55
KEY_V                   = $56
KEY_W                   = $57
KEY_X                   = $58
KEY_Y                   = $59
KEY_Z                   = $5A
KEY_LSQRBRACKET         = $5B
KEY_POUND               = $5C
KEY_RSQRBRACKET         = $5D
KEY_UPARROW             = $5E
KEY_LEFTARROW           = $5F
;KEY_                   = $60
;KEY_                   = $61
;KEY_                   = $62
;KEY_                   = $63
;KEY_                   = $64
;KEY_                   = $65
;KEY_                   = $66
;KEY_                   = $67
;KEY_                   = $68
;KEY_                   = $69
;KEY_                   = $6A
;KEY_                   = $6B
;KEY_                   = $6C
;KEY_                   = $6D
;KEY_                   = $6E
;KEY_                   = $6F
;KEY_                   = $70
;KEY_                   = $71
;KEY_                   = $72
;KEY_                   = $73
;KEY_                   = $74
;KEY_                   = $75
;KEY_                   = $76
;KEY_                   = $77
;KEY_                   = $78
;KEY_                   = $79
;KEY_                   = $7A
;KEY_                   = $7B
;KEY_                   = $7C
;KEY_                   = $7D
;KEY_                   = $7E
;KEY_                   = $7F
;KEY_                   = $80
KEY_COMM_1              = $81
;KEY_                   = $82
KEY_SH_RUNSTOP          = $83
;KEY_                   = $84
KEY_F1                  = $85
KEY_F3                  = $86
KEY_F5                  = $87
KEY_F7                  = $88
KEY_F2                  = $89
KEY_F4                  = $8A
KEY_F6                  = $8B
KEY_F8                  = $8C
KEY_SH_RETURN           = $8D
;KEY_                   = $8E
;KEY_                   = $8F
KEY_CTRL_1              = $90
KEY_UP                  = $91
KEY_CTRL_0              = $92
KEY_SH_HOME             = $93
KEY_INSERT              = $94
KEY_COMM_2              = $95
KEY_COMM_3              = $96
KEY_COMM_4              = $97
KEY_COMM_5              = $98
KEY_COMM_6              = $99
KEY_COMM_7              = $9A
KEY_COMM_8              = $9B
KEY_CTRL_5              = $9C
KEY_LEFT                = $9D
KEY_CTRL_8              = $9E
KEY_CTRL_4              = $9F
KEY_SH_SPACE            = $A0
KEY_COMM_K              = $A1
KEY_COMM_I              = $A2
KEY_COMM_T              = $A3
;KEY_                   = $A4
KEY_COMM_G              = $A5
;KEY_                   = $A6
KEY_COMM_M              = $A7
;KEY_                   = $A8
KEY_SH_POUND            = $A9
KEY_COMM_N              = $AA
KEY_COMM_Q              = $AB
KEY_COMM_D              = $AC
KEY_COMM_Z              = $AD
KEY_COMM_S              = $AE
KEY_COMM_P              = $AF
KEY_COMM_A              = $B0
KEY_COMM_E              = $B1
KEY_COMM_R              = $B2
KEY_COMM_W              = $B3
KEY_COMM_H              = $B4
KEY_COMM_J              = $B5
KEY_COMM_L              = $B6
KEY_COMM_Y              = $B7
KEY_COMM_U              = $B8
KEY_COMM_O              = $B9
KEY_SH_AT               = $BA
KEY_COMM_F              = $BB
KEY_COMM_C              = $BC
KEY_COMM_X              = $BD
KEY_COMM_V              = $BE
KEY_COMM_B              = $BF
;KEY_                   = $C0
KEY_SH_A                = $C1
KEY_SH_B                = $C2
KEY_SH_C                = $C3
KEY_SH_D                = $C4
KEY_SH_E                = $C5
KEY_SH_F                = $C6
KEY_SH_G                = $C7
KEY_SH_H                = $C8
KEY_SH_I                = $C9
KEY_SH_J                = $CA
KEY_SH_K                = $CB
KEY_SH_L                = $CC
KEY_SH_M                = $CD
KEY_SH_N                = $CE
KEY_SH_O                = $CF
KEY_SH_P                = $D0
KEY_SH_Q                = $D1
KEY_SH_R                = $D2
KEY_SH_S                = $D3
KEY_SH_T                = $D4
KEY_SH_U                = $D5
KEY_SH_V                = $D6
KEY_SH_W                = $D7
KEY_SH_X                = $D8
KEY_SH_Y                = $D9
KEY_SH_Z                = $DA
;KEY_                   = $DB
;KEY_                   = $DC
;KEY_                   = $DD
KEY_SH_UPARROW          = $DE
;KEY_                   = $DF

