;---------  SIDwinder V01.20  ----------


         *= $0c00

zp1      = $2b             ;1st col
zp2      = $2c
zp3      = $2d             ;2nd col
zp4      = $2e
zp5      = $2f             ;3rd col
zp6      = $30
zp7      = $31             ;sct.len
zp8      = $32
zp9      = $33             ;corner pos

ctinit   = $45fc
volume   = $46bd
dur_dc   = $4653
dur_rs   = $4654
gt_dec   = $464e
trk_lo   = $4664
trk_hi   = $4665
trkpos   = $4666
sctpos   = $4669
f_type   = $46bb
s_nmbr   = $46a7
w_pntr   = $4691
offset   = $46c2

speeds   = $4700
start1   = $4720
start2   = $4740
start3   = $4760

tr1adl   = $4780
tr2adl   = $47a0
tr3adl   = $47c0
tr1adh   = $47e0
tr2adh   = $4800
tr3adh   = $4820

gld_al   = $4840
gld_ah   = $4850

sctadl   = $4880
sctadh   = $48e0

snd_ad   = $4940           ;i_edit!
snd_sr   = $4980
snd_gt   = $49c0
snd_wt   = $4a00
snd_ft   = $4a40
snd_pt   = $4a80
snd_st   = $4ac0

wve_fm   = $4b00
wve_st   = $4c00

flt_rp   = $4d00
flt_fh   = $4e00
flt_rl   = $4f00

pls_rp   = $5000
pls_pl   = $5100
pls_ph   = $5200

sld_rp   = $5300
sld_fl   = $5400
sld_fh   = $5500


         jmp $3a97

call_1   sei
         lda #$01
         sta $d019
calls1   = *+1
         ldy #$00
callr1   = *+1
         lda #$00
         jsr jp1003
         cli
callj1   = *+1
         jmp $ea81
call_2   sei
         lda #$01
         sta $d019
calls2   = *+1
         ldy #$00
callr2   = *+1
         lda #$00
         jsr jp1006
         cli
callj2   = *+1
         jmp $ea81
call_3   sei
         lda #$01
         sta $d019
calls3   = *+1
         ldy #$00
callr3   = *+1
         lda #$00
         jsr jp1006
         cli
callj3   = *+1
         jmp $ea81
call_4   sei
         lda #$01
         sta $d019
calls4   = *+1
         ldy #$00
callr4   = *+1
         lda #$00
         jsr jp1006
         cli
callj4   = *+1
         jmp $ea81
call_5   sei
         lda #$01
         sta $d019
calls5   = *+1
         ldy #$00
callr5   = *+1
         lda #$00
         jsr jp1006
         cli
callj5   = *+1
         jmp $ea81
call_6   sei
         lda #$01
         sta $d019
calls6   = *+1
         ldy #$00
callr6   = *+1
         lda #$00
         jsr jp1006
         cli
callj6   = *+1
         jmp $ea81
call_7   sei
         lda #$01
         sta $d019
calls7   = *+1
         ldy #$00
callr7   = *+1
         lda #$00
         jsr jp1006
         cli
callj7   = *+1
         jmp $ea81
call_8   sei
         lda #$01
         sta $d019
calls8   = *+1
         ldy #$00
callr8   = *+1
         lda #$00
         jsr jp1006
         cli
callj8   = *+1
         jmp $ea81
call_9   sei
         lda #$01
         sta $d019
calls9   = *+1
         ldy #$00
callr9   = *+1
         lda #$00
         jsr jp1006
         cli
callj9   = *+1
         jmp $ea81
call_0   sei
         lda #$01
         sta $d019
calls0   = *+1
         ldy #$00
callr0   = *+1
         lda #$00
         jsr jp1006
         cli
callj0   = *+1
         jmp $ea31

callno   sei               ;stopped
         lda #$01
         sta $d019
         lda #$fa
         sta $d012
         cli
         jmp $ea31

jp1003   sta $d012         ;1st
         sty $0314
         dec $d020
         lda #$f1
         sta irqpnt+1
         lda #$06
         sta irqpnt+2
         lda e_radd
         cmp e_rmax
         bcc notrec
         sta e_rmax
         ldx #$03          ;max.rtime
         jsr irqout
         lda e_radd
notrec   ldx #$00          ;act.rtime
         jsr irqout
         lda $d012
         sta e_ract
         jsr $4003
         lda $d012
         sec
         sbc e_ract
         sta e_radd
         inc $d020
         lda #$00
         ldx #$7a
         cpx e_tr1x        ;trk1 off?
         beq *+5
         sta w_pntr
         cpx e_tr2x        ;trk2 off?
         beq *+5
         sta w_pntr+$07
         cpx e_tr3x        ;trk3 off?
         beq *+5
         sta w_pntr+$0e
         dec e_clkt        ;time
         bne notsec
         lda #$32          ;50 frames
         sta e_clkt
         lda #$19
         sta irqpnt+1
         lda #$07
         sta irqpnt+2
         lda e_secs
         sed
         clc
         adc #$01          ;inc secs
         cmp #$60
         beq yesmin
         sta e_secs
         cld
         jmp yessec
yesmin   lda #$00          ;1 min
         sta e_secs
         lda e_mins
         clc
         adc #$01          ;inc mins
         cmp #$60
         bne notmin
         lda #$00          ;1 hour
notmin   sta e_mins
         cld
         ldx #$00
         jsr irqout
         lda e_secs
yessec   ldx #$03
         jsr irqout
notsec   lda e_acts        ;a.speed
         cmp #$06
         bcc wdatas
         rts
wdatas   lda #$be          ;max 6x
         sta irqpnt+1
         lda #$05
         sta irqpnt+2
         lda trkpos        ;trk
         sec
         sbc #$01
         ldx #$00
         jsr irqout
         lda trkpos+$07
         sec
         sbc #$01
         ldx #$03
         jsr irqout
         lda trkpos+$0e
         sec
         sbc #$01
         ldx #$06
         jsr irqout
         lda dur_rs        ;dur
         clc
         adc #$01
         ldx #$0f
         jsr irqout
         lda dur_rs+$07
         clc
         adc #$01
         ldx #$12
         jsr irqout
         lda dur_rs+$0e
         clc
         adc #$01
         ldx #$15
         jsr irqout
         lda sctpos        ;sct
         ldx #$28
         jsr irqout
         lda sctpos+$07
         ldx #$2b
         jsr irqout
         lda sctpos+$0e
         ldx #$2e
         jsr irqout
         lda dur_dc        ;act
         ldx #$37
         jsr irqout
         lda dur_dc+$07
         ldx #$3a
         jsr irqout
         lda dur_dc+$0e
         ldx #$3d
         jsr irqout
         lda s_nmbr        ;snd
         ldx #$50
         jsr irqout
         lda s_nmbr+$07
         ldx #$53
         jsr irqout
         lda s_nmbr+$0e
         ldx #$56
         jsr irqout
         lda gt_dec        ;off
         ldx #$5f
         jsr irqout
         lda gt_dec+$07
         ldx #$62
         jsr irqout
         lda gt_dec+$0e
         ldx #$65
         jmp irqout

jp1006   sta $d012         ;multi
         sty $0314
         dec $d020
         lda $d012
         sta e_ract
         jsr $4006
         lda $d012
         sec
         sbc e_ract
         clc
         adc e_radd
         sta e_radd
         inc $d020
         rts

setspd   ldy e_tune
         lda speeds,y
         sta e_acts
         tay
         lda call1s,y
         sta calls1
         lda call1r,y
         sta callr1
         lda call1j,y
         sta callj1
         lda call2s,y
         sta calls2
         lda call2r,y
         sta callr2
         lda call2j,y
         sta callj2
         lda call3s,y
         sta calls3
         lda call3r,y
         sta callr3
         lda call3j,y
         sta callj3
         lda call4s,y
         sta calls4
         lda call4r,y
         sta callr4
         lda call4j,y
         sta callj4
         lda call5s,y
         sta calls5
         lda call5r,y
         sta callr5
         lda call5j,y
         sta callj5
         lda call6s,y
         sta calls6
         lda call6r,y
         sta callr6
         lda call6j,y
         sta callj6
         lda call7s,y
         sta calls7
         lda call7r,y
         sta callr7
         lda call7j,y
         sta callj7
         lda call8s,y
         sta calls8
         lda call8r,y
         sta callr8
         lda call8j,y
         sta callj8
         lda call9s,y
         sta calls9
         lda call9r,y
         sta callr9
         lda call9j,y
         sta callj9
         lda call0s,y
         sta calls0
         lda call0r,y
         sta callr0
         lda call0j,y
         sta callj0
         lda rstart,y
         rts

getkey   lda #$00
         sta $c6
         lda $c6
         beq *-2
         lda $0277
         cmp #$0d          ;return
         beq accept
         cmp #$11          ;c.down
         beq accept
         cmp #$13          ;home
         beq accept
         cmp #$14          ;delete
         beq accept
         cmp #$1d          ;c.right
         beq accept
         cmp #$91          ;c.up
         beq accept
         cmp #$94          ;insert
         beq accept
         cmp #$9d          ;c.left
         beq accept
         cmp #$c4          ;sh.d
         beq accept
         cmp #$c5          ;sh.e
         beq accept
         cmp #$c7          ;sh.g
         beq accept
         cmp #$c8          ;sh.h
         beq accept
         cmp #$c9          ;sh.i
         beq accept
         cmp #$ca          ;sh.j
         beq accept
         cmp #$d3          ;sh.s
         beq accept
         cmp #$d6          ;sh.v
         beq accept
         cmp #$db          ;sh.+
         beq accept
         cmp #$dd          ;sh.-
         beq accept
         cmp #$20
         bcc getkey
         cmp #$8e
         bcs getkey
         cmp #$60
         bcc accept
         cmp #$85
         bcc getkey
accept   rts

irqout   ldy $0429
         cpy #$54
         bne irqpnt+3
         pha               ;hex #
         lsr a
         lsr a
         lsr a
         lsr a
         dex
         jsr irqcnv
         pla
         and #$0f
irqcnv   ora #$30
         inx
         cmp #$3a
         bcc irqpnt
         clc
         adc #$07
irqpnt   sta $face,x
         rts

numout   pha               ;hex #
         lsr a
         lsr a
         lsr a
         lsr a
         dex
         jsr numcnv
         pla
         and #$0f
numcnv   ora #$30
         inx
         cmp #$3a
         bcc numpnt
         clc
         adc #$07
numpnt   sta $face,x
         rts

fncout   sta fncnum+1      ;function
         lda $0429
         cmp #$54
         beq fncend
         tya
         pha
fncnum   ldy #$00
         lda fncadl,y
         sta fncpnt+1
         lda fncadh,y
         sta fncpnt+2
         ldy #$11
fncpnt   lda $face,y
         sta $043c,y
         dey
         bpl fncpnt
         pla
         tay
fncend   rts

colsnd   tya               ;snd.
         pha
         ldy #$27
         lda #$0f
collp1   sta $d878,y
         dey
         bpl collp1
         pla
         tay
         rts

colafp   tya               ;arp+flt+pls
         pha
         ldy #$ff
         lda #$0f
collp2   sta $d940,y
         dey
         bne collp2
         pla
         tay
         rts

coltrs   tya               ;trk+sct
         pha
         ldy #$ff
         lda #$0f
collp3   sta $d878,y
         dey
         bne collp3
         pla
         tay
         rts

colsta   tya               ;trst.
         pha
         ldy #$07
         lda #$0f
collp4   sta $da9e,y
         dey
         bpl collp4
         ldy #$04
collp5   sta $db69,y
         dey
         bpl collp5
         pla
         tay
         rts

colgld   tya               ;gld+more
         pha
         ldy #$ff
         lda #$0f
collp6   sta $dad0,y
         dey
         bne collp6
         pla
         tay
         rts

sndtab   txa               ;tables
         pha
         tya
         pha
         lda zp9
         pha
         lda #$2f
         sta numpnt+1
         lda #$04
         sta numpnt+2
         ldy e_sndn
         ldx #$00
         tya               ;#
         jsr numout
         lda #$82
         sta numpnt+1
         lda #$04
         sta numpnt+2
         ldx #$00
         lda snd_ad,y      ;ad
         jsr numout
         ldx #$03
         lda snd_sr,y      ;sr
         jsr numout
         ldx #$06
         lda snd_gt,y      ;gt
         jsr numout
         ldx #$09
         lda snd_wt,y      ;wt
         jsr numout
         ldx #$0c
         lda snd_ft,y      ;ft
         jsr numout
         ldx #$0f
         lda snd_pt,y      ;pt
         jsr numout
         ldx #$12
         lda snd_st,y      ;st
         jsr numout
         lda e_test        ;note
         ldy #$08
notest   dey
         cmp octave,y
         bcc notest
         sbc octave,y      ;c=1
         asl a
         tax
         lda twelve,x
         sta $047e
         lda twelve+1,x
         sta $047f
         iny
         tya
         ora #$30
         sta $0480
         pla
         sta zp9
         pla
         tay
         pla
         tax
         rts

chk_fa   lda zp9
         cmp #$fb
         bcc *+6
         lda #$fa
         sta zp9
         rts

wvetab   jsr chk_fa
         lda #LO(wve_fm)
         clc
         adc zp9
         sta zp1
         lda #HI(wve_fm)
         sta zp2
         lda #LO(wve_st)
         clc
         adc zp9
         sta zp3
         lda #HI(wve_st)
         sta zp4
         lda #$00
         sta zp5
         sta zp6
         lda #$42
         sta numpnt+1
         lda #$05
         sta numpnt+2
         jmp tblout

flttab   jsr chk_fa
         lda #LO(flt_rp)
         clc
         adc zp9
         sta zp1
         lda #HI(flt_rp)
         sta zp2
         lda #LO(flt_fh)
         clc
         adc zp9
         sta zp3
         lda #HI(flt_fh)
         sta zp4
         lda #LO(flt_rl)
         clc
         adc zp9
         sta zp5
         lda #HI(flt_rl)
         sta zp6
         lda #$4d
         sta numpnt+1
         lda #$05
         sta numpnt+2
         jmp tblout

plstab   jsr chk_fa
         lda #LO(pls_rp)
         clc
         adc zp9
         sta zp1
         lda #HI(pls_rp)
         sta zp2
         lda #LO(pls_ph)
         clc
         adc zp9
         sta zp3
         lda #HI(pls_ph)
         sta zp4
         lda #LO(pls_pl)
         clc
         adc zp9
         sta zp5
         lda #HI(pls_pl)
         sta zp6
         lda #$5b
         sta numpnt+1
         lda #$05
         sta numpnt+2
         jmp tblout

gldtab   lda #LO(gld_ah)
         clc
         adc zp9
         sta zp1
         lda #HI(gld_ah)
         adc #$00
         sta zp2
         lda #LO(gld_al)
         clc
         adc zp9
         sta zp3
         lda #HI(gld_al)
         adc #$00
         sta zp4
         lda #$00
         sta zp5
         sta zp6
         lda #$d2
         sta numpnt+1
         lda #$06
         sta numpnt+2
         jmp tblout

sldtab   jsr chk_fa
         lda #LO(sld_rp)
         clc
         adc zp9
         sta zp1
         lda #HI(sld_rp)
         sta zp2
         lda #LO(sld_fh)
         clc
         adc zp9
         sta zp3
         lda #HI(sld_fh)
         sta zp4
         lda #LO(sld_fl)
         clc
         adc zp9
         sta zp5
         lda #HI(sld_fl)
         sta zp6
         lda #$dd
         sta numpnt+1
         lda #$06
         sta numpnt+2
         jmp tblout

trstab   lda #LO(start1)
         clc
         adc zp9
         sta zp1
         lda #HI(start1)
         adc #$00
         sta zp2
         lda #LO(start2)
         clc
         adc zp9
         sta zp3
         lda #HI(start2)
         adc #$00
         sta zp4
         lda #LO(start3)
         clc
         adc zp9
         sta zp5
         lda #HI(start3)
         adc #$00
         sta zp6
         lda #$eb
         sta numpnt+1
         lda #$06
         sta numpnt+2

tblout   txa               ;write
         pha
         tya
         pha
         ldy #$05
loop01   ldx x_line,y
         tya
         clc
         adc zp9
         jsr numout
         inx
         inx
         lda (zp1),y
         jsr numout
         inx
         inx
         lda (zp3),y
         jsr numout
         lda zp6
         beq twocol
         inx
         inx
         lda (zp5),y
         jsr numout
twocol   dey
         bpl loop01
         pla
         tay
         pla
         tax
         rts

sctout   txa               ;sector
         pha
         tya
         pha
         lda #$4c
         sta numpnt+1
         lda #$04
         sta numpnt+2
         lda e_sctn
         ldx #$00
         jsr numout
         ldx e_sctn
         lda sctadl,x
         clc
         adc zp9
         sta zp1
         lda sctadh,x
         adc #$00
         sta zp2
         lda #$95
         sta numpnt+1
         lda #$04
         sta numpnt+2
         ldy #$05          ;sct.out
loop02   ldx x_line,y
         tya
         pha
         clc
         adc zp9
         jsr numout
         inx
         inx
         lda (zp1),y
         cmp #$c0
         bcc nossnd
         and #$3f
         pha
         lda #LO(sc_snd)
         ldy #HI(sc_snd)
seclin   sta sndwrt+1
         sty sndwrt+2
         ldy #$00
sndwrt   lda $face,y
         sta $0495,x       ;sector
         inx
         iny
         cpy #$04
         bne sndwrt
         pla
         jsr numout
loop03   pla
         tay
         dey
         bpl loop02
         pla
         tay
         pla
         tax
         rts
nossnd   cmp #$80
         bcc nosdur
         sbc #$7f
         pha
         lda #LO(sc_dur)
         ldy #HI(sc_dur)
         jmp seclin
nosdur   cmp #$7f
         bne nosend
         lda #LO(sc_end)
         ldy #HI(sc_end)
fullin   sta fullwt+1
         sty fullwt+2
         ldy #$00
fullwt   lda $face,y
         sta $0495,x
         inx
         iny
         cpy #$06
         bne fullwt
         jmp loop03
nosend   cmp #$6f
         bne nohold
         lda #LO(sc_hld)
         ldy #HI(sc_hld)
         jmp fullin
nohold   cmp #$5f
         bne norest
         lda #LO(sc_rst)
         ldy #HI(sc_rst)
         jmp fullin
norest   cmp #$60
         bcc nosgld
         and #$1f
         clc
         adc #$01
         pha
         lda #LO(sc_gld)
         ldy #HI(sc_gld)
         jmp seclin
nosgld   ldy #$08
         dey
         cmp octave,y
         bcc nosgld+2
         sbc octave,y      ;c=1
         asl a
         pha
         iny
         tya
         ora #$30
         sta $0498,x
         lda #$20
         sta $0495,x
         sta $0499,x
         sta $049a,x
         pla
         tay
         lda twelve,y
         sta $0496,x
         lda twelve+1,y
         sta $0497,x
         jmp loop03

sctlen   txa               ;length
         pha
         tya
         pha
         ldy e_sctn
         lda sctadl,y
         sta zp7
         lda sctadh,y
         sta zp8
         lda #$29
         sta numpnt+1
         lda #$06
         sta numpnt+2
         ldy #$00
         sty len_lo
         sty len_hi
         sty actdur
         beq sctcmd
skip_2   iny
         beq sctend
skip_1   iny
         beq sctend
sctcmd   lda (zp7),y
         cmp #$60
         bcs nonote
adddur   lda len_lo
         clc
         adc actdur
         sta len_lo
         bcc skip_1
         inc len_hi
         jmp skip_1
nonote   cmp #$6f
         beq adddur
         bcc skip_2
         cmp #$7f
         beq sctend
         cmp #$c0
         bcs skip_1
         sec
         sbc #$7f
         sta actdur
         jmp skip_1
sctend   ldx #$02
         lda len_lo
         jsr numout
         ldx #$00
         lda len_hi
         jsr numout
         pla
         tay
         pla
         tax
         rts

tr1out   txa               ;tracks
         pha
         tya
         pha
         jsr chk_fa
         lda #$79
         sta trkwrt+4
         sta numpnt+1
         lda #$04
         sta numpnt+2
         ldy e_tune
         lda tr1adl,y
         clc
         adc zp9
         sta zp7
         lda tr1adh,y
         adc #$00
         sta zp8
         jmp trkout

tr2out   txa
         pha
         tya
         pha
         jsr chk_fa
         lda #$82
         sta trkwrt+4
         sta numpnt+1
         lda #$04
         sta numpnt+2
         ldy e_tune
         lda tr2adl,y
         clc
         adc zp9
         sta zp7
         lda tr2adh,y
         adc #$00
         sta zp8
         jmp trkout

tr3out   txa
         pha
         tya
         pha
         jsr chk_fa
         lda #$8b
         sta trkwrt+4
         sta numpnt+1
         lda #$04
         sta numpnt+2
         ldy e_tune
         lda tr3adl,y
         clc
         adc zp9
         sta zp7
         lda tr3adh,y
         adc #$00
         sta zp8

trkout   ldy #$00
         ldx x_line,y
         tya
         pha
         clc
         adc zp9
         jsr numout
         inx
         inx
         lda (zp7),y
         cmp #$40
         bcs nottup
         pha
         lda #LO(tr_tup)
         ldy #HI(tr_tup)
trklin   sta trkwrt+1
         sty trkwrt+2
         ldy #$00
trkwrt   lda $face,y
         sta $0400,x
         inx
         iny
         cpy #$05
         bne trkwrt
         pla
         cmp #$ff
         beq nonumb
         dex
         dex
         jsr numout
nonumb   pla
         tay
         iny
         cpy #$06
         bne trkout+2
         dec zp7           ;top space
         ldy #$00
         lda (zp7),y
         inc zp7
         cmp #$ff
         bne nextra
         lda trkwrt+4
         sta cextra+1
         ldx #$07
         lda #$20
cextra   sta $0400,x
         dex
         bpl cextra
nextra   pla
         tay
         pla
         tax
         rts
nottup   cmp #$80
         bcs nottdn
         and #$3f
         pha
         lda #LO(tr_tdn)
         ldy #HI(tr_tdn)
         jmp trklin
nottdn   cmp #$e0
         bcs notsct
         and #$7f
         pha
         lda #LO(tr_sct)
         ldy #HI(tr_sct)
         jmp trklin
notsct   cmp #$f0
         beq haltvp
         bcs notvol
         and #$0f
         pha
         lda #LO(tr_vol)
         ldy #HI(tr_vol)
         jmp trklin
haltvp   lda #$ff
         pha
         lda #LO(tr_hlt)
         ldy #HI(tr_hlt)
         jmp trklin
notvol   cmp #$f8
         bcs notdec
         and #$0f
         pha
         lda #LO(tr_dec)
         ldy #HI(tr_dec)
         jmp trklin
notdec   cmp #$ff
         bcs notinc
         sec
         sbc #$f7
         pha
         lda #LO(tr_inc)
         ldy #HI(tr_inc)
         jmp trklin
notinc   cpy #$05
         beq skpclr
         txa
         pha
         clc
         adc trkwrt+4
         sta afterj+1
         lda trkwrt+5
         adc #$00
         sta afterj+2
         ldx #$25
         lda #$20
afterj   sta $face,x
         inx
         cpx #$2d
         bne afterj
         pla
         tax
         pla               ;y=y+1
         clc
         adc #$01
         pha
skpclr   iny
         lda (zp7),y
         pha
         lda #LO(tr_jmp)
         ldy #HI(tr_jmp)
         jmp trklin

f1_key   sei               ;play
         txa
         pha
         tya
         pha
         lda #$00
         sta e_radd
         sta e_ract
         sta e_rmax
         sta e_secs
         sta e_mins
         lda #$32
         sta e_clkt
         lda $0429
         cmp #$54
         bne *+16          ;sounds s.
         lda #$30
         sta $0719         ;clock
         sta $071a
         sta $071c
         sta $071d
         jsr setspd
         sta $d012
         lda #LO(call_1)
         sta $0314
         lda #HI(call_1)
         sta $0315
         lda #$80
         sta ttrack+1
         lda e_tune
         jsr $4000
         pla
         tay
         pla
         tax
         lda #$00
         cli
         rts

f2_key   sei               ;sector
         txa
         pha
         tya
         pha
         lda #$00
         sta trkpos
         sta trkpos+$07
         sta trkpos+$0e
         sta e_radd
         sta e_ract
         sta e_rmax
         sta e_secs
         sta e_mins
         lda #$32
         sta e_clkt
         lda $0429
         cmp #$54
         bne *+16          ;sounds s.
         lda #$30
         sta $0719         ;clock
         sta $071a
         sta $071c
         sta $071d
         jsr setspd
         sta $d012
         lda #LO(call_1)
         sta $0314
         lda #HI(call_1)
         sta $0315
         lda e_sctn
         ora #$80
         sta ttrack+1
         lda #LO(ttrack)      ;mod.init
         sta trk_lo
         lda #HI(ttrack)
         sta trk_hi
         lda #LO(etrack)
         sta trk_lo+$07
         sta trk_lo+$0e
         lda #HI(etrack)
         sta trk_hi+$07
         sta trk_hi+$0e
         jsr ctinit
         pla
         tay
         pla
         tax
         lda #$00
         cli
         rts

f3_key   sei               ;stop
         lda #LO(callno)
         sta $0314
         lda #HI(callno)
         sta $0315
         lda #$80
         sta ttrack+1
         lda #$fa
         sta $d012
         lda #$00
         sta $d418
         cli
         rts

f4_key   sei               ;sfx
         txa
         pha
         tya
         pha
         lda #$00
         sta trkpos
         sta trkpos+$07
         sta trkpos+$0e
         sta e_radd
         sta e_ract
         sta e_rmax
         sta e_secs
         sta e_mins
         lda #$32
         sta e_clkt
         lda $0429
         cmp #$54
         bne *+16          ;sounds s.
         lda #$30
         sta $0719         ;clock
         sta $071a
         sta $071c
         sta $071d
         jsr setspd
         sta $d012
         lda #LO(call_1)
         sta $0314
         lda #HI(call_1)
         sta $0315
         lda #$df          ;sct.#
         sta ttrack+1
         lda e_sndn        ;snd.#
         ora #$c0
         sta $cf00
         lda e_test        ;note
         sta $cf02
         lda #LO(ttrack)      ;mod.init
         sta trk_lo
         lda #HI(ttrack)
         sta trk_hi
         lda #LO(etrack)
         sta trk_lo+$07
         sta trk_lo+$0e
         lda #HI(etrack)
         sta trk_hi+$07
         sta trk_hi+$0e
         jsr ctinit
         pla
         tay
         pla
         tax
         lda #$00
         cli
         rts

spaces   lda $0314         ;sfx on?
         cmp #LO(callno)
         beq spcend
         lda ttrack+1
         cmp #$df
         bne spcend
         sei
         txa
         pha
         tya
         pha
         lda #$00
         sta trkpos
         sta trkpos+$07
         sta trkpos+$0e
         lda e_sndn        ;snd.#
         ora #$c0
         sta $cf00
         lda e_test        ;note
         sta $cf02
         lda #LO(ttrack)      ;mod.init
         sta trk_lo
         lda #HI(ttrack)
         sta trk_hi
         lda #LO(etrack)
         sta trk_lo+$07
         sta trk_lo+$0e
         lda #HI(etrack)
         sta trk_hi+$07
         sta trk_hi+$0e
         jsr ctinit
         pla
         tay
         pla
         tax
spcend   lda #$00
         cli
         rts

f5_key   lda $0314
         cmp #LO(callno)
         bne f5_end
         sei
         tya
         pha
         jsr setspd
         sta $d012
         lda #LO(call_1)
         sta $0314
         lda #HI(call_1)
         sta $0315
         lda f_type
         ora volume
         sta $d418
         pla
         tay
f5_end   lda #$00
         cli
         rts

f7_key   lda $0314
         cmp #LO(callno)
         beq f5_end
         sei
         txa
         pha
         tya
         pha
f7_fwd   ldx #$00
         dex
         bne *-1
         dex
         bne *-1
         jsr fast_f
         lda #$fe
         sta $dc00
         lda $dc01
         and #$08
         beq f7_fwd
         bit $d011
         bpl *-3
         bit $d011
         bmi *-3
         lda #$01
         sta $d019
         pla
         tay
         pla
         tax
         lda #$00
         cli
         rts

fast_f   dec e_clkt        ;time
         bne fast_e
         lda #$32          ;50 frames
         sta e_clkt
         lda #$19
         sta irqpnt+1
         lda #$07
         sta irqpnt+2
         lda e_secs
         sed
         clc
         adc #$01          ;inc secs
         cmp #$60
         beq fast_m
         sta e_secs
         cld
         jmp fast_s
fast_m   lda #$00          ;1 min
         sta e_secs
         lda e_mins
         clc
         adc #$01          ;inc mins
         cmp #$60
         bne fast_n
         lda #$00          ;1 hour
fast_n   sta e_mins
         cld
         ldx #$00
         jsr irqout
         lda e_secs
fast_s   ldx #$03
         jsr irqout
fast_e   jmp $4003

f6_key   dec e_tune
         jmp *+6
f8_key   inc e_tune
         txa
         pha
         lda zp9
         pha
         lda e_tune
         and #$1f
         sta e_tune
         tax
         jsr startw
         lda start1,x
         sta e_tr1p
         sta zp9
         jsr tr1out
         lda start2,x
         sta e_tr2p
         sta zp9
         jsr tr2out
         lda start3,x
         sta e_tr3p
         sta zp9
         jsr tr3out
         pla
         sta zp9
         pla
         tax
         lda #$01
         rts

onoff1   lda e_tr1x        ;trk1 on
         eor #$62          ;toggle
         sta e_tr1x
         lda $0429
         cmp #$54
         bne *+8
         lda e_tr1x
         sta $0430
         lda #$00
         rts
onoff2   lda e_tr2x
         eor #$62
         sta e_tr2x
         lda $0429
         cmp #$54
         bne *+8
         lda e_tr2x
         sta $0439
         lda #$00
         rts
onoff3   lda e_tr3x
         eor #$62
         sta e_tr3x
         lda $0429
         cmp #$54
         bne *+8
         lda e_tr3x
         sta $0442
         lda #$00
         rts

sounds   jsr sndtab        ;screen
         ldy e_sndn
         lda snd_wt,y
         sta zp9
         jsr wvetab
         lda snd_ft,y
         sta zp9
         jsr flttab
         lda snd_pt,y
         sta zp9
         jsr plstab
         lda e_gldp
         sta zp9
         jsr gldtab
         lda snd_st,y
         sta zp9
         jsr sldtab
         lda e_tune
         sta zp9
         jmp trstab

startw   txa               ;corner
         pha
         lda #$9e
         sta numpnt+1
         lda #$06
         sta numpnt+2
         ldx e_tune
         lda start1,x      ;trst
         ldx #$00
         jsr numout
         ldx e_tune
         lda start2,x
         ldx #$03
         jsr numout
         ldx e_tune
         lda start3,x
         ldx #$06
         jsr numout
         lda e_rmax
         ldx #$56
         jsr numout
         lda e_mins        ;time
         ldx #$7b
         jsr numout
         lda e_secs
         ldx #$7e
         jsr numout
         lda e_tune        ;tune#
         ldx #$cb
         jsr numout
         ldx e_tune
         lda speeds,x
         ldx #$ce
         jsr numout
         pla
         tax
         rts

keychk   cmp #$2c          ;trk.sw.
         bne *+5
         jmp onoff1
         cmp #$2e
         bne *+5
         jmp onoff2
         cmp #$2f
         bne *+5
         jmp onoff3
         cmp #$85          ;f-keys
         bne *+5
         jmp f1_key
         cmp #$86
         bne *+5
         jmp f3_key
         cmp #$87
         bne *+5
         jmp f5_key
         cmp #$88
         bne *+5
         jmp f7_key
         cmp #$89
         bne *+5
         jmp f2_key
         cmp #$8a
         bne *+5
         jmp f4_key
         cmp #$8b
         bne *+12
         lda $0429
         cmp #$53
         beq keyfnd
         jmp f6_key
         cmp #$8c
         bne *+14
         lda $0429
         cmp #$53
         beq keyfnd
         jmp f8_key
keyfnd   lda #$00
         rts

w_edit   ldy e_sndn        ;wvetab
         lda snd_wt,y
         sta zp9
         ldy #$00
         ldx #$00
w_edi2   lda #zp1
         sta w_zpge+1
         sta w_zpgf+1
         lda e_msg1
         jsr fncout
w_loop   jsr colafp
         lda #$01
         sta $d945,x
         sta $d946,x
         jsr wvetab
w_newc   jsr getkey        ;new char
         cmp #$0d
         bne w_down
         cpy #$05
         bne w_rint
         ldx x_line,y
         lda zp9
         cmp #$fa
         beq w_edi2
         inc zp9
         jmp w_edi2
w_rint   iny
         ldx x_line,y
         jmp w_edi2
w_down   cmp #$11
         bne w_home
         cpy #$05
         bne w_dint
         lda zp9           ;scroll
         cmp #$fa
         beq w_newc
         inc zp9
         jmp w_loop
w_dint   iny               ;down
         txa
         clc
         adc #$28
         tax
         jmp w_loop
w_home   cmp #$13
         bne w_delc
         ldy #$00
         sty zp9
         jmp w_edi2-2
w_delc   cmp #$14          ;delete
         bne w_rght
         sei
         txa
         pha
         tya
         pha
         clc
         adc zp9
         cmp #$ff
         beq w_dele
         ldx #$3f          ;mod.pntr
w_dcmp   cmp snd_wt,x
         bcs w_dlow
         dec snd_wt,x
w_dlow   dex
         bpl w_dcmp
         sta e_orad
         ldx #$00
w_djst   lda wve_fm,x
         cmp #$ff
         bne w_djnx
         lda e_orad
         cmp wve_st,x
         bcs w_djnx
         dec wve_st,x
w_djnx   inx
         bne w_djst
         jsr sndtab
         lda #$ff
         sec
         sbc zp9
         sta w_dcpy+1
w_delp   iny
         lda (zp1),y
         dey
         sta (zp1),y
         iny
         lda (zp3),y
         dey
         sta (zp3),y
         iny
w_dcpy   cpy #$00
         bne w_delp
w_dele   lda #$00
         sta (zp1),y
         sta (zp3),y
         lda #$01
         sta $d019
         pla
         tay
         pla
         tax
         cli
         jmp w_loop
w_rght   cmp #$1d
         bne w_uppp
         lda w_zpge+1
         cmp #zp3
         bne *+5
         jmp w_newc
         inc w_zpge+1
         inc w_zpge+1
         inc w_zpgf+1
         inc w_zpgf+1
         inx
         inx
         inx
         stx e_orad
         lda w_zpge+1
         sec
         sbc #zp1
         lsr a
         tax
         lda e_msg1,x
         jsr fncout
         ldx e_orad
         jmp w_loop
w_uppp   cmp #$91
         bne w_inst
         cpy #$00
         bne w_uint
         lda zp9           ;scroll
         bne *+5
         jmp w_newc
         dec zp9
         jmp w_loop
w_uint   dey               ;down
         txa
         sec
         sbc #$28
         tax
         jmp w_loop
w_inst   cmp #$94
         bne w_left
         sei
         txa
         pha
         sty w_icpy+1
         tya
         clc
         adc zp9
         cmp #$ff
         beq w_inse
         ldx #$3f
w_icmp   cmp snd_wt,x      ;mod.pntr
         beq w_ilow-3
         bcs w_ilow
         inc snd_wt,x
w_ilow   dex
         bpl w_icmp
         sta e_orad
         ldx #$00
w_ijst   lda wve_fm,x
         cmp #$ff
         bne w_ijnx
         lda e_orad
         cmp wve_st,x
         beq w_ijnx-3
         bcs w_ijnx
         inc wve_st,x
w_ijnx   inx
         bne w_ijst
         jsr sndtab
         lda #$ff
         sec
         sbc zp9
         tay
w_islp   dey
         lda (zp1),y
         iny
         sta (zp1),y
         dey
         lda (zp3),y
         iny
         sta (zp3),y
         dey
w_icpy   cpy #$00
         bne w_islp
w_inse   lda #$00
         sta (zp1),y
         sta (zp3),y
         lda #$01
         sta $d019
         pla
         tax
         cli
         jmp w_loop
w_left   cmp #$9d
         bne w_inot
         lda w_zpge+1
         cmp #zp1
         bne *+5
         jmp w_newc
         dec w_zpge+1
         dec w_zpge+1
         dec w_zpgf+1
         dec w_zpgf+1
         dex
         dex
         dex
         stx e_orad
         lda w_zpge+1
         sec
         sbc #zp1
         lsr a
         tax
         lda e_msg1,x
         jsr fncout
         ldx e_orad
         jmp w_loop
w_inot   cmp #$db          ;sh.+
         bne w_dnot
         lda e_test
         cmp #$5e
         beq *+8
         inc e_test
         jsr sndtab
         jmp w_newc
w_dnot   cmp #$dd
         bne w_spax
         lda e_test
         beq *+8
         dec e_test
         jsr sndtab
         jmp w_newc
w_spax   cmp #$20          ;test
         bne w_gsnd
         jsr spaces
         jmp w_newc
w_gsnd   cmp #$28          ;exit
         bcs w_isnd
         and #$07
         tay
         jmp colafp
w_isnd   cmp #$2d          ;snd.#
         beq w_dsnd
         cmp #$2b
         bne w_scrn
         inc e_sndn
         jmp *+6
w_dsnd   dec e_sndn
         lda e_sndn
         and #$3f
         sta e_sndn
         jsr sounds
         jmp w_edit
w_scrn   cmp #$5f          ;to editor
         bne w_tr1x
         ldy #$00
         jmp colafp
w_tr1x   jsr keychk
         bne w_sret
         jmp w_newc
w_sret   cmp #$8d
         bne w_numb
         ldy #$01
         jmp colafp
w_numb   cmp #$30
         bcc w_back
         cmp #$3a
         bcc w_back+3
         cmp #$41
         bcc w_back
         cmp #$47
         bcc w_back+3
w_back   jmp w_newc
         cmp #$40
         bcc *+5
         sec
         sbc #$07
         and #$0f
         sta e_orad
w_zpge   lda (zp1),y
         asl a
         asl a
         asl a
         asl a
         ora e_orad
w_zpgf   sta (zp1),y
         jmp w_newc-3

f_edit   ldy e_sndn        ;flttab
         lda snd_ft,y
         sta zp9
         ldy #$00
         ldx #$00
f_edi2   lda #zp1
         sta f_zpge+1
         sta f_zpgf+1
         lda e_msg1
         jsr fncout
f_loop   jsr colafp
         lda #$01
         sta $d950,x
         sta $d951,x
         jsr flttab
f_newc   jsr getkey        ;new char
         cmp #$0d
         bne f_down
         cpy #$05
         bne f_rint
         ldx x_line,y
         lda zp9
         cmp #$fa
         beq f_edi2
         inc zp9
         jmp f_edi2
f_rint   iny
         ldx x_line,y
         jmp f_edi2
f_down   cmp #$11
         bne f_home
         cpy #$05
         bne f_dint
         lda zp9           ;scroll
         cmp #$fa
         beq f_newc
         inc zp9
         jmp f_loop
f_dint   iny               ;down
         txa
         clc
         adc #$28
         tax
         jmp f_loop
f_home   cmp #$13
         bne f_delc
         ldy #$00
         sty zp9
         jmp f_edi2-2
f_delc   cmp #$14          ;delete
         bne f_rght
         sei
         txa
         pha
         tya
         pha
         clc
         adc zp9
         cmp #$ff
         beq f_dele
         ldx #$3f          ;mod.pntr
f_dcmp   cmp snd_ft,x
         bcs f_dlow
         dec snd_ft,x
f_dlow   dex
         bpl f_dcmp
         sta e_orad
         ldx #$00
f_djst   lda flt_rp,x
         cmp #$ff
         bne f_djnx
         lda e_orad
         cmp flt_fh,x
         bcs f_djnx
         dec flt_fh,x
f_djnx   inx
         bne f_djst
         jsr sndtab
         lda #$ff
         sec
         sbc zp9
         sta f_dcpy+1
f_delp   iny
         lda (zp1),y
         dey
         sta (zp1),y
         iny
         lda (zp3),y
         dey
         sta (zp3),y
         iny
         lda (zp5),y
         dey
         sta (zp5),y
         iny
f_dcpy   cpy #$00
         bne f_delp
f_dele   lda #$00
         sta (zp1),y
         sta (zp3),y
         sta (zp5),y
         lda #$01
         sta $d019
         pla
         tay
         pla
         tax
         cli
         jmp f_loop
f_rght   cmp #$1d
         bne f_uppp
         lda f_zpge+1
         cmp #zp5
         bne *+5
         jmp f_newc
         inc f_zpge+1
         inc f_zpge+1
         inc f_zpgf+1
         inc f_zpgf+1
         inx
         inx
         inx
         stx e_orad
         lda f_zpge+1
         sec
         sbc #zp1
         lsr a
         tax
         lda e_msg1,x
         jsr fncout
         ldx e_orad
         jmp f_loop
f_uppp   cmp #$91
         bne f_inst
         cpy #$00
         bne f_uint
         lda zp9           ;scroll
         bne *+5
         jmp f_newc
         dec zp9
         jmp f_loop
f_uint   dey               ;down
         txa
         sec
         sbc #$28
         tax
         jmp f_loop
f_inst   cmp #$94
         bne f_left
         sei
         txa
         pha
         sty f_icpy+1
         tya
         clc
         adc zp9
         cmp #$ff
         beq f_inse
         ldx #$3f
f_icmp   cmp snd_ft,x      ;mod.pntr
         beq f_ilow-3
         bcs f_ilow
         inc snd_ft,x
f_ilow   dex
         bpl f_icmp
         sta e_orad
         ldx #$00
f_ijst   lda flt_rp,x
         cmp #$ff
         bne f_ijnx
         lda e_orad
         cmp flt_fh,x
         beq f_ijnx-3
         bcs f_ijnx
         inc flt_fh,x
f_ijnx   inx
         bne f_ijst
         jsr sndtab
         lda #$ff
         sec
         sbc zp9
         tay
f_islp   dey
         lda (zp1),y
         iny
         sta (zp1),y
         dey
         lda (zp3),y
         iny
         sta (zp3),y
         dey
         lda (zp5),y
         iny
         sta (zp5),y
         dey
f_icpy   cpy #$00
         bne f_islp
f_inse   lda #$00
         sta (zp1),y
         sta (zp3),y
         sta (zp5),y
         lda #$01
         sta $d019
         pla
         tax
         cli
         jmp f_loop
f_left   cmp #$9d
         bne f_inot
         lda f_zpge+1
         cmp #zp1
         bne *+5
         jmp f_newc
         dec f_zpge+1
         dec f_zpge+1
         dec f_zpgf+1
         dec f_zpgf+1
         dex
         dex
         dex
         stx e_orad
         lda f_zpge+1
         sec
         sbc #zp1
         lsr a
         tax
         lda e_msg1,x
         jsr fncout
         ldx e_orad
         jmp f_loop
f_inot   cmp #$db          ;sh.+
         bne f_dnot
         lda e_test
         cmp #$5e
         beq *+8
         inc e_test
         jsr sndtab
         jmp f_newc
f_dnot   cmp #$dd
         bne f_spax
         lda e_test
         beq *+8
         dec e_test
         jsr sndtab
         jmp f_newc
f_spax   cmp #$20          ;test
         bne f_gsnd
         jsr spaces
         jmp f_newc
f_gsnd   cmp #$28          ;exit
         bcs f_isnd
         and #$07
         tay
         jmp colafp
f_isnd   cmp #$2d          ;snd.#
         beq f_dsnd
         cmp #$2b
         bne f_scrn
         inc e_sndn
         jmp *+6
f_dsnd   dec e_sndn
         lda e_sndn
         and #$3f
         sta e_sndn
         jsr sounds
         jmp f_edit
f_scrn   cmp #$5f          ;to editor
         bne f_tr1x
         ldy #$00
         jmp colafp
f_tr1x   jsr keychk
         bne f_sret
         jmp f_newc
f_sret   cmp #$8d
         bne f_numb
         ldy #$01
         jmp colafp
f_numb   cmp #$30
         bcc f_back
         cmp #$3a
         bcc f_back+3
         cmp #$41
         bcc f_back
         cmp #$47
         bcc f_back+3
f_back   jmp f_newc
         cmp #$40
         bcc *+5
         sec
         sbc #$07
         and #$0f
         sta e_orad
f_zpge   lda (zp1),y
         asl a
         asl a
         asl a
         asl a
         ora e_orad
f_zpgf   sta (zp1),y
         jmp f_newc-3

p_edit   ldy e_sndn        ;plstab
         lda snd_pt,y
         sta zp9
         ldy #$00
         ldx #$00
p_edi2   lda #zp1
         sta p_zpge+1
         sta p_zpgf+1
         lda e_msg1
         jsr fncout
p_loop   jsr colafp
         lda #$01
         sta $d95e,x
         sta $d95f,x
         jsr plstab
p_newc   jsr getkey        ;new char
         cmp #$0d
         bne p_down
         cpy #$05
         bne p_rint
         ldx x_line,y
         lda zp9
         cmp #$fa
         beq p_edi2
         inc zp9
         jmp p_edi2
p_rint   iny
         ldx x_line,y
         jmp p_edi2
p_down   cmp #$11
         bne p_home
         cpy #$05
         bne p_dint
         lda zp9           ;scroll
         cmp #$fa
         beq p_newc
         inc zp9
         jmp p_loop
p_dint   iny               ;down
         txa
         clc
         adc #$28
         tax
         jmp p_loop
p_home   cmp #$13
         bne p_delc
         ldy #$00
         sty zp9
         jmp p_edi2-2
p_delc   cmp #$14          ;delete
         bne p_rght
         sei
         txa
         pha
         tya
         pha
         clc
         adc zp9
         cmp #$ff
         beq p_dele
         ldx #$3f          ;mod.pntr
p_dcmp   cmp snd_pt,x
         bcs p_dlow
         dec snd_pt,x
p_dlow   dex
         bpl p_dcmp
         sta e_orad
         ldx #$00
p_djst   lda pls_rp,x
         cmp #$ff
         bne p_djnx
         lda e_orad
         cmp pls_ph,x
         bcs p_djnx
         dec pls_ph,x
p_djnx   inx
         bne p_djst
         jsr sndtab
         lda #$ff
         sec
         sbc zp9
         sta p_dcpy+1
p_delp   iny
         lda (zp1),y
         dey
         sta (zp1),y
         iny
         lda (zp3),y
         dey
         sta (zp3),y
         iny
         lda (zp5),y
         dey
         sta (zp5),y
         iny
p_dcpy   cpy #$00
         bne p_delp
p_dele   lda #$00
         sta (zp1),y
         sta (zp3),y
         sta (zp5),y
         lda #$01
         sta $d019
         pla
         tay
         pla
         tax
         cli
         jmp p_loop
p_rght   cmp #$1d
         bne p_uppp
         lda p_zpge+1
         cmp #zp5
         bne *+5
         jmp p_newc
         inc p_zpge+1
         inc p_zpge+1
         inc p_zpgf+1
         inc p_zpgf+1
         inx
         inx
         inx
         stx e_orad
         lda p_zpge+1
         sec
         sbc #zp1
         lsr a
         tax
         lda e_msg1,x
         jsr fncout
         ldx e_orad
         jmp p_loop
p_uppp   cmp #$91
         bne p_inst
         cpy #$00
         bne p_uint
         lda zp9           ;scroll
         bne *+5
         jmp p_newc
         dec zp9
         jmp p_loop
p_uint   dey               ;down
         txa
         sec
         sbc #$28
         tax
         jmp p_loop
p_inst   cmp #$94
         bne p_left
         sei
         txa
         pha
         sty p_icpy+1
         tya
         clc
         adc zp9
         cmp #$ff
         beq p_inse
         ldx #$3f
p_icmp   cmp snd_pt,x      ;mod.pntr
         beq p_ilow-3
         bcs p_ilow
         inc snd_pt,x
p_ilow   dex
         bpl p_icmp
         sta e_orad
         ldx #$00
p_ijst   lda pls_rp,x
         cmp #$ff
         bne p_ijnx
         lda e_orad
         cmp pls_ph,x
         beq p_ijnx-3
         bcs p_ijnx
         inc pls_ph,x
p_ijnx   inx
         bne p_ijst
         jsr sndtab
         lda #$ff
         sec
         sbc zp9
         tay
p_islp   dey
         lda (zp1),y
         iny
         sta (zp1),y
         dey
         lda (zp3),y
         iny
         sta (zp3),y
         dey
         lda (zp5),y
         iny
         sta (zp5),y
         dey
p_icpy   cpy #$00
         bne p_islp
p_inse   lda #$00
         sta (zp1),y
         sta (zp3),y
         sta (zp5),y
         lda #$01
         sta $d019
         pla
         tax
         cli
         jmp p_loop
p_left   cmp #$9d
         bne p_inot
         lda p_zpge+1
         cmp #zp1
         bne *+5
         jmp p_newc
         dec p_zpge+1
         dec p_zpge+1
         dec p_zpgf+1
         dec p_zpgf+1
         dex
         dex
         dex
         stx e_orad
         lda p_zpge+1
         sec
         sbc #zp1
         lsr a
         tax
         lda e_msg1,x
         jsr fncout
         ldx e_orad
         jmp p_loop
p_inot   cmp #$db          ;sh.+
         bne p_dnot
         lda e_test
         cmp #$5e
         beq *+8
         inc e_test
         jsr sndtab
         jmp p_newc
p_dnot   cmp #$dd
         bne p_spax
         lda e_test
         beq *+8
         dec e_test
         jsr sndtab
         jmp p_newc
p_spax   cmp #$20          ;test
         bne p_gsnd
         jsr spaces
         jmp p_newc
p_gsnd   cmp #$28          ;exit
         bcs p_isnd
         and #$07
         tay
         jmp colafp
p_isnd   cmp #$2d          ;snd.#
         beq p_dsnd
         cmp #$2b
         bne p_scrn
         inc e_sndn
         jmp *+6
p_dsnd   dec e_sndn
         lda e_sndn
         and #$3f
         sta e_sndn
         jsr sounds
         jmp p_edit
p_scrn   cmp #$5f          ;to editor
         bne p_tr1x
         ldy #$00
         jmp colafp
p_tr1x   jsr keychk
         bne p_sret
         jmp p_newc
p_sret   cmp #$8d
         bne p_numb
         ldy #$01
         jmp colafp
p_numb   cmp #$30
         bcc p_back
         cmp #$3a
         bcc p_back+3
         cmp #$41
         bcc p_back
         cmp #$47
         bcc p_back+3
p_back   jmp p_newc
         cmp #$40
         bcc *+5
         sec
         sbc #$07
         and #$0f
         sta e_orad
p_zpge   lda (zp1),y
         asl a
         asl a
         asl a
         asl a
         ora e_orad
p_zpgf   sta (zp1),y
         jmp p_newc-3

g_edit   lda e_gldp        ;gldtab
         sta zp9
         ldy #$00
         ldx #$00
g_edi2   lda #zp1
         sta g_zpge+1
         sta g_zpgf+1
         lda e_msg1
         jsr fncout
g_loop   jsr colgld
         lda #$01
         sta $dad5,x
         sta $dad6,x
         jsr gldtab
g_newc   jsr getkey        ;new char
         cmp #$0d
         bne g_down
         cpy #$05
         bne g_rint
         ldx x_line,y
         lda zp9
         cmp #$0a
         beq g_edi2
         inc zp9
         jmp g_edi2
g_rint   iny
         ldx x_line,y
         jmp g_edi2
g_down   cmp #$11
         bne g_home
         cpy #$05
         bne g_dint
         lda zp9           ;scroll
         cmp #$0a
         beq g_newc
         inc zp9
         jmp g_loop
g_dint   iny               ;down
         txa
         clc
         adc #$28
         tax
         jmp g_loop
g_home   cmp #$13
         bne g_delc
         ldy #$00
         sty zp9
         jmp g_edi2-2
g_delc   cmp #$14          ;delete
         bne g_rght
         txa
         pha
         tya
         pha
         clc
         adc zp9
         cmp #$0f
         beq g_dele
         lda #$0f
         sec
         sbc zp9
         sta g_dcpy+1
g_delp   iny
         lda (zp1),y
         dey
         sta (zp1),y
         iny
         lda (zp3),y
         dey
         sta (zp3),y
         iny
g_dcpy   cpy #$00
         bne g_delp
g_dele   lda #$00
         sta (zp1),y
         sta (zp3),y
         pla
         tay
         pla
         tax
         jmp g_loop
g_rght   cmp #$1d
         bne g_uppp
         lda g_zpge+1
         cmp #zp3
         bne *+5
         jmp g_newc
         inc g_zpge+1
         inc g_zpge+1
         inc g_zpgf+1
         inc g_zpgf+1
         inx
         inx
         inx
         stx e_orad
         lda g_zpge+1
         sec
         sbc #zp1
         lsr a
         tax
         lda e_msg1,x
         jsr fncout
         ldx e_orad
         jmp g_loop
g_uppp   cmp #$91
         bne g_inst
         cpy #$00
         bne g_uint
         lda zp9           ;scroll
         bne *+5
         jmp g_newc
         dec zp9
         jmp g_loop
g_uint   dey               ;down
         txa
         sec
         sbc #$28
         tax
         jmp g_loop
g_inst   cmp #$94
         bne g_left
         txa
         pha
         sty g_icpy+1
         tya
         clc
         adc zp9
         cmp #$0f
         beq g_inse
         lda #$0f
         sec
         sbc zp9
         tay
g_islp   dey
         lda (zp1),y
         iny
         sta (zp1),y
         dey
         lda (zp3),y
         iny
         sta (zp3),y
         dey
g_icpy   cpy #$00
         bne g_islp
g_inse   lda #$00
         sta (zp1),y
         sta (zp3),y
         pla
         tax
         jmp g_loop
g_left   cmp #$9d
         bne g_spax
         lda g_zpge+1
         cmp #zp1
         bne *+5
         jmp g_newc
         dec g_zpge+1
         dec g_zpge+1
         dec g_zpgf+1
         dec g_zpgf+1
         dex
         dex
         dex
         stx e_orad
         lda g_zpge+1
         sec
         sbc #zp1
         lsr a
         tax
         lda e_msg1,x
         jsr fncout
         ldx e_orad
         jmp g_loop
g_spax   cmp #$20          ;test
         bne g_gsnd
         jsr spaces
         jmp g_newc
g_gsnd   cmp #$28          ;exit
         bcs g_scrn
         and #$07
         tay
         lda zp9
         sta e_gldp
         jmp colgld
g_scrn   cmp #$5f          ;to editor
         bne g_tr1x
         ldy #$00
         lda zp9
         sta e_gldp
         jmp colgld
g_tr1x   jsr keychk
         bne g_numb
         jmp g_newc
g_numb   cmp #$30
         bcc g_back
         cmp #$3a
         bcc g_back+3
         cmp #$41
         bcc g_back
         cmp #$47
         bcc g_back+3
g_back   jmp g_newc
         cmp #$40
         bcc *+5
         sec
         sbc #$07
         and #$0f
         sta e_orad
g_zpge   lda (zp1),y
         asl a
         asl a
         asl a
         asl a
         ora e_orad
g_zpgf   sta (zp1),y
         jmp g_newc-3

v_edit   ldy e_sndn        ;sldtab
         lda snd_st,y
         sta zp9
         ldy #$00
         ldx #$00
v_edi2   lda #zp1
         sta v_zpge+1
         sta v_zpgf+1
         lda e_msg1
         jsr fncout
v_loop   jsr colgld
         lda #$01
         sta $dae0,x
         sta $dae1,x
         jsr sldtab
v_newc   jsr getkey        ;new char
         cmp #$0d
         bne v_down
         cpy #$05
         bne v_rint
         ldx x_line,y
         lda zp9
         cmp #$fa
         beq v_edi2
         inc zp9
         jmp v_edi2
v_rint   iny
         ldx x_line,y
         jmp v_edi2
v_down   cmp #$11
         bne v_home
         cpy #$05
         bne v_dint
         lda zp9           ;scroll
         cmp #$fa
         beq v_newc
         inc zp9
         jmp v_loop
v_dint   iny               ;down
         txa
         clc
         adc #$28
         tax
         jmp v_loop
v_home   cmp #$13
         bne v_delc
         ldy #$00
         sty zp9
         jmp v_edi2-2
v_delc   cmp #$14          ;delete
         bne v_rght
         sei
         txa
         pha
         tya
         pha
         clc
         adc zp9
         cmp #$ff
         beq v_dele
         ldx #$3f          ;mod.pntr
v_dcmp   cmp snd_st,x
         bcs v_dlow
         dec snd_st,x
v_dlow   dex
         bpl v_dcmp
         sta e_orad
         ldx #$00
v_djst   lda sld_rp,x
         cmp #$ff
         bne v_djnx
         lda e_orad
         cmp sld_fh,x
         bcs v_djnx
         dec sld_fh,x
v_djnx   inx
         bne v_djst
         jsr sndtab
         lda #$ff
         sec
         sbc zp9
         sta v_dcpy+1
v_delp   iny
         lda (zp1),y
         dey
         sta (zp1),y
         iny
         lda (zp3),y
         dey
         sta (zp3),y
         iny
         lda (zp5),y
         dey
         sta (zp5),y
         iny
v_dcpy   cpy #$00
         bne v_delp
v_dele   lda #$00
         sta (zp1),y
         sta (zp3),y
         sta (zp5),y
         lda #$01
         sta $d019
         pla
         tay
         pla
         tax
         cli
         jmp v_loop
v_rght   cmp #$1d
         bne v_uppp
         lda v_zpge+1
         cmp #zp5
         bne *+5
         jmp v_newc
         inc v_zpge+1
         inc v_zpge+1
         inc v_zpgf+1
         inc v_zpgf+1
         inx
         inx
         inx
         stx e_orad
         lda v_zpge+1
         sec
         sbc #zp1
         lsr a
         tax
         lda e_msg1,x
         jsr fncout
         ldx e_orad
         jmp v_loop
v_uppp   cmp #$91
         bne v_inst
         cpy #$00
         bne v_uint
         lda zp9           ;scroll
         bne *+5
         jmp v_newc
         dec zp9
         jmp v_loop
v_uint   dey               ;down
         txa
         sec
         sbc #$28
         tax
         jmp v_loop
v_inst   cmp #$94
         bne v_left
         sei
         txa
         pha
         sty v_icpy+1
         tya
         clc
         adc zp9
         cmp #$ff
         beq v_inse
         ldx #$3f
v_icmp   cmp snd_st,x      ;mod.pntr
         beq v_ilow-3
         bcs v_ilow
         inc snd_st,x
v_ilow   dex
         bpl v_icmp
         sta e_orad
         ldx #$00
v_ijst   lda sld_rp,x
         cmp #$ff
         bne v_ijnx
         lda e_orad
         cmp sld_fh,x
         beq v_ijnx-3
         bcs v_ijnx
         inc sld_fh,x
v_ijnx   inx
         bne v_ijst
         jsr sndtab
         lda #$ff
         sec
         sbc zp9
         tay
v_islp   dey
         lda (zp1),y
         iny
         sta (zp1),y
         dey
         lda (zp3),y
         iny
         sta (zp3),y
         dey
         lda (zp5),y
         iny
         sta (zp5),y
         dey
v_icpy   cpy #$00
         bne v_islp
v_inse   lda #$00
         sta (zp1),y
         sta (zp3),y
         sta (zp5),y
         lda #$01
         sta $d019
         pla
         tax
         cli
         jmp v_loop
v_left   cmp #$9d
         bne v_inot
         lda v_zpge+1
         cmp #zp1
         bne *+5
         jmp v_newc
         dec v_zpge+1
         dec v_zpge+1
         dec v_zpgf+1
         dec v_zpgf+1
         dex
         dex
         dex
         stx e_orad
         lda v_zpge+1
         sec
         sbc #zp1
         lsr a
         tax
         lda e_msg1,x
         jsr fncout
         ldx e_orad
         jmp v_loop
v_inot   cmp #$db          ;sh.+
         bne v_dnot
         lda e_test
         cmp #$5e
         beq *+8
         inc e_test
         jsr sndtab
         jmp v_newc
v_dnot   cmp #$dd
         bne v_spax
         lda e_test
         beq *+8
         dec e_test
         jsr sndtab
         jmp v_newc
v_spax   cmp #$20          ;test
         bne v_gsnd
         jsr spaces
         jmp v_newc
v_gsnd   cmp #$28          ;exit
         bcs v_isnd
         and #$07
         tay
         jmp colgld
v_isnd   cmp #$2d          ;snd.#
         beq v_dsnd
         cmp #$2b
         bne v_scrn
         inc e_sndn
         jmp *+6
v_dsnd   dec e_sndn
         lda e_sndn
         and #$3f
         sta e_sndn
         jsr sounds
         jmp v_edit
v_scrn   cmp #$5f          ;to editor
         bne v_tr1x
         ldy #$00
         jmp colgld
v_tr1x   jsr keychk
         bne v_sret
         jmp v_newc
v_sret   cmp #$8d
         bne v_numb
         ldy #$01
         jmp colgld
v_numb   cmp #$30
         bcc v_back
         cmp #$3a
         bcc v_back+3
         cmp #$41
         bcc v_back
         cmp #$47
         bcc v_back+3
v_back   jmp v_newc
         cmp #$40
         bcc *+5
         sec
         sbc #$07
         and #$0f
         sta e_orad
v_zpge   lda (zp1),y
         asl a
         asl a
         asl a
         asl a
         ora e_orad
v_zpgf   sta (zp1),y
         jmp v_newc-3

r_edit   lda e_tune        ;trstab
         sta zp9
         ldy #$00
         ldx #$00
r_edi2   lda #zp1
         sta r_zpge+1
         sta r_zpgf+1
         lda e_msg1
         jsr fncout
r_loop   jsr colgld
         lda #$01
         sta $daee,x
         sta $daef,x
         jsr trstab
r_newc   jsr getkey        ;new char
         cmp #$0d
         bne r_down
         cpy #$05
         bne r_rint
         ldx x_line,y
         lda zp9
         cmp #$1a
         beq r_edi2
         inc zp9
         jmp r_edi2
r_rint   iny
         ldx x_line,y
         jmp r_edi2
r_down   cmp #$11
         bne r_home
         cpy #$05
         bne r_dint
         lda zp9           ;scroll
         cmp #$1a
         beq r_newc
         inc zp9
         jmp r_loop
r_dint   iny               ;down
         txa
         clc
         adc #$28
         tax
         jmp r_loop
r_home   cmp #$13
         bne r_delc
         ldy #$00
         sty zp9
         jmp r_edi2-2
r_delc   cmp #$14          ;delete
         bne r_rght
         txa
         pha
         tya
         pha
         clc
         adc zp9
         cmp #$1f
         beq r_dele
         lda #$1f
         sec
         sbc zp9
         sta r_dcpy+1
r_delp   iny
         lda (zp1),y
         dey
         sta (zp1),y
         iny
         lda (zp3),y
         dey
         sta (zp3),y
         iny
         lda (zp5),y
         dey
         sta (zp5),y
         iny
r_dcpy   cpy #$00
         bne r_delp
r_dele   lda #$00
         sta (zp1),y
         sta (zp3),y
         sta (zp5),y
         pla
         tay
         pla
         tax
         jmp r_loop
r_rght   cmp #$1d
         bne r_uppp
         lda r_zpge+1
         cmp #zp5
         bne *+5
         jmp r_newc
         inc r_zpge+1
         inc r_zpge+1
         inc r_zpgf+1
         inc r_zpgf+1
         inx
         inx
         inx
         stx e_orad
         lda r_zpge+1
         sec
         sbc #zp1
         lsr a
         tax
         lda e_msg1,x
         jsr fncout
         ldx e_orad
         jmp r_loop
r_uppp   cmp #$91
         bne r_inst
         cpy #$00
         bne r_uint
         lda zp9           ;scroll
         bne *+5
         jmp r_newc
         dec zp9
         jmp r_loop
r_uint   dey               ;down
         txa
         sec
         sbc #$28
         tax
         jmp r_loop
r_inst   cmp #$94
         bne r_left
         txa
         pha
         sty r_icpy+1
         tya
         clc
         adc zp9
         cmp #$1f
         beq r_inse
         lda #$1f
         sec
         sbc zp9
         tay
r_islp   dey
         lda (zp1),y
         iny
         sta (zp1),y
         dey
         lda (zp3),y
         iny
         sta (zp3),y
         dey
         lda (zp5),y
         iny
         sta (zp5),y
         dey
r_icpy   cpy #$00
         bne r_islp
r_inse   lda #$00
         sta (zp1),y
         sta (zp3),y
         sta (zp5),y
         pla
         tax
         jmp r_loop
r_left   cmp #$9d
         bne r_inot
         lda r_zpge+1
         cmp #zp1
         bne *+5
         jmp r_newc
         dec r_zpge+1
         dec r_zpge+1
         dec r_zpgf+1
         dec r_zpgf+1
         dex
         dex
         dex
         stx e_orad
         lda r_zpge+1
         sec
         sbc #zp1
         lsr a
         tax
         lda e_msg1,x
         jsr fncout
         ldx e_orad
         jmp r_loop
r_inot   cmp #$db          ;sh.+
         bne r_dnot
         lda e_test
         cmp #$5e
         beq *+8
         inc e_test
         jsr sndtab
         jmp r_newc
r_dnot   cmp #$dd
         bne r_spax
         lda e_test
         beq *+8
         dec e_test
         jsr sndtab
         jmp r_newc
r_spax   cmp #$20          ;test
         bne r_gsnd
         jsr spaces
         jmp r_newc
r_gsnd   cmp #$28          ;exit
         bcs r_isnd
         and #$07
         tay
         jmp colgld
r_isnd   cmp #$2d          ;snd.#
         beq r_dsnd
         cmp #$2b
         bne r_scrn
         inc e_sndn
         jmp *+6
r_dsnd   dec e_sndn
         lda e_sndn
         and #$3f
         sta e_sndn
         lda zp9
         pha
         jsr sounds
         pla
         jmp r_edit+3
r_scrn   cmp #$5f          ;to editor
         bne r_tr1x
         ldy #$00
         jmp colgld
r_tr1x   jsr keychk
         bne r_numb
         jmp r_newc
r_numb   cmp #$30
         bcc r_back
         cmp #$3a
         bcc r_back+3
         cmp #$41
         bcc r_back
         cmp #$47
         bcc r_back+3
r_back   jmp r_newc
         cmp #$40
         bcc *+5
         sec
         sbc #$07
         and #$0f
         sta e_orad
r_zpge   lda (zp1),y
         asl a
         asl a
         asl a
         asl a
         ora e_orad
r_zpgf   sta (zp1),y
         jmp r_newc-3


i_edit   jsr sounds
         jsr sndtab
i_loop   lda e_spos
         asl a
         asl a
         asl a
         asl a
         asl a
         asl a
         php
         clc
         adc #$40
         sta zp1
         lda #$49
         adc #$00
         plp
         adc #$00
         sta zp2
         lda e_spos
         asl a
         clc
         adc e_spos
         tax
         ldy e_sndn
         lda e_spos
         jsr fncout
i_wcol   jsr colsnd
         lda #$01
         sta $d882,x
         sta $d883,x
i_newc   jsr getkey
         cmp #$0d
         bne i_down
         lda snd_ad,y
         sta $56f8
         lda snd_sr,y
         sta $56f9
         lda snd_gt,y
         sta $56fa
         lda snd_wt,y
         sta $56fb
         lda snd_ft,y
         sta $56fc
         lda snd_pt,y
         sta $56fd
         lda snd_st,y
         sta $56fe
         jmp i_wcol
i_down   cmp #$11
         bne i_home
         lda (zp1),y
         clc
         adc #$01
         sta (zp1),y
         jmp i_edit
i_home   cmp #$13
         bne i_rght
         lda #$00
         sta e_sndn
         sta e_spos
         jmp i_edit
i_rght   cmp #$1d
         bne i_uppp
         lda e_spos
         cmp #$06
         beq i_newc
         inc e_spos
         jmp i_loop
i_uppp   cmp #$91
         bne i_left
         lda (zp1),y
         sec
         sbc #$01
         sta (zp1),y
         jmp i_edit
i_left   cmp #$9d
         bne i_inot
         lda e_spos
         beq i_newc
         dec e_spos
         jmp i_loop
i_inot   cmp #$db          ;sh.+
         bne i_dnot
         lda e_test
         cmp #$5e
         beq *+8
         inc e_test
         jsr sndtab
         jmp i_newc
i_dnot   cmp #$dd
         bne i_spax
         lda e_test
         beq *+8
         dec e_test
         jsr sndtab
         jmp i_newc
i_spax   cmp #$20          ;test
         bcc *-5
         bne i_gsnd
         jsr spaces
         jmp i_newc
i_gsnd   cmp #$28          ;exit
         bcs i_isnd
         and #$07
         tay
         jmp colsnd
i_isnd   cmp #$2d          ;snd.#
         beq i_dsnd
         cmp #$2b
         bne i_sbuf
         inc e_sndn
         jmp *+6
i_dsnd   dec e_sndn
         lda e_sndn
         and #$3f
         sta e_sndn
         jmp i_edit
i_sbuf   cmp #$5e
         bne i_scrn
         lda $56f8
         sta snd_ad,y
         lda $56f9
         sta snd_sr,y
         lda $56fa
         sta snd_gt,y
         lda $56fb
         sta snd_wt,y
         lda $56fc
         sta snd_ft,y
         lda $56fd
         sta snd_pt,y
         lda $56fe
         sta snd_st,y
         jmp i_edit
i_scrn   cmp #$5f          ;to editor
         bne i_tr1x
         ldy #$00
         jmp colsnd
i_tr1x   jsr keychk
         bne i_sret
         jmp i_newc
i_sret   cmp #$8d
         bne i_numb
         ldy e_spos
         cpy #$03
         bcc i_sret-3
         cpy #$06
         beq *+3
         dey
         jmp colsnd
i_numb   cmp #$30
         bcc i_sret-3
         cmp #$3a
         bcc i_cont
         cmp #$41
         bcc i_sret-3
         cmp #$47
         bcc i_cont
i_cont   cmp #$40
         bcc *+5
         sec
         sbc #$07
         and #$0f
         sta e_orad
         lda (zp1),y
         asl a
         asl a
         asl a
         asl a
         ora e_orad
         sta (zp1),y
         jmp i_edit


         *= $3b9e

len_lo   .byte $00
len_hi   .byte $00
actdur   .byte $00
e_tune   .byte $00         ;tune#
e_acts   .byte $00         ;speed
e_sctn   .byte $00         ;sct.#
e_ltrk   .byte $01         ;last trk
e_octv   .byte $00         ;octave
e_tr1p   .byte $00         ;trk.pos
e_tr2p   .byte $00
e_tr3p   .byte $00
e_tr1x   .byte $7a         ;trk.on
e_tr2x   .byte $7a
e_tr3x   .byte $7a
e_msg1   .byte $00         ;message
e_msg2   .byte $00
e_msg3   .byte $00
e_gldp   .byte $00         ;gld.pos
e_sndn   .byte $00         ;snd.#
e_spos   .byte $00         ;sretpos
e_test   .byte $00         ;t.note
e_radd   .byte $00
e_ract   .byte $00
e_rmax   .byte $00
e_clkt   .byte $00         ;timing
e_secs   .byte $00         ;clock sec
e_mins   .byte $00         ;clock min
e_orad   .byte $00         ;ora-reg

call1s   .byte LO(call_1),LO(call_2),LO(call_2)
         .byte LO(call_2),LO(call_2),LO(call_2)
         .byte LO(call_2),LO(call_2),LO(call_2)
         .byte LO(call_2)
call2s   .byte $00,LO(call_1),LO(call_3)
         .byte LO(call_3),LO(call_3),LO(call_3)
         .byte LO(call_3),LO(call_3),LO(call_3)
         .byte LO(call_3)
call3s   .byte $00,$00,LO(call_1),LO(call_4)
         .byte LO(call_4),LO(call_4),LO(call_4)
         .byte LO(call_4),LO(call_4),LO(call_4)
call4s   .byte $00,$00,$00,LO(call_1)
         .byte LO(call_5),LO(call_5),LO(call_5)
         .byte LO(call_5),LO(call_5),LO(call_5)
call5s   .byte $00,$00,$00,$00,LO(call_1)
         .byte LO(call_6),LO(call_6),LO(call_6)
         .byte LO(call_6),LO(call_6)
call6s   .byte $00,$00,$00,$00,$00
         .byte LO(call_1),LO(call_7),LO(call_7)
         .byte LO(call_7),LO(call_7)
call7s   .byte $00,$00,$00,$00,$00,$00
         .byte LO(call_1),LO(call_8),LO(call_8)
         .byte LO(call_8)
call8s   .byte $00,$00,$00,$00,$00,$00
         .byte $00,LO(call_1),LO(call_9)
         .byte LO(call_9)
call9s   .byte $00,$00,$00,$00,$00,$00
         .byte $00,$00,LO(call_1),LO(call_0)
call0s   .byte $00,$00,$00,$00,$00,$00
         .byte $00,$00,$00,LO(call_1)

call1r   .byte $46,$d8,$8e,$66,$4f,$4a
         .byte $3c,$3a,$36,$2e
call2r   .byte $00,$42,$f0,$b0,$88,$76
         .byte $62,$5a,$52,$48
call3r   .byte $00,$00,$2c,$fa,$c1,$a2
         .byte $88,$7a,$6e,$62
call4r   .byte $00,$00,$00,$1c,$fa,$ce
         .byte $ae,$9a,$8a,$7c
call5r   .byte $00,$00,$00,$00,$0e,$fa
         .byte $d4,$ba,$a6,$96
call6r   .byte $00,$00,$00,$00,$00,$0a
         .byte $fa,$da,$c2,$b0
call7r   .byte $00,$00,$00,$00,$00,$00
         .byte $16,$fa,$de,$ca
call8r   .byte $00,$00,$00,$00,$00,$00
         .byte $00,$14,$fa,$e4
call9r   .byte $00,$00,$00,$00,$00,$00
         .byte $00,$00,$10,$fe
call0r   .byte $00,$00,$00,$00,$00,$00
         .byte $00,$00,$00,$08

call1j   .byte $31,$81,$81,$81,$81,$81
         .byte $81,$81,$81,$81
call2j   .byte $00,$31,$81,$81,$81,$81
         .byte $81,$81,$81,$81
call3j   .byte $00,$00,$31,$81,$81,$81
         .byte $81,$81,$81,$81
call4j   .byte $00,$00,$00,$31,$81,$81
         .byte $81,$81,$81,$81
call5j   .byte $00,$00,$00,$00,$31,$81
         .byte $81,$81,$81,$81
call6j   .byte $00,$00,$00,$00,$00,$31
         .byte $81,$81,$81,$81
call7j   .byte $00,$00,$00,$00,$00,$00
         .byte $31,$81,$81,$81
call8j   .byte $00,$00,$00,$00,$00,$00
         .byte $00,$31,$81,$81
call9j   .byte $00,$00,$00,$00,$00,$00
         .byte $00,$00,$31,$81
call0j   .byte $00,$00,$00,$00,$00,$00
         .byte $00,$00,$00,$31

fncadl   .byte LO(fnctxt)+$00,LO(fnctxt)+$12
         .byte LO(fnctxt)+$24,LO(fnctxt)+$36
         .byte LO(fnctxt)+$48,LO(fnctxt)+$5a
         .byte LO(fnctxt)+$6c,LO(fnctxt)+$7e
         .byte LO(fnctxt)+$90,LO(fnctxt)+$a2
         .byte LO(fnctxt)+$b4,LO(fnctxt)+$c6
         .byte LO(fnctxt)+$d8,LO(fnctxt)+$ea
         .byte LO(fnctxt)+$fc,LO(fnctxt)+$0e
         .byte LO(fnctxt)+$20,LO(fnctxt)+$32

fncadh   .byte HI(fnctxt)+$00,HI(fnctxt)+$00
         .byte HI(fnctxt)+$00,HI(fnctxt)+$00
         .byte HI(fnctxt)+$00,HI(fnctxt)+$00
         .byte HI(fnctxt)+$00,HI(fnctxt)+$00
         .byte HI(fnctxt)+$00,HI(fnctxt)+$01
         .byte HI(fnctxt)+$01,HI(fnctxt)+$01
         .byte HI(fnctxt)+$01,HI(fnctxt)+$01
         .byte HI(fnctxt)+$01,HI(fnctxt)+$01
         .byte HI(fnctxt)+$01,HI(fnctxt)+$01

rstart   .byte $46,$42,$2c,$1c,$0e,$0a
         .byte $16,$14,$10,$08
etrack   .byte $00,$80,$ff,$01
ttrack   .byte $00,$df,$ff,$01
x_line   .byte $00,$28,$50,$78
         .byte $a0,$c8,$00,$00
octave   .byte $00,$0c,$18,$24
         .byte $30,$3c,$48,$54
twelve   .text "c-c#d-d#e-f-"
         .text "f#g-g#a-a#b-"
sc_snd   .text "snd.  "
sc_dur   .text "dur.  "
sc_gld   .text "gld.  "
sc_end   .text "-end!-"
sc_hld   .text "-hold-"
sc_rst   .text "------"
tr_tup   .byte $54,$12,$2b,$20,$20  ;"Tr+  "
tr_tdn   .byte $54,$12,$2d,$20,$20  ;"Tr-  "
tr_sct   .byte $53,$03,$14,$20,$20  ;"Sct  "
tr_vol   .byte $56,$0f,$0c,$20,$20  ;"Vol  "
tr_hlt   .byte $48,$0c,$14,$56,$50  ;"HltVP"
tr_dec   .byte $44,$05,$03,$20,$20  ;"Dec  "
tr_inc   .byte $49,$0e,$03,$20,$20  ;"Inc  "
tr_jmp   .byte $4a,$0d,$10,$20,$20  ;"Jmp  "

fnctxt   .byte $41,$14,$14,$01,$03,$0b  ;"Attack + Decay    "
         .byte $20,$2b,$20,$44,$05,$03
         .byte $01,$19,$20,$20,$20,$20
         .byte $53,$15,$13,$14,$01,$09  ;"Sustain + Release "
         .byte $0e,$20,$2b,$20,$52,$05
         .byte $0c,$05,$01,$13,$05,$20
         .byte $47,$01,$14,$05,$20,$0f  ;"Gate off counter  "
         .byte $06,$06,$20,$03,$0f,$15
         .byte $0e,$14,$05,$12,$20,$20
         .byte $41,$12,$10,$05,$07,$07  ;"Arpeggio pointer  "
         .byte $09,$0f,$20,$10,$0f,$09
         .byte $0e,$14,$05,$12,$20,$20
         .byte $46,$09,$0c,$14,$05,$12  ;"Filter pointer    "
         .byte $20,$10,$0f,$09,$0e,$14
         .byte $05,$12,$20,$20,$20,$20
         .byte $50,$15,$0c,$13,$05,$20  ;"Pulse pointer     "
         .byte $10,$0f,$09,$0e,$14,$05
         .byte $12,$20,$20,$20,$20,$20
         .byte $53,$0c,$09,$04,$05,$20  ;"Slide pointer     "
         .byte $10,$0f,$09,$0e,$14,$05
         .byte $12,$20,$20,$20,$20,$20
         .byte $57,$01,$16,$05,$06,$0f  ;"Waveform / Command"
         .byte $12,$0d,$20,$2f,$20,$43
         .byte $0f,$0d,$0d,$01,$0e,$04
         .byte $41,$12,$10,$05,$07,$07  ;"Arpeggio steps    "
         .byte $09,$0f,$20,$13,$14,$05
         .byte $10,$13,$20,$20,$20,$20
         .byte $52,$05,$10,$05,$01,$14  ;"Repeat / Command  "
         .byte $20,$2f,$20,$43,$0f,$0d
         .byte $0d,$01,$0e,$04,$20,$20
         .byte $46,$12,$05,$11,$15,$05  ;"Frequency low     "
         .byte $0e,$03,$19,$20,$0c,$0f
         .byte $17,$20,$20,$20,$20,$20
         .byte $46,$12,$05,$11,$15,$05  ;"Frequency high    "
         .byte $0e,$03,$19,$20,$08,$09
         .byte $07,$08,$20,$20,$20,$20
         .byte $52,$05,$13,$0f,$0e,$01  ;"Resonance + F.low "
         .byte $0e,$03,$05,$20,$2b,$20
         .byte $46,$2e,$0c,$0f,$17,$20
         .byte $50,$15,$0c,$13,$05,$20  ;"Pulse width low   "
         .byte $17,$09,$04,$14,$08,$20
         .byte $0c,$0f,$17,$20,$20,$20
         .byte $50,$15,$0c,$13,$05,$20  ;"Pulse width high  "
         .byte $17,$09,$04,$14,$08,$20
         .byte $08,$09,$07,$08,$20,$20
         .byte $54,$12,$01,$03,$0b,$20  ;"Track 1 startpos. "
         .byte $31,$20,$13,$14,$01,$12
         .byte $14,$10,$0f,$13,$2e,$20
         .byte $54,$12,$01,$03,$0b,$20  ;"Track 2 startpos. "
         .byte $32,$20,$13,$14,$01,$12
         .byte $14,$10,$0f,$13,$2e,$20
         .byte $54,$12,$01,$03,$0b,$20  ;"Track 3 startpos. "
         .byte $33,$20,$13,$14,$01,$12
         .byte $14,$10,$0f,$13,$2e,$20

filnam   .text "            "
         .text "             "
msg_ld   .byte $50,$0c,$05,$01,$13,$05  ;"Please wait,"
         .byte $20,$17,$01,$09,$14,$2c
         .byte $20,$0c,$0f,$01,$04,$09  ;" loading...  "
         .byte $0e,$07,$2e,$2e,$2e,$20
         .byte $20
msg_sv   .byte $50,$0c,$05,$01,$13,$05  ;"Please wait,"
         .byte $20,$17,$01,$09,$14,$2c
         .byte $20,$13,$01,$16,$09,$0e  ;" saving...   "
         .byte $07,$2e,$2e,$2e,$20,$20
         .byte $20
msg_np   .byte $44,$05,$16,$09,$03,$05  ;"Device 8 not"
         .byte $20,$38,$20,$0e,$0f,$14
         .byte $20,$10,$12,$05,$13,$05  ;" present     "
         .byte $0e,$14,$20,$20,$20,$20
         .byte $20
msg_pl   .byte $55,$0e,$09,$04,$05,$0e  ;"Unidentified"
         .byte $14,$09,$06,$09,$05,$04
         .byte $20,$10,$0c,$01,$19,$05  ;" player      "
         .byte $12,$20,$20,$20,$20,$20
         .byte $20

;---------------------------------------

