;-------- Taki's Player V01.22 ---------

;relocatable
#ifndef LO
#define LO(x) (x&$ff)
#define HI(x) (x>>8)
#endif

#ifndef sid
#define sid $d400
#endif

pt       =$fb

pstart   =$4000;
         *= pstart

p_init   jmp m_init        ;initialize
p_play   jmp irqplr        ;irq player
p_mult   jmp mltspd        ;multi-speed

         .byte $20,$2d,$54,$01,$0b,$09  ;" -Taki's Player V01.22-"
         .byte $27,$13,$20,$50,$0c,$01
         .byte $19,$05,$12,$20
p_ver    .byte $56,$30
         .byte $31,$2e,$32,$32,$2d
         .byte $3d,$3e,$20,$4d,$15,$13  ;"=> Music by Taki"
         .byte $09,$03,$20,$02,$19,$20
         .byte $54,$01,$0b,$09
         .byte $2f,$4e,$01,$14,$15,$12  ;"/Natural beat <="
         .byte $01,$0c,$20,$02,$05,$01
         .byte $14,$20,$3c,$3d

freqhi   .byte $01,$01,$01,$01,$01,$01
         .byte $01,$01,$01,$01,$01,$02
         .byte $02,$02,$02,$02,$02,$02
         .byte $03,$03,$03,$03,$03,$04
         .byte $04,$04,$04,$05,$05,$05
         .byte $06,$06,$06,$07,$07,$08
         .byte $08,$09,$09,$0a,$0a,$0b
         .byte $0c,$0d,$0d,$0e,$0f,$10
         .byte $11,$12,$13,$14,$15,$17
         .byte $18,$1a,$1b,$1d,$1f,$20
         .byte $22,$24,$27,$29,$2b,$2e
         .byte $31,$34,$37,$3a,$3e,$41
         .byte $45,$49,$4e,$52,$57,$5c
         .byte $62,$68,$6e,$75,$7c,$83
         .byte $8b,$93,$9c,$a5,$af,$b9
         .byte $c4,$d0,$dd,$ea,$f8,$00

freqlo   .byte $16,$27,$39,$4b,$5f,$74
         .byte $8a,$a1,$ba,$d4,$f0,$0e
         .byte $2d,$4e,$71,$96,$be,$e7
         .byte $14,$42,$74,$a9,$e0,$1b
         .byte $5a,$9c,$e2,$2d,$7b,$cf
         .byte $27,$85,$e8,$51,$c1,$37
         .byte $b4,$38,$c4,$59,$f7,$9e
         .byte $4e,$0a,$d0,$a2,$81,$6d
         .byte $67,$70,$89,$b2,$ed,$3b
         .byte $9d,$14,$a0,$45,$03,$db
         .byte $cf,$e1,$12,$65,$db,$76
         .byte $3a,$27,$41,$8a,$05,$b5
         .byte $9d,$c1,$24,$c9,$b6,$ed
         .byte $73,$4e,$82,$14,$0a,$6a
         .byte $3b,$82,$48,$93,$6b,$da
         .byte $e7,$9c,$04,$28,$14,$00

irqplr   lda vol_ct
         beq volend
         dec vol_ct        ;vol.ctrl
         bne volend
         lda vol_cr
         sta vol_ct
         lda volume
         clc
         adc vol_ad
         sta volume
         beq volend-5
         cmp #$0f
         bcc volend
         lda #$00
         sta vol_ct

volend   ldx #$00
         jsr player
         ldx #$07
         jsr player
         ldx #$0e

player   lda dur_dc,x
         sta lastdr,x
         bne *+5
         jmp firstf
         tay
         lda finish,x
         sta lastfn,x
         beq wframe+3
         lda gt_dec,x      ;gate timer
         beq wframe
         dec gt_dec,x
         bne wframe
         lda #$fe          ;gate off
         sta gt_msk,x
wframe   lda lastfn,x
         cpy #$02
         bcc lframe
         bne decsnd
         cmp #$80          ;last-1
         bcc decsnd
         lda #$fe
         sta gt_msk,x
         lda #$00
         sta sid+5,x
         sta sid+6,x
decsnd   dec dur_dc,x
         jmp p_test

lframe   cmp #$c0          ;last
         beq track
         lda sct_lo,x
         sta pt
         lda sct_hi,x
         sta pt+1
         ldy sctpos,x
         jmp sector
track    lda trk_lo,x
         sta pt
         lda trk_hi,x
         sta pt+1
         ldy trkpos,x
         lda (pt),y
         cmp #$ff          ;Jmp00
         bne notjmp
         iny
         lda (pt),y
         tay
         lda (pt),y

notjmp   cmp #$f8          ;Inc00
         bcc notinc
         sbc #$f7          ;c=1
         asl a
         asl a
         asl a
         sta vol_ct
         sta vol_cr
         lda #$01          ;increase
         sta vol_ad
         iny
         jmp trkcmd

notinc   cmp #$f0          ;Dec00
         bcc notdec
         beq haltvp
nothlt   sbc #$f0          ;c=1
         asl a
         asl a
         asl a
         sta vol_ct
         sta vol_cr
         lda #$ff          ;decrease
         sta vol_ad
         iny
         jmp trkcmd

notdec   cmp #$e0          ;Vol00
         bcc notvol
         and #$0f
         sta volume
haltvp   lda #$00
         sta vol_ct
         iny
trkcmd   lda (pt),y

notvol   cmp #$80
         bcs nottrp
         cmp #$40          ;Tr+00
         bcc settrp
         eor #$bf          ;Tr-00
         clc
         adc #$01
settrp   sta transp,x
         iny

nottrp   iny               ;Sct00
         tya
         sta trkpos,x
         dey
         lda (pt),y
         and #$7f
         tay
         lda sctadl,y
         sta sct_lo,x
         sta pt
         lda sctadh,y
         sta sct_hi,x
         sta pt+1
         lda #$00
         sta sctpos,x
         tay

sector   lda (pt),y
         cmp #$c0          ;Snd.00
         bcc nossnd
         and #$3f
         sta s_nmbr,x
         inc sctpos,x
         iny
         lda (pt),y
nossnd   cmp #$80          ;Dur.01
         bcc nosdur
         and #$3f
         sta dur_rs,x
         inc sctpos,x
nosdur   dec dur_dc,x
         lda lastfn,x
         cmp #$c0
         beq *+5
         jmp p_test
         rts

firstf   lda sct_lo,x      ;1st frame
         sta pt
         lda sct_hi,x
         sta pt+1
         ldy sctpos,x
         lda (pt),y
         cmp #$5f          ;---
         beq norest-3
         cmp #$6f          ;+++
         bne norest
         jmp setfin+3

norest   cmp #$60
         bcs *+5
         jmp normal
         inc sctpos,x
         iny
         clc
         adc #$01
         cmp #$70
         bcs nogld0
         and #$0f          ;Gld.01
         sta g_mode,x
         lda (pt),y
         clc
         adc transp,x
         sta g_note
         tay
         lda freqlo,y
         sta acf_lo
         lda freqhi,y
         sta acf_hi
         inc sctpos,x
         ldy sctpos,x
         lda (pt),y
         clc
         adc transp,x
         sta acnote,x
         tay
         lda acf_lo
         sec
         sbc freqlo,y
         sta g_addl,x
         lda acf_hi
         sbc freqhi,y
         sta g_addh,x
         cpy g_note
         beq glinit-5
         bcs glinit
         lda g_mode,x
         ora #$80          ;down
         bmi glinit-3

nogld0   and #$0f          ;Gld.11
         sta g_mode,x
         ldy acnote,x
         sty g_note
         lda freqlo,y
         sta acf_lo
         lda freqhi,y
         sta acf_hi
         ldy sctpos,x
         lda (pt),y
         clc
         adc transp,x
         sta acnote,x
         tay
         lda acf_lo
         sec
         sbc freqlo,y
         sta g_addl,x
         lda acf_hi
         sbc freqhi,y
         sta g_addh,x
         cpy g_note
         bcc setbit
         bne normal-3
         lda #$00
         beq normal-6
setbit   lda g_mode,x
         ora #$80          ;down
         sta g_mode,x
         jmp setfin

normal   adc transp,x      ;c=0
         sta acnote,x
         lda #$00
         sta g_mode,x

glinit   lda #$ff
         sta gt_msk,x
         ldy s_nmbr,x
         lda snd_ad,y
         sta sid+5,x
         lda snd_sr,y
         sta sid+6,x
         lda snd_gt,y      ;gate off
         sta gt_dec,x
         lda snd_wt,y      ;wave
         sta w_pntr,x
         lda #$00
         sta w_cntr,x

         lda snd_pt,y
         cmp #$ff          ;no pls.rst
         beq tvinit
         sta p_pntr,x
         lda #$00
         sta p_cntr,x
         sta p_wdtl,x
         sta p_wdth,x

tvinit   lda snd_st,y
         cmp #$ff          ;no sld.rst
         beq tfinit
         sta v_pntr,x
         lda #$00
         sta v_cntr,x
         sta v_modl,x
         sta v_modh,x

tfinit   lda snd_ft,y
         cpx #$00
         bne filtrk
         cmp #$ff          ;no flt.rst
         beq setfin
         sta f_pntr
         stx f_cntr
         stx f_freq
         stx f_lres
         stx f_type
filtrk   cmp #$00
         beq nnfres
         lda filter,x
nnfres   sta flt_on,x

setfin   ldy sctpos,x
         lda dur_rs,x
         sta dur_dc,x
         inc sctpos,x
nxtcmd   iny
         lda (pt),y
         bmi nxtcmd
         cmp #$7f
         bne t_rest
         lda #$c0          ;Finish
         bne setend
t_rest   cmp #$5f
         bne t_hold
         lda #$40          ;---
         bne setend
t_hold   cmp #$6f
         bcs t_zero
         lda #$80          ;notes
         bne setend
t_zero   lda #$00          ;+++
setend   sta finish,x
         lda lastfn,x
         bpl p_test
s_adsr   lda #$09          ;1st frame
         sta sid+4,x
         rts


mltspd   ldx #$00          ;multi-speed
         jsr sounds
         ldx #$07
         jsr sounds
         ldx #$0e

sounds   lda lastfn,x
         bpl p_test
         lda lastdr,x
         beq s_adsr

p_test   ldy p_pntr,x      ;pulse fx
         beq w_test        ;pls.off
         lda p_cntr,x
         beq p_nrep
         dec p_cntr,x      ;repeat
         dey
         jmp p_ncmd+6
p_nrep   lda pls_rp,y
         cmp #$ff
         bne p_ncmd
         lda pls_ph,y      ;jump
         sta p_pntr,x
         tay
         lda pls_rp,y
p_ncmd   sta p_cntr,x      ;normal
         inc p_pntr,x
         lda p_wdtl,x
         clc
         adc pls_pl,y
         sta p_wdtl,x
         sta sid+2,x
         lda p_wdth,x
         adc pls_ph,y
         sta p_wdth,x
         sta sid+3,x

w_test   lda w_cntr,x      ;arpeggio
         beq w_nrep
         dec w_cntr,x
         jmp g_test
w_nrep   ldy w_pntr,x
         lda wve_wf,y
         cmp #$ff
         bne w_ncmd
         lda wve_st,y      ;jump
         sta w_pntr,x
         tay
         lda wve_wf,y
w_ncmd   inc w_pntr,x
         cmp #$90
         bcs w_srep
         sta w_form,x
         bcc w_norm
w_srep   sbc #$90          ;c=1
         sta w_cntr,x
w_norm   lda wve_st,y
         sta w_step,x

g_test   lda g_mode,x      ;glide fx
         beq v_test
         bmi g_down
         tay               ;up
         lda g_addl,x
         clc
         adc gld_al,y
         sta g_addl,x
         lda g_addh,x
         adc gld_ah,y
         sta g_addh,x
         bcc v_test
         bcs g_wend
g_down   and #$0f
         tay
         lda g_addl,x
         sec
         sbc gld_al,y
         sta g_addl,x
         lda g_addh,x
         sbc gld_ah,y
         sta g_addh,x
         bcs v_test
g_wend   lda #$00          ;off
         sta g_mode,x
         sta g_addl,x
         sta g_addh,x

v_test   ldy v_pntr,x      ;slide fx
         beq setsid        ;sld.off
         lda v_cntr,x
         beq v_nrep
         dec v_cntr,x      ;repeat
         dey
         jmp v_ncmd+6
v_nrep   lda sld_rp,y
         cmp #$fe          ;copy
         bcc v_ncmd
         beq v_copy
         lda sld_fh,y      ;jump
         sta v_pntr,x
         tay
         lda sld_rp,y
         cmp #$fe          ;copy
         bcc v_ncmd
v_copy   inc v_pntr,x
         lda sld_fl,y
         sta sid,x
         lda sld_fh,y
         jmp direct        ;skip add's
v_ncmd   sta v_cntr,x
         inc v_pntr,x
         lda v_modl,x
         clc
         adc sld_fl,y
         sta v_modl,x
         lda v_modh,x
         adc sld_fh,y
         sta v_modh,x

setsid   lda acnote,x
         clc
         adc w_step,x
         tay
         lda g_mode,x
         beq laxity
         lda freqlo,y
         clc
         adc g_addl,x      ;glide
         sta sid,x
         lda freqhi,y
         adc g_addh,x
         jmp direct
laxity   lda freqlo,y
         clc
         adc v_modl,x      ;slide
         sta sid,x
         lda freqhi,y
         adc v_modh,x
direct   sta sid+1,x
         lda w_form,x
         and gt_msk,x
         sta sid+4,x

chkflt   cpx #$00          ;filter fx
         bne sndend
f_test   ldy f_pntr
         beq f_wsid
         lda f_cntr
         beq f_nrep
         dec f_cntr        ;repeat
         dey
         jmp f_ncmd+6
f_nrep   lda flt_rp,y
         cmp #$fe
         bcc f_ncmd
         beq f_nset
         lda flt_fh,y      ;jump
         sta f_pntr
         tay
         lda flt_rp,y
         cmp #$fe
         bcc f_ncmd
f_nset   lda flt_fh,y      ;set type
         sta f_type
         inc f_pntr
         iny
         lda flt_rp,y
f_ncmd   sta f_cntr        ;normal
         inc f_pntr
         lda f_lres
         clc
         adc flt_rl,y
         tax
         and #$f7
         sta f_lres
         sta sid+$15         ;freq lo
         txa
         and #$08
         cmp #$08          ;carry!
         lda f_freq
         adc flt_fh,y
         sta f_freq
         sta sid+$16         ;freq hi

f_wsid   lda f_lres        ;resonance
         and #$f0
         ora flt_on        ;filter on
         ora flt_on+$07
         ora flt_on+$0e
         sta sid+$17
         lda f_type        ;pass type
         ora volume
         sta sid+$18
sndend   rts


m_init   cmp #$20          ;initialize
         bcs sndend
         tay
         lda tr1adl,y      ;address lo
         sta trk_lo
         lda tr2adl,y
         sta trk_lo+$07
         lda tr3adl,y
         sta trk_lo+$0e
         lda tr1adh,y      ;address hi
         sta trk_hi
         lda tr2adh,y
         sta trk_hi+$07
         lda tr3adh,y
         sta trk_hi+$0e
         lda start1,y      ;startpos.
         sta trkpos
         lda start2,y
         sta trkpos+$07
         lda start3,y
         sta trkpos+$0e
ctinit   lda #$0f          ;variables
         sta volume
         ldy #$02
setvar   ldx offset,y
         lda #$03
         sta gt_dec,x
         sta dur_dc,x
         sta dur_rs,x
         lda #$c0
         sta finish,x
         lda sctadl
         sta sct_lo,x
         lda sctadh
         sta sct_hi,x
         lda #$00
         sta transp,x
         sta sctpos,x
         sta p_pntr,x
         sta v_pntr,x
         sta w_pntr,x
         sta s_nmbr,x
         dey
         bpl setvar
         sta f_pntr
         sta vol_ct
         sta vol_cr
         sta vol_ad
         ldy #$18
clrsid   sta sid,y
         dey
         bpl clrsid
         rts


gt_dec   .byte $00
gt_msk   .byte $fe
lastfn   .byte $00
finish   .byte $00
lastdr   .byte $00
dur_dc   .byte $00
dur_rs   .byte $00,$00,$fe,$00,$00
         .byte $00,$00,$00,$00,$fe
         .byte $00,$00,$00,$00,$00

transp   .byte $00
trk_lo   .byte $00
trk_hi   .byte $00
trkpos   .byte $00
sct_lo   .byte $00
sct_hi   .byte $00
sctpos   .byte $00,$00,$00,$00,$00
         .byte $00,$00,$00,$00,$00
         .byte $00,$00,$00,$00,$00

p_pntr   .byte $00
p_cntr   .byte $00
p_wdtl   .byte $00
p_wdth   .byte $00
g_mode   .byte $00
g_addl   .byte $00
g_addh   .byte $00,$00,$00,$00,$00
         .byte $00,$00,$00,$00,$00
         .byte $00,$00,$00,$00,$00

v_pntr   .byte $00
v_cntr   .byte $00
v_modl   .byte $00
v_modh   .byte $00
w_pntr   .byte $00
w_cntr   .byte $00
w_form   .byte $00,$00,$00,$00,$00
         .byte $00,$00,$00,$00,$00
         .byte $00,$00,$00,$00,$00

w_step   .byte $00
s_nmbr   .byte $00
acnote   .byte $00
g_note   .byte $00
vol_ct   .byte $00
filter   .byte $01
flt_on   .byte $00,$00,$00,$00,$00
         .byte $00,$02,$00,$00,$00
         .byte $00,$00,$00,$04,$00

f_pntr   .byte $00
f_cntr   .byte $00
f_lres   .byte $00
f_freq   .byte $00
f_type   .byte $00
volume   .byte $00

acf_lo   = g_note+$07
acf_hi   = g_note+$0e
vol_cr   = vol_ct+$07
vol_ad   = vol_ct+$0e

offset   .byte $00,$07,$0e


         *= pstart+$0700
speeds   .byte $00,$00,$00,$00
         .byte $00,$00,$00,$00
         *= pstart+$0720
start1   .byte $00,$00,$00,$00
         .byte $00,$00,$00,$00
         *= pstart+$0740
start2   .byte $00,$00,$00,$00
         .byte $00,$00,$00,$00
         *= pstart+$0760
start3   .byte $00,$00,$00,$00
         .byte $00,$00,$00,$00
         *= pstart+$0780
tr1adl   .byte $00,$00,$00,$00
         .byte $00,$00,$00,$00
         *= pstart+$07a0
tr2adl   .byte $00,$00,$00,$00
         .byte $00,$00,$00,$00
         *= pstart+$07c0
tr3adl   .byte $00,$00,$00,$00
         .byte $00,$00,$00,$00

snd_ad   = pstart+$0940
snd_sr   = pstart+$0980
snd_gt   = pstart+$09c0
snd_wt   = pstart+$0a00
snd_ft   = pstart+$0a40
snd_pt   = pstart+$0a80
snd_st   = pstart+$0ac0

wve_wf   = pstart+$0b00
wve_st   = pstart+$0c00

flt_rp   = pstart+$0d00
flt_fh   = pstart+$0e00
flt_rl   = pstart+$0f00

pls_rp   = pstart+$1000
pls_pl   = pstart+$1100
pls_ph   = pstart+$1200

sld_rp   = pstart+$1300
sld_fl   = pstart+$1400
sld_fh   = pstart+$1500

tracks   = pstart+$1800
sectors  = pstart+$3000

         *= pstart+$07e0
tr1adh   .byte HI(pstart)+$18,HI(pstart)+$19,HI(pstart)+$1a,HI(pstart)+$1b
         .byte HI(pstart)+$1c,HI(pstart)+$1d,HI(pstart)+$1e,HI(pstart)+$1f
         *= pstart+$0800
tr2adh   .byte HI(pstart)+$20,HI(pstart)+$21,HI(pstart)+$22,HI(pstart)+$23
         .byte HI(pstart)+$24,HI(pstart)+$25,HI(pstart)+$26,HI(pstart)+$27
         *= pstart+$0820
tr3adh   .byte HI(pstart)+$28,HI(pstart)+$29,HI(pstart)+$2a,HI(pstart)+$2b
         .byte HI(pstart)+$2c,HI(pstart)+$2d,HI(pstart)+$2e,HI(pstart)+$2f
         *= pstart+$0840
gld_al   .byte $00,$20,$40,$60,$80,$a0
         .byte $c0,$e0,$00,$20,$40,$60
         .byte $80,$a0,$c0,$e0
gld_ah   .byte $00,$00,$00,$00,$00,$00
         .byte $00,$00,$01,$01,$01,$01
         .byte $01,$01,$01,$01

         *= pstart+$0880

sctadl   .byte $00,$00,$00,$00,$00,$00
         .byte $00,$00,$00,$00,$00,$00
         .byte $00,$00,$00,$00,$00,$00
         .byte $00,$00,$00,$00,$00,$00

         .byte $00,$00,$00,$00,$00,$00
         .byte $00,$00,$00,$00,$00,$00
         .byte $00,$00,$00,$00,$00,$00
         .byte $00,$00,$00,$00,$00,$00

         .byte $00,$00,$00,$00,$00,$00
         .byte $00,$00,$00,$00,$00,$00
         .byte $00,$00,$00,$00,$00,$00
         .byte $00,$00,$00,$00,$00,$00

         .byte $00,$00,$00,$00,$00,$00
         .byte $00,$00,$00,$00,$00,$00
         .byte $00,$00,$00,$00,$00,$00
         .byte $00,$00,$00,$00,$00,$00

         *= pstart+$08e0

sctadh   .byte HI(pstart)+$30,HI(pstart)+$31,HI(pstart)+$32
         .byte HI(pstart)+$33,HI(pstart)+$34,HI(pstart)+$35
         .byte HI(pstart)+$36,HI(pstart)+$37,HI(pstart)+$38
         .byte HI(pstart)+$39,HI(pstart)+$3a,HI(pstart)+$3b
         .byte HI(pstart)+$3c,HI(pstart)+$3d,HI(pstart)+$3e
         .byte HI(pstart)+$3f,HI(pstart)+$40,HI(pstart)+$41
         .byte HI(pstart)+$42,HI(pstart)+$43,HI(pstart)+$44
         .byte HI(pstart)+$45,HI(pstart)+$46,HI(pstart)+$47

         .byte HI(pstart)+$48,HI(pstart)+$49,HI(pstart)+$4a
         .byte HI(pstart)+$4b,HI(pstart)+$4c,HI(pstart)+$4d
         .byte HI(pstart)+$4e,HI(pstart)+$4f,HI(pstart)+$50
         .byte HI(pstart)+$51,HI(pstart)+$52,HI(pstart)+$53
         .byte HI(pstart)+$54,HI(pstart)+$55,HI(pstart)+$56
         .byte HI(pstart)+$57,HI(pstart)+$58,HI(pstart)+$59
         .byte HI(pstart)+$5a,HI(pstart)+$5b,HI(pstart)+$5c
         .byte HI(pstart)+$5d,HI(pstart)+$5e,HI(pstart)+$5f

         .byte HI(pstart)+$60,HI(pstart)+$61,HI(pstart)+$62
         .byte HI(pstart)+$63,HI(pstart)+$64,HI(pstart)+$65
         .byte HI(pstart)+$66,HI(pstart)+$67,HI(pstart)+$68
         .byte HI(pstart)+$69,HI(pstart)+$6a,HI(pstart)+$6b
         .byte HI(pstart)+$6c,HI(pstart)+$6d,HI(pstart)+$6e
         .byte HI(pstart)+$6f,HI(pstart)+$70,HI(pstart)+$71
         .byte HI(pstart)+$72,HI(pstart)+$73,HI(pstart)+$74
         .byte HI(pstart)+$75,HI(pstart)+$76,HI(pstart)+$77

         .byte HI(pstart)+$78,HI(pstart)+$79,HI(pstart)+$7a
         .byte HI(pstart)+$7b,HI(pstart)+$7c,HI(pstart)+$7d
         .byte HI(pstart)+$7e,HI(pstart)+$7f,HI(pstart)+$80
         .byte HI(pstart)+$81,HI(pstart)+$82,HI(pstart)+$83
         .byte HI(pstart)+$84,HI(pstart)+$85,HI(pstart)+$86
         .byte HI(pstart)+$87,HI(pstart)+$88,HI(pstart)+$89
         .byte HI(pstart)+$8a,HI(pstart)+$8b,HI(pstart)+$8c
         .byte HI(pstart)+$8d,HI(pstart)+$8e,HI(pstart)+$8f


;---------------------------------------
;
;
;SndTab: AD SR Gt Wt Ft Pt St
;
;AD      Attack, Decay
;SR      Sustain, Release
;Gt      Gate off counter
;Wt      Waveform pointer
;Ft      Filter pointer
;Pt      Pulse pointer
;St      Slide pointer
;
;
;WveTab: Wf St
;
;Wf      Waveform values
;        $90 Repeat arpeggio (-$8F)
;            & hold waveform
;        $FF Jump (Position: St)
;St      Arpeggio offset
;
;
;FltTab: Rp Fh Rl
;
;Rp      Repeat counter
;        $FE Type (Fh bits 4-6)
;        $FF Jump (Position: Fh)
;Fh      Frequency addition hi
;Rl      Resonance add + freq.add lo
;
;
;PlsTab: Rp Ph Pl
;
;Rp      Repeat counter
;        $FF Jump (Position: Ph)
;Ph      Pulse width addition hi
;Pl      Pulse width addition lo
;
;
;SldTab: Rp Fh Fl
;
;Rp      Repeat counter
;        $FE Copy freq to SID
;        $FF Jump (Position: Fh)
;Fh      Frequency addition hi
;Fl      Frequency addition lo
;
;
;GldTab: Ah Al
;
;Ah      Frequency addition hi
;Al      Frequency addition lo
;
;
;Next Instruction Lookahead
;
;  NextInst  HardRst  GateOff  Finish
;
;   Finish      +        +      $C0
;   Notes       +        +      $80
;    ---        -        +      $40
;    +++        -        -      $00
;   Gld.0*      +        +      $80
;   Gld.1*      -        -      $00
;
;
;Track & Sector Commands
;
; $00-$3F   Tr+00     $00-$5E   Notes
; $40-$7F   Tr-00     $5F        ---
; $80-$DF   Sct00     $60-$7E   Gld.01
; $E0-$EF   Vol00     $6F        +++
; $F0       HltVS     $7F       Finish
; $F1-$F7   Dec00     $80-$BF   Dur.01
; $F8-$FE   Inc00     $C0-$FF   Snd.00
; $FF       Jmp00
;
;
;---------------------------------------

