/* rle.c - run length encoder */

#include <stdio.h>
#include <sys/stat.h>

typedef unsigned char byte;

void main(int argc, char **argv)
{
  char addr[2];
  byte* data;
  byte rle=0xaa;
  int dist[256];
  register int i, j, k, t;
  int count;
  FILE *fi, *fo;
  struct stat sb;

  if(argc < 3) {
    fprintf(stderr, "Usage: rle infile outfile\n");
    exit(1);
  }

  if(stat(argv[1], &sb)) {
    fprintf(stderr, "File not found\n");
    exit(1);
  }

  if( (fi = fopen(argv[1], "r")) == NULL) {
    fprintf(stderr, "File not found\n");
    exit(1);
  }

  t = sb.st_size - 2;

  data = malloc(t);

  fread(addr, 1, 2, fi);
  fread(data, 1, t, fi);
  fclose(fi);

  memset((void*)dist, 0, 256*sizeof(int));

  for(i=0; i<t; i++)
    ++dist[data[i]];

  j = t;
  for(i=0; i<256; i++)
    if(dist[i] < j) {
      rle = i;
      j = dist[i];
    }

  printf("rle: %d  count: %d\n", rle, j);

  if( (fo = fopen(argv[2], "w")) == NULL) {
    fprintf(stderr, "Couldn't open output file\n");
    exit(1);
  }

  putc(rle, fo);

  for(i=0; i<t; ) {
    putc(data[i], fo);
    if(data[i] == rle) {
      putc(0, fo);
      i++;
      continue;
    }

    for(j=i+1; j<t && (j-i)<256 && data[j]==data[i]; j++);
    if(j-i > 3) {
      putc(rle, fo);
      putc(j-i-1, fo);
    }
    else if(j-i > 0)
      for(k=0; k<j-i-1; k++)
	putc(data[i], fo);

    i = j;
  }

  fclose(fo);
  printf("Done\n");

  exit(0);
}
