/* This is a very simplified version of the POSIX opendir(),  */
/* readdir(), and closedir() -- for Commodore computers.      */
/* Created by Josef Soucek, 2003.  E-mail: josef.soucek@ct.cz */

/* 2003-01-21 -- Version 0.1 */
/* 2009-10-10 -- Version 0.3 */
/* 2011-04-07 -- Version 0.4, groepaz */
/* 2011-04-14 -- Version 0.5, Greg King */

/* Tested with floppy-drive and IDE64 devices.        */
/* Not tested with messed (buggy) directory listings. */
/* Limits filenames to 16 chars. (VICE supports more  */
/* in directory listings).                            */


#include <stdarg.h>
#include <cbm.h>
#include <errno.h>

void __fastcall__ chrinword (void);
void __fastcall__ chrinword2 (void);

//Temp. storage while reading a directory entry.
extern unsigned char byte;
#pragma zpsym ("byte")
extern unsigned char i;
#pragma zpsym ("i")
extern unsigned char numfiles;
#pragma zpsym ("numfiles")

//Buffer into which to read the current dir. entry.
extern struct cbm_dirent d;
#pragma zpsym ("d");

//The following function was removed and replaced with in-line code in menu.c
//for efficiency.
//unsigned char __fastcall__ cbm_opendir2 (unsigned char lfn, unsigned char device)


/* Reads one directory line into cbm_dirent structure.
** Returns 0 if reading directory-line was successful.
** Returns non-zero if reading directory failed, or no more file-names to read.
** Returns 2 on last line.  Then, l_dirent->size = the number of "blocks free."
*/
unsigned char __fastcall__ cbm_readdir2 (void/*register struct cbm_dirent* l_dirent*/)
{
	//Eat offset to next line and block size--neither is needed.
	chrinword2 ();
	//Is first byte on line a 'b'?
	//Return 'b' (non-zero to indicate end of dir.).
	__asm__ (
		"\tjsr\t$ffcf\n"
		"\tcmp\t#\'b\'\n"
		"\tbeq\t@zz21\n"
		);
	//Eat to quote.
	__asm__ (
		"@zz31:\n"
		"\tjsr\t$ffcf\n"
		//"\tjsr\t_cbm_k_basin\n"
		"\tcmp\t#34\n"
		"\tbne\t@zz31\n"
		);
	//Read name into d.name.
	__asm__ (
		//Start # bytes count.
		"\tldx\t#0\n"
		//"\tsta\t_numfiles\n"
		"@zz01:\n"
		//Read byte.
		"\tjsr\t$ffcf\n"
		//Exit loop if quote.
		"\tcmp\t#34\n"
		"\tbeq\t@zz02\n"
		//Write until end of string or end of 16 characters.
		"\tcpx\t#16\n"
		"\tbeq\t@zz01\n"
		"\tsta\t_d,x\n"
		//Loop.
		"\tinx\n"
		"\tbne\t@zz01\n"
		"@zz02:\n"
		//Terminate string.
		"\tlda\t#0\n"
		"\tsta\t_d,x\n"
		);
#ifdef __Do1581__
	//If 1581:
	__asm__ (
		//Eat spaces.
		"@zz04:\n"
		"\tjsr\t$ffcf\n"
		"\tcmp\t#32\n"
		"\tbeq\t@zz04\n"
		//Default is type CBM (1581 partition).
		"\tldx\t#$02\n"
		//Is CBM (starts w/ 'c')?
		"\tcmp\t#'c'\n"
		//Exit test type 2 (partition).
		"\tbeq\t@zz06\n"
		//Next, try PRG.
		"\tdex\n"
		"\tcmp\t#'p'\n"
		//If so, exit type 1.
		"\tbeq\t@zz06\n"
		//Else, type 0 (other--ignore).
		"\tdex\n"
		"@zz06:\tstx\t_d+19\n"
		);
#else
	//If 1541/71:
	__asm__ (
		"@zz04:\n"
		//Eat spaces.
		"\tjsr\t$ffcf\n"
		"\tcmp\t#32\n"
		"\tbeq\t@zz04\n"
		//Default is PRG.
		"\tldx\t#$01\n"
		//Is PRG?
		"\tcmp\t#'p'\n"
		//Exit as type #1 (prg).
		"\tbeq\t@zz06\n"
		//Otherwise, type #0.
		"\tdex\n"
		"@zz06:\tstx\t_d+19\n"
		);
#endif
	//Eat to end of line (0-terminator).
	__asm__ (
		"@zz20:\n"
		"\tjsr\t$ffcf\n"
		"\ttax\n"
		"\tbne\t@zz20\n"
		"@zz21:\n"
		);

}


//The following function was removed for the same reasons as cbm_opendir().
//void __fastcall__ cbm_closedir (unsigned char lfn);


