;
; Startup code for cc65 (C128 version)
;
;-------------------------------------------------------------------------
; This file is modified from the original version by Joseph Rose, a.k.a.
; Harry Potter: a default Bank 15 9k memory model is used to minimize
; banking, and start-up code unnecessary to DirMenu is disabled.  Also,
; the _e variable, which is the current selection, is set to zero along
; with another variable.
;

        .export         _exit
        .export         __STARTUP__ : absolute = 1      ; Mark as startup
        .import         initlib, donelib
        .import         zerobss
        .import         push0, callmain, _main
        .import         RESTOR, BSOUT, CLRCH, __EXEHDR__
        .import         __RAM_START__, __RAM_SIZE__, __STACKSIZE__
        .importzp       _e

	.exportzp	_d

        .include        "zeropage.inc"
        .include        "c128.inc"


; ------------------------------------------------------------------------
; Startup code
.define zpspace $48
.segment        "STARTUP"

Start:

; Switch to the second charset

        lda     #14
        jsr     BSOUT

; Before doing anything else, we have to setup our banking configuration.
; Otherwise just the lowest 16K are actually RAM. Writing through the ROM
; to the underlying RAM works, but it is bad style.

        ;lda     MMU_CR          ; Get current memory configuration...
        ;pha                     ; ...and save it for later
        ;lda     #MMU_CFG_CC65   ; Bank0 with kernal ROM
        ;sta     MMU_CR

; Save the zero page locations we need

        ldx     #zpspace-1
L1:     lda     $02,x
        sta     zpsave,x
        dex
        bpl     L1

; Clear the BSS data

        ;jsr     zerobss

; Save system stuff and setup the stack

        ;pla                     ; Get MMU setting
        ;sta     mmusave

        ;tsx
        ;stx     spsave          ; Save the system stack pointer

        lda     #<(__RAM_START__ + __RAM_SIZE__ + __STACKSIZE__)
        sta     sp
	sta	_e
        lda     #>(__RAM_START__ + __RAM_SIZE__ + __STACKSIZE__)
        sta     sp+1            ; Set argument stack ptr

; Call module constructors

        ;jsr     initlib

; Set the bank for the file name to our execution bank. We must do this,
; *after* calling constructors, because some of them may depend on the
; original value of this register.
;
; Harry Potter: I reenabled these two lines due to a bug with the directory
; reading.  With these lines disabled, the C128 emulator can't always read the
; dir properly:

        lda     #0
        sta     FNAM_BANK

; Push arguments and call main()

        ;jsr     callmain
	;jsr	push0
	;jsr	push0
	jsr	_main

; Back from main (this is also the _exit entry). Run module destructors

_exit:  ;pha                     ; Save the return code on stack
        ;jsr     donelib

;jsr	_getkey
	;jsr	$FFE4
	;tax
	;mbeq	*-4



; Copy back the zero page stuff

        ldx     #zpspace-1
L2:     lda     zpsave,x
        sta     $02,x
        dex
        bpl     L2

; Place the program return code into ST

        ;pla
        ;sta     ST

; Reset the stack and the memory configuration

        ;ldx     spsave
        ;txs
        ;ldx     mmusave
        ;stx     MMU_CR

; Done, return to BASIC

;jsr	_getkey
	;jsr	$FFE4
	;tax
	;beq	*-4

	;lda	$91
	;ora	#$80
	;sta	$91

        rts

; ------------------------------------------------------------------------
; Data

;.segment        "ZPSAVE"
.bss

zpsave: .res    zpspace

; ------------------------------------------------------------------------

.bss

;spsave: .res    1

.zeropage
_d:	.res	21
