/**************************************************************************
 *
 * Interface module of type UI for a cc65
 * application.
 *
 * This code skeleton was created using TempC by Joseph Rose.
 * This code is not copyrighted.  The end progammer may read,
 * analyze or modify it as he/she wishes.
 *
 **************************************************************************/

/* Standard includes: */
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>

#include <conio.h>

//Include the header for this file.
#include "menu.h"

//unsigned char __fastcall__ cbm_opendir2 (unsigned char lfn, unsigned char device);

//This function is a watered-down version of cc65's cbm_readdir() function for just
//what DirMenu needs.
//
//Function in cbm_dir.s module included with this program.
unsigned char __fastcall__ cbm_readdir2 (void);

//String/filename for reading the directory.
#ifdef __PET__
static const char dire[3]="0:$";
#else
static const char dire[1]="$";
#endif
//Routine to skip a word while reading the directory.
void __fastcall__ chrinword (void);

#ifdef __Do1581__
//If using a 1581, a temp. ptr. to the current partition's entry while opening
//a new sub-partition (skips the '/').
//
void __fastcall__ open15 (void);

//Defined in zprout.s.
extern char* curpart;
#pragma zpsym ("curpart")
char slash[1]="/";
#endif

#ifdef __VIC20__
extern unsigned char backbrdrcol;
#endif

//Temp. for centering title on screen.
extern unsigned char titlex;
#pragma zpsym ("titlex")

//Macro for setting default text color.
#ifdef __C128__
#define setunselcol textcolor (col_unselect);
#elif defined __PET__
#define setunselcol
#else
#define setunselcol textcol=col_unselect
#endif

void __fastcall__ writetitle (char*);

//Inline asm for reverson/reversoff functions, don't use () in call.
#ifdef __C64__
#define reverson  __asm__ ("\tlda\t#$80\n\tsta\t$C7\n")
#define reversoff __asm__ ("\tlda\t#$00\n\tsta\t$C7\n")
#elif defined __C128__
#define reverson  __asm__ ("\tlda\t#$80\n\tsta\t$F3\n")
#define reversoff __asm__ ("\tlda\t#$00\n\tsta\t$F3\n")
#elif defined __C16__
#define reverson  __asm__ ("\tlda\t#$80\n\tsta\t$C2\n")
#define reversoff __asm__ ("\tlda\t#$00\n\tsta\t$C2\n")
#elif defined __VIC20__
#define reverson  __asm__ ("\tlda\t#$80\n\tsta\t$C7\n")
#define reversoff __asm__ ("\tlda\t#$00\n\tsta\t$C7\n")
#endif

/* Array holding file names. */
char files [maxfiles][lenfilename+1];

//Functions for getting the address of different entries for parsing.
//Note that these functions return the address for inline asm 
char* __fastcall__ geteaddr (unsigned char en);
		//Get entry # passed.
char* __fastcall__ geteaddri (void);
		//Get entry # indicated by variable i.
char* __fastcall__ geteaddrcur (void);
		//Get entry # indicated by variable e (current entry).

//Temp. variables.
//e=cur. entry.
//c=current char.
//i=extra entry during scans.
//x=temp. for sort routines.
//numfiles=# entries in directory.
//
//Defined in zprout.s.
extern unsigned char e, x, c, numfiles, i;
//Current entry being read from dir.
extern struct cbm_dirent d;
#pragma zpsym ("e")
#pragma zpsym ("x")
#pragma zpsym ("c")
#pragma zpsym ("numfiles")
#pragma zpsym ("i")
#pragma zpsym ("d");

#ifdef __Do1581__
//Title 2: the current partition on a 1581.
char title2[40];
//Temp. string for switching partitions on a 1581.
char dout[24];
#endif

//Display current entry in menu.
//
//Defined in zprout.s.
void __fastcall__ DispDirEntry (void);

//Function to advance to next entry w/ wraparound for gotokey().
//
//Defined in zprout.s.
static unsigned char __fastcall__ advf (void);

//If a printable character is pressed,
//this function switches to the next entry in the dir. that starts with the
//given key.  On a 1581, also handles partitions (the '/' is skipped).
static void gotokey (void)
{
	//Loop until current entry is reached again (end of dir.).
	for (i=e; advf()!=e; ) 
        {
        	//if (files[i][0]==k)
#ifdef __Do1581__
		//if (*geteaddri()=='<' && geteaddri()[1]==c)
                //{e=i; return;}
		__asm__ (
			//Get current entry.
			"\tjsr\t_geteaddri\n"
			//Is char. 0 same as key?
			"\tldy\t#0\n"
			"\tlda\t(ptr2),y\n"
			"\tcmp\t_c\n"
			//Exit.
			"\tbeq\t@zz3\n"
			//Is partition entry?
			"\tcmp\t#'/'\n"
			"\tbne\t@zx02\n"
			//If so, check next byte.
			"\tiny\n"
			"\tlda\t(ptr2),y\n"
			"\tcmp\t_c\n"
			"\tbne\t@zx02\n"
			//If =, exit.
			"@zz3:\n"
			"\tlda\t_i\n"
			"\tsta\t_e\n"
			"@rxx:\n"
			"\trts\n"
			"@zx02:\n"
			);
#else
		__asm__ (
			//Get cur. entry.
			"\tjsr\t_geteaddri\n"
			//First char. =?
			"\tldy\t#0\n"
			"\tlda\t(ptr2),y\n"
			"\tcmp\t_c\n"
			"\tbne\t@zx02\n"
			//Exit.
			"\tlda\t_i\n"
			"\tsta\t_e\n"
			"\trts\n"
			"@zx02:\n"
			);
#endif
	}
	//Does current entry have typed first letter?
	__asm__ (
		//Get current entry.
		"\tjsr\t_geteaddrcur\n"
		//First letter same as typed?
		"\tldy\t#0\n"
		"\tlda\t(ptr2),y\n"
		"\tcmp\t_c\n"
		//Exit.
		"\tbne\t@zy02\n"
		"\trts\n"
		"@zy02:\n"
#ifdef __Do1581__
		//If 1581 and current entry partition
		"\tcmp\t#'/'\n"
		"\tbne\t@zx01\n"
		//and second letter same as typed,
		"\tiny\n"
		"\tlda\t(ptr2),y\n"
		"\tcmp\t_c\n"
		//exit.
		"\tbne\t@zx01\n"
		"\trts\n"
		"@zx01:\n"
#endif
		);
	//Make border (or background on c128 in 80-column mode) red.
#ifdef __C16__

        brdrcol=0x42;
#elif defined __C128__
        if (columns==40) bordercolor (2);
	else bgcolor (2);
#elif defined __VIC20__
	backbrdrcol=0x1A;
#elif !defined __PET__
	brdrcol=2;
#endif
	//Wait for a period of time.
	__asm__ (
		"\tldy\t#$C0\n"
		"@zy10:\n"
		"\tldx\t#$00\n"
		"@zy11:\n"
		"\tdex\n"
		"\tbne\t@zy11\n"
		"\tdey\n"
		"\tbne\t@zy10\n"
		);
	//Restore color.
#ifdef __C16__
        brdrcol=0x65;
#elif defined __C128__
        if (columns==40) bordercolor (13);
	else bgcolor (1);
#elif defined __VIC20__
	backbrdrcol=0x1B;
#elif !defined __PET__
	brdrcol=13;
#endif
}

static char tmpswap[32];
#ifndef __VIC20__
static char title[]="\x12""DirMenu - ";
#endif

/* Function to select a program to run. */
void SelPrg (void)
{
	//If 1581, clear second title (current partition).
#ifdef __Do1581__
	/*curpart[0]=*/title2[1]=0;
	title2[0]='/';
#endif
top:	//Goto point for switching partitions on a 1581--reloads the direcory.
//#ifdef __Do1581__
//	e=0;
//#endif
	clrscr();
	/* Open directory on device 8. */
	__asm__ (
		//Set LFNs.
		"\tlda\t#1\n"
		"\tldx\t#8\n"
		"\tldy\t#0\n"
		"\tsty\t_c\n"
		"\tsty\t_e\n"
		"\tjsr\t$FFBA\n"
		//Set name ("$", as above in dire).
		"\tldx\t#<_dire\n"
		"\tldy\t#>_dire\n"
#ifdef __PET__
		"\tlda\t#3\n"
#endif
		"\tjsr\t$FFBD\n"
		//Open directory.
		"\tjsr\t$FFC0\n"
		);
		//Open directory for input.
		__asm__ (
			"\tldx\t#1\n"
			//"\ttax\n"
			"\tjsr\t$FFC6\n"
			);
            /* Skip start address */
	    chrinword ();

	    /* Read disk label. */
	cbm_readdir2 ();
	//Set title color for writing title(s).
#ifdef __C128__
	textcolor (col_title);
#elif !defined __PET__
	//tabx=12;		//const center on 40-column computers
	textcol=col_title;
#endif
	__asm__ (
		//"\tsty\t_e\n"
#ifdef __Do1581__
		//If 1581 and not in top partition, skip create title.
		//"\tsty\t_curpart\n"
		"\tlda\t_title2+1\n"
		"\tbne\t@z14\n"
		//";---\n"
#endif
#ifndef __VIC20__
		//Copy program name to title string.
		"\tldy\t#0\n"
		"\tsty\t_e\n"
		"@z10:\n"
		"\tlda\t_title,y\n"
		"\tsta\t_tmpswap,y\n"
		"\tbeq\t@z11\n"
		"\tiny\n"
		"\tbne\t@z10\n"
		//"@z11:\t;stx\t_i\n"
		"@z11:\n"
		//);
#endif
	//Scan disk title from right for end of name (before space-
	//padding) and write NULL.
        //__asm__ (
        	"\tldx\t#15\n"
                "@zz8:\n"
                "\tlda\t_d,x\n"
                "\tcmp\t#32\n"
                "\tbne\t@zz9\n"
                "\tdex\n"
                "\tbne\t@zz8\n"
                "@zz9:\n"
                "\tlda\t#0\n"
                "\tsta\t_d+1,x\n"
        	);
	__asm__ (
#ifndef __VIC20__
		//Append disk name to program title for display.
		"\ttax\n"
		"@z12:\tlda\t_d,x\n"
		"\tsta\t_tmpswap,y\n"
		"\tbeq\t@z13\n"
		"\tiny\n"
		"\tinx\n"
		"\tbne\t@z12\n"
		"@z13:\n"
		"\tsty\t_titlex\n"
		"@z14:\n"
#else
		//Append disk name to program title for display.
		"\tldx\t#0\n"
		"@z12:\tlda\t_d,x\n"
		"\tsta\t_tmpswap,x\n"
		"\tbeq\t@z13\n"
		//"\tiny\n"
		"\tinx\n"
		"\tbne\t@z12\n"
		"@z13:\n"
		"\tstx\t_titlex\n"
#endif
//#ifndef __Do1581__
//#ifdef __Do1581__
//#else
//		"\tsty\t_i\n"
//#endif
		);
	//Write title.
        writetitle (tmpswap);
#ifdef __Do1581__
	printscr (title2);
#endif
	//setunselcol ();
//#ifdef __C128__
//	setunselcol ();//textcol=col_unselect;
//#else
	setunselcol;
//#endif
	/* Read directory entries until end of dir. or overflow. */
	// (e is set to 0 in start-up code)
	for (;e<columns && !cbm_readdir2 ()/*!cbm_readdir(1, &d)*/;)
	{
		//Save entry if program (or partition if 1581).
#ifdef __Do1581__
		//Is partition?
		if (d.type==2) {
			//Get address of current entry.
			__asm__ ("\tjsr\t_geteaddrcur\n"
				 //"\tsta\tptr2\n\tstx\tptr2+1\n"
				 //Write slash (to indicate partition).
				 "\tldy\t#0\n"
				 "\tlda\t#\'/\'\n"
				 "\tsta\t(ptr2),y\n"
				 "\tiny\n"
				 //Copy name after slash.
				 "@z15:\n"
				 "\tlda\t_d-1,y\n"
				 "\tbeq\t@z16\n"
				 "\tsta\t(ptr2),y\n"
				 "\tiny\n"
				 "\tbne\t@z15\n"
				 "@z16:\n"
				 //End string.
				 "\tlda\t#0\n"
				 "\tsta\t(ptr2),y\n"
				 );
			++e; //continue;
		} else
#endif
		//Is program?
		if (d.type/*==CBM_T_PRG*/) {//continue;
			/* Store program name. */
			//brdrcol=0;
			__asm__ ("\tjsr\t_geteaddrcur\n"
				 //"\tsta\tptr2\n\tstx\tptr2+1\n"
				 "\tldy\t#16\n"
				 "@zz1:\tlda\t_d,y\n"
				 "\tsta\t(ptr2),y\n"
				 "\tdey\n"
				 "\tbpl\t@zz1\n"
				 "\tinc\t_e\n");
			/* Display program name. */
		}
	}
	//Write # entries read.
	numfiles=e;
	//Clear write mode and close directory.
	cbm_k_clrch();
	
	__asm__ ("\tlda\t#1\n\tjsr\t$FFC3\n");
	//Sort directory.
        for (; c<numfiles; ++c){
		//Set current entry as swap entries.
		__asm__("\tldx\t_c\n"
			"\tstx\t_i\n"
			"\tstx\t_x\n"
			);
		//Scan for earliest string;
		for (; x<numfiles; ++x) {
			__asm__ (
				//Get address of test entry.
				"\tlda\t_x\n"
				"\tjsr\t_geteaddr\n"
				"\tsta\t_d+17\n"
				"\tstx\t_d+18\n"
				//Get address of current entry.
				"\tjsr\t_geteaddri\n"
				"\tldy\t#0\n"
				"@zx00:\n"
				//Compare.
				"\tlda\t(_d+17),y\n"
				"\tcmp\t(ptr2),y\n"
				"\tbne\t@zx01\n"
				"\tiny\n"
				"\tbne\t@zx00\n"
				"@zx01:\n"
				//If <, mark test for swap.
				"\tbcs\t@zx02\n"
				"\tlda\t_x\n"
				"\tsta\t_i\n"
				"@zx02:\n"
				);
                }
		//Swap.
		__asm__ (
			//Get entry addresses.
			"\tlda\t_c\n"
			"\tjsr\t_geteaddr\n"
			"\tsta\t_d+17\n"
			"\tstx\t_d+18\n"
			"\tjsr\t_geteaddri\n"
			//Perform swap.
#ifdef __Do1581__
			"\tldy\t#18\n"
#else
			"\tldy\t#16\n"
#endif
			"@zz10:\n"
			"\tlda\t(_d+17),y\n"
			"\ttax\n"
			"\tlda\t(ptr2),y\n"
			"\tsta\t(_d+17),y\n"
			"\ttxa\n"
			"\tsta\t(ptr2),y\n"
			"\tdey\n"
			"\tbpl\t@zz10\n"
			);
		//}
        }
	//Print entries from last to first.
	while (--e) DispDirEntry ();
	//Display prompt.
#ifndef __VIC20__
	__asm__ ("\ttay\n\tldx\t#24\n\tclc\n\tjsr\t$fff0\n");
#else
	__asm__ ("\ttay\n\tldx\t#21\n\tclc\n\tjsr\t$fff0\n");
#endif
	// Set color.
#ifdef __C128__
		textcolor (col_prompt);
#elif !defined __PET__
		textcol=col_prompt;
#endif
	// Write prompt.
	prints ("Select the program to run.");
	//Menu loop: get user selection.
	do
	{
		/* Highlight current selection. */
		reverson;
#if defined __C16__ || defined __PLUS4__ || defined __C64__
		textcol=col_hilite;
#elif defined __C128__
		textcolor (col_hilite);
#endif
		//Write current selection.
		DispDirEntry ();
		//Get ket into c.
		__asm__ ("@zz:\tjsr\t$FFE4\n\tbeq\t@zz\n\tsta\t_c\n");
		/* Unhilight and write. */
		reversoff;
		//Unselect current entry.
#ifdef __C128__
		setunselcol; //();//textcol=col_unselect;
#else
		setunselcol;
#endif
		DispDirEntry ();
		/* Process key. */
		switch (c)
		{
		/* If down, advance and wrap-around. */
		case CH_CURS_DOWN:
			__asm__ ("\tldx\t_e\n"
				 "\tinx\n"
				 "\tcpx\t_numfiles\n"
				 "\tbcc\t@zz3\n"
				 "\tldx\t#0\n"
				 "@zz3:\tstx\t_e\n");
				break;
		/* If up, move back and wrap-around. */
		case CH_CURS_UP:
			__asm__ (
				"\tldx\t_e\n"
				"\tbne\t@zz2\n"
				"\tldx\t_numfiles\n"
				"@zz2:\tdex\n"
				"\tstx\t_e\n");
			break;
		//If return, return program name or switch to partition.
		case '\n':
		
#ifdef __Do1581__
			//If 1581, check if the current selection is a partition.
			if (geteaddrcur()[0]=='/')
			{
				//If it is, get address after "/" prefix in entry.
				curpart=geteaddrcur()+1;
				//Write the string in dout to set new partition.
				__asm__ (
					//Write "/:".
					"\tlda\t#\'/\'\n"
					"\tsta\t_dout\n"
					"\tlda\t#\':\'\n"
					"\tsta\t_dout+1\n"
					);
				//strcat2 (dout, curpart);
				__asm__ (
					//Add to title2.
					"\tldx\t#0\n"
					"@z30:\n"
					"\tlda\t_title2,x\n"
					"\tbeq\t@z31\n"
					"\tinx\n"
					"\tbne\t@z30\n"
					"@z31:\n"
					);
				__asm__ (
					//Append name to dout string.
					"\tldy\t#0\n"
					"@zz15:\n"
					"\tlda\t(_curpart),y\n"
					"\tsta\t_dout+2,y\n"
					"\tsta\t_title2,x\n"
					"\tbeq\t@zz16\n"
					"\tinx\n"
					"\tiny\n"
					"\tbne\t@zz15\n"
					"@zz16:\n"
					//Append "/" to title and write EOS (0);
					"\tsta\t_title2+1,x\n"
					"\tlda\t#\'/\'\n"
					"\tsta\t_title2,x\n"
					);
				//Switch partition.
				//cbm_open (1,8,15,dout); cbm_close (1);
				__asm__ (
					//Set FLS.
					//"\tlda\t#1\n"
					//"\tldx\t#8\n"
					//"\tldy\t#15\n"
					//"\tjsr\t$FFBA\n"
					"\tjsr\t_open15\n"
					//Get dout's len' to a.
					"\tldx\t#0\n"
					"@za10:\n"
					"\tlda\t_dout,x\n"
					"\tbeq\t@za11\n"
					"\tinx\n"
					"\tbne\t@za10\n"
					"@za11:\n"
					"\ttxa\n"
//"\tsta\t$400\n"
					//Write string to change partitions to channel

					"\tldx\t#<_dout\n"
					"\tldy\t#>_dout\n"
					"\tjsr\t$FFBD\n"
					//Open channel.
					"\tjsr\t$FFC0\n"
					);
//__asm__ ("@zzxx:\tjsr\t$FFE4\n\tcmp\t#0\n\tbeq\t@zzxx\n");
				//Close channel.
				__asm__ ("\tlda\t#1\n\tjsr\t$FFC3\n");

				//Loop back to load directory.
				goto top;
			}
#endif
			return;
		//If cancel,
		case CH_STOP:
#ifdef __Do1581__
			//If 1581, test for subpartition.
			if (title2[1]) {
				//If so, clear partition name,
				title2[1]=0;
				//and revert to top
				//cbm_open (1,8,15,"/"); cbm_close (1);
				//and go back to dir load.
				__asm__ (
					//"\tlda\t#1\n"
					//"\tldx\t#8\n"
					//"\tldy\t#15\n"
					//"\tjsr\t$FFBA\n"
					"\tjsr\t_open15\n"
					//Set name ("$", as above in dire).
					"\tldx\t#<_slash\n"
					"\tldy\t#>_slash\n"
					"\tjsr\t$FFBD\n"
					//Open directory.
					"\tjsr\t$FFC0\n"
					);
				//cbm_close (1);
				__asm__ ("\tlda\t#1\n\tjsr\t$FFC3\n");
				goto top;
			}
#endif
			//Abort.  Current entry e<0 indicates cancel.
			prints ("\fProgram aborted!");
			e=-1; return;
			//exit(0);
		}
		//If printable character, go to next entry w/ current start letter
		//or flash not-found error.
                if (c&0x60) {
			gotokey ();
                }
	} while(1);
//quiterr:
//	e=-1;
}

