//Header file for dirmenu.
#ifndef __dirmenu_menu_H
#define __dirmenu_menu_H

//Some constants:
#ifdef __Do1581__
#define lenfilename 18		//filename length for CBM computers
#else
#define lenfilename 16		//filename length for CBM computers
#endif
#ifdef __C128__
#define maxfiles 80		//# allowable files for this program
#define __Rows__ 25		//# rows.
#elifdef __VIC20__
#define maxfiles 18		//# allowable files for this program
#define __Rows__ 23		//# rows.
#else
#define maxfiles 40		//# allowable files for this program
#define __Rows__ 25		//# rows.
#endif

//Color defines:
#ifdef __C16__
#define col_unselect	0x42	//unselect color
#define col_hilite	0x6D	//highlighted text
#define col_title	0x5D	//title color
#define col_prompt	0x3C	//prompt color
#else
#define col_unselect	4	//unselect color
#ifdef __VIC20__
#define col_hilite	0	//highlighted text
#else
#define col_hilite	10	//highlighted text
#endif
#define col_title	5	//title color
#define col_prompt	6	//prompt color
#endif

//Routine to display menu and return selection.  Returns selection in prg[].
void SelPrg (void);

//CBMSimpleIO updated functions:
void __fastcall__ prints (char*);	//Print string.
void __fastcall__ printc (char);	//Print character.
void __fastcall__ printcr (void);	//Print return.
void __fastcall__ printscr (char*);	//Print string followed by CR.
void home (void);			//Set the cursor to the top-left of the screen.

//Turn reverse video on or off.
void reverson  (void);
void reversoff (void);

//Colors as variables for C64/C16:
//(Use normal functions for C128 and include the colors2_128_x.s file.)
extern unsigned char backcol, brdrcol, textcol;
#ifdef __C128__
#pragma zpsym ("textcol")
#endif

//Cursor x-pos variable.
extern unsigned char tabx;
#pragma zpsym ("tabx")
//Struct containing the screen colors, defined and written in main.c.
//main.c is also responsible for setting the border and background
//colors directly.
extern struct colenv {
	unsigned char	unselect,
			hilite,
			title,
			prompt;
} col;
#ifdef __C128__
extern unsigned char columns;
#pragma zpsym ("columns")
#else
#define columns 40
#endif
extern char *zpptr01;
#pragma zpsym ("zpptr01")
#endif

