.include	"zeropage.inc"
;_files is an 80-element array of type char[17] containing the files.
;_prints is a quick puts() function that outputs a string to the screen
;using the kernal's chrout routine.
.import		_files, _prints, popax

;_geteaddrcur returns the address of the current entry given in _e,
;_DispDirEntry displays a menu entry, and
;_WriteEntry writes the current selection to the current pos. on the
;screen.
.export		_geteaddrcur, _DispDirEntry, _WriteEntry, _memswap17
;.export		_geteaddr, _strcpy2, _strcat2, _strless2, _strlen2
.export		_geteaddr, _geteaddri;, _strless2, _strlen2
.ifdef __Do1581__
;.export		_strcpy2, _strcat2
.exportzp	_curpart
.export		_open15
.endif
.exportzp	_titlex

.export		_advf
.export		_chrinword, _chrinword2

;_e is the current menu selection #,
;_c holds the current key-press and a temp. centering # for displaying the
;title on a C128 ,
;_x is the column # of the current menu option, and
;_numfiles is the # of entries on the disk.
.exportzp	_e, _c, _x, _numfiles, _i, _byte, _d

;For the C128:
.ifdef __C128__
.export		_getcolumns	;Routine to get # columns and calculate
				;centerig x-pos for title.
.exportzp	_columns	;Returned # columns on the screen.
.endif

;For the PET:
.ifdef __PET__
.exportzp	_columns	;Returned # columns on the screen.
.endif

;The _e variable was moved here to support an optimization on the C64
;version.  The optimization was later removed due to an incompatibility, but
;this line wasn't corrected.
;.ifdef __C64__
;_e=$4B
;.endif

;Define ZP variables:
.zeropage
;.ifndef __C64__
_e:		.res	1
;.endif
_x:		.res	1
_c:		.res	1
_numfiles:	.res	1
_i:		.res	1
_byte:		.res	1
.ifdef __C128__
_columns:	.res	1
.endif
.ifdef __PET__
_columns:	.res	1
.endif
.ifdef	__Do1581__
_curpart:	.res	2
.endif
_titlex:	.res	1

;The following routine calculates the address of a given filename in the
;list.  The element # is in _e.
.code
;This entry gets the address of the current pos.
_geteaddri:
	lda	_i
	bpl	_geteaddr
_geteaddrcur:
	lda	_e
;This entry calculates the address of the file whose # is passed in .A.
_geteaddr:
.ifdef __Do1581__
	sta	regbank+4		;Store orig. e as word in regbank+4.
	ldy	#0
	;stx	regbank+5
	sty	tmp1			;High byte of shift calc. = 0.
	asl				;Multiply by 16 using shifts.
	asl				;Max. value of e is 39, so high bit is
.ifdef __C128__
	rol	tmp1			;(79 on C128)
.endif
	adc	regbank+4
	bcc	*+4
	inc	tmp1
	asl
	rol	tmp1
	asl
	rol	tmp1
	sec
	sbc	regbank+4
	bcs	*+4
	dec	tmp1
	clc
	adc	#<_files
	tay
	lda	tmp1
	adc	#>_files
	tax
	tya
	sta	ptr2
	stx	ptr2+1
	;ldy	#0
	rts
.else
;Quick-multiply by 17:
	sta	regbank+4		;Store orig. e as word in regbank+4.
	ldy	#0
	;stx	regbank+5
	sty	tmp1			;High byte of shift calc. = 0.
.ifdef __C128__
	ldx	#4
@z:
	asl
	rol	tmp1
	dex
	bne	@z
.else
	asl				;Multiply by 16 using shifts.
	asl				;Max. value of e is 39, so high bit is
;.ifdef __C128__
;	rol	tmp1			;(79 on C128)
;.endif
	asl				;not needed immediately.
	rol	tmp1
	asl
	rol	tmp1
.endif
	;clc				;Add orig. e for *17.
	adc	regbank+4
	ldx	tmp1
	bcc	*+4
	inx
	;inc	tmp1
	clc				;Add pointer to files array.
	adc     #<(_files)
	pha;tay
	;lda	tmp1
	txa
	adc     #>(_files)
	tax
	pla;tya
	;ldx	#>(_files)
	
	;ldx	#>(_files)
	;bcc	*+3
	;inx
	sta	ptr2
	stx	ptr2+1
	;ldy	#0
	rts
.endif

_DispDirEntry:
;Calculate X coordinate.
.ifdef __C128__			;Needs extra work on a C128:
	lda	_e		;Get entry # and set column to 0.
	ldx	#0
@lp:
	cmp	#20		;Test entry # and end loop if <20
	bcc	@lp2		;(on this column).
	sbc	#20		;Subtract 20 from entry,
	tay
	txa
	;clc			;add 20 to column for next column and
	adc	#19;20
	;sbc	#20
	tax
	tya
	bcc	@lp		;loop.  (Carry overflow not expected)
@lp2:
	txa			;Store as column and set as .X to PLOT
	sta	_x		;kernal routine.
	tay
.else				;For other computers,
	ldy	#0		;assume column 0.
	lda	_e		;If entry >=20, use column 20 instead.
	cmp	#20
	bcc	*+4
	ldy	#20
	sty	_x		;Set.
.endif
;Get y co.
	sec
	lda	_e		;Get entry.

	sbc	_x		;Subtract column # to get entry in column and
.ifdef __Do1581__
	adc	#2
.else
	adc	#1		;add 2 (explicit 1 + carry assumed set)
.endif
	tax			;for screen .Y.
	jsr	$fff0		;Call PLOT (carry already clear).
;Entry point to write to current screen pos.
_WriteEntry:
	jsr	_geteaddrcur
	jmp	_prints


.ifdef __C128__
;On a C128, get screen columns and the pos. of centered disk name.
_getcolumns:
;	lda	#40
;	;ldx	#12
;	bit	$D7
;	bpl	*+3
;	;lda	#80
;	asl
;	;ldx	#32
;	;lda	#0
;	sta	_columns
;	;stx	_c
;	rts
.endif

_memswap17:
;	lda	_c
;	jsr	_geteaddr
;	sta	ptr1
;	stx	ptr1+1
;	jsr	_geteaddri
;	;jsr	popax
;	;sta	ptr2
;	;stx	ptr2+1
;	;jsr	readptrs
;.ifdef __Do1581__
;	ldy	#18
;.else
;	ldy	#16
;.endif
;@lp:
;	lda	(ptr1),y
;	tax
;	lda	(ptr2),y
;	sta	(ptr1),y
;	txa
;	sta	(ptr2),y
;	dey
;	bpl	@lp
;
;	rts

;.ifdef __Do1581__
;_strcat2:
;	jsr	readptrs
;	ldy	#0
;@lp:
;	lda	(ptr2),y
;	beq	@exit
;	iny
;	bne	@lp
;@exit:
;	;dey
;	tya
;	clc
;	adc	ptr2
;	sta	ptr2
;	bcc	entr;*+4
;	inc	ptr2+1
;	bne	entr
;
;_strcpy2:
;	jsr	readptrs
;entr:
;	ldy	#0
;@lp:
;	lda	(ptr1),y
;	sta	(ptr2),y
;	beq	@exit
;	iny
;	bne	@lp
;@exit:
;	rts

;_strless2:
;	;jsr	readptrs
;	lda	_x
;	jsr	_geteaddr
;	sta	ptr1
;	stx	ptr1+1
;	jsr	_geteaddri
;	ldy	#0
;@lp:
;	lda	(ptr2),y
;	cmp	(ptr1),y
;	bne	@exit
;	;cmp	#0
;	;beq	@exit
;	iny
;	bne	@lp
;@exit:
;	lda	#0
;	;tax
;	rol
;	rts

;_strlen2:
;	sta	ptr3
;	stx	ptr3+1
;	ldy	#0
;@lp:
;	lda	(ptr3),y
;	beq	@end
;	iny
;	bne	@lp
;@end:
;	iny
;	tya
;	rts

;readptrs:
;	sta	ptr1
;	stx	ptr1+1
;	jsr	popax
;	sta	ptr2
;	stx	ptr2+1
;	;ldy	#0
;	rts
;.endif

_advf:
;	;tax
;	ldx	_i
;	inx
;	cpx	_numfiles
;	bcc	*+4
;	ldx	#0
;	;txa
;	stx	_i
;	txa
;	ldx	#0
;	rts
	;lda	_i
	ldx	_i
	inx
	txa
	ldx	#0
	cmp	_numfiles
	bcc	*+3
	txa
	sta	_i
	rts

_chrinword2:
	jsr	_chrinword
_chrinword:
	jsr	$ffcf
	;pha
	;jsr	$ffcf
	;tax
	;pla
	;rts
	jmp	$ffcf

.ifdef __Do1581__
_open15:
	lda	#1
	ldx	#8
	ldy	#15
	jmp	$FFBA
.endif

.zeropage
_d:	.res	24
