/**************************************************************************
 *
 * Interface module of type UI for a cc65
 * application.
 *
 * This code skeleton was created using TempC by Joseph Rose.
 * This code is not copyrighted.  The end progammer may read,
 * analyze or modify it as he/she wishes.
 *
 **************************************************************************/

/* Standard includes: */
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>

/* Special headers */
//#include <c64.h>
#include <conio.h>
#if defined __APPLE2__ || defined __APPLE2ENH__
#include <dirent.h>
#endif

/* You should include this module's header here. */
#include "menu.h"

/* Pointer to array holding file names. */
static char (*files) [maxfiles][lenfilename+1];
char prg [17]; /* Name of open file. */

/* Display one file in list. */
/* i=file #. */
static void DispDirEntry (unsigned char i/*, char* f*/)
{
	cputsxy ((i>=20)*20, i%20+2, files[0][i]);
}


/* Function to select a program to run. */
void SelPrg ()
{
	static unsigned char numfiles;	/* # Programs on disk */
	static char c;
	static signed char i; /* temp. variable */
	static struct cbm_dirent d; /* Read directory entry data */

	/* Allocate files database. */
	files=malloc(maxfiles*(lenfilename+1));
	/* Display title of screen */
	clrscr();
	
	cputsxy ((__Columns__-14)>>1,0,"Select program");
#ifdef __CBM__
	/* Open directory on device 8. */
	if (cbm_opendir(12,8)) {/* If error, */
		puts("Can't load directory."); return; /* exit. */
	}
	/* Read disk label. */
	cbm_readdir (12, &d);
	//i=0;
	/* Read directory entries until end of dir. or overflow. */
	for (i=0;i<maxfiles && !cbm_readdir(12, &d);)
	{
		/* Skip if not a program. */
		if (d.type!=CBM_T_PRG) continue;
		/* Store program name. */
		strcpy (files[0][i],d.name);
		/* Display program name. */
		DispDirEntry (i++);

	}
	/* Write # programs. */
	numfiles=i;

	cbm_closedir (12); /* Close directory. */
	/* Leave source open for Apple 2 support. */
#elif defined __APPLE2__ || defined __APPLE2ENH__
#endif
	/* Display files. */
	/*for (i=0; i<numfiles; ++i)
	{
		DispDirEntry (i);
	}*/
	/* If disk blank, */
	if (numfiles==0){
		/* error and cancel operation. */
		cputsxy (0,__Rows__-2,"No programs on disk.\r\n"
			"Press any key to continue.");
		cgetc();
		free(files);
		return;
	}
	/* Display select prompt. */
	cputsxy (0,__Rows__-1,"Select the program to run.");
	/* Set selection to first in list. */
	i=0;
	while(1)
	{
		/* Highlight current selection. */
		revers(1);
#if defined __C16__ || defined __PLUS4__
		textcolor (0x6D);
#elif defined __C64__ || defined __C128__
		textcolor (COLOR_LIGHTRED);
#endif
		DispDirEntry (i/*,files[0][i]*/);
		/* Get key. */
		c=cgetc();
		/* Unhilight. */
		revers(0);
#if defined __C16__ || defined __PLUS4__
		textcolor (0x42);
#elif defined __C64__ 
		textcolor (COLOR_PURPLE);
#elif defined __C128__
		textcolor (COLOR_VIOLET);
#endif
		DispDirEntry (i/*,files[0][i]*/);
		/* Process key. */
		switch (c)
		{
		/* If down, advance and wrap-around. */
		case CH_CURS_DOWN:
			++i;
			if (i>=numfiles) i=0;
			break;
		/* If up, move back and wrap-around. */
		case CH_CURS_UP:
			--i;
			if (i<0) i=numfiles-1;
			break;
		/* If Return, return program name. */
		case '\n':
			strcpy (prg, files[0][i]);
		/* If return or cancel, exit routine.
		 * If cancel, returned program is already nullified
		 * upon call to this routine. */
		case CH_STOP:
			free(files);
			return;
		}
	}
}

