/* LUnix-preprocessor (lupo) Version 0.7

   Written by Daniel Dallmann (aka Poldi) in Sep 1996.
   This piece of software is freeware ! So DO NOT sell it !!
   You may copy and redistribute this file for free, but only with this header
   unchanged in it. (Or you risc eternity in hell)

   If you've noticed a bug or created an additional feature, let me know.
   My (internet) email-address is Daniel.Dallmann@studbox.uni-stuttgart.de

 Nov  3 *poldi* bugfix: tabs now really are white spaces
                        "." may be part of macro-names.
                feature: lupo now removes remarks (prefixed by ";")
                         this can be switched off (-r option)

*/

#include <stdio.h>
#include <stdlib.h>

#undef debug

#define include_depth_max 5
#define if_depth_max 10
#define line_length_max 500
#define defines_max 300
#define macro_length_max 1000
#define parameters_max 10          /* not over 30 ! */

#define no_match 0x6fff

static FILE *infile;
static int  line;
static int  lpos[include_depth_max-1];
static char *infilename[include_depth_max];
static FILE *infilestream[include_depth_max];
static int  infiles;
static int  errors;

static char *defs[defines_max];
static int  parcount[defines_max];
static char *repl[defines_max];
static char *mpar[parameters_max];
static int  defcount;
static int  remove_remarks;

void error(char *message)
{
  static int i;

  printf("  error:%s in line %i\n",message,line);
  if (infiles>0) {
    i=infiles;
    printf("    of file \"%s\",",infilename[i]);
    i--;
    while(i>=0) {
      printf("    which is included from \"%s\" (line %i)\n",infilename[i],lpos[i]);
      i--; }
  }
  errors++;
}

void Howto() 
{
  printf("lupo [-oq] file\n");
  printf("  little universal preprocessor version 0.7 by poldi\n");
  printf("  -o file        - define outputfile (default lupo.out)\n");
  printf("  -dname[=macro] - predefine macro\n");
  printf("  -r             - don't remove remarks\n");
  printf("  -s             - don't remove leading spaces\n");
  exit(-1);
}

int nextchar(char *string, int pos)
{
  /* printf("nexchar:\"%s\"\n",&string[pos]); */

  while (string[pos]==' ' || string[pos]=='\t') pos++;
  return pos;
}

int is_sep(char a)
{
  if ( (a>='a' && a<='z') ||
       (a>='A' && a<='Z') ||
       (a>='0' && a<='9') ||
       a=='_' || a=='@' ||
       a=='' || a=='' ||
       a=='' || a=='' ||
       a=='' || a=='' ||
       a=='' || a=='.'     ) return 0;

  return 1;
}

#ifdef debug

void macroout(char *mac)
{
  int i;

  printf("\"");
  i=0;
  while (mac[i]!='\0') {
    if (mac[i]<32) printf("\\%i",mac[i]);
    else printf("%c",mac[i]);
    i++; }
  printf("\"\n");
}

#endif

char *str_sav(char *string)
{
  char *hlp;

# ifdef debug  
  printf("str_sav:"); macroout(string);
# endif

  hlp=(char *)malloc(strlen(string)+1);
  if (hlp==NULL) { error("out of memory"); exit(-1); }
  strcpy(hlp,string);
  return hlp;
}

int readline(char *buffer)
{
  int i=0, quoted=0;
  static int tmp;
  line++;

  if (infiles<0) return EOF;

  while (1) {
    if (i==line_length_max-1) { 
      error("line too long");
      buffer[i]='\0';
      return 0; }
    tmp=getc(infile);
    if (tmp==EOF) {
      if (quoted) error("stray \\");
      if (i==0) {
        fclose(infile);
        if (infiles==0) { infiles=-1; return EOF; }
        else free(infilename[infiles]);
        infiles--;
        infile=infilestream[infiles];
        line=lpos[infiles]; }
      buffer[i]='\0';
      return 0; }
    if (tmp=='\\' && !quoted) { quoted=1; continue; }
    if (tmp=='\n') {
      if (quoted) { line++; quoted=0; continue; }
      buffer[i]='\0';
      return 0; }
    if (tmp<32 && tmp!='\t') continue;
    if (quoted) { buffer[i++]='\\'; quoted=0; }
    buffer[i++]=tmp; }
}

int match(char *string,int pos,char *pattern)
{
  int i=0;

  while (pattern[i]!='\0') {
    if (pattern[i]!=string[pos+i]) return no_match;
    i++; }

  if (!is_sep(string[pos+i])) return no_match;
  return pos+i;
}

int search_def(char *name)
{
  int i;
 
  i=0;
  while (i<defcount) {
    if (!strcmp(defs[i],name)) return i;
    i++; }

  return no_match;
}

int get_term(char *line, int *pos)
{
  int tmp;
  int hlp,hlp2;

  *pos=nextchar(line,*pos);

  if (line[*pos]=='!') {
    *pos+=1;
    return get_term(line,pos) ? 0:1 ; }

  if (line[*pos]=='(') {
    *pos+=1;
    tmp=get_expr(line,pos);
    *pos=nextchar(line,*pos);
    if (line[*pos]!=')') error("syntax");
    *pos+=1;
    return tmp; }
  
  /* or val */

  hlp=*pos;
  while (!is_sep(line[hlp])) hlp++;
  hlp2=line[hlp];
  line[hlp]='\0';
  if (search_def(&line[*pos])!=no_match) tmp=1; else tmp=0;
  line[hlp]=hlp2;
  *pos=hlp;
  return tmp; 
}

int get_sum(char *line, int *pos)
{
  int tmp;

  tmp=1;
  while(1) {
    tmp=tmp & get_term(line,pos);
    *pos=nextchar(line,*pos);
    if (line[*pos]!='&') return tmp;
    *pos+=1; }
} 

int get_expr(char *line, int *pos)
{
  int tmp;

  tmp=0;
  while(1) {
    tmp=tmp | get_sum(line,pos);
    if (line[*pos]!='|') return tmp;
    *pos+=1; }
} 

void process_line(char *l)
{
  int  i,need,a,b;
  int  x,y;
  char *tmp;
  char *tmp2;
  char *tmp3;
  int  str_quote,quote;

# ifdef debug
  printf("processing:\"%s\"\n",l);
# endif

  str_quote=quote=0;
  i=0; x=0;
  while (l[i]!='\0') {
    if (x==0) {
      if (!is_sep(l[i]) && !quote && !str_quote) {
        x=0; y=no_match;
        while (x<defcount) {
          if ((y=match(l,i,defs[x]))!=no_match) break;
          x++; }
        if ((y!=no_match) && (parcount[x]==0 || l[y]=='(') ) {

#         ifdef debug
          printf("match found !\n");
#         endif

          need=strlen(repl[x]);
          if (parcount[x]>0) {
            tmp3=str_sav(l);
            tmp3[y]=',';
            a=0;
            while (a<parcount[x]) {
              if (tmp3[y]==')') { error("missing parameter"); return; }
              if (tmp3[y]!=',') { error("syntax"); return; }
              tmp3[y]='\0';
              b=y=nextchar(l,y+1);
              mpar[a++]=&tmp3[y];
              while (tmp3[y]!='\0' && tmp3[y]!=',' && tmp3[y]!=')') y++; }

            if (tmp3[y]==',') { error("too much parameters"); return; }
            if (tmp3[y]!=')') { error("syntax"); return; }
            tmp3[y]='\0';
            y++;
            a=0;
            tmp=repl[x];
            while (tmp[a]!='\0') {
              if (tmp[a]<32 && tmp[a]>1) need+=strlen(mpar[tmp[a]-2])-1;
              a++; }

#           ifdef debug         
            printf("macroparameters: ");

            a=0;
            while (a<parcount[x]) {
              printf("\"%s\" ",mpar[a]);
              a++; }
            printf("\n");
#           endif

          } 
          else tmp3=NULL;
          
          if (need<y-i) {
            a=i+need; b=y;
            while ( (l[a++]=l[b++])!='\0' );
            l[a]='\0'; }

          if (need>y-i) {
            b=strlen(l); a=b+(need-y+i);
            while (b>=y) l[a--]=l[b--];  }
          
          a=0;
          tmp=repl[x];
          while (tmp[a]!='\0') {
            if (tmp[a]<32 && tmp[a]>1) {
              b=0;
              tmp2=mpar[tmp[a++]-2];
              while (tmp2[b]!='\0') l[i++]=tmp2[b++]; }
            else l[i++]=tmp[a++]; }

#         ifdef debug
          printf("replaced, now:\"%s\"\n",l);
#         endif

          if (tmp3!=NULL) free(tmp3);
          x=0; }
        else x=1;  } }
    else {
      if (is_sep(l[i])) x=0;
      }

    if (remove_remarks && !quote && l[i]==';') {
      l[i]='\0';
#     ifdef debug
      printf("deleted remark\n");
#     endif
      return; }

    if (l[i]=='\"' && !quote) { /*"*/
      if (str_quote) str_quote=0; else str_quote=1; }
    if (l[i]=='\\') quote=1; else quote=0;

    i++; }
}

int read_macro_def(char *lbuf, int *j)
{
  int args=-1;
  int i,p;

  /* read mask, count parameters (and remember their name) */

  p=(*j);
  while (!is_sep(lbuf[(*j)])) (*j)++;
  if (lbuf[(*j)]=='(') {
    lbuf[(*j)]=',';
    while (lbuf[i=nextchar(lbuf,(*j))]==',') {
      lbuf[(*j)]='\0';
      (*j)=nextchar(lbuf,i+1);
      if (lbuf[(*j)]=='\0') { 
        error("syntax"); return no_match; }
      if (args>=parameters_max) { 
        error("too many parameter"); return no_match; }
      mpar[++args]=&lbuf[(*j)];
      while (!is_sep(lbuf[(*j)])) (*j)++; }
    if (lbuf[i]!=')') error("syntax");
    lbuf[(*j)]='\0';
    (*j)=nextchar(lbuf,i+1); }
  else {
    if (lbuf[(*j)]!='\0') { 
      if (lbuf[(*j)]!=' ' && lbuf[(*j)]!='\t') { 
        error("syntax"); return no_match; }
      lbuf[(*j)]='\0'; 
      (*j)=nextchar(lbuf,(*j)+1); } }

  if (defcount>=defines_max) { 
    error("too many defines"); return no_match; }
  parcount[defcount]=args+1;
  if (search_def(&lbuf[p])!=no_match) { 
    error("redefined macro"); return no_match; }

  defs[defcount]=str_sav(&lbuf[p]);

# ifdef debug
  printf("new macro with %i parameter:",args+1);

  i=0;
  while (i<=args) printf(" \"%s\"",mpar[i++]);
  printf("\n");
# endif

  return args;
}

void main(int argc, char **argv)
{
  static int  i,j,p,tmp1,tmp2;
  static char lbuf[line_length_max];
  static char buf[100];
  static int  quiet_mode;
  static char *file_input;
  static char *file_output;
  static char *tmpstr;
  static FILE *outfile;
  static int  disable,depth;
  static int  if_flag[if_depth_max];
  static int  remove_spaces=1;

  file_input=file_output=NULL;
  quiet_mode=errors=disable=depth=0;
  if_flag[depth]=no_match;
  defcount=0;
  remove_remarks=1;

  i=1;
  while ( i<argc ) {
    if (argv[i][0]=='-') {
      j=1;
      while (argv[i][j]!='\0') {
        switch (argv[i][j]) {
          case 'd': { 
            if (defcount>=defines_max) { 
              error("too many defines\n"); 
              exit(-1); }
            tmpstr=&argv[i][j+1];
            p=0;
            while (!is_sep(tmpstr[p])) p++;
            if (tmpstr[p]=='=') {
              tmpstr[p]='\0';
              defs[defcount]=str_sav(tmpstr);
              repl[defcount]=str_sav(&tmpstr[p+1]); }
            else if (tmpstr[p]=='\0') {
              defs[defcount]=str_sav(tmpstr);
              repl[defcount]=str_sav(""); }
            else Howto();
            defcount++;
            j=0; break; }
          case 'o': { i++; file_output=argv[i]; j=0; break; }
          case 'r': { remove_remarks=0; break; }
          case 's': { remove_spaces=0; break; }
          default:  Howto();
          }
        if (i==argc) Howto();
        if (j==0) break;
        j++; }
	} else {
      if (file_input!=NULL) Howto();
      file_input=argv[i]; }
    i++; }

  if (file_input==NULL) { printf("%s: No input file\n",argv[0]); exit(1); }
  if (file_output==NULL) file_output="lupo.out";

  outfile=fopen(file_output,"w");
  if (outfile==NULL) {
    printf("can't write to outputfile\n");
    exit(-1); }
  line=0;
  infiles=0;
  infile=fopen(file_input,"r");
  if (infile==NULL) {
    printf("can't open inputfile\n");
    exit(-1); }
  infilestream[0]=infile;
  infilename[0]=file_input;

  while (readline(lbuf)!=EOF) {

#   ifdef debug
    printf("line=\"%s\" depth=%i, disable=%i, if_flag=%i\n",lbuf,depth,disable,if_flag[depth]);
#   endif

    i=nextchar(lbuf,0);
    if (lbuf[i]=='\0') continue;
    
    i=nextchar(lbuf,0);
    if (lbuf[i]=='#') {
    
      /* is a preprocessor directive */
    
      i=nextchar(lbuf,++i);
      if (lbuf[i]=='\0') continue; /* was NULL-directive */

      if ((j=match(lbuf,i,"if"))!=no_match ||
          (j=match(lbuf,i,"ifdef"))!=no_match ) {
        p=get_expr(lbuf,&j);
        if (lbuf[j]!='\0' && lbuf[j]!=';') error("syntax");
        depth++; 
        if (depth>=if_depth_max) {
          error("too deep if");
          exit(-1); }
        if (!disable && !p) { 
           disable=depth;
           if_flag[depth]=0; }
        else if_flag[depth]=1;
        continue; }

      if ((j=match(lbuf,i,"elif"))!=no_match) {
        if (if_flag[depth]==no_match) { 
          error("elif without if");
          continue; }
        p=get_expr(lbuf,&j);
        if (lbuf[j]!='\0' && lbuf[j]!=';') error("syntax");
        p=if_flag[depth]==0 && p;
        if (!p && !disable) disable=depth;
        if (p && disable==depth) disable=0;
        if (p) if_flag[depth]=1;
        if (depth==0) error("elif without if");
        continue; }

      if ((j=match(lbuf,i,"ifndef"))!=no_match) {
        p=get_term(lbuf,&j);
        j=nextchar(lbuf,j);
        if (lbuf[j]!='\0' && lbuf[j]!=';') error("syntax");
        depth++;
        if (depth>=if_depth_max) {
          error("too deep if");
          exit(-1); }
        if (p && !disable) {
          disable=depth;
          if_flag[depth]=0; }
        else if_flag[depth]=1;
        continue; }

      if ((j=match(lbuf,i,"else"))!=no_match) {
        j=nextchar(lbuf,j);
        if (lbuf[j]!='\0' && lbuf[j]!=';') error("syntax");
        if (depth==0 || if_flag[depth]==no_match) 
          error("else without if"); 
        else {
          if (if_flag[depth]==0) {
            disable=0;
            if_flag[depth]=1; }
          else if (!disable) disable=depth; }
        continue; }

      if ((j=match(lbuf,i,"endif"))!=no_match) {
        j=nextchar(lbuf,j);
        if (lbuf[j]!='\0' && lbuf[j]!=';') error("syntax");
        if (disable==depth) disable=0;
        if (depth==0) error("endif without if"); else {
          if_flag[depth]=no_match;
          depth--; }
        continue; }

      if ((j=match(lbuf,i,"enddef"))!=no_match) {
        error("enddef without begindef");
        continue; }

      if ((j=match(lbuf,i,"msg"))!=no_match) {
        if (!disable) printf("%s\n",&lbuf[nextchar(lbuf,j)]);
        continue; }

      if ((j=match(lbuf,i,"error"))!=no_match) {
        if (!disable) {
          error("preprocessing stopped");
          exit(-1); }
        continue; }

      if ((j=match(lbuf,i,"include"))!=no_match) {
        if (disable) continue;

        j=nextchar(lbuf,j);
        process_line(&lbuf[j]);

        if (lbuf[j]=='\0') { error("missing filename"); continue; }
        if (lbuf[j]!='\"') { error("'\"' expected"); continue; }
        i=++j;
        while (lbuf[j]!='\"' && lbuf[j]!='\0') { /*"*/
          j++; }
        if (lbuf[j]=='\0') error("unterminated filename");
        lbuf[j]='\0';
        infile=fopen(&lbuf[i],"r");
        if (infile==NULL) {
          sprintf(buf,"can't open file \"%s\"",&lbuf[i]);
          error(buf);
          infile=infilestream[infiles];
          continue; }
        lpos[infiles]=line;
        if (lbuf[nextchar(lbuf,j+1)]!='\0') error("syntax");
        infiles++;
        if (infiles>=include_depth_max) { error("too many nested includes"); exit(-1); }
        infilestream[infiles]=infile;
        infilename[infiles]=str_sav(&lbuf[i]);
        line=0;
        continue; }

      if ((j=match(lbuf,i,"undef"))!=no_match) {
        if (disable) continue;

        j=nextchar(lbuf,j);

        if (lbuf[j]=='\0') { error("missing argument"); continue; }

        p=j;
        while (!is_sep(lbuf[j])) j++;

        if (lbuf[j]!='\0') {
          i=nextchar(lbuf,j);
          if (lbuf[i]!='\0' && lbuf[i]!=';') { error("syntax"); continue; }
          lbuf[j]='\0'; }

        i=search_def(&lbuf[p]);
        if (i!=no_match) {
          free(defs[i]);
          free(repl[i]);
          defcount--;
          while (i<defcount) {
            parcount[i]=parcount[i+1];
            defs[i]=defs[i+1];
            repl[i]=repl[i+1];
            i++; }

#         ifdef debug
		  printf("removed!\n");
#         endif

          }
	    continue; }

      if ((j=match(lbuf,i,"define"))!=no_match ||
          (j=match(lbuf,i,"begindef"))!=no_match) {

        int args,flag;
        flag=(lbuf[i]=='b');

        if (disable) {

          if (flag) {
            /* search for #enddef */
            tmp2=0;
            while (readline(lbuf)!=EOF) {
              i=nextchar(lbuf,0);
              if (lbuf[i]!='#') continue;
              i=nextchar(lbuf,i+1);
              if ((j=match(lbuf,i,"enddef"))==no_match) {
                error("#directive in macro-definition");
                continue; }
              j=nextchar(lbuf,j);
              if (lbuf[j]!='\0' && lbuf[j]!=';') error("syntax");
              tmp2=1;
              break; }
            if (!tmp2) error("begindef without enddef"); }

            continue; }

        j=nextchar(lbuf,j);
        process_line(&lbuf[j]);
        if (lbuf[j]=='\0') { error("missing argument"); continue; }

        if ((args=read_macro_def(lbuf,&j))==no_match) continue;

        /* read replacement, and replace parameter by single ascii */

        if (!flag) {
          /* makro defined in this line */
          i=p=j;
          while (lbuf[j]!='\0') {
            if (!is_sep(lbuf[j])) {
              tmp1=0; tmp2=no_match;
              while (tmp1<=args) {
                if ((tmp2=match(lbuf,j,mpar[tmp1]))!=no_match) break;
                tmp1++; }
              if (tmp2!=no_match) {
                lbuf[i++]=(char) tmp1+2;
                j=tmp2; 
                continue; } }
            lbuf[i++]=lbuf[j++]; }
          lbuf[i]='\0';
          repl[defcount]=str_sav(&lbuf[p]); }

        else {
          /* makro defined in next lines, terminated with #enddef */
          char *lbuf2;

          i=nextchar(lbuf,j);
          if (lbuf[i]!='\0' && lbuf[i]!=';') error("syntax");
          tmpstr=malloc(macro_length_max+1);
          if (tmpstr==NULL) { error("out of memory"); exit(-1); }

          tmp2=0; p=0;
          lbuf2=malloc(line_length_max);
          if (lbuf2==NULL) { error("out of memory"); exit(-1); }

          while (readline(lbuf2)!=EOF) {
            i=nextchar(lbuf2,0);
            if (lbuf2[i]=='#') {
              i=nextchar(lbuf2,i+1);
              if ((j=match(lbuf2,i,"enddef"))!=no_match) {
                j=nextchar(lbuf2,j);
                if (lbuf2[j]!='\0' && lbuf2[j]!=';') error("syntax");
                tmp2=1;
                break; }
              else error("#directive in macro-definition"); }
            else {
              process_line(lbuf2);
              j=0;
              while (lbuf2[j]!='\0' && p<macro_length_max) {
                if (!is_sep(lbuf2[j])) {
                  tmp1=0; tmp2=no_match;
                  while (tmp1<=args) {
                    if ((tmp2=match(lbuf2,j,mpar[tmp1]))!=no_match) break;
                    tmp1++; }
                  if (tmp2!=no_match) {
                    tmpstr[p++]=(char) tmp1+2;
                    j=tmp2; 
                    continue; } }
                tmpstr[p++]=lbuf2[j++]; }
              tmp2=0; }
            if (p<macro_length_max) tmpstr[p++]=(char) 1; }

          free(lbuf2);
          if (!tmp2) error("begindef without enddef"); 
          if (p>=macro_length_max) {
            error("macro too long");
            p=macro_length_max; }
          tmpstr[p]='\0';
          repl[defcount]=realloc(tmpstr,p+1);
#         ifdef debug  
          printf("str_sav:"); macroout(repl[defcount]);
#         endif
          }
        
        defcount++;
        continue; } 

      sprintf(buf,"unknown directive \"%s\"",&lbuf[i]);
      error(buf);
      continue; }
    
    if (disable==0) {
      process_line(lbuf);
      i=0;
      if (remove_spaces) { 
        while (lbuf[i]==' ' || lbuf[i]=='\t') i++; }

      if (!remove_spaces || lbuf[i]!='\0') {
        while (lbuf[i]!='\0') {
          if (lbuf[i]==1) fprintf(outfile,"\n");
          else fputc(lbuf[i],outfile); 
          i++; }
        fprintf(outfile,"\n"); }
	  }
   }

   fclose(outfile);
   if (depth!=0) error("if without endif");
   if (errors) {
     printf("summary: %i error(s)\n",errors);
     exit(-1); }
   else { 
     printf("done, no errors\n"); 
     exit(0); }
}

