;
; HES 64FORTH DISASSEMBLY
;

TOS	=	$60		; $60
N	=	TOS+8		; $68
IP	=	N+8		; $70
W	=	IP+3		; $73
UP	=	W+2		; $75
XSAVE	=	UP+2		; $77
NXTMP	=	XSAVE+2		; $79

	*=	$8000

L8000	.WORD	L8019			; COLD BOOT
	.WORD	L8009			; WARM BOOT
	.BYTE	$C3,$C2,$CD,$38,$30	; CARTRIDGE ID

L8009	NOP
	LDA	$C5
	CMP	#$3F
	BEQ	L8016
	JSR	$F6BC
	JMP	$FE72

L8016	JMP	L9374

L8019	LDX	#$FF
	STX	$D016
	JSR	$FDA3
L8021	JSR	$FD50
	JSR	$FD15
L8027	NOP
	NOP
	NOP
	NOP
	LDA	#$C0
	JSR	$FF90
	JSR	$E518
	CLI
	JMP	L936B

; ORIGIN

ORIG	.WORD	0
	.WORD	0
	.WORD	0
	.WORD	0
	.WORD	0
	.WORD	0

; BOOTUP VARIABLES

	.WORD	$87B		; TOP WORD
	.WORD	0		; 
L8047	.WORD	$940		; UP
	.WORD	TOS		; TOP OF STACK
	.WORD	$1FF		; TOP OF RETURN STACK
	.WORD	$B80		; TIB
	.WORD	$1F		; WIDTH
	.WORD	0		; 
	.WORD	$B40		; FENCE
	.WORD	$F44		; DP
	.WORD	$88C		; VOC-LINK

;	VWORDS

L8059	.BYTE	$86,'VWORD',$D3
	.WORD	0
VWORDS	.WORD	DOVAR
	.WORD	PKEY		; 0
	.WORD	PEMIT		; 2
	.WORD	PQTER		; 4
	.WORD	PCRR		; 6
	.WORD	PCREAT		; 8
	.WORD	PNUMBE		; 10
	.WORD	PERROR		; 12
	.WORD	PDOT		; 14
	.WORD	PDFIND		; 16
	.WORD	PCCOM		; 18
	.WORD	PCOMMA		; 20
	.WORD	PRSLW		; 22
	.WORD	L80D1		; 24
	.WORD	1		; 26
	.WORD	1		; 28

L8082	.BYTE	$94		; 
	.WORD	L9EBF

	.BYTE	$85		; F1
	.WORD	LA048

	.BYTE	$86		; F2
	.WORD	LA051

	.BYTE	$87		; F5
	.WORD	LA05B

	.BYTE	$1D		; RIGHT
	.WORD	LA065

	.BYTE	$9D		; LEFT
	.WORD	LA06D

	.BYTE	$11		; DOWN
	.WORD	LA077

	.BYTE	$91		; UP
	.WORD	LA07F

	.BYTE	$13		; CTL-S
	.WORD	TOP

	.BYTE	$89		; F2
	.WORD	NN

	.BYTE	$8A		; F4
	.WORD	BB

	.BYTE	$88		; F7
	.WORD	PFF

	.BYTE	$8C		; F8
	.WORD	LA089

	.BYTE	$94		; 
	.WORD	L9F35

	.BYTE	$8B		; F6
	.WORD	LA091

	.BYTE	$B0		; CBM-A
	.WORD	LA051

	.BYTE	$AE		; CBM-S
	.WORD	LA06D

	.BYTE	$AC		; CBM-D
	.WORD	LA065

	.BYTE	$BB		; CBM-B
	.WORD	LA048

	.BYTE	$B1		; CBM-E
	.WORD	LA07F

	.BYTE	$B2		; CBM-R
	.WORD	BB

	.BYTE	$BD		; CBM-X
	.WORD	LA077

	.BYTE	$BC		; CBM-C
	.WORD	NN

	.BYTE	$A5		; CBM-G
	.WORD	LA0AB

	.BYTE	$AD		; CBM-Z
	.WORD	LA0A1

	.BYTE	$B7		; CBM-Y
	.WORD	LA099

	.BYTE	0

L80D1	.BYTE	$8D
	.WORD	L80D5
	.BYTE	0

L80D5	.WORD	DOCOL
	.WORD	CR
	.WORD	PDOTQ
	.BYTE	18
	.BYTE	'(C)1983 TOM ZIMMER'
	.WORD	CR
	.WORD	SEMIS

;	(MATCH)

L80F2	.BYTE	$87,'(MATCH',$A9
	.WORD	L8059
PMATCH	.WORD	*+2
	LDY	0,X
	BEQ	L8123
	LDA	2,X
	STA	NXTMP
	LDA	3,X
	STA	NXTMP+1
	LDA	4,X
	STA	XSAVE
	LDA	5,X
	STA	NXTMP-1
L8112	DEY
	LDA	(NXTMP),Y
	CMP	(XSAVE),Y
	BNE	L8123
	CPY	#0
	BNE	L8112
	LDA	#1
	STA	4,X
	BNE	L8128
L8123	LDA	#0
	TAY
	STA	4,X
L8128	TYA
	STA	5,X
	JMP	POPTWO

;	LIT

L812E	.BYTE	$83,'LI',$D4
	.WORD	L80F2
LIT	.WORD	*+2
	LDA	(IP),Y
	PHA
	INC	IP
	BNE	L813F
	INC	IP+1
L813F	LDA	(IP),Y
L8141	INC	IP
	BNE	PUSH
	INC	IP+1

PUSH	DEX
	DEX

PUT	STA	1,X
	PLA
	STA	0,X

NEXT	LDY	#1
	LDA	(IP),Y
	STA	W+1
	DEY
	LDA	(IP),Y
	STA	W
	LDA	(W),Y
	STA	NXTMP
	INY
	LDA	(W),Y
	STA	NXTMP+1
	DEY
	CLC
	LDA	IP
	ADC	#2
	STA	IP
	BCC	L816E
	INC	IP+1
L816E	JMP	(NXTMP)

;	CLIT

L8171	.BYTE	$84,'CLI',$D4
	.WORD	L812E
CLIT	.WORD	*+2
	LDA	(IP),Y
	PHA
	TYA
	BEQ	L8141

SETUP	ASL	A
	STA	N-1
L8183	LDA	0,X
	STA	N,Y
	INX
	INY
	CPY	N-1
	BNE	L8183
	LDY	#0
	RTS

;	EXECUTE

L8191	.BYTE	$87,'EXECUT',$C5
	.WORD	L8171
EXEC	.WORD	*+2
	LDA	0,X
	STA	W
	LDA	1,X
	STA	W+1
	INX
	INX
	LDY	#0
L81A9	LDA	(W),Y
	STA	NXTMP
	INY
	LDA	(W),Y
	STA	NXTMP+1
	DEY
	JMP	(NXTMP)

;	VECTOR

L81B6	.BYTE	$86,'VECTO',$D2
	.WORD	L8191
	.WORD	DOCOL
	.WORD	CONST
	.WORD	PSCOD
DOVEC	LDY	#2
	CLC
	LDA	(W),Y
	ADC	#$32
	ADC	UP
	STA	W
	LDA	#0
	TAY
	ADC	UP+1
	STA	W+1
	LDA	(W),Y
	PHA
	INY
	LDA	(W),Y
	DEY
	STA	W+1
	PLA
	STA	W
	JMP	L81A9

;	BRANCH

L81E6	.BYTE	$86,'BRANC',$C8
	.WORD	L81B6
BRAN	.WORD	*+2
	CLC
	LDA	(IP),Y
	ADC	IP
	PHA
	INY
	LDA	(IP),Y
	ADC	IP+1
	STA	IP+1
	PLA
	STA	IP
	JMP	NEXT

;	0BRANCH

L8204	.BYTE	$87,'0BRANC',$C8
	.WORD	L81E6
ZBRAN	.WORD	*+2
	INX
	INX
	LDA	$FE,X
	ORA	$FF,X
	BEQ	BRAN+2

BUMP	CLC
	LDA	IP
	ADC	#2
	STA	IP
	BCC	L8223
	INC	IP+1
L8223	JMP	NEXT

;	(LOOP)

L8226	.BYTE	$86,'(LOOP',$A9
	.WORD	L8204
PLOOP	.WORD	*+2
	STX	XSAVE
	TSX
	INC	$101,X
	BNE	PL1
	INC	$102,X

PL1	CLC
	LDA	$103,X
	SBC	$101,X
	LDA	$104,X
	SBC	$102,X

PL2	LDX	XSAVE
	ASL	A
	BCC	BRAN+2
	PLA
	PLA
	PLA
	PLA
	JMP	BUMP

;	(+LOOP)

L8255	.BYTE	$87,'(+LOOP',$A9
	.WORD	L8226
PPLOO	.WORD	*+2
	INX
	INX
	STX	XSAVE
	LDA	$FF,X
	PHA
	PHA
	LDA	$FE,X
	TSX
	INX
	INX
	CLC
	ADC	$101,X
	STA	$101,X
	PLA
	ADC	$102,X
	STA	$102,X
	PLA
	BPL	PL1
	CLC
	LDA	$101,X
	SBC	$103,X
	LDA	$102,X
	SBC	$104,X
	JMP	PL2

;	(DO)

L828F	.BYTE	$84,'(DO',$A9
	.WORD	L8255
PDO	.WORD	*+2
	LDA	3,X
	PHA
	LDA	2,X
	PHA
	LDA	1,X
	PHA
	LDA	0,X
	PHA

POPTWO	INX
	INX

POP	INX
	INX
	JMP	NEXT

;	I

L82AB	.BYTE	$81,$C9
	.WORD	L828F
I	.WORD	R+2

;	DIGIT

L82B1	.BYTE	$85,'DIGI',$D4
	.WORD	L82AB
DIGIT	.WORD	*+2
	SEC
	LDA	2,X
	SBC	#'0'
	BMI	L82DA
	CMP	#10
	BMI	L82CD
	SEC
	SBC	#7
	CMP	#10
	BMI	L82DA
L82CD	CMP	0,X
	BPL	L82DA
	STA	2,X
	LDA	#1
	PHA
	TYA
	JMP	PUT

L82DA	TYA
	PHA
	JMP	L855C

;	(FIND)

L82DF	.BYTE	$86,'(FIND',$A9
	.WORD	L82B1
PFIND	.WORD	*+2
	LDA	#2
	JSR	SETUP
	STX	XSAVE
L82F1	LDY	#0
	LDA	(N),Y
	EOR	(N+2),Y
	AND	#$3F
	BNE	L8328
L82FB	INY
	LDA	(N),Y
	EOR	(N+2),Y
	ASL	A
	BNE	L8326
	BCC	L82FB
	LDX	XSAVE
	DEX
	DEX
	DEX
	DEX
	CLC
	TYA
	ADC	#5
	ADC	N
	STA	2,X
	LDY	#0
	TYA
	ADC	N+1
	STA	3,X
	STY	1,X
	LDA	(N),Y
	STA	0,X
	LDA	#1
	PHA
	JMP	PUSH

L8326	BCS	L832D
L8328	INY
	LDA	(N),Y
	BPL	L8328
L832D	INY
	LDA	(N),Y
	TAX
	INY
	LDA	(N),Y
	STA	N+1
	STX	N
	ORA	N
	BNE	L82F1
	LDX	XSAVE
	LDA	#0
	PHA
	JMP	PUSH

;	ENCLOSE

L8344	.BYTE	$87,'ENCLOS',$C5
	.WORD	L82DF
ENCL	.WORD	*+2
	LDA	#2
	JSR	SETUP
	TXA
	SEC
	SBC	#8
	TAX
	STY	3,X
	STY	1,X
	DEY
	DEC	N+3
	DEC	1,X
L8363	INY
	BNE	L836A
	INC	N+3
	INC	1,X
L836A	LDA	(N+2),Y
	CMP	N
	BEQ	L8363
	STY	4,X
	LDA	1,X
	STA	5,X
L8376	LDA	(N+2),Y
	BNE	L8396
	STY	2,X
	STY	0,X
	LDA	1,X
	STA	3,X
	TYA
	CMP	4,X
	BNE	L8393
	LDA	1,X
	CMP	5,X
	BNE	L8393
	INC	2,X
	BNE	L8393
	INC	3,X
L8393	JMP	NEXT

L8396	PHA
	STY	2,X
	LDA	1,X
	STA	3,X
	INY
	BNE	L83A4
	INC	1,X
	INC	N+3
L83A4	PLA
	CMP	N
	BNE	L8376
	STY	0,X
	JMP	NEXT

;	EMIT

L83AE	.BYTE	$84,'EMI',$D4
	.WORD	L8344
EMIT	.WORD	DOVEC
	.BYTE	2

PEMIT	.WORD	DOCOL
	.WORD	L964F
	.WORD	ONE
	.WORD	OUT
	.WORD	PSTOR
	.WORD	SEMIS

;	KEY

L83C4	.BYTE	$83,'KE',$D9
	.WORD	L83AE
KEY	.WORD	DOVEC
	.BYTE	0

PKEY	.WORD	DOCOL
	.WORD	ZERO
	.WORD	LIT,$CC
	.WORD	CSTOR
	.WORD	QTER
	.WORD	QDUP
	.WORD	ZBRAN,$FFFA
	.WORD	ONE
	.WORD	LIT
	.WORD	$CD
	.WORD	CSTOR
	.WORD	LIT,$CF
	.WORD	CAT
	.WORD	ZEQU
	.WORD	ZBRAN,$FFF6
	.WORD	ONE
	.WORD	LIT,$CC
	.WORD	CSTOR
	.WORD	TOR
	.WORD	CTBL
	.WORD	AT
	.WORD	COUNT
	.WORD	QDUP
	.WORD	ZBRAN,$1C
	.WORD	R
	.WORD	EQUAL
	.WORD	ZBRAN,$E
	.WORD	RFROM
	.WORD	ZEQU
	.WORD	OVER
	.WORD	AT
	.WORD	EXEC
	.WORD	TOR
	.WORD	TWOP
	.WORD	BRAN,$FFE0
	.WORD	DROP
	.WORD	RFROM
	.WORD	QDUP
	.WORD	ZBRAN,$FFA4
	.WORD	SEMIS

;	?TERMINAL

L842F	.BYTE	$89,'?TERMINA',$CC
	.WORD	L83C4
QTER	.WORD	DOVEC
	.BYTE	4

PQTER	.WORD	*+2
	STX	XSAVE
	JSR	$FFE4
	LDY	#0
	STY	$D4
	LDX	XSAVE
	JMP	PUSH0A

;	CR

L844E	.BYTE	$82,'C',$D2
	.WORD	L842F
CR	.WORD	DOVEC
	.BYTE	6

PCRR	.WORD	DOCOL
	.WORD	PDOTQ
	.BYTE	1
	.BYTE	$D
	.WORD	ZERO
	.WORD	OUT
	.WORD	STORE
	.WORD	SEMIS

;	VRESET

L8464	.BYTE	$86,'VRESE',$D4
	.WORD	L844E
VRESET	.WORD	DOCOL
	.WORD	VWORDS
	.WORD	IO
	.WORD	CLIT
	.BYTE	28
	.WORD	CMOVE
	.WORD	SEMIS

;	CMOVE

L847A	.BYTE	$85,'CMOV',$C5
	.WORD	L8464
CMOVE	.WORD	*+2
	LDA	#3
	JSR	SETUP
L8489	CPY	N
	BNE	L8494
	DEC	N+1
	BPL	L8494
	JMP	NEXT

L8494	LDA	(N+4),Y
	STA	(N+2),Y
	INY
	BNE	L8489
	INC	N+5
	INC	N+3
	JMP	L8489

;	SMOVE

L84A2	.BYTE	$85,'SMOV',$C5
	.WORD	L847A
SMOVE	.WORD	*+2
	STX	XSAVE
	LDA	#2
	JSR	SETUP
	LDY	#39
L84B5	LDA	(N+2),Y
	CMP	#64
	BCC	L84BD
	SBC	#64
L84BD	STA	(N),Y
	DEY
	BPL	L84B5
	LDX	XSAVE
	JMP	NEXT

;	U*

L84C7	.BYTE	$82,'U',$AA
	.WORD	L84A2
USTAR	.WORD	*+2
	LDA	2,X
	STA	N
	STY	2,X
	LDA	3,X
	STA	N+1
	STY	3,X
	LDY	#16
L84DC	ASL	2,X
	ROL	3,X
	ROL	0,X
	ROL	1,X
	BCC	L84FB
	CLC
	LDA	N
	ADC	2,X
	STA	2,X
	LDA	N+1
	ADC	3,X
	STA	3,X
	BCC	L84FB
	INC	0,X
	BNE	L84FB
	INC	1,X
L84FB	DEY
	BNE	L84DC
	JMP	NEXT

;	U/

L8501	.BYTE	$82,'U',$AF
	.WORD	L84C7
USLAS	.WORD	*+2
	STY	N+1
	LDA	4,X
	LDY	2,X
	STY	4,X
	ASL	A
	STA	2,X
	LDA	5,X
	LDY	3,X
	STY	5,X
	ROL	A
	STA	3,X
	LDA	#16
	STA	N
L8520	ROL	4,X
	ROL	5,X
	ROL	N+1
	SEC
	LDA	4,X
	SBC	0,X
	TAY
	LDA	5,X
	SBC	1,X
	PHA
	LDA	N+1
	SBC	#0
	LDA	#0
	STA	N+1
	PLA
	BCC	L8540
	STY	4,X
	STA	5,X
L8540	ROL	2,X
	ROL	3,X
	DEC	N
	BNE	L8520
	JMP	POP

;	AND

L854B	.BYTE	$83,'AN',$C4
	.WORD	L8501
ANDD	.WORD	*+2
	LDA	0,X
	AND	2,X
	PHA
	LDA	1,X
	AND	3,X
L855C	INX
	INX
	JMP	PUT

;	OR

L8561	.BYTE	$82,'O',$D2
	.WORD	L854B
ORR	.WORD	*+2
	LDA	0,X
	ORA	2,X
	PHA
	LDA	1,X
	ORA	3,X
	JMP	L855C

;	XOR

L8574	.BYTE	$83,'XO',$D2
	.WORD	L8561
XORR	.WORD	*+2
	LDA	0,X
	EOR	2,X
	PHA
	LDA	1,X
	EOR	3,X
	JMP	L855C

;	SP@

L8588	.BYTE	$83,'SP',$C0
	.WORD	L8574
SPAT	.WORD	*+2
	TXA

PUSH0A	PHA
	LDA	#0
	JMP	PUSH

;	SP!

L8597	.BYTE	$83,'SP',$A1
	.WORD	L8588
SPSTO	.WORD	*+2
	LDY	#6
	LDA	(UP),Y
	TAX
	JMP	NEXT

;	RP!

L85A7	.BYTE	$83,'RP',$A1
	.WORD	L8597
RPSTO	.WORD	*+2
	STX	XSAVE
	LDY	#8
	LDA	(UP),Y
	TAX
	TXS
	LDX	XSAVE
	JMP	NEXT

;	;S

L85BC	.BYTE	$82,';',$D3
	.WORD	L85A7
SEMIS	.WORD	*+2
	PLA
	STA	IP
	PLA
	STA	IP+1
	JMP	NEXT

;	LEAVE

L85CC	.BYTE	$85,'LEAV',$C5
	.WORD	L85BC
LEAVE	.WORD	*+2
	STX	XSAVE
	TSX
	LDA	$101,X
	STA	$103,X
	LDA	$102,X
	STA	$104,X
	LDX	XSAVE
	JMP	NEXT

;	>R

L85EA	.BYTE	$82,'>',$D2
	.WORD	L85CC
TOR	.WORD	*+2
	LDA	1,X
	PHA
	LDA	0,X
	PHA
	JMP	POP

;	R>

L85FA	.BYTE	$82,'R',$BE
	.WORD	L85EA
RFROM	.WORD	*+2
	DEX
	DEX
	PLA
	STA	0,X
	PLA
	STA	1,X
	JMP	NEXT

;	R

L860C	.BYTE	$81,$D2
	.WORD	L85FA
R	.WORD	*+2
	STX	XSAVE
	TSX
	LDA	$101,X
	PHA
	LDA	$102,X
	LDX	XSAVE
	JMP	PUSH

;	0=

L8621	.BYTE	$82,'0',$BD
	.WORD	L860C
ZEQU	.WORD	*+2
	LDA	0,X
	ORA	1,X
	STY	1,X
	BNE	L8631
	INY
L8631	STY	0,X
	JMP	NEXT

;	0<

L8636	.BYTE	$82,'0',$BC
	.WORD	L8621
ZLESS	.WORD	*+2
	ASL	1,X
	TYA
	ROL	A
	STY	1,X
	STA	0,X
	JMP	NEXT

;	+

L8648	.BYTE	$81,$AB
	.WORD	L8636
PLUS	.WORD	*+2
	CLC
	LDA	0,X
	ADC	2,X
	STA	2,X
	LDA	1,X
	ADC	3,X
	STA	3,X
	JMP	POP

;	D+

L865E	.BYTE	$82,'D',$AB
	.WORD	L8648
DPLUS	.WORD	*+2
	CLC
	LDA	2,X
	ADC	6,X
	STA	6,X
	LDA	3,X
	ADC	7,X
	STA	7,X
	LDA	0,X
	ADC	4,X
	STA	4,X
	LDA	1,X
	ADC	5,X
	STA	5,X
	JMP	POPTWO

;	MINUS

L8681	.BYTE	$85,'MINU',$D3
	.WORD	L865E
MINUS	.WORD	*+2
	SEC
	TYA
	SBC	0,X
	STA	0,X
	TYA
	SBC	1,X
	STA	1,X
	JMP	NEXT

;	DMINUS

L8699	.BYTE	$86,'DMINU',$D3
	.WORD	L8681
DMINU	.WORD	*+2
	SEC
	TYA
	SBC	2,X
	STA	2,X
	TYA
	SBC	3,X
	STA	3,X
	JMP	MINUS+3

;	OVER

L86B2	.BYTE	$84,'OVE',$D2
	.WORD	L8699
OVER	.WORD	*+2
	LDA	2,X
	PHA
	LDA	3,X
	JMP	PUSH

;	DROP

L86C3	.BYTE	$84,'DRO',$D0
	.WORD	L86B2
DROP	.WORD	POP

;	2DROP

L86CC	.BYTE	$85,'2DRO',$D0
	.WORD	L86C3
TDROP	.WORD	POPTWO

;	SWAP

L86D6	.BYTE	$84,'SWA',$D0
	.WORD	L86CC
SWAP	.WORD	*+2
	LDA	2,X
	PHA
	LDA	0,X
	STA	2,X
	LDA	3,X
	LDY	1,X
	STY	3,X
	JMP	PUT

;	DUP

L86EF	.BYTE	$83,'DU',$D0
	.WORD	L86D6
DUP	.WORD	*+2
	LDA	0,X
	PHA
	LDA	1,X
	JMP	PUSH

;	+!

L86FF	.BYTE	$82,'+',$A1
	.WORD	L86EF
PSTOR	.WORD	*+2
	CLC
	LDA	(0,X)
	ADC	2,X
	STA	(0,X)
	INC	0,X
	BNE	L8713
	INC	1,X
L8713	LDA	(0,X)
	ADC	3,X
	STA	(0,X)
	JMP	POPTWO

;	TOGGLE

L871C	.BYTE	$86,'TOGGL',$C5
	.WORD	L86FF
TOGGL	.WORD	*+2
	LDA	(2,X)
	EOR	0,X
	STA	(2,X)
	JMP	POPTWO

;	@

L8730	.BYTE	$81,$C0
	.WORD	L871C
AT	.WORD	*+2
	LDA	(0,X)
	PHA
	INC	0,X
	BNE	L873F
	INC	1,X
L873F	LDA	(0,X)
	JMP	PUT

;	C@

L8744	.BYTE	$82,'C',$C0
	.WORD	L8730
CAT	.WORD	*+2
	LDA	(0,X)
	STA	0,X
	STY	1,X
	JMP	NEXT

;	!

L8754	.BYTE	$81,$A1
	.WORD	L8744
STORE	.WORD	*+2
	LDA	2,X
	STA	(0,X)
	INC	0,X
	BNE	L8764
	INC	1,X
L8764	LDA	3,X
	STA	(0,X)
	JMP	POPTWO

;	C!

L876B	.BYTE	$82,'C',$A1
	.WORD	L8754
CSTOR	.WORD	*+2
	LDA	2,X
	STA	(0,X)
	JMP	POPTWO

;	:

L8779	.BYTE	$C1,$BA
	.WORD	L876B
COLON	.WORD	DOCOL
	.WORD	QEXEC
	.WORD	SCSP
	.WORD	CURR
	.WORD	AT
	.WORD	CONT
	.WORD	STORE
	.WORD	CREAT
	.WORD	RBRAC
	.WORD	PSCOD
DOCOL	LDA	IP+1
	PHA
	LDA	IP
	PHA
	CLC
	LDA	W
	ADC	#2
	STA	IP
	TYA
	ADC	W+1
	STA	IP+1
	JMP	NEXT

;	;

L87A6	.BYTE	$C1,$BB
	.WORD	L8779
	.WORD	DOCOL
	.WORD	QCSP
	.WORD	COMP
	.WORD	SEMIS
	.WORD	SMUDGE
	.WORD	LBRAC
	.WORD	SEMIS

;	CONSTANT

L87B8	.BYTE	$88,'CONSTAN',$D4
	.WORD	L87A6
CONST	.WORD	DOCOL
	.WORD	CREAT
	.WORD	SMUDGE
	.WORD	COMMA
	.WORD	PSCOD
DOCON	LDY	#2
	LDA	(W),Y
	PHA
	INY
	LDA	(W),Y
	JMP	PUSH

;	VARIABLE

L87D8	.BYTE	$88,'VARIABL',$C5
	.WORD	L87B8
VAR	.WORD	DOCOL
	.WORD	CONST
	.WORD	PSCOD
DOVAR	CLC
	LDA	W
	ADC	#2
	PHA
	TYA
	ADC	W+1
	JMP	PUSH

;	USER

L87F5	.BYTE	$84,'USE',$D2
	.WORD	L87D8
USER	.WORD	DOCOL
	.WORD	CONST
	.WORD	PSCOD
DOUSE	LDY	#2
	CLC
	LDA	(W),Y
	ADC	UP
	PHA
	LDA	#0
	ADC	UP+1
	JMP	PUSH

;	0

L8811	.BYTE	$81,$B0
	.WORD	L87F5
ZERO	.WORD	DOCON
	.WORD	0

;	1

L8819	.BYTE	$81,$B1
	.WORD	L8811
ONE	.WORD	DOCON
	.WORD	1

;	2

L8821	.BYTE	$81,$B2
	.WORD	L8819
TWO	.WORD	DOCON
	.WORD	2

;	3

L8829	.BYTE	$81,$B3
	.WORD	L8821
THREE	.WORD	DOCON
	.WORD	3

;	BL

L8831	.BYTE	$82,'B',$CC
	.WORD	L8829
BL	.WORD	DOCON
	.WORD	32

;	C/L

L883A	.BYTE	$83,'C/',$CC
	.WORD	L8831
CSLL	.WORD	DOCON
	.WORD	64

;	FIRST

L8844	.BYTE	$85,'FIRS',$D4
	.WORD	L883A
FIRST	.WORD	DOCON
	.WORD	$7BFC

;	LIMIT

L8850	.BYTE	$85,'LIMI',$D4
	.WORD	L8844
LIMIT	.WORD	DOCON
	.WORD	$8000

;	B/BUF

L885C	.BYTE	$85,'B/BU',$C6
	.WORD	L8850
BBUF	.WORD	DOCON
	.WORD	1024

;	B/SCR

L8868	.BYTE	$85,'B/SC',$D2
	.WORD	L885C
BSCR	.WORD	DOCON
	.WORD	1

;	+ORIGIN

L8874	.BYTE	$87,'+ORIGI',$CE
	.WORD	L8868
PORIG	.WORD	DOCOL
	.WORD	LIT,ORIG
	.WORD	PLUS
	.WORD	SEMIS

;	TIB

L8888	.BYTE	$83,'TI',$C2
	.WORD	L8874
TIB	.WORD	DOUSE
	.BYTE	$A

;	WIDTH

L8891	.BYTE	$85,'WIDT',$C8
	.WORD	L8888
WIDTH	.WORD	DOUSE
	.BYTE	$C

;	FENCE

L889C	.BYTE	$85,'FENC',$C5
	.WORD	L8891
FENCE	.WORD	DOUSE
	.BYTE	$10

;	DP

L88A7	.BYTE	$82,'D',$D0
	.WORD	L889C
DP	.WORD	DOUSE
	.BYTE	$12

;	VOC-LINK

L88AF	.BYTE	$88,'VOC-LIN',$CB
	.WORD	L88A7
VOCL	.WORD	DOUSE
	.BYTE	$14

;	BLK

L88BD	.BYTE	$83,'BL',$CB
	.WORD	L88AF
BLK	.WORD	DOUSE
	.BYTE	$16

;	IN

L88C6	.BYTE	$82,'I',$CE
	.WORD	L88BD
IN	.WORD	DOUSE
	.BYTE	$18

;	OUT

L88CE	.BYTE	$83,'OU',$D4
	.WORD	L88C6
OUT	.WORD	DOUSE
	.BYTE	$1A

;	SCR

L88D7	.BYTE	$83,'SC',$D2
	.WORD	L88CE
SCR	.WORD	DOUSE
	.BYTE	$1C

;	BMAX

L88E0	.BYTE	$84,'BMA',$D8
	.WORD	L88D7
BMAX	.WORD	DOUSE
	.BYTE	$1E

;	CONTEXT

L88EA	.BYTE	$87,'CONTEX',$D4
	.WORD	L88E0
CONT	.WORD	DOUSE
	.BYTE	$20

;	CURRENT

L88F7	.BYTE	$87,'CURREN',$D4
	.WORD	L88EA
CURR	.WORD	DOUSE
	.BYTE	$22

;	STATE

L8904	.BYTE	$85,'STAT',$C5
	.WORD	L88F7
STATE	.WORD	DOUSE
	.BYTE	$24

;	BASE

L890F	.BYTE	$84,'BAS',$C5
	.WORD	L8904
BASE	.WORD	DOUSE
	.BYTE	$26

;	DPL

L8919	.BYTE	$83,'DP',$CC
	.WORD	L890F
DPL	.WORD	DOUSE
	.BYTE	$28

;	CSP

L8922	.BYTE	$83,'CS',$D0
	.WORD	L8919
CSP	.WORD	DOUSE
	.BYTE	$2C

;	R#

L892B	.BYTE	$82,'R',$A3
	.WORD	L8922
RNUM	.WORD	DOUSE
	.BYTE	$2E

;	HLD

L8933	.BYTE	$83,'HL',$C4
	.WORD	L892B
HLD	.WORD	DOUSE
	.BYTE	$30

;	I/O

L893C	.BYTE	$83,'I/',$CF
	.WORD	L8933
IO	.WORD	DOUSE
	.BYTE	$32

;	F#

L8945	.BYTE	$82,'F',$A3
	.WORD	L893C
FNUM	.WORD	DOUSE
	.BYTE	$4C

;	D#

L894D	.BYTE	$82,'D',$A3
	.WORD	L8945
DNUM	.WORD	DOUSE
	.BYTE	$4E

;	CTBL

L8955	.BYTE	$84,'CTB',$CC
	.WORD	L894D
CTBL	.WORD	DOUSE
	.BYTE	$4A

;	EFLAG

L895F	.BYTE	$85,'EFLA',$C7
	.WORD	L8955
EFLAG	.WORD	DOUSE
	.BYTE	$C0

;	DR#

L896A	.BYTE	$83,'DR',$A3
	.WORD	L895F
DRNUM	.WORD	DOUSE
	.BYTE	$C2

;	DCHAN

L8973	.BYTE	$85,'DCHA',$CE
	.WORD	L896A
DCHAN	.WORD	DOUSE
	.BYTE	$C4

;	CURVOICE

L897E	.BYTE	$88,'CURVOIC',$C5
	.WORD	L8973
CURVOC	.WORD	DOUSE
	.BYTE	$C8

;	IFLAG

L898C	.BYTE	$85,'IFLA',$C7
	.WORD	L897E
IFLAG	.WORD	DOUSE
	.BYTE	$D4

;	FN

L8997	.BYTE	$82,'F',$CE
	.WORD	L898C
FN	.WORD	DOUSE
	.BYTE	$7E

;	1+

L899F	.BYTE	$82,'1',$AB
	.WORD	L8997
ONEP	.WORD	DOCOL
	.WORD	ONE
	.WORD	PLUS
	.WORD	SEMIS

;	2+

L89AC	.BYTE	$82,'2',$AB
	.WORD	L899F
TWOP	.WORD	DOCOL
	.WORD	TWO
	.WORD	PLUS
	.WORD	SEMIS

;	HERE

L89B9	.BYTE	$84,'HER',$C5
	.WORD	L89AC
HERE	.WORD	DOCOL
	.WORD	DP
	.WORD	AT
	.WORD	SEMIS

;	ALLOT

L89C8	.BYTE	$85,'ALLO',$D4
	.WORD	L89B9
ALLOT	.WORD	DOCOL
	.WORD	DP
	.WORD	PSTOR
	.WORD	SEMIS

;	,

L89D8	.BYTE	$81,$AC
	.WORD	L89C8
COMMA	.WORD	DOVEC
	.BYTE	20

PCOMMA	.WORD	DOCOL
	.WORD	HERE
	.WORD	STORE
	.WORD	TWO
	.WORD	ALLOT
	.WORD	SEMIS

;	C,

L89EB	.BYTE	$82,'C',$AC
	.WORD	L89D8
CCOM	.WORD	DOVEC
	.BYTE	18

PCCOM	.WORD	DOCOL
	.WORD	HERE
	.WORD	CSTOR
	.WORD	ONE
	.WORD	ALLOT
	.WORD	SEMIS

;	-

L89FF	.BYTE	$81,$AD
	.WORD	L89EB
SUBB	.WORD	DOCOL
	.WORD	MINUS
	.WORD	PLUS
	.WORD	SEMIS

;	=

L8A0B	.BYTE	$81,$BD
	.WORD	L89FF
EQUAL	.WORD	DOCOL
	.WORD	SUBB
	.WORD	ZEQU
	.WORD	SEMIS

;	U<

L8A17	.BYTE	$82,'U',$BC
	.WORD	L8A0B
ULESS	.WORD	*+2
	SEC
	LDA	2,X
	SBC	0,X
	LDA	3,X
	SBC	1,X
	INX
	INX
	BCS	L8A33
	LDA	#1
	PHA
	LDA	#0
	JMP	PUT

L8A33	LDA	#0
	PHA
	JMP	PUT

;	<

L8A39	.BYTE	$81,$BC
	.WORD	L8A17
LESS	.WORD	*+2
	SEC
	LDA	2,X
	SBC	0,X
	LDA	3,X
	SBC	1,X
	STY	3,X
	BVC	L8A4E
	EOR	#$80
L8A4E	BPL	L8A51
	INY
L8A51	STY	2,X
	JMP	POP

;	>

L8A56	.BYTE	$81,$BE
	.WORD	L8A39
GREAT	.WORD	DOCOL
	.WORD	SWAP
	.WORD	LESS
	.WORD	SEMIS

;	ROT

L8A62	.BYTE	$83,'RO',$D4
	.WORD	L8A56
ROT	.WORD	DOCOL
	.WORD	TOR
	.WORD	SWAP
	.WORD	RFROM
	.WORD	SWAP
	.WORD	SEMIS

;	SPACE

L8A74	.BYTE	$85,'SPAC',$C5
	.WORD	L8A62
SPACE	.WORD	DOCOL
	.WORD	BL
	.WORD	EMIT
	.WORD	SEMIS

;	-DUP

L8A84	.BYTE	$84,'-DU',$D0
	.WORD	L8A74
QDUP	.WORD	DOCOL
	.WORD	DUP
	.WORD	ZBRAN,4
	.WORD	DUP
	.WORD	SEMIS

;	TRAVERSE

L8A97	.BYTE	$88,'TRAVERS',$C5
	.WORD	L8A84
TRAV	.WORD	DOCOL
	.WORD	SWAP
	.WORD	OVER
	.WORD	PLUS
	.WORD	CLIT
	.BYTE	$7F
	.WORD	OVER
	.WORD	CAT
	.WORD	LESS
	.WORD	ZBRAN,$FFF1
	.WORD	SWAP
	.WORD	DROP
	.WORD	SEMIS

;	LATEST

L8ABD	.BYTE	$86,'LATES',$D4
	.WORD	L8A97
LATES	.WORD	DOCOL
	.WORD	CURR
	.WORD	AT
	.WORD	AT
	.WORD	SEMIS

;	LFA

L8AD0	.BYTE	$83,'LF',$C1
	.WORD	L8ABD
LFA	.WORD	DOCOL
	.WORD	CLIT
	.BYTE	4
	.WORD	SUBB
	.WORD	SEMIS

;	CFA

L8ADF	.BYTE	$83,'CF',$C1
	.WORD	L8AD0
CFA	.WORD	DOCOL
	.WORD	TWO
	.WORD	SUBB
	.WORD	SEMIS

;	NFA

L8AED	.BYTE	$83,'NF',$C1
	.WORD	L8ADF
NFA	.WORD	DOCOL
	.WORD	CLIT
	.BYTE	5
	.WORD	SUBB
	.WORD	LIT,-1
	.WORD	TRAV
	.WORD	SEMIS

;	PFA

L8B02	.BYTE	$83,'PF',$C1
	.WORD	L8AED
PFA	.WORD	DOCOL
	.WORD	ONE
	.WORD	TRAV
	.WORD	CLIT
	.BYTE	5
	.WORD	PLUS
	.WORD	SEMIS

;	!CSP

L8B15	.BYTE	$84,'!CS',$D0
	.WORD	L8B02
SCSP	.WORD	DOCOL
	.WORD	SPAT
	.WORD	CSP
	.WORD	STORE
	.WORD	SEMIS

;	?ERROR

L8B26	.BYTE	$86,'?ERRO',$D2
	.WORD	L8B15
QERR	.WORD	DOCOL
	.WORD	SWAP
	.WORD	ZBRAN,4
	.WORD	ERROR
	.WORD	DROP
	.WORD	SEMIS

;	?COMP

L8B3D	.BYTE	$85,'?COM',$D0
	.WORD	L8B26
QCOMP	.WORD	DOCOL
	.WORD	STATE
	.WORD	AT
	.WORD	ZEQU
	.WORD	CLIT
	.BYTE	$11
	.WORD	QERR
	.WORD	SEMIS

;	?EXEC

L8B54	.BYTE	$85,'?EXE',$C3
	.WORD	L8B3D
QEXEC	.WORD	DOCOL
	.WORD	STATE
	.WORD	AT
	.WORD	CLIT
	.BYTE	$12
	.WORD	QERR
	.WORD	SEMIS

;	?PAIRS

L8B69	.BYTE	$86,'?PAIR',$D3
	.WORD	L8B54
QPAIR	.WORD	DOCOL
	.WORD	SUBB
	.WORD	CLIT
	.BYTE	$13
	.WORD	QERR
	.WORD	SEMIS

;	?CSP

L8B7D	.BYTE	$84,'?CS',$D0
	.WORD	L8B69
QCSP	.WORD	DOCOL
	.WORD	SPAT
	.WORD	CSP
	.WORD	AT
	.WORD	SUBB
	.WORD	CLIT
	.BYTE	$14
	.WORD	QERR
	.WORD	SEMIS

;	?LOADING

L8B95	.BYTE	$88,'?LOADIN',$C7
	.WORD	L8B7D
QLOAD	.WORD	DOCOL
	.WORD	BLK
	.WORD	AT
	.WORD	ZEQU
	.WORD	CLIT
	.BYTE	$16
	.WORD	QERR
	.WORD	SEMIS

;	COMPILE

L8BAF	.BYTE	$87,'COMPIL',$C5
	.WORD	L8B95
COMP	.WORD	DOCOL
	.WORD	QCOMP
	.WORD	RFROM
	.WORD	DUP
	.WORD	TWOP
	.WORD	TOR
	.WORD	AT
	.WORD	COMMA
	.WORD	SEMIS

;	[

L8BCB	.BYTE	$C1,$DB
	.WORD	L8BAF
LBRAC	.WORD	DOCOL
	.WORD	ZERO
	.WORD	STATE
	.WORD	STORE
	.WORD	SEMIS

;	]

L8BD9	.BYTE	$81,$DD
	.WORD	L8BCB
RBRAC	.WORD	DOCOL
	.WORD	CLIT
	.BYTE	$C0
	.WORD	STATE
	.WORD	STORE
	.WORD	SEMIS

;	SMUDGE

L8BE8	.BYTE	$86,'SMUDG',$C5
	.WORD	L8BD9
SMUDGE	.WORD	DOCOL
	.WORD	LATES
	.WORD	CLIT
	.BYTE	$20
	.WORD	TOGGL
	.WORD	SEMIS

;	HEX

L8BFC	.BYTE	$83,'HE',$D8
	.WORD	L8BE8
HEX	.WORD	DOCOL
	.WORD	CLIT
	.BYTE	$10
	.WORD	BASE
	.WORD	STORE
	.WORD	SEMIS

;	DECIMAL

L8C0D	.BYTE	$87,'DECIMA',$CC
	.WORD	L8BFC
DECIM	.WORD	DOCOL
	.WORD	CLIT
	.BYTE	$A
	.WORD	BASE
	.WORD	STORE
	.WORD	SEMIS

;	(;CODE)

L8C22	.BYTE	$87,'(;CODE',$A9
	.WORD	L8C0D
PSCOD	.WORD	DOCOL
	.WORD	RFROM
	.WORD	LATES
	.WORD	PFA
	.WORD	CFA
	.WORD	STORE
	.WORD	SEMIS

;	;CODE

L8C3A	.BYTE	$C5,';COD',$C5
	.WORD	L8C22
	.WORD	DOCOL
	.WORD	QCSP
	.WORD	COMP
	.WORD	PSCOD
	.WORD	LBRAC
	.WORD	SMUDGE
	.WORD	SEMIS

;	<BUILDS

L8C50	.BYTE	$87,'<BUILD',$D3
	.WORD	L8C3A
BUILD	.WORD	DOCOL
	.WORD	ZERO
	.WORD	CONST
	.WORD	SEMIS

;	DOES>

L8C62	.BYTE	$85,'DOES',$BE
	.WORD	L8C50
DOES	.WORD	DOCOL
	.WORD	RFROM
	.WORD	LATES
	.WORD	PFA
	.WORD	STORE
	.WORD	PSCOD
DODOE	LDA	IP+1
	PHA
	LDA	IP
	PHA
	LDY	#2
	LDA	(W),Y
	STA	IP
	INY
	LDA	(W),Y
	STA	IP+1
	CLC
	LDA	W
	ADC	#4
	PHA
	LDA	W+1
	ADC	#0
	JMP	PUSH

;	COUNT

L8C94	.BYTE	$85,'COUN',$D4
	.WORD	L8C62
COUNT	.WORD	DOCOL
	.WORD	DUP
	.WORD	ONEP
	.WORD	SWAP
	.WORD	CAT
	.WORD	SEMIS

;	TYPE

L8CA8	.BYTE	$84,'TYP',$C5
	.WORD	L8C94
TYPE	.WORD	DOCOL
	.WORD	QDUP
	.WORD	ZBRAN,$1D
	.WORD	OVER
	.WORD	PLUS
	.WORD	SWAP
	.WORD	PDO
	.WORD	I
	.WORD	CAT
	.WORD	CLIT
	.BYTE	$7F
	.WORD	ANDD
	.WORD	EMIT
	.WORD	PLOOP,$FFF3
	.WORD	BRAN,4
	.WORD	DROP
	.WORD	SEMIS

;	-TRAILING

L8CD6	.BYTE	$89,'-TRAILIN',$C7
	.WORD	L8CA8
DTRAI	.WORD	DOCOL
	.WORD	DUP
	.WORD	ZERO
	.WORD	PDO
	.WORD	TDUP
	.WORD	PLUS
	.WORD	ONE
	.WORD	SUBB
	.WORD	CAT
	.WORD	BL
	.WORD	SUBB
	.WORD	ZBRAN,8
	.WORD	LEAVE
	.WORD	BRAN,6
	.WORD	ONE
	.WORD	SUBB
	.WORD	PLOOP,$FFE2
	.WORD	SEMIS

;	(.")

L8D0C	.BYTE	$84,'(."',$A9
	.WORD	L8CD6
PDOTQ	.WORD	DOCOL
	.WORD	R
	.WORD	COUNT
	.WORD	DUP
	.WORD	ONEP
	.WORD	RFROM
	.WORD	PLUS
	.WORD	TOR
	.WORD	TYPE
	.WORD	SEMIS

;	."

L8D27	.BYTE	$C2,'.',$A2
	.WORD	L8D0C
DOTQ	.WORD	DOCOL
	.WORD	CLIT
	.BYTE	'"'
	.WORD	STATE
	.WORD	AT
	.WORD	ZBRAN,$14
	.WORD	COMP
	.WORD	PDOTQ
	.WORD	WORD
	.WORD	HERE
	.WORD	CAT
	.WORD	ONEP
	.WORD	ALLOT
	.WORD	BRAN,$A
	.WORD	WORD
	.WORD	HERE
	.WORD	COUNT
	.WORD	TYPE
	.WORD	SEMIS

;	EXPECT

L8D55	.BYTE	$86,'EXPEC',$D4
	.WORD	L8D27
EXPECT	.WORD	DOCOL
	.WORD	OVER
	.WORD	PLUS
	.WORD	OVER
	.WORD	PDO
	.WORD	EFLAG
	.WORD	AT
	.WORD	ZBRAN,8
	.WORD	KEY
	.WORD	BRAN,4
	.WORD	CHRIN
	.WORD	DUP
	.WORD	CLIT
	.BYTE	$14
	.WORD	EQUAL
	.WORD	ZBRAN,$2A
	.WORD	DROP
	.WORD	CLIT
	.BYTE	$9D
	.WORD	DUP
	.WORD	EMIT
	.WORD	SPACE
	.WORD	OVER
	.WORD	I
	.WORD	EQUAL
	.WORD	DUP
	.WORD	RFROM
	.WORD	TWO
	.WORD	SUBB
	.WORD	PLUS
	.WORD	TOR
	.WORD	CLIT
	.BYTE	$93
	.WORD	STAR
	.WORD	SUBB
	.WORD	BRAN,$2C
	.WORD	DUP
	.WORD	CLIT
	.BYTE	$D
	.WORD	EQUAL
	.WORD	ZBRAN,$E
	.WORD	LEAVE
	.WORD	DROP
	.WORD	BL
	.WORD	ZERO
	.WORD	BRAN,9
	.WORD	DUP
	.WORD	CLIT
	.BYTE	$7F
	.WORD	ANDD
	.WORD	I
	.WORD	CSTOR
	.WORD	ZERO
	.WORD	I
	.WORD	ONEP
	.WORD	STORE
	.WORD	EFLAG
	.WORD	AT
	.WORD	ZBRAN,8
	.WORD	EMIT
	.WORD	BRAN,4
	.WORD	DROP
	.WORD	PLOOP,$FF81
	.WORD	DROP
	.WORD	SEMIS

;	QUERY

L8DED	.BYTE	$85,'QUER',$D9
	.WORD	L8D55
QUERY	.WORD	DOCOL
	.WORD	TIB
	.WORD	AT
	.WORD	CLIT
	.BYTE	80
	.WORD	EXPECT
	.WORD	ZERO
	.WORD	IN
	.WORD	STORE
	.WORD	SEMIS

;	NULL

L8E08	.BYTE	$C1,$80
	.WORD	L8DED
	.WORD	DOCOL
	.WORD	BLK
	.WORD	AT
	.WORD	ZBRAN,4
	.WORD	QEXEC
	.WORD	RFROM
	.WORD	DROP
	.WORD	SEMIS

;	FILL

L8E1E	.BYTE	$84,'FIL',$CC
	.WORD	L8E08
FILL	.WORD	DOCOL
	.WORD	SWAP
	.WORD	TOR
	.WORD	OVER
	.WORD	CSTOR
	.WORD	DUP
	.WORD	ONEP
	.WORD	RFROM
	.WORD	ONE
	.WORD	SUBB
	.WORD	CMOVE
	.WORD	SEMIS

;	ERASE

L8E3D	.BYTE	$85,'ERAS',$C5
	.WORD	L8E1E
ERASE	.WORD	DOCOL
	.WORD	ZERO
	.WORD	FILL
	.WORD	SEMIS

;	BLANKS

L8E4D	.BYTE	$86,'BLANK',$D3
	.WORD	L8E3D
BLANK	.WORD	DOCOL
	.WORD	BL
	.WORD	FILL
	.WORD	SEMIS

;	HOLD

L8E5E	.BYTE	$84,'HOL',$C4
	.WORD	L8E4D
HOLD	.WORD	DOCOL
	.WORD	LIT,-1
	.WORD	HLD
	.WORD	PSTOR
	.WORD	HLD
	.WORD	AT
	.WORD	CSTOR
	.WORD	SEMIS

;	PAD

L8E77	.BYTE	$83,'PA',$C4
	.WORD	L8E5E
PAD	.WORD	DOCOL
	.WORD	HERE
	.WORD	CLIT
	.BYTE	68
	.WORD	PLUS
	.WORD	SEMIS

;	WORD

L8E88	.BYTE	$84,'WOR',$C4
	.WORD	L8E77
WORD	.WORD	DOCOL
	.WORD	BLK
	.WORD	AT
	.WORD	ZBRAN,$C
	.WORD	BLK
	.WORD	AT
	.WORD	BLOCK
	.WORD	BRAN,6
	.WORD	TIB
	.WORD	AT
	.WORD	IN
	.WORD	AT
	.WORD	PLUS
	.WORD	SWAP
	.WORD	ENCL
	.WORD	HERE
	.WORD	CLIT
	.BYTE	'"'
	.WORD	BLANK
	.WORD	IN
	.WORD	PSTOR
	.WORD	OVER
	.WORD	SUBB
	.WORD	TOR
	.WORD	R
	.WORD	HERE
	.WORD	CSTOR
	.WORD	PLUS
	.WORD	HERE
	.WORD	ONEP
	.WORD	RFROM
	.WORD	CMOVE
	.WORD	SEMIS

;	(NUMBER)

L8ED4	.BYTE	$88,'(NUMBER',$A9
	.WORD	L8E88
PNUMB	.WORD	DOCOL
	.WORD	ONEP
	.WORD	DUP
	.WORD	TOR
	.WORD	CAT
	.WORD	BASE
	.WORD	AT
	.WORD	DIGIT
	.WORD	ZBRAN,$2C
	.WORD	SWAP
	.WORD	BASE
	.WORD	AT
	.WORD	USTAR
	.WORD	DROP
	.WORD	ROT
	.WORD	BASE
	.WORD	AT
	.WORD	USTAR
	.WORD	DPLUS
	.WORD	DPL
	.WORD	AT
	.WORD	ONEP
	.WORD	ZBRAN,8
	.WORD	ONE
	.WORD	DPL
	.WORD	PSTOR
	.WORD	RFROM
	.WORD	BRAN,$FFC6
	.WORD	RFROM
	.WORD	SEMIS

;	NUMBER

L8F21	.BYTE	$86,'NUMBE',$D2
	.WORD	L8ED4
NUMBER	.WORD	DOVEC
	.BYTE	10

PNUMBE	.WORD	DOCOL
	.WORD	ZERO
	.WORD	ZERO
	.WORD	ROT
	.WORD	DUP
	.WORD	ONEP
	.WORD	CAT
	.WORD	CLIT
	.BYTE	'-'
	.WORD	EQUAL
	.WORD	DUP
	.WORD	TOR
	.WORD	PLUS
	.WORD	LIT,-1
	.WORD	DPL
	.WORD	STORE
	.WORD	PNUMB
	.WORD	DUP
	.WORD	CAT
	.WORD	BL
	.WORD	SUBB
	.WORD	ZBRAN,$15
	.WORD	DUP
	.WORD	CAT
	.WORD	CLIT
	.BYTE	'.'
	.WORD	SUBB
	.WORD	ZERO
	.WORD	QERR
	.WORD	ZERO
	.WORD	BRAN,$FFDD
	.WORD	DROP
	.WORD	RFROM
	.WORD	ZBRAN,4
	.WORD	DMINU
	.WORD	SEMIS

;	-FIND

L8F7B	.BYTE	$85,'-FIN',$C4
	.WORD	L8F21
DFIND	.WORD	DOVEC
	.BYTE	16

PDFIND	.WORD	DOCOL
	.WORD	BL
	.WORD	WORD
	.WORD	HERE
	.WORD	CONT
	.WORD	AT
	.WORD	AT
	.WORD	PFIND
	.WORD	DUP
	.WORD	ZEQU
	.WORD	ZBRAN,$A
	.WORD	DROP
	.WORD	HERE
	.WORD	LATES
	.WORD	PFIND
	.WORD	SEMIS

;	ERROR

L8FA8	.BYTE	$85,'ERRO',$D2
	.WORD	L8F7B
ERROR	.WORD	DOVEC
	.BYTE	12

PERROR	.WORD	DOCOL
	.WORD	SPACE
	.WORD	HERE
	.WORD	COUNT
	.WORD	TYPE
	.WORD	PDOTQ
	.BYTE	4
	.BYTE	'<-?#'
	.WORD	DUP
	.WORD	DOT
	.WORD	MESS
	.WORD	ZERO
	.WORD	PSCR
	.WORD	SPSTO
	.WORD	QUIT

;	ERROR MESSAGES

L8FD2	.WORD	L9006
	.WORD	L900B
	.WORD	L9018
	.WORD	L9034
	.WORD	L9026
	.WORD	L9026
	.WORD	L9026
	.WORD	L9026
	.WORD	L9046
	.WORD	L9026
	.WORD	L9026
	.WORD	L9026
	.WORD	L9026
	.WORD	L9026
	.WORD	L9026
	.WORD	L9026
	.WORD	L9026
	.WORD	L9058
	.WORD	L906B
	.WORD	L907E
	.WORD	L9094
	.WORD	L90AA
	.WORD	L90BE
	.WORD	L9026
	.WORD	L90D4
	.WORD	L9026

L9006	.BYTE	4
	.BYTE	'WHAT'
L900B	.BYTE	12
	.BYTE	'STACK EMPTY!'
L9018	.BYTE	13
	.BYTE	'OUT OF MEMORY'
L9026	.BYTE	13
	.BYTE	'UNKNOWN ERROR'
L9034	.BYTE	17
	.BYTE	'HAS BAD ADDR MODE'
L9046	.BYTE	17
	.BYTE	'BLOCK RANGE ERROR'
L9058	.BYTE	18
	.BYTE	'FOR COMPILING ONLY'
L906B	.BYTE	18
	.BYTE	'FOR EXECUTING ONLY'
L907E	.BYTE	21
	.BYTE	'IMPROPER CONDITIONALS'
L9094	.BYTE	21
	.BYTE	'INCOMPLETE DEFINITION'
L90AA	.BYTE	19
	.BYTE	'THIS WORD PROTECTED'
L90BE	.BYTE	21
	.BYTE	'USE ONLY WHEN LOADING'
L90D4	.BYTE	22
	.BYTE	'SPECIFY THE VOCABULARY'

;	ID.

L90EB	.BYTE	$83,'ID',$AE
	.WORD	L8FA8
IDDOT	.WORD	DOCOL
	.WORD	COUNT
	.WORD	CLIT
	.BYTE	$1F
	.WORD	ANDD
	.WORD	TYPE
	.WORD	SPACE
	.WORD	SEMIS

;	CREATE

L9100	.BYTE	$86,'CREAT',$C5
	.WORD	L90EB
CREAT	.WORD	DOVEC
	.BYTE	8

PCREAT	.WORD	DOCOL
	.WORD	DFIND
	.WORD	ZBRAN,$14
	.WORD	DROP
	.WORD	CR
	.WORD	PDOTQ
	.BYTE	7
	.BYTE	'REDEF: '
	.WORD	NFA
	.WORD	IDDOT
	.WORD	HERE
	.WORD	DUP
	.WORD	CAT
	.WORD	WIDTH
	.WORD	AT
	.WORD	MIN
	.WORD	ONEP
	.WORD	ALLOT
	.WORD	DUP
	.WORD	CLIT
	.BYTE	$A0
	.WORD	TOGGL
	.WORD	HERE
	.WORD	ONE
	.WORD	SUBB
	.WORD	CLIT
	.BYTE	$80
	.WORD	TOGGL
	.WORD	LATES
	.WORD	COMMA
	.WORD	CURR
	.WORD	AT
	.WORD	STORE
	.WORD	HERE
	.WORD	TWOP
	.WORD	COMMA
	.WORD	SEMIS

;	[COMPILE]

L915A	.BYTE	$C9,'[COMPILE',$DD
	.WORD	L9100
	.WORD	DOCOL
	.WORD	DFIND
	.WORD	ZEQU
	.WORD	ZERO
	.WORD	QERR
	.WORD	DROP
	.WORD	CFA
	.WORD	COMMA
	.WORD	SEMIS

;	LITERAL

L9178	.BYTE	$C7,'LITERA',$CC
	.WORD	L915A
LITER	.WORD	DOCOL
	.WORD	STATE
	.WORD	AT
	.WORD	ZBRAN,8
	.WORD	COMP
	.WORD	LIT,COMMA
	.WORD	SEMIS

;	DLITERAL

L9194	.BYTE	$C8,'DLITERA',$CC
	.WORD	L9178
DLIT	.WORD	DOCOL
	.WORD	STATE
	.WORD	AT
	.WORD	ZBRAN,8
	.WORD	SWAP
	.WORD	LITER
	.WORD	LITER
	.WORD	SEMIS

;	?STACK

L91B1	.BYTE	$86,'?STAC',$CB
	.WORD	L9194
QSTAC	.WORD	DOCOL
	.WORD	SPAT
	.WORD	CLIT
	.BYTE	TOS
	.WORD	SWAP
	.WORD	ULESS
	.WORD	ONE
	.WORD	QERR
	.WORD	EM
	.WORD	AT
	.WORD	HERE
	.WORD	CLIT
	.BYTE	$A0
	.WORD	PLUS
	.WORD	ULESS
	.WORD	TWO
	.WORD	QERR
	.WORD	SEMIS

;	INTERPRET

L91DC	.BYTE	$89,'INTERPRE',$D4
	.WORD	L91B1
INTER	.WORD	DOCOL
	.WORD	DFIND
	.WORD	ZBRAN,$1E
	.WORD	STATE
	.WORD	AT
	.WORD	LESS
	.WORD	ZBRAN,$A
	.WORD	CFA
	.WORD	COMMA
	.WORD	BRAN,6
	.WORD	CFA
	.WORD	EXEC
	.WORD	QSTAC
	.WORD	BRAN,$1C
	.WORD	HERE
	.WORD	NUMBER
	.WORD	DPL
	.WORD	AT
	.WORD	ONEP
	.WORD	ZBRAN,8
	.WORD	DLIT
	.WORD	BRAN,6
	.WORD	DROP
	.WORD	LITER
	.WORD	QSTAC
	.WORD	BRAN,$FFC2

;	IMMEDIATE

L922A	.BYTE	$89,'IMMEDIAT',$C5
	.WORD	L91DC
	.WORD	DOCOL
	.WORD	LATES
	.WORD	CLIT
	.BYTE	$40
	.WORD	TOGGL
	.WORD	SEMIS

;	VOCABULARY

L9241	.BYTE	$8A,'VOCABULAR',$D9
	.WORD	L922A
	.WORD	DOCOL
	.WORD	BUILD
	.WORD	LIT,$A081
	.WORD	COMMA
	.WORD	CURR
	.WORD	AT
	.WORD	CFA
	.WORD	COMMA
	.WORD	HERE
	.WORD	VOCL
	.WORD	AT
	.WORD	COMMA
	.WORD	VOCL
	.WORD	STORE
	.WORD	DOES
DOVOC	.WORD	TWOP
	.WORD	CONT
	.WORD	STORE
	.WORD	SEMIS

;	DEFINITIONS

L9276	.BYTE	$8B,'DEFINITION',$D3
	.WORD	L9241
DEFIN	.WORD	DOCOL
	.WORD	CONT
	.WORD	AT
	.WORD	CURR
	.WORD	STORE
	.WORD	SEMIS

;	(

L9290	.BYTE	$C1,$A8
	.WORD	L9276
	.WORD	DOCOL
	.WORD	CLIT
	.BYTE	')'
	.WORD	WORD
	.WORD	SEMIS

;	QUIT

L929D	.BYTE	$84,'QUI',$D4
	.WORD	L9290
QUIT	.WORD	DOCOL
	.WORD	ZERO
	.WORD	BLK
	.WORD	STORE
	.WORD	LBRAC
	.WORD	RPSTO
	.WORD	CR
	.WORD	QUERY
	.WORD	CR
	.WORD	INTER
	.WORD	STATE
	.WORD	AT
	.WORD	ZEQU
	.WORD	ZBRAN,9
	.WORD	CR
	.WORD	PDOTQ
	.BYTE	2
	.BYTE	'OK'
	.WORD	BRAN,$FFE3
	.WORD	SEMIS

;	ABORT

L92CF	.BYTE	$85,'ABOR',$D4
	.WORD	L929D
ABORT	.WORD	DOCOL
	.WORD	SPSTO
	.WORD	DECIM
	.WORD	VRESET
	.WORD	ZERO
	.WORD	EFLAG
	.WORD	STORE
	.WORD	LIT,$93
	.WORD	EMIT
	.WORD	LIT,$8E
	.WORD	EMIT
	.WORD	LIT,5
	.WORD	BORDR
	.WORD	CR
	.WORD	PDOTQ
	.BYTE	34
	.BYTE	'     $$$$$$$$ 64FORTH 1.2 $$$$$$$$'
	.WORD	CLIT
	.BYTE	$3B
	.WORD	SPACS
	.WORD	PDOTQ
	.BYTE	14
	.BYTE	'COPYRIGHT 1983'
	.WORD	CR
	.WORD	CR
	.WORD	PDOTQ
	.BYTE	40
	.BYTE	'HUMAN ENGINEERED SOFTWARE  BY T.J.ZIMMER'
	.WORD	CR
	.WORD	$848		; FORTH
	.WORD	DEFIN
	.WORD	QUIT

L936B	LDA	#>COLD1
	STA	IP+1
	LDA	#<COLD1
	JMP	L937A

L9374	LDA	#>WARM
	STA	IP+1
	LDA	#<WARM
L937A	STA	IP
	CLD
	LDX	#$FF
	TXS
	LDX	#TOS
	JMP	NEXT

L9385	.WORD	L8000		; CHECKSUM START ADDR
L9387	.WORD	L9385		; CHECKSUM END ADDR + 1
L9389	.WORD	$83E4		; CHECKSUM

;	COLD

L938B	.BYTE	$84,'COL',$C4
	.WORD	L92CF
COLD	.WORD	DOCOL
COLD1	.WORD	CLIT
	.BYTE	22
	.WORD	L9436
	.WORD	EMPTY
	.WORD	CASSET
	.WORD	LIT,16
	.WORD	BMAX
	.WORD	STORE
	.WORD	ZERO
	.WORD	DRIVE
	.WORD	LIT,7
	.WORD	DCHAN
	.WORD	STORE
	.WORD	BLKTBL
	.WORD	LIT,$20
	.WORD	ERASE
	.WORD	LIT,$7400
	.WORD	EM
	.WORD	STORE
	.WORD	LIT,5
	.WORD	BORDR
	.WORD	VRESET
	.WORD	LIT,5
	.WORD	EMIT
	.WORD	LIT,L8000	; COPY ROM IMAGE
	.WORD	DUP		; TO RAM UNDERNEATH
	.WORD	LIT,16*1024
	.WORD	CMOVE
	.WORD	L93E7
	.WORD	SEMIS

	.BYTE	$85,'ABOR',$D4
	.WORD	0

L93E7	.WORD	DOCOL
	.WORD	LIT,L8000
	.WORD	DUP
	.WORD	DUP		; ERASE $8000-$83FF
	.WORD	LIT,1024
L93F5	.WORD	ERASE
	.WORD	LIT,1024
	.WORD	CMOVE
	.WORD	ZERO		; CALC CHECKSUM
	.WORD	LIT,L9387
	.WORD	AT
	.WORD	LIT,L9385
	.WORD	AT
	.WORD	PDO
	.WORD	I
	.WORD	CAT
	.WORD	PLUS
	.WORD	PLOOP,$FFF8
	.WORD	LIT,L9389
	.WORD	AT
	.WORD	SUBB
	.WORD	ZBRAN,$C
	.WORD	LIT,$200
	.WORD	LIT,$FFFF
	.WORD	ERASE
	.WORD	ABORT

WARM	.WORD	CLIT
	.BYTE	14
	.WORD	L9436
	.WORD	ABORT

; COPY BOOTUP VARIABLES

L9436	.WORD	DOCOL
	.WORD	CLIT
	.BYTE	12
	.WORD	PORIG
	.WORD	LIT,L8047
	.WORD	AT
	.WORD	DUP
	.WORD	LIT,UP
	.WORD	STORE
	.WORD	ROT
	.WORD	CMOVE
	.WORD	SEMIS

;	EMPTY

L9451	.BYTE	$85,'EMPT',$D9
	.WORD	L938B
EMPTY	.WORD	DOCOL
	.WORD	LIT,LA955
	.WORD	LIT,$840
	.WORD	LIT,$4E
	.WORD	CMOVE
	.WORD	LIT,$1000
	.WORD	DP
	.WORD	STORE
	.WORD	$848		; FORTH
	.WORD	DEFIN
	.WORD	SEMIS

;	S->D

L9477	.BYTE	$84,'S->',$C4
	.WORD	L9451
STOD	.WORD	DOCOL
	.WORD	DUP
	.WORD	ZLESS
	.WORD	MINUS
	.WORD	SEMIS

;	+-

L9488	.BYTE	$82,'+',$AD
	.WORD	L9477
PM	.WORD	DOCOL
	.WORD	ZLESS
	.WORD	ZBRAN,4
	.WORD	MINUS
	.WORD	SEMIS

;	D+-

L9499	.BYTE	$83,'D+',$AD
	.WORD	L9488
DPM	.WORD	DOCOL
	.WORD	ZLESS
	.WORD	ZBRAN,4
	.WORD	DMINU
	.WORD	SEMIS

;	ABS

L94AB	.BYTE	$83,'AB',$D3
	.WORD	L9499
ABS	.WORD	DOCOL
	.WORD	DUP
	.WORD	PM
	.WORD	SEMIS

;	DABS

L94B9	.BYTE	$84,'DAB',$D3
	.WORD	L94AB
DABS	.WORD	DOCOL
	.WORD	DUP
	.WORD	DPM
	.WORD	SEMIS

;	MIN

L94C8	.BYTE	$83,'MI',$CE
	.WORD	L94B9
MIN	.WORD	DOCOL
	.WORD	TDUP
	.WORD	GREAT
	.WORD	ZBRAN,4
	.WORD	SWAP
	.WORD	DROP
	.WORD	SEMIS

;	MAX

L94DE	.BYTE	$83,'MA',$D8
	.WORD	L94C8
MAX	.WORD	DOCOL
	.WORD	TDUP
	.WORD	LESS
	.WORD	ZBRAN,4
	.WORD	SWAP
	.WORD	DROP
	.WORD	SEMIS

;	M*

L94F4	.BYTE	$82,'M',$AA
	.WORD	L94DE
MSTAR	.WORD	DOCOL
	.WORD	TDUP
	.WORD	XORR
	.WORD	TOR
	.WORD	ABS
	.WORD	SWAP
	.WORD	ABS
	.WORD	USTAR
	.WORD	RFROM
	.WORD	DPM
	.WORD	SEMIS

;	M/

L950F	.BYTE	$82,'M',$AF
	.WORD	L94F4
MSLAS	.WORD	DOCOL
	.WORD	OVER
	.WORD	TOR
	.WORD	TOR
	.WORD	DABS
	.WORD	R
	.WORD	ABS
	.WORD	USLAS
	.WORD	RFROM
	.WORD	R
	.WORD	XORR
	.WORD	PM
	.WORD	SWAP
	.WORD	RFROM
	.WORD	PM
	.WORD	SWAP
	.WORD	SEMIS

;	*

L9536	.BYTE	$81,$AA
	.WORD	L950F
STAR	.WORD	DOCOL
	.WORD	USTAR
	.WORD	DROP
	.WORD	SEMIS

;	/MOD

L9542	.BYTE	$84,'/MO',$C4
	.WORD	L9536
SLMOD	.WORD	DOCOL
	.WORD	TOR
	.WORD	STOD
	.WORD	RFROM
	.WORD	MSLAS
	.WORD	SEMIS

;	/

L9555	.BYTE	$81,$AF
	.WORD	L9542
SLASH	.WORD	DOCOL
	.WORD	SLMOD
	.WORD	SWAP
	.WORD	DROP
	.WORD	SEMIS

;	MOD

L9563	.BYTE	$83,'MO',$C4
	.WORD	L9555
MOD	.WORD	DOCOL
	.WORD	SLMOD
	.WORD	DROP
	.WORD	SEMIS

;	*/MOD

L9571	.BYTE	$85,'*/MO',$C4
	.WORD	L9563
SSMOD	.WORD	DOCOL
	.WORD	TOR
	.WORD	MSTAR
	.WORD	RFROM
	.WORD	MSLAS
	.WORD	SEMIS

;	*/

L9585	.BYTE	$82,'*',$AF
	.WORD	L9571
SSLAS	.WORD	DOCOL
	.WORD	SSMOD
	.WORD	SWAP
	.WORD	DROP
	.WORD	SEMIS

;	M/MOD

L9594	.BYTE	$85,'M/MO',$C4
	.WORD	L9585
MSLM	.WORD	DOCOL
	.WORD	TOR
	.WORD	ZERO
	.WORD	R
	.WORD	USLAS
	.WORD	RFROM
	.WORD	SWAP
	.WORD	TOR
	.WORD	USLAS
	.WORD	RFROM
	.WORD	SEMIS

;	BLOCK

L95B2	.BYTE	$85,'BLOC',$CB
	.WORD	L9594
BLOCK	.WORD	DOCOL
	.WORD	GBLOCK
	.WORD	FIRST
	.WORD	TWOP
	.WORD	SEMIS

;	(LINE)

L95C4	.BYTE	$86,'(LINE',$A9
	.WORD	L95B2
PLINE	.WORD	DOCOL
	.WORD	TOR
	.WORD	CSLL
	.WORD	BBUF
	.WORD	SSMOD
	.WORD	RFROM
	.WORD	PLUS
	.WORD	BLOCK
	.WORD	PLUS
	.WORD	CSLL
	.WORD	SEMIS

;	.LINE

L95E3	.BYTE	$85,'.LIN',$C5
	.WORD	L95C4
DLINE	.WORD	DOCOL
	.WORD	PLINE
	.WORD	DTRAI
	.WORD	TYPE
	.WORD	SEMIS

;	MESSAGE

L95F5	.BYTE	$87,'MESSAG',$C5
	.WORD	L95E3
MESS	.WORD	DOCOL
	.WORD	CLIT
	.BYTE	$19
	.WORD	MIN
	.WORD	ZERO
	.WORD	MAX
	.WORD	TWO
	.WORD	STAR
	.WORD	LIT,L8FD2
	.WORD	PLUS
	.WORD	AT
	.WORD	COUNT
	.WORD	TYPE
	.WORD	SEMIS

;	LOAD

L961C	.BYTE	$84,'LOA',$C4
	.WORD	L95F5
LOAD	.WORD	DOCOL
	.WORD	DUP
	.WORD	DOT
	.WORD	BLK
	.WORD	AT
	.WORD	TOR
	.WORD	IN
	.WORD	AT
	.WORD	TOR
	.WORD	ZERO
	.WORD	IN
	.WORD	STORE
	.WORD	BLK
	.WORD	STORE
	.WORD	INTER
	.WORD	RFROM
	.WORD	IN
	.WORD	STORE
	.WORD	RFROM
	.WORD	BLK
	.WORD	STORE
	.WORD	SEMIS

L964F	.WORD	*+2
	LDA	0,X
	STX	XSAVE
	JSR	$FFD2
	LDX	XSAVE
	JMP	POP

;	'

L965D	.BYTE	$C1,$A7
	.WORD	L961C
TICK	.WORD	DOCOL
	.WORD	DFIND
	.WORD	ZEQU
	.WORD	ZERO
	.WORD	QERR
	.WORD	DROP
	.WORD	LITER
	.WORD	SEMIS

;	BACK

L9671	.BYTE	$84,'BAC',$CB
	.WORD	L965D
BACK	.WORD	DOCOL
	.WORD	HERE
	.WORD	SUBB
	.WORD	COMMA
	.WORD	SEMIS

;	BEGIN

L9682	.BYTE	$C5,'BEGI',$CE
	.WORD	L9671
	.WORD	DOCOL
	.WORD	QCOMP
	.WORD	HERE
	.WORD	ONE
	.WORD	SEMIS

;	ENDIF

L9694	.BYTE	$C5,'ENDI',$C6
	.WORD	L9682
ENDIF	.WORD	DOCOL
	.WORD	QCOMP
	.WORD	TWO
	.WORD	QPAIR
	.WORD	HERE
	.WORD	OVER
	.WORD	SUBB
	.WORD	SWAP
	.WORD	STORE
	.WORD	SEMIS

;	DO

L96B0	.BYTE	$C2,'D',$CF
	.WORD	L9694
	.WORD	DOCOL
	.WORD	COMP
	.WORD	PDO
	.WORD	HERE
	.WORD	THREE
	.WORD	SEMIS

;	LOOP

L96C1	.BYTE	$C4,'LOO',$D0
	.WORD	L96B0
	.WORD	DOCOL
	.WORD	THREE
	.WORD	QPAIR
	.WORD	COMP
	.WORD	PLOOP
	.WORD	BACK
	.WORD	SEMIS

;	+LOOP

L96D6	.BYTE	$C5,'+LOO',$D0
	.WORD	L96C1
	.WORD	DOCOL
	.WORD	THREE
	.WORD	QPAIR
	.WORD	COMP
	.WORD	PPLOO
	.WORD	BACK
	.WORD	SEMIS

;	UNTIL

L96EC	.BYTE	$C5,'UNTI',$CC
	.WORD	L96D6
UNTIL	.WORD	DOCOL
	.WORD	ONE
	.WORD	QPAIR
	.WORD	COMP
	.WORD	ZBRAN,BACK
	.WORD	SEMIS

;	AGAIN

L9702	.BYTE	$C5,'AGAI',$CE
	.WORD	L96EC
AGAIN	.WORD	DOCOL
	.WORD	ONE
	.WORD	QPAIR
	.WORD	COMP
	.WORD	BRAN
	.WORD	BACK
	.WORD	SEMIS

;	REPEAT

L9718	.BYTE	$C6,'REPEA',$D4
	.WORD	L9702
	.WORD	DOCOL
	.WORD	TOR
	.WORD	TOR
	.WORD	AGAIN
	.WORD	RFROM
	.WORD	RFROM
	.WORD	TWO
	.WORD	SUBB
	.WORD	ENDIF
	.WORD	SEMIS

;	IF

L9735	.BYTE	$C2,'I',$C6
	.WORD	L9718
IF	.WORD	DOCOL
	.WORD	COMP
	.WORD	ZBRAN,HERE
	.WORD	ZERO
	.WORD	COMMA
	.WORD	TWO
	.WORD	SEMIS

;	ELSE

L974A	.BYTE	$C4,'ELS',$C5
	.WORD	L9735
	.WORD	DOCOL
	.WORD	TWO
	.WORD	QPAIR
	.WORD	COMP
	.WORD	BRAN
	.WORD	HERE
	.WORD	ZERO
	.WORD	COMMA
	.WORD	SWAP
	.WORD	TWO
	.WORD	ENDIF
	.WORD	TWO
	.WORD	SEMIS

;	WHILE

L976B	.BYTE	$C5,'WHIL',$C5
	.WORD	L974A
	.WORD	DOCOL
	.WORD	IF
	.WORD	TWOP
	.WORD	SEMIS

;	SPACES

L977B	.BYTE	$86,'SPACE',$D3
	.WORD	L976B
SPACS	.WORD	DOCOL
	.WORD	ZERO
	.WORD	MAX
	.WORD	QDUP
	.WORD	ZBRAN,$C
	.WORD	ZERO
	.WORD	PDO
	.WORD	SPACE
	.WORD	PLOOP,$FFFC
	.WORD	SEMIS

;	<#

L979C	.BYTE	$82,'<',$A3
	.WORD	L977B
BDIGS	.WORD	DOCOL
	.WORD	PAD
	.WORD	HLD
	.WORD	STORE
	.WORD	SEMIS

;	#>

L97AB	.BYTE	$82,'#',$BE
	.WORD	L979C
EDIGS	.WORD	DOCOL
	.WORD	DROP
	.WORD	DROP
	.WORD	HLD
	.WORD	AT
	.WORD	PAD
	.WORD	OVER
	.WORD	SUBB
	.WORD	SEMIS

;	SIGN

L97C2	.BYTE	$84,'SIG',$CE
	.WORD	L97AB
SIGN	.WORD	DOCOL
	.WORD	ROT
	.WORD	ZLESS
	.WORD	ZBRAN,7
	.WORD	CLIT
	.BYTE	'-'
	.WORD	HOLD
	.WORD	SEMIS

;	#

L97DA	.BYTE	$81,$A3
	.WORD	L97C2
DIG	.WORD	DOCOL
	.WORD	BASE
	.WORD	AT
	.WORD	MSLM
	.WORD	ROT
	.WORD	CLIT
	.BYTE	9
	.WORD	OVER
	.WORD	LESS
	.WORD	ZBRAN,7
	.WORD	CLIT
	.BYTE	7
	.WORD	PLUS
	.WORD	CLIT
	.BYTE	'0'
	.WORD	PLUS
	.WORD	HOLD
	.WORD	SEMIS

;	#S

L9801	.BYTE	$82,'#',$D3
	.WORD	L97DA
DIGS	.WORD	DOCOL
	.WORD	DIG
	.WORD	TDUP
	.WORD	ORR
	.WORD	ZEQU
	.WORD	ZBRAN,$FFF6
	.WORD	SEMIS

;	D.R

L9816	.BYTE	$83,'D.',$D2
	.WORD	L9801
DDOTR	.WORD	DOCOL
	.WORD	TOR
	.WORD	SWAP
	.WORD	OVER
	.WORD	DABS
	.WORD	BDIGS
	.WORD	DIGS
	.WORD	SIGN
	.WORD	EDIGS
	.WORD	RFROM
	.WORD	OVER
	.WORD	SUBB
	.WORD	SPACS
	.WORD	TYPE
	.WORD	SEMIS

;	D.

L983A	.BYTE	$82,'D',$AE
	.WORD	L9816
DDOT	.WORD	DOCOL
	.WORD	ZERO
	.WORD	DDOTR
	.WORD	SPACE
	.WORD	SEMIS

;	D.R

L9849	.BYTE	$82,'.',$D2
	.WORD	L983A
DOTR	.WORD	DOCOL
	.WORD	TOR
	.WORD	STOD
	.WORD	RFROM
	.WORD	DDOTR
	.WORD	SEMIS

;	.

L985A	.BYTE	$81,$AE
	.WORD	L9849
DOT	.WORD	DOVEC
	.BYTE	14

PDOT	.WORD	DOCOL
	.WORD	STOD
	.WORD	DDOT
	.WORD	SEMIS

;	?

L9869	.BYTE	$81,$BF
	.WORD	L985A
QUES	.WORD	DOCOL
	.WORD	AT
	.WORD	DOT
	.WORD	SEMIS

;	LIST

L9875	.BYTE	$84,'LIS',$D4
	.WORD	L9869
LIST	.WORD	DOCOL
	.WORD	DECIM
	.WORD	CR
	.WORD	DUP
	.WORD	SCR
	.WORD	STORE
	.WORD	PDOTQ
	.BYTE	6
	.BYTE	'SCR # '
	.WORD	DOT
	.WORD	CLIT
	.BYTE	16
	.WORD	ZERO
	.WORD	PDO
	.WORD	CR
	.WORD	I
	.WORD	TWO
	.WORD	DOTR
	.WORD	SPACE
	.WORD	I
	.WORD	SCR
	.WORD	AT
	.WORD	DLINE
	.WORD	QTER
	.WORD	ZBRAN,4
	.WORD	LEAVE
	.WORD	PLOOP,$FFE4
	.WORD	CR
	.WORD	SEMIS

;	VLIST

L98BC	.BYTE	$85,'VLIS',$D4
	.WORD	L9875
	.WORD	DOCOL
	.WORD	CONT
	.WORD	AT
	.WORD	AT
	.WORD	CR
	.WORD	DUP
	.WORD	IDDOT
	.WORD	TAB
	.WORD	PFA
	.WORD	LFA
	.WORD	QTER
	.WORD	ZBRAN,$D
	.WORD	KEY
	.WORD	CLIT
	.BYTE	3
	.WORD	SUBB
	.WORD	ZBRAN,$C
	.WORD	AT
	.WORD	DUP
	.WORD	ZEQU
	.WORD	ZBRAN,$FFDD
	.WORD	DROP
	.WORD	SEMIS

;	READS

L98F7	.BYTE	$85,'READ',$D3
	.WORD	L98BC
	.WORD	DOCOL
	.WORD	OVER
	.WORD	PLUS
	.WORD	SWAP
	.WORD	PDO
	.WORD	I
	.WORD	READ
	.WORD	PLOOP,$FFFA
	.WORD	SEMIS

;	WRITES

L9913	.BYTE	$86,'WRITE',$D3
	.WORD	L98F7
	.WORD	DOCOL
	.WORD	OVER
	.WORD	PLUS
	.WORD	SWAP
	.WORD	PDO
	.WORD	I
	.WORD	WRITE
	.WORD	PLOOP,$FFFA
	.WORD	SEMIS

;	LOADS

L9930	.BYTE	$85,'LOAD',$D3
	.WORD	L9913
	.WORD	DOCOL
	.WORD	ZERO
	.WORD	PDO
	.WORD	ONE
	.WORD	READ
	.WORD	ONE
	.WORD	LOAD
	.WORD	PLOOP,$FFF6
	.WORD	SEMIS

;	EM

L994C	.BYTE	$82,'E',$CD
	.WORD	L9930
EM	.WORD	DOCON
	.WORD	$283

;	THRU

L9955	.BYTE	$84,'THR',$D5
	.WORD	L994C
	.WORD	DOCOL
	.WORD	ONEP
	.WORD	SWAP
	.WORD	PDO
	.WORD	I
	.WORD	LOAD
	.WORD	PLOOP,$FFFA
	.WORD	SEMIS

;	SETNAM

L996E	.BYTE	$86,'SETNA',$CD
	.WORD	$84C
SETNAM	.WORD	DOCOL
	.WORD	SWAP
	.WORD	LIT,$100
	.WORD	SLMOD
	.WORD	LIT,$FFBD
	.WORD	SYS
	.WORD	THDROP
	.WORD	SEMIS

;	NAME

L998B	.BYTE	$84,'NAM',$C5
	.WORD	L9955
NAME	.WORD	DOCOL
	.WORD	FN
	.WORD	GTEXT
	.WORD	FN
	.WORD	COUNT
	.WORD	SETNAM
	.WORD	SEMIS

;	TAB

L99A0	.BYTE	$83,'TA',$C2
	.WORD	L998B
TAB	.WORD	DOCOL
	.WORD	CLIT
	.BYTE	$A
	.WORD	OUT
	.WORD	AT
	.WORD	OVER
	.WORD	MOD
	.WORD	SUBB
	.WORD	ZERO
	.WORD	MAX
	.WORD	DUP
	.WORD	OUT
	.WORD	AT
	.WORD	PLUS
	.WORD	CLIT
	.BYTE	30
	.WORD	GREAT
	.WORD	ZBRAN,$A
	.WORD	DROP
	.WORD	CR
	.WORD	BRAN,4
	.WORD	SPACS
	.WORD	SEMIS

;	TEXT

L99D6	.BYTE	$84,'TEX',$D4
	.WORD	L99A0
TEXT	.WORD	DOCOL
	.WORD	HERE
	.WORD	CSLL
	.WORD	ONEP
	.WORD	BLANK
	.WORD	WORD
	.WORD	HERE
	.WORD	PAD
	.WORD	CSLL
	.WORD	ONEP
	.WORD	CMOVE
	.WORD	SEMIS

;	LINE

L99F5	.BYTE	$84,'LIN',$C5
	.WORD	L99D6
LINE	.WORD	DOCOL
	.WORD	DUP
	.WORD	LIT,$FFF0
	.WORD	ANDD
	.WORD	DUP
	.WORD	ZBRAN,4
	.WORD	TOP
	.WORD	CLIT
	.BYTE	$11
	.WORD	QERR
	.WORD	SCR
	.WORD	AT
	.WORD	PLINE
	.WORD	DROP
	.WORD	SEMIS

;	2DUP

L9A1D	.BYTE	$84,'2DU',$D0
	.WORD	L99F5
TDUP	.WORD	DOCOL
	.WORD	OVER
	.WORD	OVER
	.WORD	SEMIS

;	2SWAP

L9A2C	.BYTE	$85,'2SWA',$D0
	.WORD	L9A1D
TSWAP	.WORD	DOCOL
	.WORD	ROT
	.WORD	TOR
	.WORD	ROT
	.WORD	RFROM
	.WORD	SEMIS

;	U.

L9A40	.BYTE	$82,'U',$AE
	.WORD	L9A2C
UDOT	.WORD	DOCOL
	.WORD	ZERO
	.WORD	DDOT
	.WORD	SEMIS

;	H.

L9A4D	.BYTE	$82,'H',$AE
	.WORD	L9A40
	.WORD	DOCOL
	.WORD	BASE
	.WORD	AT
	.WORD	SWAP
	.WORD	HEX
	.WORD	UDOT
	.WORD	BASE
	.WORD	STORE
	.WORD	SEMIS

;	DUMP

L9A64	.BYTE	$84,'DUM',$D0
	.WORD	L9A4D
	.WORD	DOCOL
	.WORD	OVER
	.WORD	PLUS
	.WORD	SWAP
	.WORD	CR
	.WORD	PDO
	.WORD	I
	.WORD	ZERO
	.WORD	CLIT
	.BYTE	5
	.WORD	DDOTR
	.WORD	I
	.WORD	CLIT
	.BYTE	8
	.WORD	PLUS
	.WORD	I
	.WORD	PDO
	.WORD	I
	.WORD	CAT
	.WORD	CLIT
	.BYTE	4
	.WORD	DOTR
	.WORD	PLOOP,$FFF5
	.WORD	CR
	.WORD	CLIT
	.BYTE	8
	.WORD	PPLOO,$FFD8
	.WORD	SEMIS

;	#LOCATE

L9AA3	.BYTE	$87,'#LOCAT',$C5
	.WORD	$84C
NLOCAT	.WORD	DOCOL
	.WORD	RNUM
	.WORD	AT
	.WORD	ZERO
	.WORD	CSLL
	.WORD	USLAS
	.WORD	SEMIS

;	BMOV

L9ABB	.BYTE	$84,'BMO',$D6
	.WORD	L9AA3
BMOV	.WORD	DOCOL
	.WORD	PAD
	.WORD	ONEP
	.WORD	CAT
	.WORD	ZBRAN,$E
	.WORD	PAD
	.WORD	SWAP
	.WORD	CSLL
	.WORD	ONEP
	.WORD	CMOVE
	.WORD	SEMIS
	.WORD	DROP
	.WORD	SEMIS

;	PADF

L9ADE	.BYTE	$84,'PAD',$C6
	.WORD	L9ABB
PADF	.WORD	DOCOL
	.WORD	PAD
	.WORD	CLIT
	.BYTE	80
	.WORD	PLUS
	.WORD	SEMIS

;	PADI

L9AF0	.BYTE	$84,'PAD',$C9
	.WORD	L9ADE
PADI	.WORD	DOCOL
	.WORD	PADF
	.WORD	CLIT
	.BYTE	80
	.WORD	PLUS
	.WORD	SEMIS

;	!CUR

L9B02	.BYTE	$84,'!CU',$D2
	.WORD	L9AF0
STOCUR	.WORD	DOCOL
	.WORD	ZERO
	.WORD	OVER
	.WORD	GREAT
	.WORD	ZEQU
	.WORD	OVER
	.WORD	BBUF
	.WORD	LESS
	.WORD	ANDD
	.WORD	ZBRAN,$A
	.WORD	RNUM
	.WORD	STORE
	.WORD	BRAN,4
	.WORD	DROP
	.WORD	VV
	.WORD	SEMIS

;	L#

L9B2D	.BYTE	$82,'L',$A3
	.WORD	L9B02
LNUM	.WORD	DOCOL
	.WORD	NLOCAT
	.WORD	SWAP
	.WORD	DROP
	.WORD	SEMIS

;	#LEAD

L9B3C	.BYTE	$85,'#LEA',$C4
	.WORD	L9B2D
NLEAD	.WORD	DOCOL
	.WORD	NLOCAT
	.WORD	LINE
	.WORD	SWAP
	.WORD	SEMIS

;	#LAG

L9B4E	.BYTE	$84,'#LA',$C7
	.WORD	L9B3C
NLAG	.WORD	DOCOL
	.WORD	NLEAD
	.WORD	DUP
	.WORD	TOR
	.WORD	PLUS
	.WORD	CSLL
	.WORD	RFROM
	.WORD	SUBB
	.WORD	SEMIS

;	-MOVE

L9B67	.BYTE	$85,'-MOV',$C5
	.WORD	L9B4E
DMOVE	.WORD	DOCOL
	.WORD	LINE
	.WORD	CSLL
	.WORD	CMOVE
	.WORD	UPDATE
	.WORD	SEMIS

;	H

L9B7B	.BYTE	$81,$C8
	.WORD	L9B67
HH	.WORD	DOCOL
	.WORD	LNUM
	.WORD	LINE
	.WORD	PADI
	.WORD	ONEP
	.WORD	CSLL
	.WORD	DUP
	.WORD	PADI
	.WORD	CSTOR
	.WORD	CMOVE
	.WORD	SEMIS

;	K

L9B95	.BYTE	$81,$CB
	.WORD	L9B7B
KK	.WORD	DOCOL
	.WORD	LNUM
	.WORD	LINE
	.WORD	CSLL
	.WORD	BLANK
	.WORD	UPDATE
	.WORD	SEMIS

;	S

L9BA7	.BYTE	$81,$D3
	.WORD	L9B95
SS	.WORD	DOCOL
	.WORD	LNUM
	.WORD	CLIT
	.BYTE	15
	.WORD	PDO
	.WORD	I
	.WORD	ONE
	.WORD	SUBB
	.WORD	LINE
	.WORD	I
	.WORD	DMOVE
	.WORD	LIT,-1
	.WORD	PPLOO,$FFEE
	.WORD	KK
	.WORD	SEMIS

;	X

L9BCC	.BYTE	$81,$D8
	.WORD	L9BA7
XX	.WORD	DOCOL
	.WORD	LNUM
	.WORD	DUP
	.WORD	HH
	.WORD	CLIT
	.BYTE	15
	.WORD	LESS
	.WORD	ZBRAN,$1B
	.WORD	CLIT
	.BYTE	15
	.WORD	SWAP
	.WORD	PDO
	.WORD	I
	.WORD	ONEP
	.WORD	LINE
	.WORD	I
	.WORD	DMOVE
	.WORD	PLOOP,$FFF4
	.WORD	BRAN,4
	.WORD	DROP
	.WORD	CLIT
	.BYTE	15
	.WORD	LINE
	.WORD	CSLL
	.WORD	BLANK
	.WORD	SEMIS

;	C

L9C07	.BYTE	$81,$C3
	.WORD	L9BCC
CC	.WORD	DOCOL
	.WORD	RNUM
	.WORD	AT
	.WORD	PLUS
	.WORD	STOCUR
	.WORD	SEMIS

;	T

L9C17	.BYTE	$81,$D4
	.WORD	L9C07
TT	.WORD	DOCOL
	.WORD	CSLL
	.WORD	STAR
	.WORD	STOCUR
	.WORD	SEMIS

;	GTEXT

L9C25	.BYTE	$85,'GTEX',$D4
	.WORD	L9C17
GTEXT	.WORD	DOCOL
	.WORD	CLIT
	.BYTE	'^'
	.WORD	TEXT
	.WORD	BMOV
	.WORD	SEMIS

;	P

L9C38	.BYTE	$81,$D0
	.WORD	L9C25
PP	.WORD	DOCOL
	.WORD	PADI
	.WORD	GTEXT
	.WORD	L9C46
	.WORD	SEMIS

L9C46	.WORD	DOCOL
	.WORD	LNUM
	.WORD	PADI
	.WORD	ONEP
	.WORD	SWAP
	.WORD	DMOVE
	.WORD	SEMIS

;	U

L9C54	.BYTE	$81,$D5
	.WORD	L9C38
UU	.WORD	DOCOL
	.WORD	ONE
	.WORD	LNUM
	.WORD	PLUS
	.WORD	TT
	.WORD	SS
	.WORD	PP
	.WORD	SEMIS

;	TOP

L9C68	.BYTE	$83,'TO',$D0
	.WORD	L9C54
TOP	.WORD	DOCOL
	.WORD	ZERO
	.WORD	STOCUR
	.WORD	SEMIS

;	COPY

L9C76	.BYTE	$84,'COP',$D9
	.WORD	L9C68
	.WORD	DOCOL
	.WORD	DUP
	.WORD	BLOCK
	.WORD	DROP
	.WORD	SWAP
	.WORD	BLOCK
	.WORD	DROP
	.WORD	FIRST
	.WORD	STORE
	.WORD	UPDATE
	.WORD	SEMIS

;	MATCH

L9C93	.BYTE	$85,'MATC',$C8
	.WORD	L9C76
MATCH	.WORD	DOCOL
	.WORD	TOR
	.WORD	TOR
	.WORD	TDUP
	.WORD	RFROM
	.WORD	RFROM
	.WORD	TSWAP
	.WORD	OVER
	.WORD	PLUS
	.WORD	SWAP
	.WORD	PDO
	.WORD	TDUP
	.WORD	I
	.WORD	SWAP
	.WORD	PMATCH
	.WORD	ZBRAN,$1A
	.WORD	TOR
	.WORD	TDROP
	.WORD	RFROM
	.WORD	SUBB
	.WORD	I
	.WORD	SWAP
	.WORD	SUBB
	.WORD	ZERO
	.WORD	SWAP
	.WORD	ZERO
	.WORD	ZERO
	.WORD	LEAVE
	.WORD	PLOOP,$FFDA
	.WORD	TDROP
	.WORD	SWAP
	.WORD	ZEQU
	.WORD	SWAP
	.WORD	SEMIS

;	1LINE

L9CE3	.BYTE	$85,'1LIN',$C5
	.WORD	L9C93
ONELIN	.WORD	DOCOL
	.WORD	NLAG
	.WORD	PADF
	.WORD	COUNT
	.WORD	MATCH
	.WORD	RNUM
	.WORD	PSTOR
	.WORD	SEMIS

;	(F)

L9CFB	.BYTE	$83,'(F',$A9
	.WORD	L9CE3
PFF	.WORD	DOCOL
	.WORD	LIT,$3FF
	.WORD	RNUM
	.WORD	AT
	.WORD	LESS
	.WORD	L9D19
	.WORD	ONELIN
	.WORD	ZBRAN,$FFF0
	.WORD	VV
	.WORD	SEMIS

L9D19	.WORD	DOCOL
	.WORD	ZBRAN,$17
	.WORD	TOP
	.WORD	PADF
	.WORD	IDDOT
	.WORD	PDOTQ
	.BYTE	6
	.BYTE	'<-NONE'
	.WORD	L9F24
	.WORD	SPSTO
	.WORD	QUIT
	.WORD	SEMIS

;	DEL

L9D36	.BYTE	$83,'DE',$CC
	.WORD	L9CFB
DEL	.WORD	DOCOL
	.WORD	RNUM
	.WORD	AT
	.WORD	MIN
	.WORD	QDUP
	.WORD	ZBRAN,$4C
	.WORD	NLEAD
	.WORD	SWAP
	.WORD	DROP
	.WORD	ZEQU
	.WORD	ZBRAN,$14
	.WORD	LIT,-1
	.WORD	CC
	.WORD	BL
	.WORD	NLAG
	.WORD	DROP
	.WORD	CSTOR
	.WORD	ONE
	.WORD	SUBB
	.WORD	TOR
	.WORD	NLAG
	.WORD	PLUS
	.WORD	R
	.WORD	SUBB
	.WORD	NLAG
	.WORD	R
	.WORD	MINUS
	.WORD	RNUM
	.WORD	PSTOR
	.WORD	NLEAD
	.WORD	PLUS
	.WORD	SWAP
	.WORD	CMOVE
	.WORD	RFROM
	.WORD	QDUP
	.WORD	ZBRAN,8
	.WORD	BLANK
	.WORD	BRAN,4
	.WORD	DROP
	.WORD	VV
	.WORD	UPDATE
	.WORD	SEMIS

;	F

L9D9A	.BYTE	$81,$C6
	.WORD	L9D36
FF	.WORD	DOCOL
	.WORD	PADF
	.WORD	GTEXT
	.WORD	PFF
	.WORD	SEMIS

;	E

L9DA8	.BYTE	$81,$C5
	.WORD	L9D9A
EE	.WORD	DOCOL
	.WORD	PADF
	.WORD	CAT
	.WORD	DEL
	.WORD	SEMIS

;	D

L9DB6	.BYTE	$81,$C4
	.WORD	L9DA8
	.WORD	DOCOL
	.WORD	FF
	.WORD	EE
	.WORD	SEMIS

;	TILL

L9DC2	.BYTE	$84,'TIL',$CC
	.WORD	L9DB6
	.WORD	DOCOL
	.WORD	PADF
	.WORD	GTEXT
	.WORD	NLEAD
	.WORD	PLUS
	.WORD	ONELIN
	.WORD	ZEQU
	.WORD	L9D19
	.WORD	NLEAD
	.WORD	PLUS
	.WORD	SWAP
	.WORD	SUBB
	.WORD	DEL
	.WORD	SEMIS

;	(I)

L9DE5	.BYTE	$83,'(I',$A9
	.WORD	L9DC2
PII	.WORD	DOCOL
	.WORD	PADI
	.WORD	COUNT
	.WORD	NLAG
	.WORD	ROT
	.WORD	OVER
	.WORD	MIN
	.WORD	TOR
	.WORD	TDUP
	.WORD	PADI
	.WORD	COUNT
	.WORD	PLUS
	.WORD	SWAP
	.WORD	CMOVE
	.WORD	CMOVE
	.WORD	RFROM
	.WORD	CC
	.WORD	UPDATE
	.WORD	SEMIS

;	I

L9E11	.BYTE	$81,$C9
	.WORD	L9DE5
II	.WORD	DOCOL
	.WORD	PADI
	.WORD	GTEXT
	.WORD	PII
	.WORD	SEMIS

;	R

L9E1F	.BYTE	$81,$D2
	.WORD	L9E11
	.WORD	DOCOL
	.WORD	EE
	.WORD	II
	.WORD	SEMIS

;	N

L9E2B	.BYTE	$81,$CE
	.WORD	L9E1F
NN	.WORD	DOCOL
	.WORD	ONE
	.WORD	PSCR
	.WORD	VV
	.WORD	SEMIS

;	B

L9E39	.BYTE	$81,$C2
	.WORD	L9E2B
BB	.WORD	DOCOL
	.WORD	LIT,-1
	.WORD	PSCR
	.WORD	VV
	.WORD	SEMIS

;	+SCR

L9E49	.BYTE	$84,'+SC',$D2
	.WORD	L9E39
PSCR	.WORD	DOCOL
	.WORD	SCR
	.WORD	AT
	.WORD	PLUS
	.WORD	ONE
	.WORD	MAX
	.WORD	BMAX
	.WORD	AT
	.WORD	MIN
	.WORD	SCR
	.WORD	STORE
	.WORD	SEMIS

;	WIPE

L9E68	.BYTE	$84,'WIP',$C5
	.WORD	L9E49
	.WORD	DOCOL
	.WORD	SCR
	.WORD	AT
	.WORD	BLOCK
	.WORD	ZERO
	.WORD	OVER
	.WORD	BBUF
	.WORD	PLUS
	.WORD	STORE
	.WORD	BBUF
	.WORD	BLANK
	.WORD	UPDATE
	.WORD	SEMIS

;	M

L9E89	.BYTE	$81,$CD
	.WORD	L9E68
	.WORD	DOCOL
	.WORD	SCR
	.WORD	AT
	.WORD	TOR
	.WORD	RNUM
	.WORD	AT
	.WORD	TOR
	.WORD	HH
	.WORD	SWAP
	.WORD	SCR
	.WORD	STORE
	.WORD	ONEP
	.WORD	CSLL
	.WORD	STAR
	.WORD	STOCUR
	.WORD	SS
	.WORD	L9C46
	.WORD	RFROM
	.WORD	CSLL
	.WORD	PLUS
	.WORD	STOCUR
	.WORD	RFROM
	.WORD	SCR
	.WORD	STORE
	.WORD	SEMIS

L9EBF	.WORD	DOCOL
	.WORD	CLIT
	.BYTE	7
	.WORD	BORDR
	.WORD	ONE
	.WORD	IFLAG
	.WORD	STORE
	.WORD	THREE
	.WORD	CTBL
	.WORD	PSTOR
	.WORD	KEY
	.WORD	DUP
	.WORD	CLIT
	.BYTE	$D
	.WORD	SUBB
	.WORD	ZBRAN,$41
	.WORD	DUP
	.WORD	CLIT
	.BYTE	$14
	.WORD	EQUAL
	.WORD	ZBRAN,$C
	.WORD	DROP
	.WORD	ONE
	.WORD	DEL
	.WORD	BRAN,$28
	.WORD	IFLAG
	.WORD	AT
	.WORD	ZBRAN,$14
	.WORD	PADI
	.WORD	ONEP
	.WORD	CSTOR
	.WORD	ONE
	.WORD	PADI
	.WORD	CSTOR
	.WORD	PII
	.WORD	BRAN,$E
	.WORD	NLEAD
	.WORD	PLUS
	.WORD	CSTOR
	.WORD	ONE
	.WORD	CC
	.WORD	UPDATE
	.WORD	BRAN,$FFB6
	.WORD	DROP
	.WORD	L9F24
	.WORD	SEMIS

L9F24	.WORD	DOCOL
	.WORD	CLIT
	.BYTE	5
	.WORD	BORDR
	.WORD	LIT,L8082
	.WORD	CTBL
	.WORD	STORE
	.WORD	SEMIS

L9F35	.WORD	DOCOL
	.WORD	IFLAG
	.WORD	DUP
	.WORD	ONE
	.WORD	TOGGL
	.WORD	AT
	.WORD	ZBRAN,9
	.WORD	CLIT
	.BYTE	7
	.WORD	BRAN,5
	.WORD	CLIT
	.BYTE	$E
	.WORD	BORDR
	.WORD	SEMIS

;	V

L9F53	.BYTE	$81,$D6
	.WORD	L9E89
VV	.WORD	DOCOL
	.WORD	NLOCAT
	.WORD	OVER
	.WORD	SCR
	.WORD	AT
	.WORD	BLOCK
	.WORD	SWAP
	.WORD	CLIT
	.BYTE	19
	.WORD	SUBB
	.WORD	ZERO
	.WORD	MAX
	.WORD	CLIT
	.BYTE	24
	.WORD	MIN
	.WORD	PLUS
	.WORD	LIT,1024
	.WORD	CLIT
	.BYTE	16
	.WORD	ZERO
	.WORD	PDO
	.WORD	SMOVE
	.WORD	CLIT
	.BYTE	40
	.WORD	PLUS
	.WORD	SWAP
	.WORD	CSLL
	.WORD	PLUS
	.WORD	SWAP
	.WORD	PLOOP,$FFEF
	.WORD	TDROP
	.WORD	OVER
	.WORD	SWAP
	.WORD	CLIT
	.BYTE	40
	.WORD	STAR
	.WORD	SWAP
	.WORD	DUP
	.WORD	CLIT
	.BYTE	24
	.WORD	SUBB
	.WORD	CLIT
	.BYTE	19
	.WORD	MAX
	.WORD	MIN
	.WORD	PLUS
	.WORD	LIT,$400
	.WORD	PLUS
	.WORD	CLIT
	.BYTE	$80
	.WORD	TOGGL
	.WORD	LIT,$680
	.WORD	CLIT
	.BYTE	40
	.WORD	CLIT
	.BYTE	$A0
	.WORD	FILL
	.WORD	ZERO
	.WORD	CLIT
	.BYTE	$A
	.WORD	USLAS
	.WORD	LIT,$6A6
	.WORD	L9FF3
	.WORD	LIT,$6A7
	.WORD	L9FF3
	.WORD	SCR
	.WORD	CAT
	.WORD	ZERO
	.WORD	CLIT
	.BYTE	$A
	.WORD	USLAS
	.WORD	LIT,$6A2
	.WORD	L9FF3
	.WORD	LIT,$6A3
	.WORD	L9FF3
	.WORD	SEMIS

L9FF3	.WORD	DOCOL
	.WORD	SWAP
	.WORD	CLIT
	.BYTE	'0'
	.WORD	PLUS
	.WORD	SWAP
	.WORD	CSTOR
	.WORD	SEMIS

LA002	.WORD	DOCOL
	.WORD	LIT,$D800
	.WORD	LIT,1024
	.WORD	LIT,$286
	.WORD	CAT
	.WORD	FILL
	.WORD	VV
	.WORD	LIT,$6D0
	.WORD	LIT,$6A8
	.WORD	LIT,$118
	.WORD	CMOVE
	.WORD	LIT,$7C0
	.WORD	CLIT
	.BYTE	40
	.WORD	BLANK
	.WORD	ZERO
	.WORD	ZERO
	.WORD	CLIT
	.BYTE	24
	.WORD	ZERO
	.WORD	LIT,$FFF0
	.WORD	SYS
	.WORD	TDROP
	.WORD	TDROP
	.WORD	ZERO
	.WORD	OUT
	.WORD	STORE
	.WORD	SEMIS

LA048	.WORD	DOCOL
	.WORD	CLIT
	.BYTE	4
	.WORD	CC
	.WORD	SEMIS

LA051	.WORD	DOCOL
	.WORD	LIT,-4
	.WORD	CC
	.WORD	SEMIS

LA05B	.WORD	DOCOL
	.WORD	LNUM
	.WORD	ONEP
	.WORD	TT
	.WORD	SEMIS

LA065	.WORD	DOCOL
	.WORD	ONE
	.WORD	CC
	.WORD	SEMIS

LA06D	.WORD	DOCOL
	.WORD	LIT,-1
	.WORD	CC
	.WORD	SEMIS

LA077	.WORD	DOCOL
	.WORD	CSLL
	.WORD	CC
	.WORD	SEMIS

LA07F	.WORD	DOCOL
	.WORD	CSLL
	.WORD	MINUS
	.WORD	CC
	.WORD	SEMIS

LA089	.WORD	DOCOL
	.WORD	EE
	.WORD	PII
	.WORD	SEMIS

LA091	.WORD	DOCOL
	.WORD	SS
	.WORD	VV
	.WORD	SEMIS

LA099	.WORD	DOCOL
	.WORD	XX
	.WORD	VV
	.WORD	SEMIS

LA0A1	.WORD	DOCOL
	.WORD	SS
	.WORD	L9C46
	.WORD	VV
	.WORD	SEMIS

LA0AB	.WORD	DOCOL
	.WORD	LA065
	.WORD	ONE
	.WORD	DEL
	.WORD	SEMIS

;	EDIT

LA0B5	.BYTE	$84,'EDI',$D4
	.WORD	L9A64
	.WORD	DOCOL
	.WORD	SCR
	.WORD	STORE
	.WORD	EDITOR
	.WORD	TOP
	.WORD	LIT,L8082
	.WORD	CTBL
	.WORD	STORE
	.WORD	LIT,LA002
	.WORD	IO
	.WORD	CLIT
	.BYTE	6
	.WORD	PLUS
	.WORD	STORE
	.WORD	ONE
	.WORD	EFLAG
	.WORD	STORE
	.WORD	SEMIS

;	ASCII

LA0E3	.BYTE	$C5,'ASCI',$C9
	.WORD	LA0B5
	.WORD	DOCOL
	.WORD	BL
	.WORD	WORD
	.WORD	HERE
	.WORD	ONEP
	.WORD	CAT
	.WORD	LITER
	.WORD	SEMIS

;	SYS

LA0FB	.BYTE	$83,'SY',$D3
	.WORD	L996E
SYS	.WORD	*+2
	STX	XSAVE
	LDA	0,X
	STA	NXTMP
	LDA	1,X
	STA	NXTMP+1
	LDY	2,X
	LDA	4,X
	STA	N
	LDA	8,X
	BNE	LA11A
	CLC
	BCC	LA11B
LA11A	SEC
LA11B	LDA	6,X
	LDX	N
	JSR	LA135
	PHP
	STX	N
	LDX	XSAVE
	STA	6,X
	LDA	N
	STA	4,X
	STY	2,X
	PLA
	STA	N
	JMP	POP

LA135	JMP	(NXTMP)

;	READ

LA138	.BYTE	$84,'REA',$C4
	.WORD	LA0E3
READ	.WORD	DOCOL
	.WORD	FSET
	.WORD	BLOCK
	.WORD	SLOAD
	.WORD	UPDATE
	.WORD	SEMIS

;	FSET

LA14B	.BYTE	$84,'FSE',$D4
	.WORD	LA0FB
FSET	.WORD	DOCOL
	.WORD	FNUM
	.WORD	AT
	.WORD	DNUM
	.WORD	AT
	.WORD	ZERO
	.WORD	SETLFS
	.WORD	SEMIS

;	SETLFS

LA162	.BYTE	$86,'SETLF',$D3
	.WORD	LA14B
SETLFS	.WORD	DOCOL
	.WORD	LIT,$FFBA
	.WORD	SYS
	.WORD	THDROP
	.WORD	SEMIS

;	3DROP

LA177	.BYTE	$85,'3DRO',$D0
	.WORD	LA138
THDROP	.WORD	DOCOL
	.WORD	TDROP
	.WORD	DROP
	.WORD	SEMIS

;	OPEN

LA187	.BYTE	$84,'OPE',$CE
	.WORD	LA162
OPEN	.WORD	*+2
	STX	XSAVE
	JSR	$FFC0
	LDX	XSAVE
	JMP	NEXT

;	SLOAD

LA19A	.BYTE	$85,'SLOA',$C4
	.WORD	LA187
SLOAD	.WORD	DOCOL
	.WORD	ZERO
	.WORD	SWAP
	.WORD	LIT,$100
	.WORD	SLMOD
	.WORD	LIT,$FFD5
	.WORD	SYS
	.WORD	THDROP
	.WORD	SEMIS

;	SAVE

LA1B8	.BYTE	$84,'SAV',$C5
	.WORD	LA19A
SAVE	.WORD	DOCOL
	.WORD	OVER
	.WORD	PLUS
	.WORD	SWAP
	.WORD	TWO
	.WORD	STORE
	.WORD	TWO
	.WORD	SWAP
	.WORD	LIT,$100
	.WORD	SLMOD
	.WORD	LIT,$FFD8
	.WORD	SYS
	.WORD	THDROP
	.WORD	SEMIS

;	WRITE

LA1DF	.BYTE	$85,'WRIT',$C5
	.WORD	LA177
WRITE	.WORD	DOCOL
	.WORD	FSET
	.WORD	BLOCK
	.WORD	BBUF
	.WORD	SAVE
	.WORD	SEMIS

;	CHKOUT

LA1F3	.BYTE	$86,'CHKOU',$D4
	.WORD	LA1B8
CHKOUT	.WORD	DOCOL
	.WORD	ZERO
	.WORD	SWAP
	.WORD	ZERO
	.WORD	LIT,$FFC9
	.WORD	SYS
	.WORD	THDROP
	.WORD	SEMIS

;	CLALL

LA20E	.BYTE	$85,'CLAL',$CC
	.WORD	LA1F3
	.WORD	*+2
	STX	XSAVE
	JSR	$FFE7
	LDX	XSAVE
	JMP	NEXT

;	CHRIN

LA222	.BYTE	$85,'CHRI',$CE
	.WORD	LA20E
CHRIN	.WORD	*+2
	JSR	$FFCF
	JMP	PUSH0A

;	BGROUND

LA232	.BYTE	$87,'BGROUN',$C4
	.WORD	LA1DF
	.WORD	*+2
	LDA	0,X
	STA	$D021
	JMP	POP

;	BORDER

LA246	.BYTE	$86,'BORDE',$D2
	.WORD	LA232
BORDR	.WORD	*+2
	LDA	0,X
	STA	$D020
	JMP	POP

;	UPORT

LA259	.BYTE	$85,'UPOR',$D4
	.WORD	LA246
	.WORD	DOCON
	.WORD	$DD00

;	DISK

LA265	.BYTE	$84,'DIS',$CB
	.WORD	LA259
DISK	.WORD	DOCOL
	.WORD	DRNUM
	.WORD	AT
	.WORD	DUP
	.WORD	DNUM
	.WORD	STORE
	.WORD	DUP
	.WORD	FNUM
	.WORD	STORE
	.WORD	ONE
	.WORD	SWAP
	.WORD	ZERO
	.WORD	SETLFS
	.WORD	SEMIS

;	CASSETTE

LA288	.BYTE	$88,'CASSETT',$C5
	.WORD	LA265
CASSET	.WORD	DOCOL
	.WORD	ONE
	.WORD	DNUM
	.WORD	STORE
	.WORD	ONE
	.WORD	FNUM
	.WORD	STORE
	.WORD	ONE
	.WORD	ONE
	.WORD	ZERO
	.WORD	SETLFS
	.WORD	SEMIS

;	TALK

LA2AB	.BYTE	$84,'TAL',$CB
	.WORD	LA222
TALK	.WORD	DOCOL
	.WORD	DZERO
	.WORD	LIT,$FFB4
	.WORD	SYS
	.WORD	THDROP
	.WORD	SEMIS

;	TKSA

LA2C0	.BYTE	$84,'TKS',$C1
	.WORD	LA2AB
TKSA	.WORD	DOCOL
	.WORD	DZERO
	.WORD	LIT,$FF96
	.WORD	SYS
	.WORD	THDROP
	.WORD	SEMIS

;	0.0

LA2D5	.BYTE	$83,'0.',$B0
	.WORD	LA2C0
DZERO	.WORD	DOCOL
	.WORD	ZERO
	.WORD	ZERO
	.WORD	SEMIS

;	UNTLK

LA2E3	.BYTE	$85,'UNTL',$CB
	.WORD	LA2D5
UNTLK	.WORD	DOCOL
	.WORD	DZERO
	.WORD	ZERO
	.WORD	LIT,$FFAB
	.WORD	SYS
	.WORD	THDROP
	.WORD	SEMIS

;	UNLSN

LA2FB	.BYTE	$85,'UNLS',$CE
	.WORD	LA2E3
UNLSN	.WORD	DOCOL
	.WORD	DZERO
	.WORD	ZERO
	.WORD	LIT,$FFAE
	.WORD	SYS
	.WORD	THDROP
	.WORD	SEMIS

;	ACPTR

LA313	.BYTE	$85,'ACPT',$D2
	.WORD	LA2FB
ACPTR	.WORD	DOCOL
	.WORD	ZERO
	.WORD	DZERO
	.WORD	LIT,$FFA5
	.WORD	SYS
	.WORD	TDROP
	.WORD	SEMIS

;	LISTEN

LA32B	.BYTE	$86,'LISTE',$CE
	.WORD	LA313
LISTEN	.WORD	DOCOL
	.WORD	DZERO
	.WORD	LIT,$FFB1
	.WORD	SYS
	.WORD	THDROP
	.WORD	SEMIS

;	CIOUT

LA342	.BYTE	$85,'CIOU',$D4
	.WORD	LA32B
CIOUT	.WORD	DOCOL
	.WORD	DZERO
	.WORD	LIT,$FFA8
	.WORD	SYS
	.WORD	THDROP
	.WORD	SEMIS

;	SECOND

LA358	.BYTE	$86,'SECON',$C4
	.WORD	LA342
SECOND	.WORD	DOCOL
	.WORD	DZERO
	.WORD	LIT,$FF93
	.WORD	SYS
	.WORD	THDROP
	.WORD	SEMIS

;	STYPE

LA36F	.BYTE	$85,'STYP',$C5
	.WORD	LA358
STYPE	.WORD	DOCOL
	.WORD	OVER
	.WORD	PLUS
	.WORD	SWAP
	.WORD	PDO
	.WORD	I
	.WORD	CAT
	.WORD	CIOUT
	.WORD	PLOOP,$FFF8
	.WORD	SEMIS

;	DTLK

LA38D	.BYTE	$84,'DTL',$CB
	.WORD	LA36F
DTLK	.WORD	DOCOL
	.WORD	LIT,$60
	.WORD	ORR
	.WORD	DRNUM
	.WORD	AT
	.WORD	TALK
	.WORD	TKSA
	.WORD	SEMIS

;	DLSN

LA3A6	.BYTE	$84,'DLS',$CE
	.WORD	LA38D
DLSN	.WORD	DOCOL
	.WORD	LIT,$60
	.WORD	ORR
	.WORD	DRNUM
	.WORD	AT
	.WORD	LISTEN
	.WORD	SECOND
	.WORD	SEMIS

;	?DERR

LA3BF	.BYTE	$85,'?DER',$D2
	.WORD	LA288
QDERR	.WORD	DOCOL
	.WORD	LIT,$F
	.WORD	DTLK
	.WORD	ZERO
	.WORD	ONEP
	.WORD	DUP
	.WORD	HERE
	.WORD	PLUS
	.WORD	ACPTR
	.WORD	DUP
	.WORD	ROT
	.WORD	CSTOR
	.WORD	LIT,$D
	.WORD	EQUAL
	.WORD	ZBRAN,$FFE8
	.WORD	HERE
	.WORD	CSTOR
	.WORD	UNTLK
	.WORD	HERE
	.WORD	ONEP
	.WORD	CAT
	.WORD	LIT,$30
	.WORD	SUBB
	.WORD	ZBRAN,$1D
	.WORD	CR
	.WORD	PDOTQ
	.BYTE	12
	.BYTE	'DISK ERROR! '
	.WORD	CR
	.WORD	HERE
	.WORD	COUNT
	.WORD	TYPE
	.WORD	QUIT
	.WORD	SEMIS

;	?D

LA41E	.BYTE	$82,'?',$C4
	.WORD	LA3BF
	.WORD	DOCOL
	.WORD	QDERR
	.WORD	HERE
	.WORD	COUNT
	.WORD	TYPE
	.WORD	SEMIS

;	-->

LA42F	.BYTE	$C3,'--',$BE
	.WORD	LA41E
	.WORD	DOCOL
	.WORD	ONE
	.WORD	BLK
	.WORD	PSTOR
	.WORD	ZERO
	.WORD	IN
	.WORD	STORE
	.WORD	SEMIS

;	<^>

LA445	.BYTE	$83,'<^',$BE
	.WORD	LA42F
ALIT	.WORD	DOCOL
	.WORD	R
	.WORD	DUP
	.WORD	CAT
	.WORD	ONEP
	.WORD	RFROM
	.WORD	PLUS
	.WORD	TOR
	.WORD	COUNT
	.WORD	SEMIS

;	^

LA45F	.BYTE	$C1,$DE
	.WORD	LA445
UARROW	.WORD	DOCOL
	.WORD	STATE
	.WORD	AT
	.WORD	ZBRAN,$18
	.WORD	COMP
	.WORD	ALIT
	.WORD	LIT,$5E		; '^'
	.WORD	WORD
	.WORD	HERE
	.WORD	CAT
	.WORD	ONEP
	.WORD	ALLOT
	.WORD	BRAN,$1A
	.WORD	LIT,$5E		; '^'
	.WORD	WORD
	.WORD	HERE
	.WORD	DUP
	.WORD	CAT
	.WORD	ONEP
	.WORD	PAD
	.WORD	SWAP
	.WORD	CMOVE
	.WORD	PAD
	.WORD	COUNT
	.WORD	SEMIS

;	DRIVE

LA49D	.BYTE	$85,'DRIV',$C5
	.WORD	LA45F
DRIVE	.WORD	DOCOL
	.WORD	LIT,8
	.WORD	PLUS
	.WORD	DRNUM
	.WORD	STORE
	.WORD	SEMIS

;	DRIVE?

LA4B3	.BYTE	$86,'DRIVE',$BF
	.WORD	LA49D
	.WORD	DOCOL
	.WORD	DRNUM
	.WORD	AT
	.WORD	LIT,8
	.WORD	SUBB
	.WORD	SEMIS

;	DTYPE

LA4CA	.BYTE	$85,'DTYP',$C5
	.WORD	LA3A6
DTYPE	.WORD	DOCOL
	.WORD	ROT
	.WORD	DLSN
	.WORD	STYPE
	.WORD	LIT,$D
	.WORD	CIOUT
	.WORD	UNLSN
	.WORD	SEMIS

;	/CMD

LA4E4	.BYTE	$C4,'/CM',$C4
	.WORD	LA4B3
SCMD	.WORD	DOCOL
	.WORD	UARROW
	.WORD	STATE
	.WORD	AT
	.WORD	ZBRAN,$A
	.WORD	COMP
	.WORD	DTYPE
	.WORD	BRAN,4
	.WORD	DTYPE
	.WORD	SEMIS

;	CMD

LA503	.BYTE	$C3,'CM',$C4
	.WORD	LA4E4
	.WORD	DOCOL
	.WORD	LIT,$F
	.WORD	LITER
	.WORD	SCMD
	.WORD	SEMIS

;	(FILE)

LA515	.BYTE	$86,'(FILE',$A9
	.WORD	LA503
PFILE	.WORD	DOCOL
	.WORD	FN
	.WORD	GTEXT
	.WORD	FN
	.WORD	COUNT
	.WORD	PUFIL
	.WORD	SEMIS

;	^FILE

LA52C	.BYTE	$85,'^FIL',$C5
	.WORD	LA515
UFILE	.WORD	DOCOL
	.WORD	FCLOSE
	.WORD	PUFIL
	.WORD	SEMIS

;	(^FILE)

LA53C	.BYTE	$87,'(^FILE',$A9
	.WORD	LA52C
PUFIL	.WORD	DOCOL
	.WORD	PFCLOS
	.WORD	DCHAN
	.WORD	AT
	.WORD	LIT,$F0
	.WORD	ORR
	.WORD	DRNUM
	.WORD	AT
	.WORD	LISTEN
	.WORD	SECOND
	.WORD	STYPE
	.WORD	ALIT
	.BYTE	6
	.BYTE	',L,',$81,',W'
	.WORD	STYPE
	.WORD	LIT,$D
	.WORD	CIOUT
	.WORD	UNLSN
	.WORD	QDERR
	.WORD	DISK
	.WORD	SEMIS

;	FILE

LA577	.BYTE	$84,'FIL',$C5
	.WORD	LA53C
FILE	.WORD	DOCOL
	.WORD	FCLOSE
	.WORD	PFILE
	.WORD	SEMIS

;	(FCLOSE)

LA586	.BYTE	$88,'(FCLOSE',$A9
	.WORD	LA577
PFCLOS	.WORD	DOCOL
	.WORD	DCHAN
	.WORD	AT
	.WORD	LIT,$F
	.WORD	ANDD
	.WORD	LIT,$E0
	.WORD	ORR
	.WORD	DRNUM
	.WORD	AT
	.WORD	LISTEN
	.WORD	SECOND
	.WORD	UNLSN
	.WORD	CASSET
	.WORD	SEMIS

;	FCLOSE

LA5B1	.BYTE	$86,'FCLOS',$C5
	.WORD	LA586
FCLOSE	.WORD	DOCOL
	.WORD	FLUSH
	.WORD	MTBUF
	.WORD	PFCLOS
	.WORD	SEMIS

;	POS

LA5C4	.BYTE	$83,'PO',$D3
	.WORD	LA4CA
POS	.WORD	DOCOL
	.WORD	LIT,$F
	.WORD	DLSN
	.WORD	LIT,$50
	.WORD	CIOUT
	.WORD	DCHAN
	.WORD	AT
	.WORD	CIOUT
	.WORD	LIT,$100
	.WORD	SLMOD
	.WORD	SWAP
	.WORD	CIOUT
	.WORD	CIOUT
	.WORD	ONE
	.WORD	CIOUT
	.WORD	UNLSN
	.WORD	SEMIS

;	SLSN

LA5F2	.BYTE	$84,'SLS',$CE
	.WORD	LA5C4
SLSN	.WORD	DOCOL
	.WORD	LIT,$60
	.WORD	ORR
	.WORD	DRNUM
	.WORD	AT
	.WORD	LISTEN
	.WORD	SECOND
	.WORD	SEMIS

;	RECWRITE

LA60B	.BYTE	$88,'RECWRIT',$C5
	.WORD	LA5F2
RECWRT	.WORD	DOCOL
	.WORD	DCHAN
	.WORD	AT
	.WORD	SLSN
	.WORD	STYPE
	.WORD	LIT,$D
	.WORD	CIOUT
	.WORD	UNLSN
	.WORD	SEMIS

;	RECREAD

LA62A	.BYTE	$87,'RECREA',$C4
	.WORD	LA60B
RECREA	.WORD	DOCOL
	.WORD	DCHAN
	.WORD	AT
	.WORD	DTLK
	.WORD	ACPTR
	.WORD	DUP
	.WORD	LIT,$D
	.WORD	EQUAL
	.WORD	OVER
	.WORD	LIT,$FF
	.WORD	EQUAL
	.WORD	ORR
	.WORD	ZEQU
	.WORD	ZBRAN,$C
	.WORD	OVER
	.WORD	CSTOR
	.WORD	ONEP
	.WORD	BRAN,$FFDE
	.WORD	DROP
	.WORD	UNTLK
	.WORD	SEMIS

;	BLKWRITE

LA666	.BYTE	$88,'BLKWRIT',$C5
	.WORD	LA62A
BLKWRT	.WORD	DOCOL
	.WORD	ONE
	.WORD	SUBB
	.WORD	LIT,8
	.WORD	STAR
	.WORD	ONEP
	.WORD	POS
	.WORD	LIT,8
	.WORD	ZERO
	.WORD	PDO
	.WORD	DUP
	.WORD	LIT,$80
	.WORD	RECWRT
	.WORD	LIT,$80
	.WORD	PLUS
	.WORD	PLOOP,$FFF0
	.WORD	DROP
	.WORD	SEMIS

;	BLKREAD

LA69F	.BYTE	$87,'BLKREA',$C4
	.WORD	LA666
BLKRD	.WORD	DOCOL
	.WORD	ONE
	.WORD	SUBB
	.WORD	LIT,8
	.WORD	STAR
	.WORD	ONEP
	.WORD	POS
	.WORD	LIT,8
	.WORD	ZERO
	.WORD	PDO
	.WORD	DUP
	.WORD	RECREA
	.WORD	DROP
	.WORD	LIT,$80
	.WORD	PLUS
	.WORD	PLOOP,$FFF2
	.WORD	DROP
	.WORD	SEMIS

;	R/W

LA6D5	.BYTE	$83,'R/',$D7
	.WORD	LA69F
RSLW	.WORD	DOVEC
	.BYTE	22

PRSLW	.WORD	DOCOL
	.WORD	DNUM
	.WORD	AT
	.WORD	LIT,3
	.WORD	GREAT
	.WORD	ZBRAN,$12
	.WORD	ZBRAN,8
	.WORD	BLKRD
	.WORD	BRAN,4
	.WORD	BLKWRT
	.WORD	BRAN,4
	.WORD	THDROP
	.WORD	SEMIS

;	UPDATE

LA702	.BYTE	$86,'UPDAT',$C5
	.WORD	LA5B1
UPDATE	.WORD	DOCOL
	.WORD	FIRST
	.WORD	DUP
	.WORD	AT
	.WORD	LIT,$8000
	.WORD	ORR
	.WORD	SWAP
	.WORD	STORE
	.WORD	SEMIS

;	EMPTY-BUFFERS

LA71F	.BYTE	$8D,'EMPTY-BUFFER',$D3
	.WORD	LA702
MTBUF	.WORD	DOCOL
	.WORD	BLKTBL
	.WORD	LIMIT
	.WORD	OVER
	.WORD	SUBB
	.WORD	ERASE
	.WORD	SEMIS

;	>RAM

LA73D	.BYTE	$84,'>RA',$CD
	.WORD	LA6D5
TORAM	.WORD	DOCOL
	.WORD	LIT,$7F
	.WORD	LIT,$DC0D
	.WORD	CSTOR
	.WORD	LIT,$34
	.WORD	ONE
	.WORD	CSTOR
	.WORD	SEMIS

;	RAM>

LA75A	.BYTE	$84,'RAM',$BE
	.WORD	LA73D
FRAM	.WORD	DOCOL
	.WORD	LIT
LA765	.WORD	$37
	.WORD	ONE
	.WORD	CSTOR
	.WORD	LIT,$81
	.WORD	LIT,$DC0D
	.WORD	CSTOR
	.WORD	SEMIS

;	>BUF

LA777	.BYTE	$84,'>BU',$C6
	.WORD	LA75A
TOBUF	.WORD	DOCOL
	.WORD	BUFAD
	.WORD	TORAM
	.WORD	BBUF
	.WORD	CMOVE
	.WORD	FRAM
	.WORD	SEMIS

;	BUF>

LA78C	.BYTE	$84,'BUF',$BE
	.WORD	LA777
FBUF	.WORD	DOCOL
	.WORD	BUFAD
	.WORD	TORAM
	.WORD	SWAP
	.WORD	BBUF
	.WORD	CMOVE
	.WORD	FRAM
	.WORD	SEMIS

;	BUFADD

LA7A3	.BYTE	$86,'BUFAD',$C4
	.WORD	LA78C
BUFAD	.WORD	DOCOL
	.WORD	LIT,$7FFF
	.WORD	ANDD
	.WORD	ONE
	.WORD	SUBB
	.WORD	ZERO
	.WORD	MAX
	.WORD	LIT,$F
	.WORD	ANDD
	.WORD	BBUF
	.WORD	STAR
	.WORD	LIT,$C000
	.WORD	PLUS
	.WORD	SEMIS

;	PTRADD

LA7CE	.BYTE	$86,'PTRAD',$C4
	.WORD	LA7A3
PTRADD	.WORD	DOCOL
	.WORD	LIT,$7FFF
	.WORD	ANDD
	.WORD	ONE
	.WORD	SUBB
	.WORD	ZERO
	.WORD	MAX
	.WORD	LIT,$F
	.WORD	ANDD
	.WORD	DUP
	.WORD	PLUS
	.WORD	BLKTBL
	.WORD	PLUS
	.WORD	SEMIS

;	CURBLK

LA7F7	.BYTE	$86,'CURBL',$CB
	.WORD	LA7CE
CURBLK	.WORD	DOCOL
	.WORD	FIRST
	.WORD	AT
	.WORD	LIT,$7FFF
	.WORD	ANDD
	.WORD	SEMIS

;	COMBUF

LA80E	.BYTE	$86,'COMBU',$C6
	.WORD	LA7F7
COMBUF	.WORD	DOCOL
	.WORD	FIRST
	.WORD	BBUF
	.WORD	SUBB
	.WORD	SEMIS

;	BLKTBL

LA821	.BYTE	$86,'BLKTB',$CC
	.WORD	LA80E
BLKTBL	.WORD	DOCOL
	.WORD	COMBUF
	.WORD	LIT,$20
	.WORD	SUBB
	.WORD	SEMIS

;	FLUSH

LA836	.BYTE	$85,'FLUS',$C8
	.WORD	LA71F
FLUSH	.WORD	DOCOL
	.WORD	FIRST
	.WORD	AT
	.WORD	ZLESS
	.WORD	ZBRAN,$1C
	.WORD	CURBLK
	.WORD	FIRST
	.WORD	TWOP
	.WORD	OVER
	.WORD	TOBUF
	.WORD	DUP
	.WORD	PTRADD
	.WORD	FIRST
	.WORD	AT
	.WORD	SWAP
	.WORD	STORE
	.WORD	FIRST
	.WORD	STORE
	.WORD	LIT,$11
	.WORD	ONE
	.WORD	PDO
	.WORD	I
	.WORD	PTRADD
	.WORD	AT
	.WORD	DUP
	.WORD	ZLESS
	.WORD	ZBRAN,$16
	.WORD	LIT,$7FFF
	.WORD	ANDD
	.WORD	DUP
	.WORD	LA943
	.WORD	I
	.WORD	PTRADD
	.WORD	STORE
	.WORD	BRAN,4
	.WORD	DROP
	.WORD	PLOOP,$FFDA
	.WORD	SEMIS

;	GBLOCK

LA896	.BYTE	$86,'GBLOC',$CB
	.WORD	LA821
GBLOCK	.WORD	DOCOL
	.WORD	CURBLK
	.WORD	OVER
	.WORD	SUBB
	.WORD	ZBRAN,$46
	.WORD	LA8FD
	.WORD	DUP
	.WORD	PTRADD
	.WORD	AT
	.WORD	LIT,$7FFF
	.WORD	ANDD
	.WORD	OVER
	.WORD	EQUAL
	.WORD	ZBRAN,$16
	.WORD	FIRST
	.WORD	TWOP
	.WORD	OVER
	.WORD	FBUF
	.WORD	PTRADD
	.WORD	AT
	.WORD	FIRST
	.WORD	STORE
	.WORD	BRAN,$18
	.WORD	FIRST
	.WORD	TWOP
	.WORD	DUP
	.WORD	BBUF
	.WORD	BLANK
	.WORD	OVER
	.WORD	ONE
	.WORD	RSLW
	.WORD	FIRST
	.WORD	STORE
	.WORD	LA8FD
	.WORD	BRAN,4
	.WORD	DROP
	.WORD	ZERO
	.WORD	LIMIT
	.WORD	TWO
	.WORD	SUBB
	.WORD	STORE
	.WORD	SEMIS

LA8FD	.WORD	DOCOL
	.WORD	CURBLK
	.WORD	DUP
	.WORD	DUP
	.WORD	PTRADD
	.WORD	AT
	.WORD	DUP
	.WORD	ZLESS
	.WORD	SWAP
	.WORD	LIT,$7FFF
	.WORD	ANDD
	.WORD	ROT
	.WORD	EQUAL
	.WORD	ZEQU
	.WORD	ANDD
	.WORD	ZBRAN,$10
	.WORD	DUP
	.WORD	PTRADD
	.WORD	AT
	.WORD	LIT,$7FFF
	.WORD	ANDD
	.WORD	LA943
	.WORD	FIRST
	.WORD	AT
	.WORD	OVER
	.WORD	PTRADD
	.WORD	STORE
	.WORD	FIRST
	.WORD	TWOP
	.WORD	SWAP
	.WORD	TOBUF
	.WORD	SEMIS

LA943	.WORD	DOCOL
	.WORD	COMBUF
	.WORD	OVER
	.WORD	FBUF
	.WORD	COMBUF
	.WORD	SWAP
	.WORD	ZERO
	.WORD	RSLW
	.WORD	SEMIS

;	FORTH

LA955	.BYTE	$C5,'FORT',$C8
	.WORD	LA9AB
	.WORD	DODOE
	.WORD	DOVOC
	.WORD	$A081
LA963	.WORD	LBFA0
	.WORD	0

;	SYSTEM

LA967	.BYTE	$C6,'SYSTE',$CD
	.WORD	$840
	.WORD	DODOE
	.WORD	DOVOC
	.WORD	$A081
LA976	.WORD	LBF1A
	.WORD	$850

;	ASSEMBLER

LA97A	.BYTE	$C9,'ASSEMBLE',$D2
	.WORD	$852
	.WORD	DODOE
	.WORD	DOVOC
	.WORD	$A081
LA98C	.WORD	LB162
	.WORD	$863

;	EDITOR

LA990	.BYTE	$C6,'EDITO',$D2
	.WORD	$865
EDITOR	.WORD	DODOE
	.WORD	DOVOC
	.WORD	$A081
LA99F	.WORD	L9F53
	.WORD	$879

LA9A3	.WORD	LA963		; TOP FORTH WORD
	.WORD	LA976		; TOP SYSTEM WORD
	.WORD	LA98C		; TOP ASSEMBLER WORD
	.WORD	LA99F		; TOP EDITOR WORD

;	NOOP

LA9AB	.BYTE	$84,'NOO',$D0
	.WORD	LA836
	.WORD	DOCOL
	.WORD	SEMIS

;	DLOAD

LA9B6	.BYTE	$85,'DLOA',$C4
	.WORD	$87B
	.WORD	DOCOL
	.WORD	DNUM
	.WORD	AT
	.WORD	FCLOSE
	.WORD	DUP
	.WORD	ONE
	.WORD	SETLFS
	.WORD	NAME
	.WORD	ZERO
	.WORD	SLOAD
	.WORD	CASSET
	.WORD	SEMIS

;	DSAVE

LA9D6	.BYTE	$85,'DSAV',$C5
	.WORD	LA9B6
	.WORD	DOCOL
	.WORD	DNUM
	.WORD	AT
	.WORD	FCLOSE
	.WORD	DUP
	.WORD	ZERO
	.WORD	SETLFS
	.WORD	NAME
	.WORD	LIT,$800
	.WORD	HERE
	.WORD	OVER
	.WORD	SUBB
	.WORD	SAVE
	.WORD	CASSET
	.WORD	SEMIS

;	FLOAD

LA9FE	.BYTE	$85,'FLOA',$C4
	.WORD	LA9D6
	.WORD	DOCOL
	.WORD	DNUM
	.WORD	AT
	.WORD	THREE
	.WORD	GREAT
	.WORD	ZBRAN,$4E
	.WORD	FN
	.WORD	DUP
	.WORD	LIT,$1E
	.WORD	PLUS
	.WORD	LIT,$14
	.WORD	CMOVE
	.WORD	LIT,$5E		; '^'
	.WORD	WORD
	.WORD	HERE
	.WORD	FN
	.WORD	LIT,$14
	.WORD	CMOVE
	.WORD	CR
	.WORD	FN
	.WORD	COUNT
	.WORD	TDUP
	.WORD	TYPE
	.WORD	SPACE
	.WORD	UFILE
	.WORD	ONE
	.WORD	LOAD
	.WORD	FN
	.WORD	LIT,$1E
	.WORD	PLUS
	.WORD	FN
	.WORD	LIT,$14
	.WORD	CMOVE
	.WORD	FN
	.WORD	COUNT
	.WORD	UFILE
	.WORD	BRAN,$A
	.WORD	FILE
	.WORD	ONE
	.WORD	LOAD
	.WORD	FCLOSE
	.WORD	SEMIS

;	.FREE

LAA6A	.BYTE	$85,'.FRE',$C5
	.WORD	LA9FE
	.WORD	DOCOL
	.WORD	EM
	.WORD	AT
	.WORD	HERE
	.WORD	SUBB
	.WORD	DOT
	.WORD	SEMIS

;	TRIAD

LAA80	.BYTE	$85
	.BYTE	'TRIA',$C4
	.WORD	LAA6A
	.WORD	DOCOL
	.WORD	ONE
	.WORD	SUBB
	.WORD	THREE
	.WORD	SLASH
	.WORD	THREE
	.WORD	STAR
	.WORD	ONEP
	.WORD	THREE
	.WORD	OVER
	.WORD	PLUS
	.WORD	SWAP
	.WORD	PDO
	.WORD	CR
	.WORD	I
	.WORD	LIST
	.WORD	PLOOP,$FFF8
	.WORD	CR
	.WORD	CR
	.WORD	CR
	.WORD	CR
	.WORD	CR
	.WORD	CR
	.WORD	CR
	.WORD	CR
	.WORD	CR
	.WORD	SEMIS

;	CLOSE

LAAC0	.BYTE	$85,'CLOS',$C5
	.WORD	LA896
CLOSE	.WORD	DOCOL
	.WORD	DZERO
	.WORD	LIT,$FFC3
	.WORD	SYS
	.WORD	THDROP
	.WORD	SEMIS

;	PROFF

LAAD6	.BYTE	$85,'PROF',$C6
	.WORD	LAAC0
PROFF	.WORD	DOCOL
	.WORD	THREE
	.WORD	THREE
	.WORD	ZERO
	.WORD	SETLFS
	.WORD	ZERO
	.WORD	ZERO
	.WORD	SETNAM
	.WORD	OPEN
	.WORD	THREE
	.WORD	CHKOUT
	.WORD	LIT,4
	.WORD	CLOSE
	.WORD	THREE
	.WORD	CLOSE
	.WORD	SEMIS

;	CHKIN

LAB00	.BYTE	$85,'CHKI',$CE
	.WORD	LAAD6
	.WORD	DOCOL
	.WORD	ZERO
	.WORD	SWAP
	.WORD	ZERO
	.WORD	LIT,$FFC6
	.WORD	SYS
	.WORD	THDROP
	.WORD	SEMIS

;	PRON

LAB1A	.BYTE	$84,'PRO',$CE
	.WORD	LAB00
PRON	.WORD	DOCOL
	.WORD	ZERO
	.WORD	ZERO
	.WORD	SETNAM
	.WORD	LIT,4
	.WORD	LIT,4
	.WORD	ZERO
	.WORD	SETLFS
	.WORD	OPEN
	.WORD	LIT,4
	.WORD	CHKOUT
	.WORD	SEMIS

;	TRY

LAB3F	.BYTE	$83,'TR',$D9
	.WORD	LAA80
	.WORD	DOCOL
	.WORD	SCR
	.WORD	AT
	.WORD	LOAD
	.WORD	SEMIS

;	PRINT

LAB4F	.BYTE	$85,'PRIN',$D4
	.WORD	LAB3F
	.WORD	DOCOL
	.WORD	PRON
	.WORD	INTER
	.WORD	PROFF
	.WORD	SEMIS

;	FORGET

LAB61	.BYTE	$86,'FORGE',$D4
	.WORD	LAB4F
FORG	.WORD	DOCOL
	.WORD	TICK
	.WORD	NFA
	.WORD	DUP
	.WORD	FENCE
	.WORD	AT
	.WORD	LESS
	.WORD	LIT
	.word	$15
	.WORD	QERR
	.WORD	TOR
	.WORD	VOCL
	.WORD	AT
	.WORD	R
	.WORD	OVER
	.WORD	LESS
	.WORD	ZBRAN,$C
	.WORD	$848		; FORTH
	.WORD	DEFIN
	.WORD	AT
	.WORD	BRAN,$FFEE
	.WORD	DUP
	.WORD	VOCL
	.WORD	STORE
	.WORD	DUP
	.WORD	LIT,4
	.WORD	SUBB
	.WORD	PFA
	.WORD	LFA
	.WORD	AT
	.WORD	DUP
	.WORD	R
	.WORD	LESS
	.WORD	ZBRAN,$FFF2
	.WORD	OVER
	.WORD	TWO
	.WORD	SUBB
	.WORD	STORE
	.WORD	AT
	.WORD	QDUP
	.WORD	ZEQU
	.WORD	ZBRAN,$FFD8
	.WORD	RFROM
	.WORD	DP
	.WORD	STORE
	.WORD	SEMIS

;	N

LABD0	.BYTE	$81,$CE
	.WORD	$84C
	.WORD	DOCON
	.WORD	N

;	IP

LABD8	.BYTE	$82,'I',$D0
	.WORD	LABD0
	.WORD	DOCON
	.WORD	IP

;	W

LABE1	.BYTE	$81,$D7
	.WORD	LABD8
	.WORD	DOCON
	.WORD	W

;	UP

LABE9	.BYTE	$82,'U',$D0
	.WORD	LABE1
	.WORD	DOCON
	.WORD	UP

;	XSAVE

LABF2	.BYTE	$85,'XSAV',$C5
	.WORD	LABE9
	.WORD	DOCON
	.WORD	XSAVE

;	NEXTMP

LABFE	.BYTE	$86,'NEXTM',$D0
	.WORD	LABF2
	.WORD	DOCON
	.WORD	NXTMP

;	POP

LAC0B	.BYTE	$83,'PO',$D0
	.WORD	LABFE
	.WORD	DOCON
	.WORD	POP

;	POPTWO

LAC15	.BYTE	$86,'POPTW',$CF
	.WORD	LAC0B
	.WORD	DOCON
	.WORD	POPTWO

;	PUT

LAC22	.BYTE	$83,'PU',$D4
	.WORD	LAC15
	.WORD	DOCON
	.WORD	PUT

;	PUSH

LAC2C	.BYTE	$84,'PUS',$C8
	.WORD	LAC22
	.WORD	DOCON
	.WORD	PUSH

;	NEXT

LAC37	.BYTE	$84,'NEX',$D4
	.WORD	LAC2C
	.WORD	DOCON
	.WORD	NEXT

;	SETUP

LAC42	.BYTE	$85,'SETU',$D0
	.WORD	LAC37
	.WORD	DOCON
	.WORD	SETUP

;	INDEX

LAC4E	.BYTE	$85,'INDE',$D8
	.WORD	LAC42
INDEX	.WORD	DOVAR
	.BYTE	$09,$09,$05,$15,$15,$01,$11,$80
	.BYTE	$09,$80,$0D,$1D,$19,$80,$80,$80
	.BYTE	$80,$00,$04,$14,$14,$80,$80,$80
	.BYTE	$80,$80,$0C,$1C,$1C,$80,$80,$2C

;	MODE

LAC78	.BYTE	$84,'MOD',$C5
	.WORD	LAC4E
MODE	.WORD	DOUSE
	.BYTE	$02
	.BYTE	$02

;	.A

LAC83	.BYTE	$82,'.',$C1
	.WORD	LAC78
	.WORD	DOCOL
	.WORD	ZERO
	.WORD	MODE
	.WORD	STORE
	.WORD	SEMIS

;	#

LAC92	.BYTE	$81,$A3
	.WORD	LAC83
	.WORD	DOCOL
	.WORD	ONE
	.WORD	MODE
	.WORD	STORE
	.WORD	SEMIS

;	MEM

LACA0	.BYTE	$83,'ME',$CD
	.WORD	LAC92
MEM	.WORD	DOCOL
	.WORD	TWO
	.WORD	MODE
	.WORD	STORE
	.WORD	SEMIS

;	,X

LACB0	.BYTE	$82,',',$D8
	.WORD	LACA0
LACB5	.WORD	DOCOL
	.WORD	THREE
	.WORD	MODE
	.WORD	STORE
	.WORD	SEMIS

;	,Y

LACBF	.BYTE	$82,',',$D9
	.WORD	LACB0
	.WORD	DOCOL
	.WORD	LIT,4
	.WORD	MODE
	.WORD	STORE
	.WORD	SEMIS

;	X)

LACD0	.BYTE	$82,'X',$A9
	.WORD	LACBF
	.WORD	DOCOL
	.WORD	LIT,5
	.WORD	MODE
	.WORD	STORE
	.WORD	SEMIS

;	)Y

LACE1	.BYTE	$82,')',$D9
	.WORD	LACD0
	.WORD	DOCOL
	.WORD	LIT,6
	.WORD	MODE
	.WORD	STORE
	.WORD	SEMIS

;	)

LACF2	.BYTE	$81,$A9
	.WORD	LACE1
	.WORD	DOCOL
	.WORD	LIT,$F
	.WORD	MODE
	.WORD	STORE
	.WORD	SEMIS

;	BOT

LAD02	.BYTE	$83,'BO',$D4
	.WORD	LACF2
	.WORD	DOCOL
	.WORD	LACB5
	.WORD	ZERO
	.WORD	SEMIS

;	SEC

LAD10	.BYTE	$83,'SE',$C3
	.WORD	LAD02
	.WORD	DOCOL
	.WORD	LACB5
	.WORD	TWO
	.WORD	SEMIS

;	RP)

LAD1E	.BYTE	$83,'RP',$A9
	.WORD	LAD10
	.WORD	DOCOL
	.WORD	LACB5
	.WORD	LIT,$101
	.WORD	SEMIS

;	UPMODE

LAD2E	.BYTE	$86,'UPMOD',$C5
	.WORD	LAD1E
UPMODE	.WORD	DOCOL
	.WORD	ZBRAN,$1A
	.WORD	MODE
	.WORD	AT
	.WORD	LIT,8
	.WORD	ANDD
	.WORD	ZEQU
	.WORD	ZBRAN,$A
	.WORD	LIT,8
	.WORD	MODE
	.WORD	PSTOR
	.WORD	ONE
	.WORD	MODE
	.WORD	AT
	.WORD	LIT,$F
	.WORD	ANDD
	.WORD	QDUP
	.WORD	ZBRAN,$E
	.WORD	ZERO
	.WORD	PDO
	.WORD	DUP
	.WORD	PLUS
	.WORD	PLOOP,$FFFA
	.WORD	OVER
	.WORD	ONEP
	.WORD	AT
	.WORD	ANDD
	.WORD	ZEQU
	.WORD	SEMIS

;	CPU

LAD7F	.BYTE	$83,'CP',$D5
	.WORD	LAD2E
	.WORD	DOCOL
	.WORD	BUILD
	.WORD	CCOM
	.WORD	DOES
DOCPU	.WORD	CAT
	.WORD	CCOM
	.WORD	MEM
	.WORD	SEMIS

;	BRK,

LAD95	.BYTE	$84,'BRK',$AC
	.WORD	LAD7F
	.WORD	DODOE
	.WORD	DOCPU
	.BYTE	0

;	CLC,

LADA1	.BYTE	$84,'CLC',$AC
	.WORD	LAD95
	.WORD	DODOE
	.WORD	DOCPU
	.BYTE	$18

;	CLD,

LADAD	.BYTE	$84,'CLD',$AC
	.WORD	LADA1
	.WORD	DODOE
	.WORD	DOCPU
	.BYTE	$D8

;	CLI,

LADB9	.BYTE	$84,'CLI',$AC
	.WORD	LADAD
	.WORD	DODOE
	.WORD	DOCPU
	.BYTE	$58

;	CLV,

LADC5	.BYTE	$84,'CLV',$AC
	.WORD	LADB9
	.WORD	DODOE
	.WORD	DOCPU
	.BYTE	$B8

;	DEX,

LADD1	.BYTE	$84,'DEX',$AC
	.WORD	LADC5
	.WORD	DODOE
	.WORD	DOCPU
	.BYTE	$CA

;	DEY,

LADDD	.BYTE	$84,'DEY',$AC
	.WORD	LADD1
	.WORD	DODOE
	.WORD	DOCPU
	.BYTE	$88

;	INX,

LADE9	.BYTE	$84,'INX',$AC
	.WORD	LADDD
	.WORD	DODOE
	.WORD	DOCPU
	.BYTE	$E8

;	INY,

LADF5	.BYTE	$84,'INY',$AC
	.WORD	LADE9
	.WORD	DODOE
	.WORD	DOCPU
	.BYTE	$C8

;	NOP,

LAE01	.BYTE	$84,'NOP',$AC
	.WORD	LADF5
	.WORD	DODOE
	.WORD	DOCPU
	.BYTE	$EA

;	PHA,

LAE0D	.BYTE	$84,'PHA',$AC
	.WORD	LAE01
	.WORD	DODOE
	.WORD	DOCPU
	.BYTE	$48

;	PHP,

LAE19	.BYTE	$84,'PHP',$AC
	.WORD	LAE0D
	.WORD	DODOE
	.WORD	DOCPU
	.BYTE	8

;	PLA,

LAE25	.BYTE	$84,'PLA',$AC
	.WORD	LAE19
	.WORD	DODOE
	.WORD	DOCPU
	.BYTE	$68

;	PLP,

LAE31	.BYTE	$84,'PLP',$AC
	.WORD	LAE25
	.WORD	DODOE
	.WORD	DOCPU
	.BYTE	$28

;	RTI,

LAE3D	.BYTE	$84,'RTI',$AC
	.WORD	LAE31
	.WORD	DODOE
	.WORD	DOCPU
	.BYTE	$40

;	RTS,

LAE49	.BYTE	$84,'RTS',$AC
	.WORD	LAE3D
	.WORD	DODOE
	.WORD	DOCPU
	.BYTE	$60

;	SEC,

LAE55	.BYTE	$84,'SEC',$AC
	.WORD	LAE49
	.WORD	DODOE
	.WORD	DOCPU
	.BYTE	$38

;	SED,

LAE61	.BYTE	$84,'SED',$AC
	.WORD	LAE55
	.WORD	DODOE
	.WORD	DOCPU
	.BYTE	$F8

;	SEI,

LAE6D	.BYTE	$84,'SEI',$AC
	.WORD	LAE61
	.WORD	DODOE
	.WORD	DOCPU
	.BYTE	$78

;	TAX,

LAE79	.BYTE	$84,'TAX',$AC
	.WORD	LAE6D
	.WORD	DODOE
	.WORD	DOCPU
	.BYTE	$AA

;	TAY,

LAE85	.BYTE	$84,'TAY',$AC
	.WORD	LAE79
	.WORD	DODOE
	.WORD	DOCPU
	.BYTE	$A8

;	TSX,

LAE91	.BYTE	$84,'TSX',$AC
	.WORD	LAE85
	.WORD	DODOE
	.WORD	DOCPU
	.BYTE	$BA

;	TXA,

LAE9D	.BYTE	$84,'TXA',$AC
	.WORD	LAE91
	.WORD	DODOE
	.WORD	DOCPU
	.BYTE	$8A

;	TXS,

LAEA9	.BYTE	$84,'TXS',$AC
	.WORD	LAE9D
	.WORD	DODOE
	.WORD	DOCPU
	.BYTE	$9A

;	TYA,

LAEB5	.BYTE	$84,'TYA',$AC
	.WORD	LAEA9
	.WORD	DODOE
	.WORD	DOCPU
	.BYTE	$98

;	M/CPU

LAEC1	.BYTE	$85,'M/CP',$D5
	.WORD	LAEB5
	.WORD	DOCOL
	.WORD	BUILD
	.WORD	CCOM
	.WORD	COMMA
	.WORD	DOES
DOMCPU	.WORD	DUP
	.WORD	ONEP
	.WORD	AT
	.WORD	LIT,$80
	.WORD	ANDD
	.WORD	ZBRAN,$A
	.WORD	LIT,$10
	.WORD	MODE
	.WORD	PSTOR
	.WORD	OVER
	.WORD	LIT,$FF00
	.WORD	ANDD
	.WORD	UPMODE
	.WORD	UPMODE
	.WORD	ZBRAN,$E
	.WORD	MEM
	.WORD	CR
	.WORD	LATES
	.WORD	IDDOT
	.WORD	THREE
	.WORD	ERROR
	.WORD	CAT
	.WORD	MODE
	.WORD	CAT
	.WORD	INDEX
	.WORD	PLUS
	.WORD	CAT
	.WORD	PLUS
	.WORD	CCOM
	.WORD	MODE
	.WORD	CAT
	.WORD	LIT,7
	.WORD	ANDD
	.WORD	ZBRAN,$1E
	.WORD	MODE
	.WORD	CAT
	.WORD	LIT,$F
	.WORD	ANDD
	.WORD	LIT,7
	.WORD	LESS
	.WORD	ZBRAN,8
	.WORD	CCOM
	.WORD	BRAN,4
	.WORD	COMMA
	.WORD	MEM
	.WORD	SEMIS

;	ADC,

LAF45	.BYTE	$84,'ADC',$AC
	.WORD	LAEC1
	.WORD	DODOE
	.WORD	DOMCPU
	.BYTE	$60,$6E,$1C

;	AND,

LAF53	.BYTE	$84,'AND',$AC
	.WORD	LAF45
	.WORD	DODOE
	.WORD	DOMCPU
	.BYTE	$20,$6E,$1C

;	CMP,

LAF61	.BYTE	$84,'CMP',$AC
	.WORD	LAF53
	.WORD	DODOE
	.WORD	DOMCPU
	.BYTE	$C0,$6E,$1C

;	EOR,

LAF6F	.BYTE	$84,'EOR',$AC
	.WORD	LAF61
	.WORD	DODOE
	.WORD	DOMCPU
	.BYTE	$40,$6E,$1C

;	LDA,

LAF7D	.BYTE	$84,'LDA',$AC
	.WORD	LAF6F
	.WORD	DODOE
	.WORD	DOMCPU
	.BYTE	$A0,$6E,$1C

;	ORA,

LAF8B	.BYTE	$84,'ORA',$AC
	.WORD	LAF7D
	.WORD	DODOE
	.WORD	DOMCPU
	.BYTE	$00,$6E,$1C

;	SBC,

LAF99	.BYTE	$84,'SBC',$AC
	.WORD	LAF8B
	.WORD	DODOE
	.WORD	DOMCPU
	.BYTE	$E0,$6E,$1C

;	STA,

LAFA7	.BYTE	$84,'STA',$AC
	.WORD	LAF99
	.WORD	DODOE
	.WORD	DOMCPU
	.BYTE	$80,$6C,$1C

;	ASL,

LAFB5	.BYTE	$84,'ASL',$AC
	.WORD	LAFA7
	.WORD	DODOE
	.WORD	DOMCPU
	.BYTE	$01,$0D,$0D

;	DEC,

LAFC3	.BYTE	$84,'DEC',$AC
	.WORD	LAFB5
	.WORD	DODOE
	.WORD	DOMCPU
	.BYTE	$C1,$0C,$0C

;	INC,

LAFD1	.BYTE	$84,'INC',$AC
	.WORD	LAFC3
	.WORD	DODOE
	.WORD	DOMCPU
	.BYTE	$E1,$0C,$0C

;	LSR,

LAFDF	.BYTE	$84,'LSR',$AC
	.WORD	LAFD1
	.WORD	DODOE
	.WORD	DOMCPU
	.BYTE	$41,$0D,$0D

;	ROL,

LAFED	.BYTE	$84,'ROL',$AC
	.WORD	LAFDF
	.WORD	DODOE
	.WORD	DOMCPU
	.BYTE	$21,$0D,$0D

;	ROR,

LAFFB	.BYTE	$84,'ROR',$AC
	.WORD	LAFED
	.WORD	DODOE
	.WORD	DOMCPU
	.BYTE	$61,$0D,$0D

;	STX,

LB009	.BYTE	$84,'STX',$AC
	.WORD	LAFFB
	.WORD	DODOE
	.WORD	DOMCPU
	.BYTE	$81,$14,$04

;	CPX,

LB017	.BYTE	$84,'CPX',$AC
	.WORD	LB009
	.WORD	DODOE
	.WORD	DOMCPU
	.BYTE	$E0,$86,$04

;	CPY,

LB025	.BYTE	$84,'CPY',$AC
	.WORD	LB017
	.WORD	DODOE
	.WORD	DOMCPU
	.BYTE	$C0,$86,$04

;	LDX,

LB033	.BYTE	$84,'LDX',$AC
	.WORD	LB025
	.WORD	DODOE
	.WORD	DOMCPU
	.BYTE	$A2,$96,$14

;	LDY,

LB041	.BYTE	$84,'LDY',$AC
	.WORD	LB033
	.WORD	DODOE
	.WORD	DOMCPU
	.BYTE	$A0,$8E,$0C

;	STY,

LB04F	.BYTE	$84,'STY',$AC
	.WORD	LB041
	.WORD	DODOE
	.WORD	DOMCPU
	.BYTE	$80,$8C,$04

;	JSR,

LB05D	.BYTE	$84,'JSR',$AC
	.WORD	LB04F
	.WORD	DODOE
	.WORD	DOMCPU
	.BYTE	$14,$80,$04

;	JMP,

LB06B	.BYTE	$84,'JMP',$AC
	.WORD	LB05D
JMPP	.WORD	DODOE
	.WORD	DOMCPU
	.BYTE	$40,$80,$84

;	BIT,

LB079	.BYTE	$84,'BIT',$AC
	.WORD	LB06B
	.WORD	DODOE
	.WORD	DOMCPU
	.BYTE	$84,$00,$00

;	BEGIN,

LB087	.BYTE	$C6,'BEGIN',$AC
	.WORD	LB079
	.WORD	DOCOL
	.WORD	HERE
	.WORD	ONE
	.WORD	SEMIS

;	UNTIL,

LB098	.BYTE	$C6,'UNTIL',$AC
	.WORD	LB087
	.WORD	DOCOL
	.WORD	QEXEC
	.WORD	TOR
	.WORD	ONE
	.WORD	QPAIR
	.WORD	RFROM
	.WORD	CCOM
	.WORD	HERE
	.WORD	ONEP
	.WORD	SUBB
	.WORD	CCOM
	.WORD	SEMIS

;	IF,

LB0B9	.BYTE	$C3,'IF',$AC
	.WORD	LB098
	.WORD	DOCOL
	.WORD	CCOM
	.WORD	HERE
	.WORD	ZERO
	.WORD	CCOM
	.WORD	TWO
	.WORD	SEMIS

;	ENDIF,

LB0CD	.BYTE	$C6,'ENDIF',$AC
	.WORD	LB0B9
	.WORD	DOCOL
	.WORD	QEXEC
	.WORD	TWO
	.WORD	QPAIR
	.WORD	HERE
	.WORD	OVER
	.WORD	CAT
	.WORD	ZBRAN,$A
	.WORD	SWAP
	.WORD	STORE
	.WORD	BRAN,$C
	.WORD	OVER
	.WORD	ONEP
	.WORD	SUBB
	.WORD	SWAP
	.WORD	CSTOR
	.WORD	SEMIS

;	ELSE,

LB0FC	.BYTE	$C5,'ELSE',$AC
	.WORD	LB0CD
	.WORD	DOCOL
	.WORD	TWO
	.WORD	QPAIR
	.WORD	HERE
	.WORD	ONEP
	.WORD	ONE
	.WORD	JMPP
	.WORD	SWAP
	.WORD	HERE
	.WORD	OVER
	.WORD	ONEP
	.WORD	SUBB
	.WORD	SWAP
	.WORD	CSTOR
	.WORD	TWO
	.WORD	SEMIS

;	NOT

LB124	.BYTE	$83,'NO',$D4
	.WORD	LB0FC
	.WORD	DOCOL
	.WORD	LIT,$20
	.WORD	PLUS
	.WORD	SEMIS

;	CS

LB134	.BYTE	$82,'C',$D3
	.WORD	LB124
	.WORD	DOCON
	.WORD	$90

;	0=

LB13D	.BYTE	$82,'0',$BD
	.WORD	LB134
	.WORD	DOCON
	.WORD	$D0

;	0<

LB146	.BYTE	$82,'0',$BC
	.WORD	LB13D
	.WORD	DOCON
	.WORD	$10

;	>=

LB14F	.BYTE	$82,'>',$BD
	.WORD	LB146
	.WORD	DOCON
	.WORD	$90

;	OVS

LB158	.BYTE	$83,'OV',$D3
	.WORD	LB14F
	.WORD	DOCON
	.WORD	$70

;	END-CODE

LB162	.BYTE	$C8,'END-COD',$C5
	.WORD	LB158
	.WORD	DOCOL
	.WORD	CURR
	.WORD	AT
	.WORD	CONT
	.WORD	STORE
	.WORD	QEXEC
	.WORD	QCSP
	.WORD	SMUDGE
	.WORD	SEMIS

;	CODE

LB17F	.BYTE	$C4,'COD',$C5
	.WORD	LAB61
	.WORD	DOCOL
	.WORD	QEXEC
	.WORD	CREAT
	.WORD	$871
	.WORD	MEM
	.WORD	SCSP
	.WORD	SEMIS

;	DEPTH

LB194	.BYTE	$85,'DEPT',$C8
	.WORD	LB17F
DEPTH	.WORD	DOCOL
	.WORD	SPAT
	.WORD	LIT,TOS
	.WORD	SWAP
	.WORD	SUBB
	.WORD	TWO
	.WORD	SLASH
	.WORD	SEMIS

;	.S

LB1AE	.BYTE	$82,'.',$D3
	.WORD	LB194
DOTS	.WORD	DOCOL
	.WORD	QSTAC
	.WORD	DEPTH
	.WORD	ZBRAN,$24
	.WORD	SPAT
	.WORD	TWO
	.WORD	SUBB
	.WORD	LIT,$5E
	.WORD	PDO
	.WORD	I
	.WORD	AT
	.WORD	LIT,5
	.WORD	DOTR
	.WORD	LIT,-2
	.WORD	PPLOO,$FFF0
	.WORD	BRAN,$C
	.WORD	PDOTQ
	.BYTE	7
	.BYTE	' EMPTY '
	.WORD	SEMIS

;	ERP

LB1EB	.BYTE	$83,'ER',$D0
	.WORD	LAB1A
ERP	.WORD	DOUSE
	.WORD	$CC

;	EIP

LB1F5	.BYTE	$83,'EI',$D0
	.WORD	LB1EB
EIP	.WORD	DOUSE
	.WORD	$CE

;	ERP!

LB1FF	.BYTE	$84,'ERP',$A1
	.WORD	LB1F5
ERPSTO	.WORD	DOCOL
	.WORD	BLKTBL
	.WORD	TWO
	.WORD	SUBB
	.WORD	ERP
	.WORD	STORE
	.WORD	SEMIS

;	E>R

LB214	.BYTE	$83,'E>',$D2
	.WORD	LB1FF
ETOR	.WORD	DOCOL
	.WORD	ERP
	.WORD	AT
	.WORD	STORE
	.WORD	LIT,-2
	.WORD	ERP
	.WORD	PSTOR
	.WORD	SEMIS

;	ER>

LB22C	.BYTE	$83,'ER',$BE
	.WORD	LB214
ERFROM	.WORD	DOCOL
	.WORD	TWO
	.WORD	ERP
	.WORD	PSTOR
	.WORD	ERP
	.WORD	AT
	.WORD	BLKTBL
	.WORD	TWO
	.WORD	SUBB
	.WORD	GREAT
	.WORD	ZBRAN,$16
	.WORD	ERPSTO
	.WORD	PDOTQ
	.BYTE	11
	.BYTE	'RSTK EMPTY '
	.WORD	SPSTO
	.WORD	QUIT
	.WORD	ERP
	.WORD	AT
	.WORD	AT
	.WORD	SEMIS

;	EIP+

LB266	.BYTE	$84,'EIP',$AB
	.WORD	LB22C
EIPPL	.WORD	DOCOL
	.WORD	TWO
	.WORD	EIP
	.WORD	PSTOR
	.WORD	SEMIS

;	EBR

LB277	.BYTE	$83,'EB',$D2
	.WORD	LB266
EBR	.WORD	DOCOL
	.WORD	EIP
	.WORD	AT
	.WORD	AT
	.WORD	DUP
	.WORD	DOT
	.WORD	EIP
	.WORD	PSTOR
	.WORD	SEMIS

EZBRAN	.WORD	DOCOL
	.WORD	ZBRAN,8
	.WORD	EIPPL
	.WORD	BRAN,4
	.WORD	EBR
	.WORD	SEMIS

;	EI

LB29F	.BYTE	$82,'E',$C9
	.WORD	LB277
EI	.WORD	DOCOL
	.WORD	ERP
	.WORD	AT
	.WORD	TWOP
	.WORD	AT
	.WORD	SEMIS

ELIT	.WORD	DOCOL
	.WORD	EIP
	.WORD	AT
	.WORD	AT
	.WORD	EIPPL
	.WORD	SEMIS

ECLIT	.WORD	DOCOL
	.WORD	EIP
	.WORD	AT
	.WORD	CAT
	.WORD	ONE
	.WORD	EIP
	.WORD	PSTOR
	.WORD	SEMIS

LB2CC	.WORD	DOCOL
	.WORD	EIP
	.WORD	AT
	.WORD	COUNT
	.WORD	TDUP
	.WORD	PLUS
	.WORD	EIP
	.WORD	STORE
	.WORD	TDUP
	.WORD	TYPE
	.WORD	SEMIS

EPDOTQ	.WORD	DOCOL
	.WORD	LB2CC
	.WORD	TDROP
	.WORD	SEMIS

EPDO	.WORD	DOCOL
	.WORD	SWAP
	.WORD	ETOR
	.WORD	ETOR
	.WORD	SEMIS

EPPLOO	.WORD	DOCOL
	.WORD	ERFROM
	.WORD	OVER
	.WORD	PLUS
	.WORD	ERFROM
	.WORD	TDUP
	.WORD	ETOR
	.WORD	ETOR
	.WORD	ROT
	.WORD	ZLESS
	.WORD	ZBRAN,6
	.WORD	SWAP
	.WORD	ONEP
	.WORD	LESS
	.WORD	ZBRAN,8
	.WORD	EBR
	.WORD	BRAN,$C
	.WORD	ERFROM
	.WORD	DROP
	.WORD	ERFROM
	.WORD	DROP
	.WORD	EIPPL
	.WORD	SEMIS

EPLOOP	.WORD	DOCOL
	.WORD	ONE
	.WORD	EPPLOO
	.WORD	SEMIS

ELEAV	.WORD	DOCOL
	.WORD	ERFROM
	.WORD	DROP
	.WORD	ERFROM
	.WORD	DROP
	.WORD	EI
	.WORD	ETOR
	.WORD	SEMIS

ECOMP	.WORD	DOCOL
	.WORD	EIP
	.WORD	AT
	.WORD	AT
	.WORD	DUP
	.WORD	TWOP
	.WORD	NFA
	.WORD	IDDOT
	.WORD	COMMA
	.WORD	EIPPL
	.WORD	SEMIS

LB356	.BYTE	16

	.WORD	BRAN
	.WORD	EBR

	.WORD	I
	.WORD	EI

	.WORD	R
	.WORD	EI

	.WORD	RPSTO
	.WORD	ERPSTO

	.WORD	TOR
	.WORD	ETOR

	.WORD	RFROM
	.WORD	ERFROM

	.WORD	COMP
	.WORD	ECOMP

	.WORD	LEAVE
	.WORD	ELEAV

	.WORD	PLOOP
	.WORD	EPLOOP

	.WORD	PPLOO
	.WORD	EPPLOO

	.WORD	PDO
	.WORD	EPDO

	.WORD	PDOTQ
	.WORD	EPDOTQ

	.WORD	ALIT
	.WORD	LB2CC

	.WORD	CLIT
	.WORD	ECLIT

	.WORD	LIT
	.WORD	ELIT

	.WORD	ZBRAN
	.WORD	EZBRAN

;	CND

LB397	.BYTE	$83,'CN',$C4
	.WORD	LB29F
CND	.WORD	DOCOL
	.WORD	LIT,LB356
	.WORD	COUNT
	.WORD	LIT,4
	.WORD	STAR
	.WORD	ZERO
	.WORD	PDO
	.WORD	TDUP
	.WORD	I
	.WORD	PLUS
	.WORD	AT
	.WORD	EQUAL
	.WORD	ZBRAN,$E
	.WORD	I
	.WORD	PLUS
	.WORD	TWOP
	.WORD	AT
	.WORD	SWAP
	.WORD	LEAVE
	.WORD	LIT,4
	.WORD	PPLOO,$FFE0
	.WORD	DROP
	.WORD	SEMIS

;	ERR

LB3D5	.BYTE	$83,'ER',$D2
	.WORD	LB397
ERR	.WORD	DOCOL
	.WORD	PDOTQ
	.BYTE	8
	.BYTE	'CODE DEF'
	.WORD	SEMIS

;	'STEP

LB3EA	.BYTE	$85,$27,'STE',$D0
	.WORD	LB3D5
TSTEP	.WORD	DOUSE
	.WORD	$D0

;	'CONT

LB3F6	.BYTE	$85
	.BYTE	$27,'CON',$D4
	.WORD	LB3EA
TCONT	.WORD	DOUSE
	.WORD	$D2

;	(STEP)

LB402	.BYTE	$86,'(STEP',$A9
	.WORD	LB3F6
PSTEP	.WORD	DOCOL
	.WORD	EIP
	.WORD	AT
	.WORD	AT
	.WORD	DUP
	.WORD	TWOP
	.WORD	NFA
	.WORD	IDDOT
	.WORD	DUP
	.WORD	LIT,SEMIS
	.WORD	SUBB
	.WORD	ZBRAN,$15
	.WORD	EIPPL
	.WORD	CND
	.WORD	EXEC
	.WORD	TAB
	.WORD	PDOTQ
	.BYTE	2
	.BYTE	'>>'
	.WORD	DOTS
	.WORD	BRAN,$F
	.WORD	DROP
	.WORD	PDOTQ
	.BYTE	8
	.BYTE	'DEF END '
	.WORD	CR
	.WORD	SEMIS

;	(CONT)

LB44B	.BYTE	$86,'(CONT',$A9
	.WORD	LB402
	.WORD	DOCOL
PCONT	.WORD	CR
	.WORD	PSTEP
	.WORD	EIP
	.WORD	AT
	.WORD	AT
	.WORD	LIT,SEMIS
	.WORD	EQUAL
	.WORD	QTER
	.WORD	ORR
	.WORD	ZBRAN,$FFEC
	.WORD	SEMIS

;	STEP

LB470	.BYTE	$84,'STE',$D0
	.WORD	LB1AE
	.WORD	DOCOL
	.WORD	TSTEP
	.WORD	AT
	.WORD	EXEC
	.WORD	SEMIS

;	CONT

LB481	.BYTE	$84,'CON',$D4
	.WORD	LB470
CONTT	.WORD	DOCOL
	.WORD	TCONT
	.WORD	AT
	.WORD	EXEC
	.WORD	SEMIS

;	EMULATE

LB492	.BYTE	$87,'EMULAT',$C5
	.WORD	LB481
EMULAT	.WORD	DOCOL
	.WORD	TICK
	.WORD	CFA
	.WORD	DUP
	.WORD	EIP
	.WORD	STORE
	.WORD	AT
	.WORD	LIT,HEX
	.WORD	AT
	.WORD	SUBB
	.WORD	ZBRAN,$27
	.WORD	CR
	.WORD	PDOTQ
	.BYTE	12
	.BYTE	'CODE DEF !! '
	.WORD	LIT,ERR+2
	.WORD	CFA
	.WORD	DUP
	.WORD	TSTEP
	.WORD	STORE
	.WORD	TCONT
	.WORD	STORE
	.WORD	BRAN,$1A
	.WORD	EIPPL
	.WORD	ERPSTO
	.WORD	LIT,PSTEP+2
	.WORD	CFA
	.WORD	TSTEP
	.WORD	STORE
	.WORD	LIT,PCONT
	.WORD	CFA
	.WORD	TCONT
	.WORD	STORE
	.WORD	SEMIS

;	TRACE

LB4F5	.BYTE	$85,'TRAC',$C5
	.WORD	LB492
	.WORD	DOCOL
	.WORD	EMULAT
	.WORD	CONTT
	.WORD	SEMIS

;	PICK

LB505	.BYTE	$84,'PIC',$CB
	.WORD	LB4F5
PICK	.WORD	DOCOL
	.WORD	TWO
	.WORD	STAR
	.WORD	SPAT
	.WORD	PLUS
	.WORD	AT
	.WORD	SEMIS

LB51A	.WORD	DOCOL
	.WORD	THREE
	.WORD	PICK
	.WORD	EQUAL
	.WORD	ORR
	.WORD	SEMIS

LB526	.WORD	DOCOL
	.WORD	DUP
	.WORD	AT
	.WORD	TWOP
	.WORD	ZERO
	.WORD	LIT,SEMIS+2
	.WORD	LB51A
	.WORD	LIT,PSCOD+2
	.WORD	LB51A
	.WORD	LIT,QUIT+2
	.WORD	LB51A
	.WORD	QTER
	.WORD	ORR
	.WORD	SWAP
	.WORD	DROP
	.WORD	ZEQU
	.WORD	SEMIS

LB54E	.WORD	DOCOL
	.WORD	DUP
	.WORD	TWOP
	.WORD	SWAP
	.WORD	AT
	.WORD	TWOP
	.WORD	ZERO
	.WORD	LIT,COMP+2
	.WORD	LB51A
	.WORD	ZBRAN,$16
	.WORD	DROP
	.WORD	DUP
	.WORD	AT
	.WORD	TWOP
	.WORD	NFA
	.WORD	IDDOT
	.WORD	TWOP
	.WORD	SPACE
	.WORD	BRAN,$82
	.WORD	ZERO
	.WORD	LIT,CLIT+2
	.WORD	LB51A
	.WORD	ZBRAN,$12
	.WORD	DROP
	.WORD	DUP
	.WORD	CAT
	.WORD	DOT
	.WORD	ONEP
	.WORD	SPACE
	.WORD	BRAN,$66
	.WORD	ZERO
	.WORD	LIT,PDOTQ+2
	.WORD	LB51A
	.WORD	LIT,ALIT+2
	.WORD	LB51A
	.WORD	ZBRAN,$1E
	.WORD	DROP
	.WORD	DUP
	.WORD	COUNT
	.WORD	DUP
	.WORD	ROT
	.WORD	SWAP
	.WORD	TYPE
	.WORD	PLUS
	.WORD	ONEP
	.WORD	LIT,5
	.WORD	SPACS
	.WORD	BRAN,$38
	.WORD	ZERO
	.WORD	LIT,LIT+2
	.WORD	LB51A
	.WORD	LIT,BRAN+2
	.WORD	LB51A
	.WORD	LIT,ZBRAN+2
	.WORD	LB51A
	.WORD	LIT,PPLOO+2
	.WORD	LB51A
	.WORD	LIT,PLOOP+2
	.WORD	LB51A
	.WORD	ZBRAN,$12
	.WORD	DROP
	.WORD	DUP
	.WORD	AT
	.WORD	DOT
	.WORD	SPACE
	.WORD	TWOP
	.WORD	BRAN,4
	.WORD	DROP
	.WORD	SEMIS

;	SOURCE

LB5FC	.BYTE	$86,'SOURC',$C5
	.WORD	LB505
	.WORD	DOCOL
	.WORD	TICK
	.WORD	DUP
	.WORD	CFA
	.WORD	AT
	.WORD	LIT,HEX+2
	.WORD	CFA
	.WORD	AT
	.WORD	EQUAL
	.WORD	ZBRAN,$78
	.WORD	PDOTQ
	.BYTE	3
	.BYTE	' : '
	.WORD	DUP
	.WORD	NFA
	.WORD	IDDOT
	.WORD	SPACE
	.WORD	DUP
	.WORD	DUP
	.WORD	AT
	.WORD	TWOP
	.WORD	NFA
	.WORD	DUP
	.WORD	CAT
	.WORD	LIT,$40
	.WORD	ANDD
	.WORD	TWO
	.WORD	SPACS
	.WORD	ZBRAN,$F
	.WORD	PDOTQ
	.BYTE	10
	.BYTE	'[COMPILE] '
	.WORD	IDDOT
	.WORD	LB526
	.WORD	ZBRAN,$16
	.WORD	LB54E
	.WORD	OUT
	.WORD	AT
	.WORD	CSLL
	.WORD	GREAT
	.WORD	ZBRAN,4
	.WORD	CR
	.WORD	BRAN,$FFBF
	.WORD	DROP
	.WORD	DUP
	.WORD	NFA
	.WORD	AT
	.WORD	LIT,$40
	.WORD	ANDD
	.WORD	ZBRAN,$F
	.WORD	PDOTQ
	.BYTE	10
	.BYTE	'IMMEDIATE '
	.WORD	BRAN,4
	.WORD	ERR
	.WORD	DROP
	.WORD	CR
	.WORD	SEMIS

;	MSREG

LB69B	.BYTE	$85,'MSRE',$C7
	.WORD	LB44B
MSREG	.WORD	DOCON
	.WORD	$779A

;	SBASE

LB6A7	.BYTE	$85,'SBAS',$C5
	.WORD	LB69B
SBASE	.WORD	DOCON
	.WORD	$D400

;	CV

LB6B3	.BYTE	$82,'C',$D6
	.WORD	LB6A7
CV	.WORD	DOCOL
	.WORD	CURVOC
	.WORD	AT
	.WORD	MSREG
	.WORD	PLUS
	.WORD	SEMIS

;	WFORM

LB6C4	.BYTE	$85,'WFOR',$CD
	.WORD	LB6B3
	.WORD	DOCOL
	.WORD	BUILD
	.WORD	CCOM
	.WORD	CCOM
	.WORD	CCOM
	.WORD	DOES
DOWFM	.WORD	COUNT
	.WORD	CV
	.WORD	PLUS
	.WORD	DUP
	.WORD	ROT
	.WORD	COUNT
	.WORD	ROT
	.WORD	CAT
	.WORD	ANDD
	.WORD	SWAP
	.WORD	CAT
	.WORD	ORR
	.WORD	SWAP
	.WORD	CSTOR
	.WORD	SEMIS

;	S!

LB6F6	.BYTE	$82,'S',$A1
	.WORD	LB5FC
SSTOR	.WORD	DOCOL
	.WORD	MSREG
	.WORD	SBASE
	.WORD	LIT,$20
	.WORD	CMOVE
	.WORD	SEMIS

;	SINIT

LB709	.BYTE	$85,'SINI',$D4
	.WORD	LB6F6
	.WORD	DOCOL
	.WORD	MSREG
	.WORD	LIT,$20
	.WORD	ERASE
	.WORD	SSTOR
	.WORD	ZERO
	.WORD	CURVOC
	.WORD	STORE
	.WORD	SEMIS

;	PWIDTH!

LB725	.BYTE	$87,'PWIDTH',$A1
	.WORD	LB709
	.WORD	DOCOL
	.WORD	CV
	.WORD	TWOP
	.WORD	STORE
	.WORD	SEMIS

;	PWIDTH@

LB739	.BYTE	$87,'PWIDTH',$C0
	.WORD	LB725
	.WORD	DOCOL
	.WORD	CV
	.WORD	TWOP
	.WORD	AT
	.WORD	SEMIS

;	FREQ!

LB74D	.BYTE	$85,'FREQ',$A1
	.WORD	LB739
	.WORD	DOCOL
	.WORD	CV
	.WORD	STORE
	.WORD	SEMIS

;	FREQ@

LB75D	.BYTE	$85,'FREQ',$C0
	.WORD	LB74D
	.WORD	DOCOL
	.WORD	CV
	.WORD	AT
	.WORD	SEMIS

;	TRIANGLE

LB76D	.BYTE	$88,'TRIANGL',$C5
	.WORD	LB75D
	.WORD	DODOE
	.WORD	DOWFM
	.BYTE	4,$F,$10

;	GATE1

LB77F	.BYTE	$85,'GATE',$B1
	.WORD	LB76D
	.WORD	DODOE
	.WORD	DOWFM
	.BYTE	4,$FE,1

;	GATE0

LB78E	.BYTE	$85,'GATE',$B0
	.WORD	LB77F
	.WORD	DODOE
	.WORD	DOWFM
	.BYTE	4,$FE,0

;	SAWTOOTH

LB79D	.BYTE	$88,'SAWTOOT',$C8
	.WORD	LB78E
	.WORD	DODOE
	.WORD	DOWFM
	.BYTE	4,$F,$20

;	SYNC1

LB7AF	.BYTE	$85,'SYNC',$B1
	.WORD	LB79D
	.WORD	DODOE
	.WORD	DOWFM
	.BYTE	4,$FD,2

;	SYNC0

LB7BE	.BYTE	$85,'SYNC',$B0
	.WORD	LB7AF
	.WORD	DODOE
	.WORD	DOWFM
	.BYTE	4,$FD,0

;	SQUARE

LB7CD	.BYTE	$86,'SQUAR',$C5
	.WORD	LB7BE
	.WORD	DODOE
	.WORD	DOWFM
	.BYTE	4,$F,$40

;	RING1

LB7DD	.BYTE	$85,'RING',$B1
	.WORD	LB7CD
	.WORD	DODOE
	.WORD	DOWFM
	.BYTE	4,$FB,4

;	RING0

LB7EC	.BYTE	$85,'RING',$B0
	.WORD	LB7DD
	.WORD	DODOE
	.WORD	DOWFM
	.BYTE	4,$FB,0

;	NOISE

LB7FB	.BYTE	$85,'NOIS',$C5
	.WORD	LB7EC
	.WORD	DODOE
	.WORD	DOWFM
	.BYTE	4,$F,$80

;	TEST1

LB80A	.BYTE	$85,'TEST',$B1
	.WORD	LB7FB
	.WORD	DODOE
	.WORD	DOWFM
	.BYTE	4,$F7,8

;	TEST0

LB819	.BYTE	$85,'TEST',$B0
	.WORD	LB80A
	.WORD	DODOE
	.WORD	DOWFM
	.BYTE	4,$F7,0

;	VOICE1

LB828	.BYTE	$86,'VOICE',$B1
	.WORD	LB819
	.WORD	DOCOL
	.WORD	ZERO
	.WORD	CURVOC
	.WORD	STORE
	.WORD	SEMIS

;	VOICE2

LB83B	.BYTE	$86,'VOICE',$B2
	.WORD	LB828
	.WORD	DOCOL
	.WORD	LIT,7
	.WORD	CURVOC
	.WORD	STORE
	.WORD	SEMIS

;	VOICE3

LB850	.BYTE	$86,'VOICE',$B3
	.WORD	LB83B
	.WORD	DOCOL
	.WORD	LIT,$E
	.WORD	CURVOC
	.WORD	STORE
	.WORD	SEMIS

;	REGSET

LB865	.BYTE	$86,'REGSE',$D4
	.WORD	LB6C4
REGSET	.WORD	DOCOL
	.WORD	DUP
	.WORD	CAT
	.WORD	ROT
	.WORD	ANDD
	.WORD	ROT
	.WORD	ORR
	.WORD	SWAP
	.WORD	CSTOR
	.WORD	SEMIS

;	REGREAD

LB882	.BYTE	$87,'REGREA',$C4
	.WORD	LB865
REGRED	.WORD	DOCOL
	.WORD	CAT
	.WORD	ANDD
	.WORD	SWAP
	.WORD	SLASH
	.WORD	SEMIS

;	ATTACK!

LB898	.BYTE	$87,'ATTACK',$A1
	.WORD	LB850
	.WORD	DOCOL
	.WORD	LIT,16
	.WORD	STAR
	.WORD	LIT,15
	.WORD	LIT,5
	.WORD	CV
	.WORD	PLUS
	.WORD	REGSET
	.WORD	SEMIS

;	ATTACK@

LB8BA	.BYTE	$87,'ATTACK',$C0
	.WORD	LB898
	.WORD	DOCOL
	.WORD	LIT,16
	.WORD	LIT,$F0
	.WORD	LIT,5
	.WORD	CV
	.WORD	PLUS
	.WORD	REGRED
	.WORD	SEMIS

;	DECAY!

LB8DA	.BYTE	$86,'DECAY',$A1
	.WORD	LB8BA
	.WORD	DOCOL
	.WORD	LIT,$F0
	.WORD	LIT,5
	.WORD	CV
	.WORD	PLUS
	.WORD	REGSET
	.WORD	SEMIS

;	DECAY@

LB8F5	.BYTE	$86,'DECAY',$C0
	.WORD	LB8DA
	.WORD	DOCOL
	.WORD	ONE
	.WORD	LIT,$F
	.WORD	LIT,5
	.WORD	CV
	.WORD	PLUS
	.WORD	REGRED
	.WORD	SEMIS

;	SUSTAIN!

LB912	.BYTE	$88,'SUSTAIN',$A1
	.WORD	LB8F5
	.WORD	DOCOL
	.WORD	LIT,16
	.WORD	STAR
	.WORD	LIT,15
	.WORD	LIT,6
	.WORD	CV
	.WORD	PLUS
	.WORD	REGSET
	.WORD	SEMIS

;	SUSTAIN@

LB935	.BYTE	$88,'SUSTAIN',$C0
	.WORD	LB912
	.WORD	DOCOL
	.WORD	LIT,16
	.WORD	LIT,$F0
	.WORD	LIT,6
	.WORD	CV
	.WORD	PLUS
	.WORD	REGRED
	.WORD	SEMIS

;	RELEASE!

LB956	.BYTE	$88,'RELEASE',$A1
	.WORD	LB935
	.WORD	DOCOL
	.WORD	LIT,$F0
	.WORD	LIT,6
	.WORD	CV
	.WORD	PLUS
	.WORD	REGSET
	.WORD	SEMIS

;	RELEASE@

LB973	.BYTE	$88,'RELEASE',$C0
	.WORD	LB956
	.WORD	DOCOL
	.WORD	ONE
	.WORD	LIT,$F
	.WORD	LIT,6
	.WORD	CV
	.WORD	PLUS
	.WORD	REGRED
	.WORD	SEMIS

;	FILTER!

LB992	.BYTE	$87,'FILTER',$A1
	.WORD	LB973
	.WORD	DOCOL
	.WORD	ZERO
	.WORD	LIT,7
	.WORD	USLAS
	.WORD	LIT,$D416
	.WORD	CSTOR
	.WORD	LIT,$D415
	.WORD	CSTOR
	.WORD	SEMIS

;	RESONANCE!

LB9B4	.BYTE	$8A,'RESONANCE',$A1
	.WORD	LB992
	.WORD	DOCOL
	.WORD	LIT,$10
	.WORD	STAR
	.WORD	LIT,$F
	.WORD	MSREG
	.WORD	LIT,$17
	.WORD	PLUS
	.WORD	REGSET
	.WORD	SEMIS

;	RESONANCE@

LB9D9	.BYTE	$8A,'RESONANCE',$C0
	.WORD	LB9B4
	.WORD	DOCOL
	.WORD	LIT,$10
	.WORD	LIT,$F0
	.WORD	MSREG
	.WORD	LIT,$17
	.WORD	PLUS
	.WORD	REGRED
	.WORD	SEMIS

;	FSELECT!

LB9FC	.BYTE	$88,'FSELECT',$A1
	.WORD	LB9D9
	.WORD	DOCOL
	.WORD	LIT,$F0
	.WORD	MSREG
	.WORD	LIT,$17
	.WORD	PLUS
	.WORD	REGSET
	.WORD	SEMIS

;	FSELECT@

LBA19	.BYTE	$88,'FSELECT',$C0
	.WORD	LB9FC
	.WORD	DOCOL
	.WORD	ONE
	.WORD	LIT,$F
	.WORD	MSREG
	.WORD	LIT,$17
	.WORD	PLUS
	.WORD	REGRED
	.WORD	SEMIS

;	FMODE!

LBA38	.BYTE	$86,'FMODE',$A1
	.WORD	LBA19
	.WORD	DOCOL
	.WORD	LIT,$10
	.WORD	STAR
	.WORD	LIT,$F
	.WORD	MSREG
	.WORD	LIT,$18
	.WORD	PLUS
	.WORD	REGSET
	.WORD	SEMIS

;	FMODE@

LBA59	.BYTE	$86,'FMODE',$C0
	.WORD	LBA38
	.WORD	DOCOL
	.WORD	LIT,$10
	.WORD	LIT,$F0
	.WORD	MSREG
	.WORD	LIT,$18
	.WORD	PLUS
	.WORD	REGRED
	.WORD	SEMIS

;	VOLUME!

LBA78	.BYTE	$87,'VOLUME',$A1
	.WORD	LBA59
	.WORD	DOCOL
	.WORD	LIT,$F0
	.WORD	MSREG
	.WORD	LIT,$18
	.WORD	PLUS
	.WORD	REGSET
	.WORD	SEMIS

;	VOLUME@

LBA94	.BYTE	$87,'VOLUME',$C0
	.WORD	LBA78
	.WORD	DOCOL
	.WORD	ONE
	.WORD	LIT,$F
	.WORD	MSREG
	.WORD	LIT,$18
	.WORD	PLUS
	.WORD	REGRED
	.WORD	SEMIS

;	OSC3@

LBAB2	.BYTE	$85,'OSC3',$C0
	.WORD	LBA94
	.WORD	DOCOL
	.WORD	LIT,$D41B
	.WORD	CAT
	.WORD	SEMIS

;	ENV3@

LBAC4	.BYTE	$85,'ENV3',$C0
	.WORD	LBAB2
	.WORD	DOCOL
	.WORD	LIT,$D41C
	.WORD	CAT
	.WORD	SEMIS

;	SPOBJ

LBAD6	.BYTE	$85,'SPOB',$CA
	.WORD	LB882
SPOBJ	.WORD	DOUSE
	.WORD	$D6

;	SPINDX

LBAE2	.BYTE	$86,'SPIND',$D8
	.WORD	LBAD6
SPINDX	.WORD	DOUSE
	.WORD	$D8

;	SPBYT

LBAEF	.BYTE	$85,'SPBY',$D4
	.WORD	LBAE2
SPBYT	.WORD	DOUSE
	.WORD	$DA

;	SCPTR

LBAFB	.BYTE	$85,'SCPT',$D2
	.WORD	LBAEF
SCPTR	.WORD	DOUSE
	.WORD	$DC

;	SPBIT

LBB07	.BYTE	$85,'SPBI',$D4
	.WORD	LBAFB
SPBIT	.WORD	DOCOL
	.WORD	LIT,$80
	.WORD	ZERO
	.WORD	SPBYT
	.WORD	STORE
	.WORD	LIT,8
	.WORD	ZERO
	.WORD	PDO
	.WORD	SCPTR
	.WORD	AT
	.WORD	CAT
	.WORD	BL
	.WORD	SUBB
	.WORD	ZBRAN,8
	.WORD	DUP
	.WORD	SPBYT
	.WORD	PSTOR
	.WORD	ZERO
	.WORD	TWO
	.WORD	USLAS
	.WORD	SWAP
	.WORD	DROP
	.WORD	ONE
	.WORD	SCPTR
	.WORD	PSTOR
	.WORD	PLOOP,$FFDA
	.WORD	DROP
	.WORD	SEMIS

;	SPGET

LBB4F	.BYTE	$85,'SPGE',$D4
	.WORD	LBB07
SPGET	.WORD	DOCOL
	.WORD	THREE
	.WORD	ZERO
	.WORD	PDO
	.WORD	SPBIT
	.WORD	SPBYT
	.WORD	AT
	.WORD	SPINDX
	.WORD	AT
	.WORD	SPOBJ
	.WORD	AT
	.WORD	PLUS
	.WORD	CSTOR
	.WORD	ONE
	.WORD	SPINDX
	.WORD	PSTOR
	.WORD	PLOOP,$FFE6
	.WORD	LIT,$10
	.WORD	SCPTR
	.WORD	PSTOR
	.WORD	SEMIS

;	SPRITE

LBB85	.BYTE	$86,'SPRIT',$C5
	.WORD	LBB4F
SPRITE	.WORD	DOCOL
	.WORD	ZERO
	.WORD	SPINDX
	.WORD	STORE
	.WORD	LIT,$431
	.WORD	SCPTR
	.WORD	STORE
	.WORD	LIT,$15
	.WORD	ZERO
	.WORD	PDO
	.WORD	SPGET
	.WORD	PLOOP,$FFFC
	.WORD	LIT,$93
	.WORD	EMIT
	.WORD	SEMIS

;	MASK

LBBB4	.BYTE	$84,'MAS',$CB
	.WORD	LBB85
MASK	.WORD	DOVAR
	.BYTE	$01,$02,$04,$08
	.BYTE	$10,$20,$40,$80

;	ORMASK

LBBC5	.BYTE	$86,'ORMAS',$CB
	.WORD	LBBB4
ORMASK	.WORD	DOCOL
	.WORD	SWAP
	.WORD	MASK
	.WORD	PLUS
	.WORD	CAT
	.WORD	OVER
	.WORD	CAT
	.WORD	ORR
	.WORD	SWAP
	.WORD	CSTOR
	.WORD	SEMIS

;	ANDMASK

LBBE4	.BYTE	$87,'ANDMAS',$CB
	.WORD	LBBC5
ANDMSK	.WORD	DOCOL
	.WORD	SWAP
	.WORD	MASK
	.WORD	PLUS
	.WORD	CAT
	.WORD	LIT,$FF
	.WORD	XORR
	.WORD	OVER
	.WORD	CAT
	.WORD	ANDD
	.WORD	SWAP
	.WORD	CSTOR
	.WORD	SEMIS

;	MASK?

LBC0A	.BYTE	$85,'MASK',$BF
	.WORD	LBBE4
MASKQ	.WORD	DOCOL
	.WORD	ZBRAN,8
	.WORD	ORMASK
	.WORD	BRAN,4
	.WORD	ANDMSK
	.WORD	SEMIS

;	COLOR

LBC22	.BYTE	$85,'COLO',$D2
	.WORD	LBAC4
	.WORD	DOCOL
	.WORD	LIT,$D027
	.WORD	PLUS
	.WORD	CSTOR
	.WORD	SEMIS

;	SHOW

LBC36	.BYTE	$84,'SHO',$D7
	.WORD	LBC22
	.WORD	DOCOL
	.WORD	LIT,$D015
	.WORD	ORMASK
	.WORD	SEMIS

;	HIDE

LBC47	.BYTE	$84,'HID',$C5
	.WORD	LBC36
	.WORD	DOCOL
	.WORD	LIT,$D015
	.WORD	ANDMSK
	.WORD	SEMIS

;	XY

LBC58	.BYTE	$82,'X',$D9
	.WORD	LBC47
XY	.WORD	DOCOL
	.WORD	DUP
	.WORD	PLUS
	.WORD	LIT,$D000
	.WORD	PLUS
	.WORD	DUP
	.WORD	ONEP
	.WORD	ROT
	.WORD	SWAP
	.WORD	CSTOR
	.WORD	CSTOR
	.WORD	SEMIS

;	CXY

LBC77	.BYTE	$83,'CX',$D9
	.WORD	LBC58
	.WORD	DOCOL
	.WORD	ROT
	.WORD	DUP
	.WORD	LIT,$100
	.WORD	ANDD
	.WORD	ROT
	.WORD	DUP
	.WORD	MASK
	.WORD	PLUS
	.WORD	CAT
	.WORD	ROT
	.WORD	ZBRAN,$E
	.WORD	LIT,$D010
	.WORD	CAT
	.WORD	ORR
	.WORD	BRAN,$10
	.WORD	LIT,$FF
	.WORD	XORR
	.WORD	LIT,$D010
	.WORD	CAT
	.WORD	ANDD
	.WORD	LIT,$D010
	.WORD	CSTOR
	.WORD	ROT
	.WORD	SWAP
	.WORD	XY
	.WORD	SEMIS

;	MULTI

LBCC1	.BYTE	$85,'MULT',$C9
	.WORD	LBC77
	.WORD	DOCOL
	.WORD	LIT,$D01C
	.WORD	ORMASK
	.WORD	SEMIS

;	HIRES

LBCD3	.BYTE	$85,'HIRE',$D3
	.WORD	LBCC1
	.WORD	DOCOL
	.WORD	LIT,$D01C
	.WORD	ANDMSK
	.WORD	SEMIS

;	XPAND

LBCE5	.BYTE	$85,'XPAN',$C4
	.WORD	LBCD3
	.WORD	DOCOL
	.WORD	SWAP
	.WORD	OVER
	.WORD	LIT,$D017
	.WORD	ROT
	.WORD	MASKQ
	.WORD	LIT,$D01D
	.WORD	ROT
	.WORD	MASKQ
	.WORD	SEMIS

;	MCLR1

LBD05	.BYTE	$85,'MCLR',$B1
	.WORD	LBCE5
	.WORD	DOCOL
	.WORD	LIT,$D025
	.WORD	CSTOR
	.WORD	SEMIS

;	MCLR2

LBD17	.BYTE	$85,'MCLR',$B2
	.WORD	LBD05
	.WORD	DOCOL
	.WORD	LIT,$D026
	.WORD	CSTOR
	.WORD	SEMIS

;	SB

LBD29	.BYTE	$82,'S',$C2
	.WORD	LBC0A
SB	.WORD	DOCON
	.WORD	$30

;	SBLK

LBD32	.BYTE	$84,'SBL',$CB
	.WORD	LBD29
SBLK	.WORD	DOCON
	.WORD	$7F8

;	SPBASE

LBD3D	.BYTE	$86,'SPBAS',$C5
	.WORD	LBD32
SPBASE	.WORD	DOCOL
	.WORD	LIT,8
	.WORD	ZERO
	.WORD	PDO
	.WORD	SB
	.WORD	I
	.WORD	PLUS
	.WORD	SBLK
	.WORD	I
	.WORD	PLUS
	.WORD	CSTOR
	.WORD	PLOOP,$FFF0
	.WORD	SEMIS

;	CUR

LBD64	.BYTE	$83,'CU',$D2
	.WORD	LBD3D
CUR	.WORD	DOCOL
	.WORD	SWAP
	.WORD	ZERO
	.WORD	ZERO
	.WORD	TSWAP
	.WORD	LIT,$FFF0
	.WORD	SYS
	.WORD	TDROP
	.WORD	TDROP
	.WORD	SEMIS

;	VDG

LBD80	.BYTE	$83,'VD',$C7
	.WORD	LBD64
VDG	.WORD	DOCOL
	.WORD	LIT,$16
	.WORD	ONE
	.WORD	PDO
	.WORD	DUP
	.WORD	I
	.WORD	CUR
	.WORD	LIT,$D6
	.WORD	EMIT
	.WORD	PLOOP,$FFF2
	.WORD	DROP
	.WORD	SEMIS

;	BDG

LBDA4	.BYTE	$83,'BD',$C7
	.WORD	LBD80
BDG	.WORD	DOCOL
	.WORD	LIT,8
	.WORD	SWAP
	.WORD	CUR
	.WORD	LIT,$1A
	.WORD	ZERO
	.WORD	PDO
	.WORD	LIT,$D6
	.WORD	EMIT
	.WORD	PLOOP,$FFF8
	.WORD	SEMIS

;	-SPOBJ

LBDC8	.BYTE	$86,'-SPOB',$CA
	.WORD	LBDA4
DSPOBJ	.WORD	DOCOL
	.WORD	SPBASE
	.WORD	LIT,7
	.WORD	MIN
	.WORD	DUP
	.WORD	SBLK
	.WORD	PLUS
	.WORD	CAT
	.WORD	LIT,$40
	.WORD	STAR
	.WORD	SEMIS

;	RBYT

LBDEB	.BYTE	$84,'RBY',$D4
	.WORD	LBDC8
RBYT	.WORD	DOCOL
	.WORD	SPOBJ
	.WORD	AT
	.WORD	SPINDX
	.WORD	AT
	.WORD	PLUS
	.WORD	CAT
	.WORD	LIT,8
	.WORD	ZERO
	.WORD	PDO
	.WORD	DUP
	.WORD	I
	.WORD	MASK
	.WORD	PLUS
	.WORD	CAT
	.WORD	ANDD
	.WORD	ZBRAN,$24
	.WORD	SCPTR
	.WORD	AT
	.WORD	LIT,7
	.WORD	I
	.WORD	SUBB
	.WORD	PLUS
	.WORD	LIT,$400
	.WORD	SUBB
	.WORD	ZERO
	.WORD	LIT,$28
	.WORD	USLAS
	.WORD	CUR
	.WORD	PDOTQ
	.BYTE	1
	.BYTE	'*'
	.WORD	PLOOP,$FFCC
	.WORD	DROP
	.WORD	LIT,8
	.WORD	SCPTR
	.WORD	PSTOR
	.WORD	SEMIS

;	SPEDIT

LBE4A	.BYTE	$86,'SPEDI',$D4
	.WORD	LBD17
SPEDIT	.WORD	DOCOL
	.WORD	LIT,$93
	.WORD	EMIT
	.WORD	LIT,8
	.WORD	VDG
	.WORD	LIT,$21
	.WORD	VDG
	.WORD	ZERO
	.WORD	BDG
	.WORD	LIT,$16
	.WORD	BDG
	.WORD	LIT,$20
	.WORD	SPACS
	.WORD	PDOTQ
	.BYTE	6
	.BYTE	'RETURN'
	.WORD	DSPOBJ
	.WORD	SPOBJ
	.WORD	STORE
	.WORD	DROP
	.WORD	LIT,$80
	.WORD	LIT,$28A
	.WORD	CSTOR
	.WORD	LIT,$431
	.WORD	SCPTR
	.WORD	STORE
	.WORD	ZERO
	.WORD	SPINDX
	.WORD	STORE
	.WORD	LIT,$15
	.WORD	ZERO
	.WORD	PDO
	.WORD	THREE
	.WORD	ZERO
	.WORD	PDO
	.WORD	RBYT
	.WORD	ONE
	.WORD	SPINDX
	.WORD	PSTOR
	.WORD	PLOOP,$FFF6
	.WORD	LIT,$10
	.WORD	SCPTR
	.WORD	PSTOR
	.WORD	PLOOP,$FFE4
	.WORD	KEY
	.WORD	DUP
	.WORD	EMIT
	.WORD	LIT,$D
	.WORD	EQUAL
	.WORD	ZBRAN,$FFF2
	.WORD	ZERO
	.WORD	LIT,$28A
	.WORD	CSTOR
	.WORD	LIT,$13
	.WORD	EMIT
	.WORD	PDOTQ
	.BYTE	8
	.BYTE	'BUILDING'
	.WORD	CR
	.WORD	PDOTQ
	.BYTE	6
	.BYTE	'SPRITE'
	.WORD	SPRITE
	.WORD	SEMIS

;	NEWSPRITE

LBEFE	.BYTE	$89,'NEWSPRIT',$C5
	.WORD	LBE4A
	.WORD	DOCOL
	.WORD	DSPOBJ
	.WORD	LIT,$3F
	.WORD	ZERO
	.WORD	FILL
	.WORD	SPEDIT
	.WORD	SEMIS

;	SCRN?

LBF1A	.BYTE	$85,'SCRN',$BF
	.WORD	LBDEB
SCRNQ	.WORD	DOCOL
	.WORD	LIT,7
	.WORD	MIN
	.WORD	LIT,4
	.WORD	SLMOD
	.WORD	ONEP
	.WORD	SEMIS

;	SPWRITE

LBF34	.BYTE	$87,'SPWRIT',$C5
	.WORD	LBEFE
	.WORD	DOCOL
	.WORD	ZERO
	.WORD	SPBYT
	.WORD	STORE
	.WORD	DSPOBJ
	.WORD	SPOBJ
	.WORD	STORE
	.WORD	SCRNQ
	.WORD	BLOCK
	.WORD	SWAP
	.WORD	LIT,$100
	.WORD	STAR
	.WORD	PLUS
	.WORD	DUP
	.WORD	SCPTR
	.WORD	STORE
	.WORD	LIT,$100
	.WORD	BLANK
	.WORD	LIT,$3F
	.WORD	ZERO
	.WORD	PDO
	.WORD	SPOBJ
	.WORD	AT
	.WORD	CAT
	.WORD	ZERO
	.WORD	BDIGS
	.WORD	DIGS
	.WORD	EDIGS
	.WORD	SCPTR
	.WORD	AT
	.WORD	SPBYT
	.WORD	AT
	.WORD	PLUS
	.WORD	SWAP
	.WORD	CMOVE
	.WORD	ONE
	.WORD	SPOBJ
	.WORD	PSTOR
	.WORD	LIT,4
	.WORD	SPBYT
	.WORD	PSTOR
	.WORD	PLOOP,$FFD4
	.WORD	UPDATE
	.WORD	SEMIS

;	SPREAD

LBFA0	.BYTE	$86,'SPREA',$C4
	.WORD	LBF34
	.WORD	DOCOL
	.WORD	IN
	.WORD	AT
	.WORD	TOR
	.WORD	BLK
	.WORD	AT
	.WORD	TOR
	.WORD	DSPOBJ
	.WORD	SPOBJ
	.WORD	STORE
	.WORD	SCRNQ
	.WORD	BLK
	.WORD	STORE
	.WORD	LIT,$100
	.WORD	STAR
	.WORD	IN
	.WORD	STORE
	.WORD	LIT,$3F
	.WORD	ZERO
	.WORD	PDO
	.WORD	BL
	.WORD	WORD
	.WORD	HERE
	.WORD	NUMBER
	.WORD	DROP
	.WORD	SPOBJ
	.WORD	AT
	.WORD	CSTOR
	.WORD	ONE
	.WORD	SPOBJ
	.WORD	PSTOR
	.WORD	PLOOP,$FFE8
	.WORD	RFROM
	.WORD	BLK
	.WORD	STORE
	.WORD	RFROM
	.WORD	IN
	.WORD	STORE
	.WORD	SEMIS

	.BYTE	$01,$21,$20	; JUNK FILL

	.END
