(DE DO NIL
  (PROG(FUNC ABL VAR) LOOP1
    (MSG T T "F(X) = ")
    (SETQ FUNC
      (READ))
    (COND((EQ FUNC
         '-)
        (RETURN T))) LOOP2
    (MSG T "ANZ. D. ABLEITUNGEN: ")
    (SETQ ABL
      (READ))
    (COND((OR(NOT(NUMBERP ABL))
        (MINUSP ABL)
        (GREATERP ABL 5))
        (GO LOOP2)))
    (ABLFUNC(PREFIX FUNC) ABL)
    (GO LOOP1)))

(DE DIFF
  (Y X)
  (COND((CONSTP Y X) 0)
    ((EQ Y X) 1)
    (T(APPLY(DIFF-FUNCTION(CAR Y))
        (CDR Y)))))

(DE DIFF-FUNCTION
  (FN)
  (OR(CDR(ASSOC FN SYSTEM-FUNCTIONS))
    (GETPROP FN
       'DFUN)
    (ERROR '(NON-DIFFERENTIAL TERM))))

(SETQ SYSTEM-FUNCTIONS
   '((PLUS.DPLUS)
      (TIMES.DTIMES)
      (QUOTIENT.DQUOTIENT)
      (MINUS.DMINUS)))

(DE CONSTP
  (L X)
  (COND((ATOM L)
      (NOT(EQ L X)))
    ((CONSTP(CAR L) X)
      (CONSTP(CDR L) X))))

(DE SIMPLE
  (X)
  (COND((ATOM X)
       X)
    ((ASSOC(CAR X) SIASSOC)
      (APPLY(CDR(ASSOC(CAR X) SIASSOC))
        (MAPCAR 'SIMPLE
          (CDR X))))
    (T(CONS(CAR X)
        (MAPCAR 'SIMPLE
          (CDR X))))))

(SETQ SIASSOC
   '((PLUS.SPLUS)
      (TIMES.STIMES)
      (QUOTIENT.SQUOTIENT)
      (MINUS.SMINUS)
      (EXPT.SEXPT)))

(DE PLN
  (A B)
  (COND((ZEROP A)
       B)
    ((NUMBERP B)
      (PLUS A B))
    ((AND(EQ(CAR B)
         'MINUS)
      (NUMBERP(CADR B)))
      (DIFFERENCE A
        (CADR B)))
    ((EQ(CAR B)
       'PLUS)
      (COND((NUMBERP(CADR B))
          (LIST 'PLUS
            (PLUS A
              (CADR B))
            (CAR(CDDR B))))
        ((NUMBERP(CAR(CDDR B)))
          (LIST 'PLUS
            (PLUS A
              (CAR(CDDR B)))
            (CADR B)))
        (T(LIST 'PLUS A B))))
    (T(LIST 'PLUS A B))))

(DE TIN
  (A B)
  (COND((NUMBERP B)
      (TIMES A B))
    ((EQ A 0) 0)
    ((EQ A 1) B)
    ((MINUSP A)
      (SIMPLE(LIST 'MINUS
          (LIST 'TIMES
            (MINUS A) B))))
    ((EQ(CAR B)
       'TIMES)
      (COND((NUMBERP(CADR B))
          (LIST 'TIMES
            (TIMES A
              (CADR B))
            (CAR(CDDR B))))
        ((NUMBERP(CAR(CDDR B)))
          (LIST 'TIMES
            (TIMES A
              (CAR(CDDR B)))
            (CADR B)))
        (T(LIST 'TIMES A B))))
    (T(LIST 'TIMES A B))))

(DE EXPT
  (A B)
  (COND((CONSTP B X)
      (LIST 'TIMES B
        (LIST 'TIMES
          (DIFF A X)
          (LIST 'EXPT A
            (LIST 'PLUS B -1)))))
    (T(LIST 'TIMES
        (LIST 'EXPT A B)
        (LIST 'PLUS
          (LIST 'TIMES
            (DIFF B X)
            (LIST 'LN A))
          (LIST 'TIMES B
            (LIST 'QUOTIENT
              (DIFF A X) A)))))))

(DEFPROP EXPT DFUN EXPT)

(DE INFIX
  (L)
  (COND((ATOM L)
       L)
    ((ATOM(CDR L))
      (CAR L))
    ((EQ(CAR L)
       'MINUS)
      (LIST '-
        (INFIX(CADR L))))
    ((ATOM(CDDR L))
      (LIST(CAR L)
        (INFIX(CADR L))))
    ((ATOM(CDR(CDDR L)))
      (LIST(INFIX(CADR L))
        (CDR(ASSOC(CAR L) INFIXASSOC))
        (INFIX(CAR(CDDR L)))))
    (T(CONS(INFIX(CADR L))
        (CONS(CDR(ASSOC(CAR L) 
              INFIXASSOC))
          (INFIX(CONS(CAR L)
              (CDDR L))))))))

(SETQ INFIXASSOC
   '((PLUS.+)
      (MINUS.-)
      (TIMES.*)
      (QUOTIENT./)
      (EXPT.^)
      (LOG.LOG)))

(DE PREFIX
  (L)
  (COND((ATOM L)
       L)
    ((ATOM(CDR L))
      (CAR L))
    ((EQ(CAR L)
       '-)
      (LIST 'MINUS
        (PREFIX(CADR L))))
    ((ATOM(CDDR L))
      (LIST(CAR L)
        (PREFIX(CADR L))))
    ((ATOM(CDR(CDDR L)))
      (COND((EQ(CADR L)
           '-)
          (LIST 'PLUS
            (PREFIX(CAR L))
            (LIST 'MINUS
              (PREFIX(CAR(CDDR L))))))
        (T(LIST(CDR(ASSOC(CADR L) 
                PREFIXASSOC))
            (PREFIX(CAR L))
            (PREFIX(CAR(CDDR L)))))))
    ((EQ(CADR L)
       '*)
      (PREFIX(CONS(LIST(CAR L)
             '*
            (CAR(CDDR L)))
          (CDR(CDDR L)))))
    ((EQ(CADR L)
       '-)
      (LIST 'PLUS
        (PREFIX(CAR L))
        (PREFIX(CONS(LIST 'MINUS
              (CAR(CDDR L)))
            (CDR(CDDR L))))))
    (T(LIST(CDR(ASSOC(CADR L) 
            PREFIXASSOC))
        (PREFIX(CAR L))
        (PREFIX(CDDR L))))))

(SETQ PREFIXASSOC
   '((+.PLUS)
      (*.TIMES)
      (/.QUOTIENT)
      (^.EXPT)
      (-.MINUS)
      (LOG.LOG)))

(DE DFUNC
  (TM)
  (LIST 'TIMES
    (DIFF A X) TM))

(SETQ DFUNC
   'NIL)

(DE PRINFIX
  (L)
  (COND((ATOM L)
      (MSG L))
    ((EQ(CAR L)
       '-)
      (MSG '-)
      (PRINFIX(CADR L)))
    ((ATOM(CDDR L))
      (MSG "("
        (CAR L) " ")
      (PRINFIX(CADR L))
      (MSG ")"))
    ((EQ(CADR L)
       '+)
      (PRIN+ L))
    ((EQ(CADR L)
       '*)
      (MAPCAR 'PRINFIX L))
    (T(MSG "(")
      (MAPCAR 'PRINFIX L)
      (MSG ")"))))

(DE PRIN+
  (L)
  (PROG NIL
    (MSG "(")
    (PRINFIX(CAR L)) LOOP
    (SETQ L
      (CDR L))
    (COND((NOT(EQ(CAR(CADR L))
           '-))
        (MSG "+")))
    (SETQ L
      (CDR L))
    (PRINFIX(CAR L))
    (COND((ATOM(CDR L))
        (RETURN(MSG ")"))))
    (GO LOOP)))

(DE ABLFUNC
  (FUNC N)
  (PROG(DFUNC I)
    (SETQ I 1) LOOP
    (COND((GREATERP I N)
        (RETURN NIL)))
    (MSG T T "F"
      (CAR(NTH '("'" "''" "'''" 
            "''''" "'''''") I)) 
      "(X) = ")
    (SETQ DFUNC
      (SIMPLE(DIFF FUNC
           'X)))
    (PRINFIX(INFIX(FLAT DFUNC)))
    (SETQ FUNC DFUNC)
    (SETQ I
      (ADD1 I))
    (GO LOOP)))

(DE FLAT
  (X)
  (COND((ATOM X)
       X)
    ((ATOM(CDR X))
       X)
    ((EQ(CAR X)
       'MINUS)
      (LIST 'MINUS
        (FLAT(CADR X))))
    ((ATOM(CDDR X))
      (LIST(CAR X)
        (FLAT(CADR X))))
    ((EQ(CAR X)
       'EXPT)
      (LIST 'EXPT
        (FLAT(CADR X))
        (FLAT(CAR(CDDR X)))))
    (T(SETQ Y
        (MAPCAR 'FLAT
          (CDR X)))
      (SETQ X
        (CAR X))
      (CONS X
        (MAPCAN '(LAMBDA(Z)
            (COND((ATOM Z)
                (LIST Z))
              ((EQ(CAR Z) X)
                (CDR Z))
              (T(LIST Z)))) Y)))))

(DE CADDR
  (X)
  (CAR(CDDR X)))

(DE DPLUS
  (A B)
  (LIST 'PLUS
    (DIFF A X)
    (DIFF B X)))

(DE SPLUS
  (X Y)
  (COND((NUMBERP X)
      (PLN X Y))
    ((NUMBERP Y)
      (PLN Y X))
    ((EQUAL X Y)
      (SIMPLE(LIST 'TIMES 2 X)))
    ((EQ(CAR Y)
       'MINUS)
      (COND((EQUAL X
          (CADR Y)) 0)
        (T(LIST 'PLUS X Y))))
    ((EQ(CAR Y)
       'PLUS)
      (COND((EQ X
          (CADR Y))
          (SIMPLE(LIST 'PLUS
              (LIST 'TIMES 2 X)
              (CAR(CDDR Y)))))
        ((EQ X
          (CAR(CDDR Y)))
          (SIMPLE(LIST 'PLUS
              (LIST 'TIMES 2 X)
              (CADR Y))))
        (T(LIST 'PLUS X Y))))
    (T(LIST 'PLUS X Y))))

(DE DMINUS
  (A)
  (LIST 'MINUS
    (DIFF A X)))

(DE SMINUS
  (X)
  (COND((NUMBERP X)
      (MINUS X))
    ((EQ(CAR X)
       'MINUS)
      (CADR X))
    ((EQ(CAR X)
       'PLUS)
      (SIMPLE(LIST 'PLUS
          (LIST 'MINUS
            (CADR X))
          (LIST 'MINUS
            (CADDR X)))))
    (T(LIST 'MINUS X))))

(DE DTIMES
  (A B)
  (LIST 'PLUS
    (LIST 'TIMES
      (DIFF A X) B)
    (LIST 'TIMES
      (DIFF B X) A)))

(DE STIMES
  (X Y)
  (COND((NUMBERP X)
      (TIN X Y))
    ((NUMBERP Y)
      (TIN Y X))
    ((EQUAL X Y)
      (LIST 'EXPT X 2))
    ((EQ(CAR Y)
       'TIMES)
      (COND((EQUAL X
          (CADR Y))
          (SIMPLE(LIST 'TIMES
              (CAR(CDDR Y))
              (LIST 'EXPT X 2))))
        ((EQUAL X
          (CAR(CDDR Y)))
          (SIMPLE(LIST 'TIMES
              (CADR Y)
              (LIST 'EXPT X 2))))
        (T(LIST 'TIMES X Y))))
    ((EQ(CAR Y)
       'MINUS)
      (SIMPLE(LIST 'MINUS
          (LIST 'TIMES X
            (CADR Y)))))
    ((EQ(CAR X)
       'MINUS)
      (SIMPLE(LIST 'MINUS
          (LIST 'TIMES Y
            (CADR X)))))
    ((AND(EQ(CAR Y)
         'EXPT)
      (EQUAL X
        (CADR Y)))
      (LIST 'EXPT X
        (ADD1(CAR(CDDR Y)))))
    ((EQ(CAR Y)
       'QUOTIENT)
      (COND((EQUAL X
          (CADR Y))
          (LIST 'QUOTIENT
            (LIST 'EXPT X 2)
            (CADDR Y)))
        ((EQUAL X
          (CADDR Y))
          (CADR Y))
        (T(LIST 'TIMES X Y))))
    (T(LIST 'TIMES X Y))))

(DE DQUOTIENT
  (A B)
  (LIST 'QUOTIENT
    (LIST 'PLUS
      (LIST 'TIMES
        (DIFF A X) B)
      (LIST 'MINUS
        (LIST 'TIMES
          (DIFF B X) A)))
    (LIST 'EXPT B 2)))

(DE SQUOTIENT
  (A B)
  (COND((EQUAL A B) 1)
    ((AND(NUMBERP A)
      (NUMBERP B))
      (COND((ZEROP(REMAINDER A B))
          (QUOTIENT A B))
        (T(LIST 'QUOTIENT A B))))
    ((EQ(CAR A)
       'TIMES)
      (COND((EQUAL(CADR A) B)
          (CADDR A))
        ((EQUAL(CADDR A) B)
          (CADR A))
        (T(LIST 'QUOTIENT A B))))
    ((EQ(CAR B)
       'TIMES)
      (COND((EQUAL(CADR B) A)
          (LIST 'QUOTIENT 1
            (CADDR B)))
        ((EQUAL(CADDR B) A)
          (LIST 'QUOTIENT 1
            (CADR B)))
        (T(LIST 'QUOTIENT A B))))
    (T(LIST 'QUOTIENT A B))))

(DE SEXPT
  (X Y)
  (COND((NUMBERP X)
      (EXPT X Y))
    ((EQ Y 0) 1)
    ((EQ Y 1) X)
    ((EQ(CAR X)
       'EXPT)
      (SIMPLE(LIST 'EXPT
          (CADR X)
          (LIST 'TIMES Y
            (CAR(CDDR X))))))
    (T(LIST 'EXPT X Y))))

(DE LOG
  (A B)
  (LIST 'TIMES
    (DIFF B X)
    (LIST 'QUOTIENT 1
      (LIST 'TIMES B
        (LIST 'LN A)))))

(DEFPROP LOG DFUN LOG)

(DE EXP
  (A)
  (DFUNC(LIST 'EXP A)))

(DEFPROP EXP DFUN EXP)

(DE SQRT
  (A)
  (DFUNC(LIST 'QUOTIENT 1
      (LIST 'TIMES 2
        (LIST 'SQRT A)))))

(DEFPROP SQRT DFUN SQRT)

(DE SIN
  (A)
  (DFUNC(LIST 'COS A)))

(DEFPROP SIN DFUN SIN)

(DE COS
  (A)
  (DFUNC(LIST 'MINUS
      (LIST 'SIN A))))

(DEFPROP COS DFUN COS)

(DE TAN
  (A)
  (DFUNC(LIST 'PLUS 1
      (LIST 'EXPT
        (LIST 'TAN A) 2))))

(DEFPROP TAN DFUN TAN)

(DE COT
  (A)
  (DFUNC(LIST 'MINUS
      (LIST 'PLUS 1
        (LIST 'EXPT
          (LIST 'COT A) 2)))))

(DEFPROP COT DFUN COT)

(DE LN
  (A)
  (LIST 'QUOTIENT
    (DIFF A X) A))

(DEFPROP LN DFUN LN)

(DE LG
  (A)
  (DFUNC(LIST 'QUOTIENT
      (LIST 'LG
         'E) A)))

(DEFPROP LG DFUN LG)

(DE ARCSIN
  (A)
  (DFUNC(LIST 'QUOTIENT 1
      (LIST 'EXPT
        (LIST 'PLUS 1
          (LIST 'MINUS
            (LIST 'EXPT A 2)))
         '(QUOTIENT 1 2)))))

(DEFPROP ARCSIN DFUN ARCSIN)

(DE ARCCOS
  (A)
  (DFUNC(LIST 'QUOTIENT -1
      (LIST 'EXPT
        (LIST 'PLUS 1
          (LIST 'MINUS
            (LIST 'EXPT A 2)))
         '(QUOTIENT 1 2)))))

(DEFPROP ARCCOS DFUN ARCCOS)

(DE ARCTAN
  (A)
  (DFUNC(LIST 'QUOTIENT 1
      (LIST 'PLUS 1
        (LIST 'EXPT A 2)))))

(DEFPROP ARCTAN DFUN ARCTAN)

(DE ARCCOT
  (A)
  (DFUNC(LIST 'QUOTIENT -1
      (LIST 'PLUS 1
        (LIST 'EXPT A 2)))))

(DEFPROP ARCCOT DFUN ARCCOT)

(DE SINH
  (A)
  (DFUNC(LIST 'COSH A)))

(DEFPROP SINH DFUN SINH)

(DE COSH
  (A)
  (DFUNC(LIST 'SINH A)))

(DEFPROP COSH DFUN COSH)

(DE TANH
  (A)
  (DFUNC(LIST 'PLUS 1
      (LIST 'MINUS
        (LIST 'EXPT
          (LIST 'TANH A) 2)))))

(DEFPROP TANH DFUN TANH)

(DE COTH
  (A)
  (DFUNC(LIST 'PLUS 1
      (LIST 'MINUS
        (LIST 'EXPT
          (LIST 'COTH A) 2)))))

(DEFPROP COTH DFUN COTH)

(DE ARSINH
  (A)
  (DFUNC(LIST 'QUOTIENT 1
      (LIST 'EXPT
        (LIST 'PLUS 1
          (LIST 'EXPT A 2))
        (LIST 'QUOTIENT 1 2)))))

(DEFPROP ARSINH DFUN ARSINH)

(DE ARCOSH
  (A)
  (DFUNC(LIST 'QUOTIENT 1
      (LIST 'EXPT
        (LIST 'PLUS
          (LIST 'EXPT A 2) -1)
        (LIST 'QUOTIENT 1 2)))))

(DEFPROP ARCOSH DFUN ARCOSH)

(DE ARTANH
  (A)
  (DFUNC(LIST 'QUOTIENT 1
      (LIST 'PLUS 1
        (LIST 'MINUS
          (LIST 'EXPT A 2))))))

(DEFPROP ARTANH DFUN ARTANH)

(DE ARCOTH
  (A)
  (DFUNC(LIST 'QUOTIENT 1
      (LIST 'PLUS 1
        (LIST 'MINUS
          (LIST 'EXPT A 2))))))

(DEFPROP ARCOTH DFUN ARCOTH)

(SETQ ABFNS
   '(DO DIFF DIFF-FUNCTION 
    SYSTEM-FUNCTIONS CONSTP SIMPLE 
    SIASSOC PLN TIN EXPT INFIX 
    INFIXASSOC PREFIX PREFIXASSOC 
    DFUNC PRINFIX PRIN+ ABLFUNC FLAT 
    CADDR DPLUS SPLUS DMINUS SMINUS 
    DTIMES STIMES DQUOTIENT SQUOTIENT 
    SEXPT LOG EXP SQRT SIN COS TAN 
    COT LN LG ARCSIN ARCCOS ARCTAN 
    ARCCOT SINH COSH TANH COTH ARSINH 
    ARCOSH ARTANH ARCOTH ABFNS))

